/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GdkGraphics;
import gnu.java.awt.peer.gtk.GdkGraphics2D;
import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkToolkit;
import gnu.java.awt.peer.gtk.GtkWindowPeer;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.event.PaintEvent;
import java.awt.peer.FramePeer;
import java.awt.peer.MenuBarPeer;

public class GtkFramePeer
extends GtkWindowPeer
implements FramePeer {
    private int menuBarHeight;
    private MenuBarPeer menuBar;

    native int getMenuBarHeight(MenuBarPeer var1);

    native void setMenuBarWidthUnlocked(MenuBarPeer var1, int var2);

    native void setMenuBarWidth(MenuBarPeer var1, int var2);

    native void setMenuBarPeer(MenuBarPeer var1);

    native void removeMenuBarPeer();

    native void gtkFixedSetVisible(boolean var1);

    int getMenuBarHeight() {
        int n = 0;
        if (this.menuBar != null) {
            n = this.getMenuBarHeight(this.menuBar);
        }
        return n;
    }

    public void setMenuBar(MenuBar bar) {
        if (bar == null && this.menuBar != null) {
            this.gtkFixedSetVisible(false);
            this.menuBar = null;
            this.removeMenuBarPeer();
            this.insets.top -= this.menuBarHeight;
            this.menuBarHeight = 0;
            this.awtComponent.validate();
            this.gtkFixedSetVisible(true);
        } else if (bar != null && this.menuBar == null) {
            this.gtkFixedSetVisible(false);
            this.menuBar = (MenuBarPeer)bar.getPeer();
            this.setMenuBarPeer(this.menuBar);
            int menuBarWidth = this.awtComponent.getWidth() - this.insets.left - this.insets.right;
            if (menuBarWidth > 0) {
                this.setMenuBarWidth(this.menuBar, menuBarWidth);
            }
            this.menuBarHeight = this.getMenuBarHeight();
            this.insets.top += this.menuBarHeight;
            this.awtComponent.validate();
            this.gtkFixedSetVisible(true);
        } else if (bar != null && this.menuBar != null) {
            this.gtkFixedSetVisible(false);
            this.removeMenuBarPeer();
            int oldHeight = this.menuBarHeight;
            int menuBarWidth = this.awtComponent.getWidth() - this.insets.left - this.insets.right;
            this.menuBar = (MenuBarPeer)bar.getPeer();
            this.setMenuBarPeer(this.menuBar);
            if (menuBarWidth > 0) {
                this.setMenuBarWidth(this.menuBar, menuBarWidth);
            }
            this.menuBarHeight = this.getMenuBarHeight();
            if (oldHeight != this.menuBarHeight) {
                this.insets.top += this.menuBarHeight - oldHeight;
                this.awtComponent.validate();
            }
            this.gtkFixedSetVisible(true);
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        if (Thread.currentThread() == GtkToolkit.mainThread) {
            int menuBarWidth = width - this.insets.left - this.insets.right;
            if (this.menuBar != null && menuBarWidth > 0) {
                this.setMenuBarWidthUnlocked(this.menuBar, menuBarWidth);
            }
            return;
        }
        int menuBarWidth = width - this.insets.left - this.insets.right;
        if (this.menuBar != null && menuBarWidth > 0) {
            this.setMenuBarWidth(this.menuBar, menuBarWidth);
        }
        this.nativeSetBounds(x, y, width - this.insets.left - this.insets.right, height - this.insets.top - this.insets.bottom + this.menuBarHeight);
    }

    public void setResizable(boolean resizable) {
        this.setSize(this.awtComponent.getWidth() - this.insets.left - this.insets.right, this.awtComponent.getHeight() - this.insets.top - this.insets.bottom + this.menuBarHeight);
        this.gtkWindowSetResizable(resizable);
    }

    protected void postInsetsChangedEvent(int top, int left, int bottom, int right) {
        this.insets.top = top + this.menuBarHeight;
        this.insets.left = left;
        this.insets.bottom = bottom;
        this.insets.right = right;
    }

    void create() {
        this.create(0, ((Frame)this.awtComponent).isUndecorated() ^ true);
        Frame frame = (Frame)this.awtComponent;
        this.setMenuBar(frame.getMenuBar());
        this.setTitle(frame.getTitle());
        this.gtkWindowSetResizable(frame.isResizable());
        this.setIconImage(frame.getIconImage());
    }

    native void nativeSetIconImage(GtkImage var1);

    public void setIconImage(Image image) {
        if (image != null) {
            if (image instanceof GtkImage) {
                this.nativeSetIconImage((GtkImage)image);
            } else {
                this.nativeSetIconImage(new GtkImage(image.getSource()));
            }
        }
    }

    public Graphics getGraphics() {
        Graphics g = GtkToolkit.useGraphics2D() ? new GdkGraphics2D(this) : new GdkGraphics(this);
        g.translate(-this.insets.left, -this.insets.top);
        return g;
    }

    protected void postConfigureEvent(int x, int y, int width, int height) {
        int frame_width = width + this.insets.left + this.insets.right;
        int frame_height = height + this.insets.top + this.insets.bottom - this.menuBarHeight;
        if (frame_width != this.awtComponent.getWidth() || frame_height != this.awtComponent.getHeight()) {
            this.awtComponent.setSize(frame_width, frame_height);
        }
        int frame_x = x - this.insets.left;
        int frame_y = y - this.insets.top + this.menuBarHeight;
        if (frame_x == this.awtComponent.getX()) {
            this.awtComponent.getY();
        }
    }

    protected void postMouseEvent(int id, long when, int mods, int x, int y, int clickCount, boolean popupTrigger) {
        super.postMouseEvent(id, when, mods, x + this.insets.left, y + this.insets.top, clickCount, popupTrigger);
    }

    protected void postExposeEvent(int x, int y, int width, int height) {
        if (!this.isInRepaint) {
            GtkFramePeer.q().postEvent(new PaintEvent(this.awtComponent, 800, new Rectangle(x + this.insets.left, y + this.insets.top, width, height)));
        }
    }

    public int getState() {
        return 0;
    }

    public void setState(int state) {
    }

    public void setMaximizedBounds(Rectangle r) {
    }

    public void setBoundsPrivate(int x, int y, int width, int height) {
    }

    public void updateAlwaysOnTop() {
    }

    public boolean requestWindowFocus() {
        return false;
    }

    public GtkFramePeer(Frame frame) {
        super(frame);
    }
}

