/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;

public class ToggleComponentHolder {
    private ArrayList<AbstractButton> _toggleables = new ArrayList();
    private boolean _selected;

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean b) {
        this._selected = b;
        for (int i = 0; i < this._toggleables.size(); ++i) {
            final AbstractButton abstractButton = this._toggleables.get(i);
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    abstractButton.setSelected(ToggleComponentHolder.this._selected);
                }
            });
        }
    }

    public void addToggleableComponent(AbstractButton toggleable) {
        Action origAction = toggleable.getAction();
        if (null == origAction) {
            throw new RuntimeException("No Action attached to button");
        }
        toggleable.setAction(new ActionProxy(origAction));
        this._toggleables.add(toggleable);
    }

    private void selectionChanged() {
        this._selected = !this._selected;
        for (int i = 0; i < this._toggleables.size(); ++i) {
            AbstractButton abstractButton = this._toggleables.get(i);
            abstractButton.setSelected(this._selected);
        }
    }

    private class ActionProxy
    implements Action {
        private Action _delegate;

        ActionProxy(Action delegate) {
            this._delegate = delegate;
        }

        @Override
        public boolean isEnabled() {
            return this._delegate.isEnabled();
        }

        @Override
        public void setEnabled(boolean b) {
            this._delegate.setEnabled(b);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this._delegate.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this._delegate.removePropertyChangeListener(listener);
        }

        @Override
        public Object getValue(String key) {
            return this._delegate.getValue(key);
        }

        @Override
        public void putValue(String key, Object value) {
            this._delegate.putValue(key, value);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToggleComponentHolder.this.selectionChanged();
            this._delegate.actionPerformed(e);
        }
    }
}

