/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.search.impl;

import java.io.File;
import java.net.URI;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.spi.search.SearchFilterDefinition;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class SharabilityFilter
extends SearchFilterDefinition {
    private static final SharabilityFilter INSTANCE = new SharabilityFilter();

    private SharabilityFilter() {
    }

    @Override
    public boolean searchFile(FileObject fileObject) throws IllegalArgumentException {
        if (fileObject.isFolder()) {
            throw new IllegalArgumentException("file (not folder) expected");
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null && !fileObject.canWrite()) {
            return true;
        }
        return SharabilityQuery.getSharability((FileObject)fileObject) != SharabilityQuery.Sharability.NOT_SHARABLE;
    }

    @Override
    public boolean searchFile(URI uRI) {
        return SharabilityQuery.getSharability((URI)uRI) != SharabilityQuery.Sharability.NOT_SHARABLE;
    }

    @Override
    public SearchFilterDefinition.FolderResult traverseFolder(URI uRI) throws IllegalArgumentException {
        switch (SharabilityQuery.getSharability((URI)uRI)) {
            case SHARABLE: {
                return SearchFilterDefinition.FolderResult.TRAVERSE_ALL_SUBFOLDERS;
            }
            case MIXED: {
                return SearchFilterDefinition.FolderResult.TRAVERSE;
            }
            case UNKNOWN: {
                return SearchFilterDefinition.FolderResult.TRAVERSE;
            }
            case NOT_SHARABLE: {
                return SearchFilterDefinition.FolderResult.DO_NOT_TRAVERSE;
            }
        }
        return SearchFilterDefinition.FolderResult.TRAVERSE;
    }

    @Override
    public SearchFilterDefinition.FolderResult traverseFolder(FileObject fileObject) throws IllegalArgumentException {
        if (!fileObject.isFolder()) {
            throw new IllegalArgumentException("folder expected");
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null && !fileObject.canWrite()) {
            return SearchFilterDefinition.FolderResult.TRAVERSE;
        }
        SharabilityQuery.Sharability sharability = SharabilityQuery.getSharability((FileObject)fileObject);
        switch (sharability) {
            case NOT_SHARABLE: {
                return SearchFilterDefinition.FolderResult.DO_NOT_TRAVERSE;
            }
            case SHARABLE: {
                return SearchFilterDefinition.FolderResult.TRAVERSE_ALL_SUBFOLDERS;
            }
        }
        return SearchFilterDefinition.FolderResult.TRAVERSE;
    }

    public static SearchFilterDefinition getInstance() {
        return INSTANCE;
    }
}

