/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.DataInput;
import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.utils.MerkleTree;

public class ValidationComplete
extends RepairMessage {
    public static RepairMessage.MessageSerializer serializer = new ValidationCompleteSerializer();
    public final boolean success;
    public final MerkleTree tree;

    public ValidationComplete(RepairJobDesc desc) {
        super(RepairMessage.Type.VALIDATION_COMPLETE, desc);
        this.success = false;
        this.tree = null;
    }

    public ValidationComplete(RepairJobDesc desc, MerkleTree tree) {
        super(RepairMessage.Type.VALIDATION_COMPLETE, desc);
        assert (tree != null);
        this.success = true;
        this.tree = tree;
    }

    private static class ValidationCompleteSerializer
    implements RepairMessage.MessageSerializer<ValidationComplete> {
        private ValidationCompleteSerializer() {
        }

        @Override
        public void serialize(ValidationComplete message, DataOutputPlus out, int version) throws IOException {
            RepairJobDesc.serializer.serialize(message.desc, out, version);
            out.writeBoolean(message.success);
            if (message.success) {
                MerkleTree.serializer.serialize(message.tree, out, version);
            }
        }

        @Override
        public ValidationComplete deserialize(DataInput in, int version) throws IOException {
            RepairJobDesc desc = RepairJobDesc.serializer.deserialize(in, version);
            if (in.readBoolean()) {
                MerkleTree tree = MerkleTree.serializer.deserialize(in, version);
                return new ValidationComplete(desc, tree);
            }
            return new ValidationComplete(desc);
        }

        @Override
        public long serializedSize(ValidationComplete message, int version) {
            long size = RepairJobDesc.serializer.serializedSize(message.desc, version);
            size += (long)TypeSizes.NATIVE.sizeof(message.success);
            if (message.success) {
                size += MerkleTree.serializer.serializedSize(message.tree, version);
            }
            return size;
        }
    }
}

