/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.state;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.Pair;
import org.benf.cfr.reader.bytecode.analysis.types.ClassNameUtils;
import org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.TypeConstants;
import org.benf.cfr.reader.state.DCCommonState;
import org.benf.cfr.reader.util.MapFactory;
import org.benf.cfr.reader.util.SetFactory;

public class ClassCache {
    private final Map<String, JavaRefTypeInstance> refClassTypeCache = MapFactory.newMap();
    private final Set<String> simpleClassNamesSeen = SetFactory.newSet();
    private final DCCommonState dcCommonState;

    public ClassCache(DCCommonState dcCommonState) {
        this.dcCommonState = dcCommonState;
        this.add(TypeConstants.ASSERTION_ERROR.getRawName(), TypeConstants.ASSERTION_ERROR);
        this.add(TypeConstants.OBJECT.getRawName(), TypeConstants.OBJECT);
        this.add(TypeConstants.STRING.getRawName(), TypeConstants.STRING);
        this.add(TypeConstants.ENUM.getRawName(), TypeConstants.ENUM);
    }

    public JavaRefTypeInstance getRefClassFor(String rawClassName) {
        rawClassName = ClassNameUtils.convertToPath(rawClassName);
        String name = ClassNameUtils.convertFromPath(rawClassName = this.dcCommonState.getPossiblyRenamedFileFromClassFileSource(rawClassName));
        JavaRefTypeInstance typeInstance = this.refClassTypeCache.get(name);
        if (typeInstance == null) {
            typeInstance = JavaRefTypeInstance.create(name, this.dcCommonState);
            this.add(name, typeInstance);
        }
        return typeInstance;
    }

    private void add(String name, JavaRefTypeInstance typeInstance) {
        this.refClassTypeCache.put(name, typeInstance);
        this.simpleClassNamesSeen.add(typeInstance.getRawShortName());
    }

    public boolean isClassName(String name) {
        return this.simpleClassNamesSeen.contains(name);
    }

    public Pair<JavaRefTypeInstance, JavaRefTypeInstance> getRefClassForInnerOuterPair(String rawInnerName, String rawOuterName) {
        String innerName = ClassNameUtils.convertFromPath(rawInnerName);
        String outerName = ClassNameUtils.convertFromPath(rawOuterName);
        JavaRefTypeInstance inner = this.refClassTypeCache.get(innerName);
        JavaRefTypeInstance outer = this.refClassTypeCache.get(outerName);
        if (inner != null && outer != null) {
            return Pair.make(inner, outer);
        }
        Pair<JavaRefTypeInstance, JavaRefTypeInstance> pair = JavaRefTypeInstance.createKnownInnerOuter(innerName, outerName, outer, this.dcCommonState);
        if (inner == null) {
            this.add(innerName, pair.getFirst());
            inner = pair.getFirst();
        }
        if (outer == null) {
            this.add(outerName, pair.getSecond());
            outer = pair.getSecond();
        }
        return Pair.make(inner, outer);
    }

    public Collection<JavaRefTypeInstance> getLoadedTypes() {
        return this.refClassTypeCache.values();
    }
}

