/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.AbstractFunctionPtg;
import org.apache.poi.hssf.record.formula.function.FunctionMetadata;
import org.apache.poi.hssf.record.formula.function.FunctionMetadataRegistry;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class FuncVarPtg
extends AbstractFunctionPtg {
    public static final byte sid = 34;
    private static final int SIZE = 4;

    public FuncVarPtg(LittleEndianInput in) {
        this.field_1_num_args = in.readByte();
        this.field_2_fnc_index = in.readShort();
        FunctionMetadata fm = FunctionMetadataRegistry.getFunctionByIndex(this.field_2_fnc_index);
        if (fm == null) {
            this.returnClass = (byte)32;
            this.paramClass = new byte[]{32};
        } else {
            this.returnClass = fm.getReturnClassCode();
            this.paramClass = fm.getParameterClassCodes();
        }
    }

    public FuncVarPtg(String pName, byte pNumOperands) {
        this.field_1_num_args = pNumOperands;
        this.field_2_fnc_index = FuncVarPtg.lookupIndex(pName);
        FunctionMetadata fm = FunctionMetadataRegistry.getFunctionByIndex(this.field_2_fnc_index);
        if (fm == null) {
            this.returnClass = (byte)32;
            this.paramClass = new byte[]{32};
        } else {
            this.returnClass = fm.getReturnClassCode();
            this.paramClass = fm.getParameterClassCodes();
        }
    }

    public void write(LittleEndianOutput out) {
        out.writeByte(34 + this.getPtgClass());
        out.writeByte(this.field_1_num_args);
        out.writeShort(this.field_2_fnc_index);
    }

    public int getNumberOfOperands() {
        return this.field_1_num_args;
    }

    public int getSize() {
        return 4;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getClass().getName()).append(" [");
        sb.append(this.lookupName(this.field_2_fnc_index));
        sb.append(" nArgs=").append(this.field_1_num_args);
        sb.append("]");
        return sb.toString();
    }
}

