/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.sandbox.security.conversation;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.sandbox.security.conversation.ConversationException;
import org.apache.ws.sandbox.security.conversation.ConversationSession;
import org.apache.ws.sandbox.security.conversation.ConversationUtil;
import org.apache.ws.sandbox.security.conversation.dkalgo.AlgoFactory;
import org.apache.ws.sandbox.security.conversation.dkalgo.DerivationAlgorithm;
import org.apache.ws.sandbox.security.conversation.message.info.DerivedKeyInfo;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.SecurityTokenReference;

public class KeyDerivator {
    private Log log = LogFactory.getLog((String)(class$org$apache$ws$sandbox$security$conversation$KeyDerivator == null ? (class$org$apache$ws$sandbox$security$conversation$KeyDerivator = KeyDerivator.class$("org.apache.ws.sandbox.security.conversation.KeyDerivator")) : class$org$apache$ws$sandbox$security$conversation$KeyDerivator).getName());
    static /* synthetic */ Class class$org$apache$ws$sandbox$security$conversation$KeyDerivator;

    public byte[] generateKey(Hashtable sessionTable, String identifier) throws WSSecurityException, ConversationException, WSSecurityException {
        this.log.debug((Object)"KeyDerivator: Inside generate key");
        String[] uuidAndDerivedKeyTokenId = ConversationUtil.getUuidAndDerivedKeyTokenId(identifier);
        ConversationSession convSession = (ConversationSession)sessionTable.get(uuidAndDerivedKeyTokenId[0]);
        this.log.debug((Object)("KeyDerivator: session found: " + uuidAndDerivedKeyTokenId[0]));
        if (convSession != null) {
            int freq = convSession.getContextInfo().getFrequency();
            if (freq == 0) {
                return convSession.getContextInfo().getSharedSecret();
            }
            return this.deriveKey(convSession, uuidAndDerivedKeyTokenId[1]);
        }
        throw new ConversationException("Conversation Session not found");
    }

    private byte[] deriveKey(ConversationSession convSession, String derivedKeyTokenId) throws WSSecurityException, ConversationException {
        DerivedKeyInfo dkInfo = (DerivedKeyInfo)convSession.getDerivedKeys().get(derivedKeyTokenId);
        SecurityTokenReference secTokRef = dkInfo.getSecurityTokenReference();
        this.log.debug((Object)("KeyDerivator: deriveKey: security token reference: " + secTokRef));
        this.log.debug((Object)"KeyDerivator: deriveKey: No security token refernece available");
        return this.deriveTokenFromContext(convSession, dkInfo);
    }

    private byte[] deriveTokenFromContext(ConversationSession convSession, DerivedKeyInfo dkInfo) throws ConversationException {
        this.log.debug((Object)("KeyDerivator: deriving key from contecxt :" + convSession.getContextInfo().getIdentifier() + " for dkt: " + dkInfo.getId()));
        byte[] secret = convSession.getContextInfo().getSharedSecret();
        String labelAndNonce = this.getLabelAndNonce(convSession, dkInfo);
        long keyLength = this.getKeyLength(convSession, dkInfo);
        int offset = this.getOffset(convSession, dkInfo);
        DerivationAlgorithm derivationAlgo = AlgoFactory.getInstance(dkInfo.getAlgorithm());
        return derivationAlgo.createKey(secret, labelAndNonce, offset, keyLength);
    }

    private String getLabelAndNonce(ConversationSession convSession, DerivedKeyInfo dkInfo) throws ConversationException {
        String label = dkInfo.getLabel();
        if (label != null || (label = convSession.getLabel()) != null) {
            String nonce = dkInfo.getNonce();
            if (nonce != null) {
                this.log.debug((Object)("KeyDerivator: Inside get label and nocne : " + label + nonce));
                return label + nonce;
            }
            throw new ConversationException("Nonce value not available");
        }
        throw new ConversationException("Label cannot be found");
    }

    private long getKeyLength(ConversationSession convSession, DerivedKeyInfo dkInfo) throws ConversationException {
        long length = dkInfo.getLength();
        if (length != -1L) {
            this.log.debug((Object)("KeyDerivator: Inside get length: " + length));
            return length;
        }
        length = convSession.getKeyLength();
        if (length != -1L) {
            this.log.debug((Object)("KeyDerivator: Inside get length: " + length));
            return length;
        }
        throw new ConversationException("Length information not available");
    }

    private int getOffset(ConversationSession convSession, DerivedKeyInfo dkInfo) throws ConversationException {
        int offset = dkInfo.getOffset();
        int generation = dkInfo.getGeneration();
        long lengthFromDkInfo = dkInfo.getLength();
        if (generation != -1 && offset != -1) {
            throw new ConversationException("Generation and Offset both cannot be used simultaneously: Generation : " + generation + "Offset : " + offset);
        }
        if (convSession.getKeyLength() != -1L) {
            if (generation == -1) {
                this.log.debug((Object)"Generation set to zero");
                generation = 0;
                return (int)convSession.getKeyLength() * generation;
            }
            return (int)convSession.getKeyLength() * generation;
        }
        if (offset != -1) {
            return offset;
        }
        if (generation != -1) {
            if (dkInfo.getLength() != -1L) {
                return generation * (int)dkInfo.getLength();
            }
            throw new ConversationException("Length information not available");
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

