/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.CustomerGatewayDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class CreateCustomerGateway
extends BaseCmd {
    private String type;
    private String ip;
    private String asn;
    private static final String[] TYPE_DESC = new String[]{"The type of VPN connection this customer gateway supports."};
    private static final String[] IP_ADDRESS_DESC = new String[]{"The static Internet-routable IP address for the customer gateway's", "outside interface."};
    public static final String[] BGP_ASN_DESC = new String[]{"The customer gateway's Border Gateway Protocol (BGP) routing", "Autonomous System Number (ASN)."};

    public CreateCustomerGateway(String[] args) {
        super("ec2addcgw", "ec2-create-customer-gateway");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected String getOptionString() {
        return "-t TYPE -i IP -b BGP_ASN";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"type");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"TYPE");
        OptionBuilder.withDescription((String)CreateCustomerGateway.joinDescription(TYPE_DESC));
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withLongOpt((String)"ip");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"IP_ADDRESS");
        OptionBuilder.withDescription((String)CreateCustomerGateway.joinDescription(IP_ADDRESS_DESC));
        options.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.withLongOpt((String)"bgp-asn");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"BGP_ASN");
        OptionBuilder.withDescription((String)CreateCustomerGateway.joinDescription(BGP_ASN_DESC));
        options.addOption(OptionBuilder.create((String)"b"));
        return options;
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Provides information to AWS about your customer gateway device. You must");
        System.out.println("     provide the BGP ASN of the device and a static Internet-routable IP address");
        System.out.println("     of the customer gateway's outside interface.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("type");
        this.printOption("ip");
        this.printOption("bgp-asn");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        this.type = this.getOptionValue("type");
        this.ip = this.getOptionValue("ip");
        this.asn = this.getOptionValue("bgp-asn");
        int asn = Integer.parseInt(this.asn);
        RequestResultPair rsp = jec2.createCustomerGateway(this.type, this.ip, asn);
        out.output(System.out, (CustomerGatewayDescription)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    protected void validateParameters() {
        this.assertOptionSet("type");
        this.assertOptionSet("ip");
        this.assertOptionSet("bgp-asn");
    }

    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    public static void main(String[] args) {
        new CreateCustomerGateway(args).invoke();
    }
}

