/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.demos.raw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.flexdock.demos.util.DemoUtility;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.defaults.AbstractDockable;
import org.flexdock.docking.defaults.DefaultDockingPort;

public class SplitPaneDemo
extends JPanel
implements DockingConstants {
    private JLabel titlebar;
    private Dockable dockableImpl;

    public SplitPaneDemo(String title) {
        this.titlebar = this.createTitlebar(" " + title);
        this.add(this.titlebar);
        this.setBorder(new LineBorder(Color.black));
        this.dockableImpl = new DockableImpl();
    }

    private JLabel createTitlebar(String title) {
        JLabel lbl = new JLabel(title);
        lbl.setForeground(Color.white);
        lbl.setBackground(Color.blue);
        lbl.setOpaque(true);
        return lbl;
    }

    public String getTitle() {
        return this.titlebar.getText().trim();
    }

    public void doLayout() {
        Insets in = this.getInsets();
        this.titlebar.setBounds(in.left, in.top, this.getWidth() - in.left - in.right, 25);
    }

    private Dockable getDockable() {
        return this.dockableImpl;
    }

    private static JPanel createContentPane() {
        JPanel p = new JPanel(new BorderLayout(5, 5));
        p.add((Component)SplitPaneDemo.buildDockingPort("North"), "North");
        p.add((Component)SplitPaneDemo.buildDockingPort("South"), "South");
        p.add((Component)SplitPaneDemo.buildDockingPort("East"), "East");
        p.add((Component)SplitPaneDemo.buildDockingPort("West"), "West");
        p.add((Component)SplitPaneDemo.createDockingPort(), "Center");
        return p;
    }

    private static DefaultDockingPort buildDockingPort(String desc) {
        DefaultDockingPort port = SplitPaneDemo.createDockingPort();
        SplitPaneDemo spd = new SplitPaneDemo(desc);
        DockingManager.registerDockable(spd.getDockable());
        port.dock(spd.getDockable(), "CENTER");
        return port;
    }

    private static DefaultDockingPort createDockingPort() {
        DefaultDockingPort port = new DefaultDockingPort();
        port.setBackground(Color.gray);
        port.setPreferredSize(new Dimension(100, 100));
        port.getDockingProperties().setSingleTabsAllowed(true);
        port.setTabsAsDragSource(true);
        return port;
    }

    public static void main(String[] args) {
        DockingManager.setSingleTabsAllowed(true);
        JFrame f = new JFrame("Split Docking Demo");
        f.setContentPane(SplitPaneDemo.createContentPane());
        f.setSize(600, 400);
        DemoUtility.setCloseOperation(f);
        f.setVisible(true);
    }

    private class DockableImpl
    extends AbstractDockable {
        private DockableImpl() {
            super("dockable." + SplitPaneDemo.this.getTitle());
            this.getDragSources().add(SplitPaneDemo.this.titlebar);
            this.setTabText(SplitPaneDemo.this.getTitle());
        }

        public Component getComponent() {
            return SplitPaneDemo.this;
        }
    }
}

