/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource;

import com.google.common.base.Objects;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.NonNullApi;
import org.gradle.internal.UncheckedException;

@NonNullApi
public class ExternalResourceName
implements Describable {
    @Nullable
    private final String encodedRoot;
    private final String path;
    private final String encodedQuery;

    public ExternalResourceName(URI uri) {
        this(ExternalResourceName.encodeRoot(uri), ExternalResourceName.extractPath(uri), ExternalResourceName.extractQuery(uri));
    }

    public ExternalResourceName(String path) {
        this(null, path, "");
    }

    private ExternalResourceName(@Nullable String encodedRoot, String path) {
        this(encodedRoot, path, "");
    }

    public ExternalResourceName(URI parent, String path) {
        this(ExternalResourceName.encodeRoot(parent), ExternalResourceName.combine(parent, path), "");
    }

    private ExternalResourceName(@Nullable String encodedRoot, String path, String encodedQuery) {
        this.encodedRoot = encodedRoot;
        this.path = path;
        this.encodedQuery = encodedQuery;
    }

    public String getDisplayName() {
        return this.getDisplayable();
    }

    public String getShortDisplayName() {
        int lastSlash = this.path.lastIndexOf(47);
        return lastSlash == -1 ? this.getDisplayable() : this.path.substring(lastSlash + 1);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public URI getUri() {
        try {
            if (this.encodedRoot == null) {
                return new URI(ExternalResourceName.encode(this.path, false) + this.encodedQuery);
            }
            return new URI(this.encodedRoot + ExternalResourceName.encode(this.path, true) + this.encodedQuery);
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public String getDisplayable() {
        if (this.encodedRoot == null) {
            return ExternalResourceName.encode(this.path, false);
        }
        return this.encodedRoot + ExternalResourceName.encode(this.path, true);
    }

    public ExternalResourceName getRoot() {
        return new ExternalResourceName(this.encodedRoot, this.path.startsWith("/") ? "/" : "");
    }

    public String getPath() {
        return this.path;
    }

    public ExternalResourceName resolve(String path) {
        boolean leadingSlash;
        ArrayList<String> parts = new ArrayList<String>();
        boolean trailingSlash = path.endsWith("/");
        if (path.startsWith("/")) {
            leadingSlash = true;
        } else {
            leadingSlash = this.path.startsWith("/");
            this.append(this.path, parts);
        }
        this.append(path, parts);
        String newPath = this.join(leadingSlash, trailingSlash, parts);
        return new ExternalResourceName(this.encodedRoot, newPath);
    }

    public ExternalResourceName append(String path) {
        return new ExternalResourceName(this.encodedRoot, this.path + path);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        ExternalResourceName other = (ExternalResourceName)obj;
        return Objects.equal((Object)this.encodedRoot, (Object)other.encodedRoot) && this.path.equals(other.path);
    }

    public int hashCode() {
        return (this.encodedRoot == null ? 0 : this.encodedRoot.hashCode()) ^ this.path.hashCode();
    }

    private static String combine(URI parent, String path) {
        String childPath;
        String parentPath = ExternalResourceName.extractPath(parent);
        String string = childPath = path.startsWith("/") ? path.substring(1) : path;
        if (childPath.length() == 0) {
            return parentPath;
        }
        if (parentPath.endsWith("/")) {
            return parentPath + childPath;
        }
        return parentPath + "/" + childPath;
    }

    private static boolean isFileOnHost(URI uri) {
        return "file".equals(uri.getScheme()) && uri.getPath().startsWith("//");
    }

    private static String extractPath(URI parent) {
        if (ExternalResourceName.isFileOnHost(parent)) {
            return URI.create(parent.getPath()).getPath();
        }
        return parent.getPath();
    }

    private static String extractQuery(URI uri) {
        String rawQuery = uri.getRawQuery();
        if (rawQuery == null) {
            return "";
        }
        return "?" + rawQuery;
    }

    private static String encodeRoot(URI uri) {
        String path;
        if (uri.getPath() == null) {
            throw new IllegalArgumentException(String.format("Cannot create resource name from non-hierarchical URI '%s'.", uri));
        }
        StringBuilder builder = new StringBuilder(uri.toString());
        String fragment = uri.getRawFragment();
        if (fragment != null) {
            int index = builder.lastIndexOf("#" + fragment);
            if (index < 0) {
                throw new RuntimeException(String.format("Can't locate fragment in URI: %s", uri));
            }
            builder.delete(index, builder.length());
        }
        if (uri.isOpaque()) {
            return builder.toString();
        }
        String query = uri.getRawQuery();
        if (query != null) {
            int index = builder.lastIndexOf("?" + query);
            if (index < 0) {
                throw new RuntimeException(String.format("Can't locate query in URI: %s", uri));
            }
            builder.delete(index, builder.length());
        }
        if ((path = uri.getRawPath()) != null && ExternalResourceName.isFileOnHost(uri)) {
            path = URI.create(path).getRawPath();
        }
        if (path != null) {
            int index = builder.lastIndexOf(path);
            if (index < 0) {
                throw new RuntimeException(String.format("Can't locate path in URI: %s", uri));
            }
            builder.delete(index, builder.length());
        }
        return ExternalResourceName.encode(builder.toString(), true);
    }

    private static String encode(String path, boolean isPathSeg) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char ch = path.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') {
                builder.append(ch);
                continue;
            }
            if (ch == '/' || ch == '@' || isPathSeg && ch == ':' || ch == '.' || ch == '-' || ch == '_' || ch == '~' || ch == '!' || ch == '$' || ch == '&' || ch == '\'' || ch == '(' || ch == ')' || ch == '*' || ch == '+' || ch == ',' || ch == ';' || ch == '=') {
                builder.append(ch);
                continue;
            }
            if (ch <= '\u007f') {
                ExternalResourceName.escapeByte(ch, builder);
                continue;
            }
            if (ch <= '\u07ff') {
                ExternalResourceName.escapeByte(0xC0 | ch >> 6 & 0x1F, builder);
                ExternalResourceName.escapeByte(0x80 | ch & 0x3F, builder);
                continue;
            }
            ExternalResourceName.escapeByte(0xE0 | ch >> 12 & 0x1F, builder);
            ExternalResourceName.escapeByte(0x80 | ch >> 6 & 0x3F, builder);
            ExternalResourceName.escapeByte(0x80 | ch & 0x3F, builder);
        }
        return builder.toString();
    }

    private static void escapeByte(int ch, StringBuilder builder) {
        builder.append('%');
        builder.append(Character.toUpperCase(Character.forDigit(ch >> 4 & 0xFF, 16)));
        builder.append(Character.toUpperCase(Character.forDigit(ch & 0xF, 16)));
    }

    private String join(boolean leadingSlash, boolean trailingSlash, List<String> parts) {
        if (parts.isEmpty() && leadingSlash) {
            return "/";
        }
        StringBuilder builder = new StringBuilder();
        for (String part : parts) {
            if (builder.length() > 0 || leadingSlash) {
                builder.append("/");
            }
            builder.append(part);
        }
        if (trailingSlash) {
            builder.append("/");
        }
        return builder.toString();
    }

    private void append(String path, List<String> parts) {
        int pos = 0;
        while (pos < path.length()) {
            String part;
            int end = path.indexOf(47, pos);
            if (end < 0) {
                part = path.substring(pos);
                pos = path.length();
            } else {
                part = path.substring(pos, end);
                pos = end + 1;
            }
            if (part.length() == 0 || part.equals(".")) continue;
            if (part.equals("..")) {
                parts.remove(parts.size() - 1);
                continue;
            }
            parts.add(part);
        }
    }
}

