/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis.executables;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.opensolaris.opengrok.analysis.FileAnalyzer;
import org.opensolaris.opengrok.analysis.FileAnalyzerFactory;
import org.opensolaris.opengrok.analysis.IteratorReader;
import org.opensolaris.opengrok.analysis.StreamSource;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;

public class JavaClassAnalyzer
extends FileAnalyzer {
    private final String urlPrefix = RuntimeEnvironment.getInstance().getUrlPrefix();
    private static final String AHREF = "<a href=\"";
    private static final String AHREFT_END = "\">";
    private static final String AHREFEND = "</a>";
    private static final String ADEFS = "defs=";
    private static final String APATH = "path=";
    private static final String AIHREF = "\" href=\"";
    private static final String ADHREF = "<a class=\"d\" name=\"";
    private final StringBuffer rstring = new StringBuffer(512);
    private static final String PACKAGE = "package ";
    private static final char EOL = '\n';
    private static final char TAB = '\t';
    private static final char SPACE = ' ';
    private static final String EXTENDS = " extends ";
    private static final String IMPLEMENTS = " implements ";
    private static final String THROWS = " throws ";
    private static final String THIS = "this";
    private static final String LCBREOL = " {\n";
    private static final String LBRA = " (";
    private static final String COMMA = ", ";
    private static final String RBRA = ") ";
    private static final String RCBREOL = "}\n";

    protected JavaClassAnalyzer(FileAnalyzerFactory factory) {
        super(factory);
    }

    @Override
    public void analyze(Document doc, StreamSource src, Writer xrefOut) throws IOException {
        try (InputStream in = src.getStream();){
            this.analyze(doc, in, xrefOut);
        }
    }

    void analyze(Document doc, InputStream in, Writer xrefOut) throws IOException {
        ArrayList<String> defs = new ArrayList<String>();
        ArrayList<String> refs = new ArrayList<String>();
        ArrayList<String> full = new ArrayList<String>();
        ClassParser classparser = new ClassParser(in, doc.get("path"));
        StringWriter out = new StringWriter();
        StringWriter fout = new StringWriter();
        this.getContent(out, fout, classparser.parse(), defs, refs, full);
        String fullt = fout.toString();
        String xref = out.toString();
        if (xrefOut != null) {
            xrefOut.append(xref);
            try {
                xrefOut.flush();
            }
            catch (IOException ex) {
                Logger.getLogger(JavaClassAnalyzer.class.getName()).log(Level.WARNING, "Couldn't flush xref, will retry once added to doc", ex);
            }
        }
        xref = null;
        StringWriter cout = new StringWriter();
        for (String fl : full) {
            cout.write(fl);
            cout.write(10);
        }
        String constants = cout.toString();
        StringReader fullout = new StringReader(fullt);
        doc.add((IndexableField)new TextField("defs", (Reader)new IteratorReader(defs)));
        doc.add((IndexableField)new TextField("refs", (Reader)new IteratorReader(refs)));
        doc.add((IndexableField)new TextField("full", (Reader)fullout));
        doc.add((IndexableField)new TextField("full", constants, Field.Store.NO));
    }

    protected String linkPath(String path) {
        this.rstring.setLength(0);
        return this.rstring.append(AHREF).append(this.urlPrefix).append(APATH).append(path).append(AHREFT_END).append(path).append(AHREFEND).toString();
    }

    protected String linkDef(String def) {
        this.rstring.setLength(0);
        return this.rstring.append(AHREF).append(this.urlPrefix).append(ADEFS).append(def).append(AHREFT_END).append(def).append(AHREFEND).toString();
    }

    protected String tagDef(String def) {
        this.rstring.setLength(0);
        return this.rstring.append(ADHREF).append(def).append(AIHREF).append(this.urlPrefix).append(ADEFS).append(def).append(AHREFT_END).append(def).append(AHREFEND).toString();
    }

    private void getContent(Writer out, Writer fout, JavaClass c, List<String> defs, List<String> refs, List<String> full) throws IOException {
        String aflgs;
        ConstantPool cp = c.getConstantPool();
        int[] v = new int[cp.getLength() + 1];
        String t = c.getSourceFileName();
        out.write(this.linkPath(t));
        defs.add(t);
        refs.add(t);
        fout.write(t);
        out.write(10);
        fout.write(10);
        out.write(PACKAGE);
        fout.write(PACKAGE);
        t = c.getPackageName();
        out.write(this.linkDef(t));
        defs.add(t);
        refs.add(t);
        fout.write(t);
        out.write(10);
        fout.write(10);
        String aflg = Utility.accessToString(c.getAccessFlags(), true);
        out.write(aflg);
        if (aflg != null) {
            out.write(32);
            fout.write(aflg);
            fout.write(32);
        }
        v[c.getClassNameIndex()] = 1;
        t = c.getClassName();
        out.write(this.tagDef(t));
        defs.add(t);
        refs.add(t);
        fout.write(t);
        out.write(EXTENDS);
        fout.write(EXTENDS);
        v[c.getSuperclassNameIndex()] = 1;
        t = c.getSuperclassName();
        out.write(this.linkDef(t));
        refs.add(t);
        fout.write(t);
        for (int i : c.getInterfaceIndices()) {
            v[i] = 1;
        }
        String[] ins = c.getInterfaceNames();
        if (ins != null && ins.length > 0) {
            out.write(IMPLEMENTS);
            fout.write(IMPLEMENTS);
            String[] stringArray = ins;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String in;
                t = in = stringArray[i];
                out.write(this.linkDef(t));
                refs.add(t);
                fout.write(t);
                out.write(32);
                fout.write(32);
            }
        }
        out.write(LCBREOL);
        fout.write(LCBREOL);
        for (Attribute a : c.getAttributes()) {
            if (a.getTag() == 2) {
                Attribute[] attributeArray = ((Code)a).getAttributes();
                int n = attributeArray.length;
                for (int i = 0; i < n; ++i) {
                    Attribute ca = attributeArray[i];
                    if (ca.getTag() != 5) continue;
                    for (LocalVariable l : ((LocalVariableTable)ca).getLocalVariableTable()) {
                        this.printLocal(out, fout, l, v, defs, refs);
                    }
                }
                continue;
            }
            if (a.getTag() != 0) continue;
            v[a.getNameIndex()] = 1;
            break;
        }
        for (Field fld : c.getFields()) {
            out.write(9);
            fout.write(9);
            aflgs = Utility.accessToString(fld.getAccessFlags());
            if (aflgs != null && aflgs.length() > 0) {
                out.write(aflgs);
                fout.write(aflgs);
                fout.write(32);
                out.write(32);
            }
            String fldsig = Utility.signatureToString(fld.getSignature());
            out.write(fldsig);
            fout.write(fldsig);
            out.write(32);
            fout.write(32);
            t = fld.getName();
            String tdef = this.tagDef(t);
            out.write(tdef);
            fout.write(tdef);
            defs.add(t);
            refs.add(t);
            out.write(10);
            fout.write(10);
        }
        for (Method m : c.getMethods()) {
            out.write(9);
            fout.write(9);
            aflgs = Utility.accessToString(m.getAccessFlags());
            if (aflgs != null && aflgs.length() > 0) {
                out.write(aflgs);
                fout.write(aflgs);
                out.write(32);
                fout.write(32);
            }
            String sig = m.getSignature();
            String msig = Utility.methodSignatureReturnType(sig, false);
            out.write(msig);
            fout.write(msig);
            out.write(32);
            fout.write(32);
            t = m.getName();
            String ltdef = this.tagDef(t);
            out.write(ltdef);
            fout.write(ltdef);
            defs.add(t);
            refs.add(t);
            out.write(LBRA);
            fout.write(LBRA);
            String[] args = Utility.methodSignatureArgumentTypes(sig, false);
            for (int i = 0; i < args.length; ++i) {
                t = args[i];
                out.write(t);
                fout.write(t);
                int spi = t.indexOf(32);
                if (spi > 0) {
                    refs.add(t.substring(0, spi));
                    defs.add(t.substring(spi + 1));
                }
                if (i >= args.length - 1) continue;
                out.write(COMMA);
                fout.write(COMMA);
            }
            out.write(RBRA);
            fout.write(RBRA);
            ArrayList<LocalVariable[]> locals = new ArrayList<LocalVariable[]>();
            for (Attribute a : m.getAttributes()) {
                if (a.getTag() == 3) {
                    for (int i : ((ExceptionTable)a).getExceptionIndexTable()) {
                        v[i] = 1;
                    }
                    String[] stringArray = ((ExceptionTable)a).getExceptionNames();
                    if (stringArray == null || stringArray.length <= 0) continue;
                    out.write(THROWS);
                    fout.write(THROWS);
                    String[] stringArray2 = stringArray;
                    int n = stringArray2.length;
                    for (int i = 0; i < n; ++i) {
                        String ex = stringArray2[i];
                        out.write(this.linkDef(ex));
                        fout.write(ex);
                        refs.add(ex);
                        out.write(32);
                        fout.write(32);
                    }
                    continue;
                }
                if (a.getTag() != 2) continue;
                for (Attribute ca : ((Code)a).getAttributes()) {
                    if (ca.getTag() != 5) continue;
                    locals.add(((LocalVariableTable)ca).getLocalVariableTable());
                }
            }
            out.write(10);
            fout.write(10);
            if (locals.isEmpty()) continue;
            Iterator iterator = locals.iterator();
            while (iterator.hasNext()) {
                LocalVariable[] ls;
                for (LocalVariable l : ls = (LocalVariable[])iterator.next()) {
                    this.printLocal(out, fout, l, v, defs, refs);
                }
            }
        }
        out.write(RCBREOL);
        fout.write(RCBREOL);
        for (int i = 0; i < v.length - 1; ++i) {
            Constant constant;
            if (v[i] == 1 || (constant = cp.getConstant(i)) == null) continue;
            full.add(this.constantToString(constant, cp, v));
        }
    }

    private void printLocal(Writer out, Writer fout, LocalVariable l, int[] v, List<String> defs, List<String> refs) throws IOException {
        v[l.getIndex()] = 1;
        v[l.getNameIndex()] = 1;
        v[l.getSignatureIndex()] = 1;
        if (!THIS.equals(l.getName())) {
            out.write(9);
            out.write(9);
            fout.write(9);
            fout.write(9);
            String sig = Utility.signatureToString(l.getSignature());
            out.write(sig);
            fout.write(sig);
            out.write(32);
            fout.write(32);
            String t = l.getName();
            out.write(t);
            defs.add(t);
            refs.add(t);
            fout.write(t);
            out.write(10);
            fout.write(10);
        }
    }

    public String constantToString(Constant c, ConstantPool cp, int[] v) throws ClassFormatException {
        String str;
        byte tag = c.getTag();
        switch (tag) {
            case 7: {
                int i = ((ConstantClass)c).getNameIndex();
                v[i] = 1;
                Constant con = cp.getConstant(i, (byte)1);
                str = Utility.compactClassName(((ConstantUtf8)con).getBytes(), false);
                break;
            }
            case 8: {
                int i = ((ConstantString)c).getStringIndex();
                v[i] = 1;
                Constant con2 = cp.getConstant(i, (byte)1);
                str = ((ConstantUtf8)con2).getBytes();
                break;
            }
            case 1: {
                str = ((ConstantUtf8)c).toString();
                break;
            }
            case 6: {
                str = ((ConstantDouble)c).toString();
                break;
            }
            case 4: {
                str = ((ConstantFloat)c).toString();
                break;
            }
            case 5: {
                str = ((ConstantLong)c).toString();
                break;
            }
            case 3: {
                str = ((ConstantInteger)c).toString();
                break;
            }
            case 12: {
                int i = ((ConstantNameAndType)c).getNameIndex();
                v[i] = 1;
                int j = ((ConstantNameAndType)c).getSignatureIndex();
                v[j] = 1;
                String sig = this.constantToString(cp.getConstant(j), cp, v);
                if (sig.charAt(0) == '(') {
                    str = Utility.methodSignatureToString(sig, this.constantToString(cp.getConstant(i), cp, v), " ");
                    break;
                }
                str = Utility.signatureToString(sig) + ' ' + this.constantToString(cp.getConstant(i), cp, v);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                int i = ((ConstantCP)c).getClassIndex();
                v[i] = 1;
                int j = ((ConstantCP)c).getNameAndTypeIndex();
                v[j] = 1;
                str = this.constantToString(cp.getConstant(i), cp, v) + ' ' + this.constantToString(cp.getConstant(j), cp, v);
                break;
            }
            default: {
                throw new ClassFormatException("Unknown constant type " + tag);
            }
        }
        return str;
    }
}

