<?php

/**
 * BaseComment
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                                    $id                                 Type: integer, primary key
 * @property int                                    $share_id                           Type: integer
 * @property int                                    $employee_number                    Type: integer(7)
 * @property int                                    $number_of_likes                    Type: integer(6)
 * @property int                                    $number_of_unlikes                  Type: integer(6)
 * @property string                                 $comment_text                       Type: string
 * @property string                                 $comment_time                       Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property string                                 $updated_at                         Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property Employee                               $employeeComment                    
 * @property Share                                  $shareComment                       
 * @property Doctrine_Collection|LikeOnComment[]    $Like                               
 * @property Doctrine_Collection|UnLikeOnComment[]  $Unlike                             
 *  
 * @method int                                      getId()                             Type: integer, primary key
 * @method int                                      getShareId()                        Type: integer
 * @method int                                      getEmployeeNumber()                 Type: integer(7)
 * @method int                                      getNumberOfLikes()                  Type: integer(6)
 * @method int                                      getNumberOfUnlikes()                Type: integer(6)
 * @method string                                   getCommentText()                    Type: string
 * @method string                                   getCommentTime()                    Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method string                                   getUpdatedAt()                      Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method Employee                                 getEmployeeComment()                
 * @method Share                                    getShareComment()                   
 * @method Doctrine_Collection|LikeOnComment[]      getLike()                           
 * @method Doctrine_Collection|UnLikeOnComment[]    getUnlike()                         
 *  
 * @method Comment                                  setId(int $val)                     Type: integer, primary key
 * @method Comment                                  setShareId(int $val)                Type: integer
 * @method Comment                                  setEmployeeNumber(int $val)         Type: integer(7)
 * @method Comment                                  setNumberOfLikes(int $val)          Type: integer(6)
 * @method Comment                                  setNumberOfUnlikes(int $val)        Type: integer(6)
 * @method Comment                                  setCommentText(string $val)         Type: string
 * @method Comment                                  setCommentTime(string $val)         Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method Comment                                  setUpdatedAt(string $val)           Type: timestamp, Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method Comment                                  setEmployeeComment(Employee $val)   
 * @method Comment                                  setShareComment(Share $val)         
 * @method Comment                                  setLike(Doctrine_Collection $val)   
 * @method Comment                                  setUnlike(Doctrine_Collection $val) 
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseComment extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_buzz_comment');
        $this->hasColumn('id', 'integer', null, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => '',
             ));
        $this->hasColumn('share_id', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             'length' => '',
             ));
        $this->hasColumn('employee_number', 'integer', 7, array(
             'type' => 'integer',
             'length' => 7,
             ));
        $this->hasColumn('number_of_likes', 'integer', 6, array(
             'type' => 'integer',
             'length' => 6,
             ));
        $this->hasColumn('number_of_unlikes', 'integer', 6, array(
             'type' => 'integer',
             'length' => 6,
             ));
        $this->hasColumn('comment_text', 'string', null, array(
             'type' => 'string',
             ));
        $this->hasColumn('comment_time', 'timestamp', null, array(
             'type' => 'timestamp',
             'notnull' => true,
             ));
        $this->hasColumn('updated_at', 'timestamp', null, array(
             'type' => 'timestamp',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Employee as employeeComment', array(
             'local' => 'employee_number',
             'foreign' => 'empNumber'));

        $this->hasOne('Share as shareComment', array(
             'local' => 'share_id',
             'foreign' => 'id'));

        $this->hasMany('LikeOnComment as Like', array(
             'local' => 'id',
             'foreign' => 'comment_id'));

        $this->hasMany('UnLikeOnComment as Unlike', array(
             'local' => 'id',
             'foreign' => 'comment_id'));
    }
}