/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf;

import com.jidesoft.plaf.LookAndFeelFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

class CachedLookAndFeel
extends LookAndFeel {
    static ClassLoader currentLoader;
    UIDefaults customDefaults = new CustomUIDefaults();

    public static void install() {
        try {
            Method method = UIManager.class.getDeclaredMethod("getLAFState", new Class[]{null});
            method.setAccessible(true);
            Object lafState = method.invoke(null, new Object[]{null});
            Field field = lafState.getClass().getDeclaredField("multiLookAndFeel");
            field.setAccessible(true);
            CachedLookAndFeel laf = new CachedLookAndFeel();
            field.set(lafState, laf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return "CachedLookAndFeel";
    }

    public String getID() {
        return "CachedLookAndFeel";
    }

    public String getDescription() {
        return "Provide customized behaviour for getUI() method";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public UIDefaults getDefaults() {
        return this.customDefaults;
    }

    public static void installJideExtension(ClassLoader newLoader) {
        CachedLookAndFeel.installJideExtension(newLoader, false);
    }

    public static void installJideExtension(ClassLoader newLoader, boolean force) {
        if (currentLoader == newLoader && !force) {
            return;
        }
        try {
            Class<?> lafFactory = newLoader.loadClass("com.jidesoft.plaf.LookAndFeelFactory");
            Method installJideExtension = lafFactory.getDeclaredMethod("installJideExtension", Integer.TYPE);
            int style = LookAndFeelFactory.getDefaultStyle();
            UIManager.put("jidesoft.extensionInstalled", null);
            installJideExtension.invoke(null, style);
        }
        catch (Exception exception) {
            // empty catch block
        }
        currentLoader = newLoader;
        UIManager.put("ClassLoader", newLoader);
    }

    public static void reinstallJideExtension() {
        CachedLookAndFeel.installJideExtension(currentLoader, true);
    }

    private static void removeCachedClass(UIDefaults defaults, Class componentUIClass) {
        if (componentUIClass != null) {
            defaults.remove(componentUIClass.getName());
            defaults.remove(componentUIClass);
        }
    }

    static class CustomUIDefaults
    extends UIDefaults {
        private static final long serialVersionUID = -6034471887061473005L;

        CustomUIDefaults() {
        }

        public ComponentUI getUI(JComponent target) {
            UIDefaults defaults = UIManager.getDefaults();
            String className = (String)defaults.get(target.getUIClassID());
            Class componentUIClass = className != null ? (Class)defaults.get(className) : null;
            ClassLoader componentUIClassLoader = componentUIClass != null ? componentUIClass.getClassLoader() : null;
            ClassLoader targetClassLoader = target.getClass().getClassLoader();
            ClassLoader uiClassLoader = (ClassLoader)UIManager.get("ClassLoader");
            if (targetClassLoader == null) {
                if (componentUIClassLoader != null && componentUIClassLoader != uiClassLoader) {
                    CachedLookAndFeel.removeCachedClass(defaults, componentUIClass);
                }
                return null;
            }
            if (targetClassLoader != componentUIClassLoader || targetClassLoader != uiClassLoader) {
                if (componentUIClassLoader != null) {
                    CachedLookAndFeel.removeCachedClass(defaults, componentUIClass);
                }
                CachedLookAndFeel.installJideExtension(targetClassLoader);
            }
            return null;
        }
    }
}

