/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TailExpression
extends Expression {
    Expression base;
    int start;

    public TailExpression(Expression base, int start) {
        this.base = base;
        this.start = start;
        this.adoptChildExpression(base);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.base = visitor.typeCheck(this.base, contextItemType);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.base = visitor.optimize(this.base, contextItemType);
        if (this.base instanceof Literal) {
            GroundedValue value = SequenceExtent.makeSequenceExtent(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext()));
            return Literal.makeLiteral(value);
        }
        return this;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        if (offer.action != 13) {
            this.base = this.doPromotion(this.base, offer);
        }
        return this;
    }

    @Override
    public int computeSpecialProperties() {
        return this.base.getSpecialProperties();
    }

    @Override
    public Expression copy() {
        return new TailExpression(this.base.copy(), this.start);
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.base.getItemType(th);
    }

    @Override
    public int computeCardinality() {
        return this.base.getCardinality() | 0x2000;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new MonoIterator<Expression>(this.base);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.base == original) {
            this.base = replacement;
            found = true;
        }
        return found;
    }

    public Expression getBaseExpression() {
        return this.base;
    }

    public int getStart() {
        return this.start;
    }

    public boolean equals(Object other) {
        return other instanceof TailExpression && this.base.equals(((TailExpression)other).base) && this.start == ((TailExpression)other).start;
    }

    public int hashCode() {
        return this.base.hashCode();
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator<? extends Item> baseIter = this.base.iterate(context);
        return TailIterator.make(baseIter, this.start);
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("tail");
        destination.emitAttribute("start", this.start + "");
        this.base.explain(destination);
        destination.endElement();
    }

    @Override
    public String toString() {
        if (this.start == 2) {
            return "tail(" + this.base.toString() + ")";
        }
        return ExpressionTool.parenthesize(this.base) + "[position() ge " + this.start + "]";
    }
}

