/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.search.SearchEngine;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.tools.ant.BuildException;

public class IvyListModules
extends IvyTask {
    private String organisation;
    private String module;
    private String branch = "*";
    private String revision;
    private String matcher = "exactOrRegexp";
    private String property;
    private String value;
    private String resolver;

    public String getMatcher() {
        return this.matcher;
    }

    public void setMatcher(String string) {
        this.matcher = string;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String string) {
        this.module = string;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String string) {
        this.organisation = string;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String string) {
        this.revision = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String string) {
        this.branch = string;
    }

    public void setResolver(String string) {
        this.resolver = string;
    }

    public String getResolver() {
        return this.resolver;
    }

    @Override
    public void doExecute() throws BuildException {
        ModuleRevisionId[] moduleRevisionIdArray;
        if (this.organisation == null) {
            throw new BuildException("no organisation provided for ivy listmodules task");
        }
        if (this.module == null) {
            throw new BuildException("no module name provided for ivy listmodules task");
        }
        if (this.revision == null) {
            throw new BuildException("no revision provided for ivy listmodules task");
        }
        if (this.property == null) {
            throw new BuildException("no property provided for ivy listmodules task");
        }
        if (this.value == null) {
            throw new BuildException("no value provided for ivy listmodules task");
        }
        Ivy ivy = this.getIvyInstance();
        IvySettings ivySettings = ivy.getSettings();
        SearchEngine searchEngine = new SearchEngine(ivySettings);
        PatternMatcher patternMatcher = ivySettings.getMatcher(this.matcher);
        if (this.resolver == null) {
            moduleRevisionIdArray = searchEngine.listModules(ModuleRevisionId.newInstance(this.organisation, this.module, this.branch, this.revision), patternMatcher);
        } else {
            DependencyResolver dependencyResolver = ivySettings.getResolver(this.resolver);
            if (dependencyResolver == null) {
                throw new BuildException("Unknown resolver: " + this.resolver);
            }
            moduleRevisionIdArray = searchEngine.listModules(dependencyResolver, ModuleRevisionId.newInstance(this.organisation, this.module, this.branch, this.revision), patternMatcher);
        }
        for (int i = 0; i < moduleRevisionIdArray.length; ++i) {
            String string = IvyPatternHelper.substitute(ivySettings.substitute(this.property), moduleRevisionIdArray[i]);
            String string2 = IvyPatternHelper.substitute(ivySettings.substitute(this.value), moduleRevisionIdArray[i]);
            this.getProject().setProperty(string, string2);
        }
    }
}

