<?php

return [
    'AD' => [
        '02' => '02',
        '03' => '03',
        '04' => '04',
        '05' => '05',
        '06' => '06',
        '07' => '07',
        '08' => '08',
    ],
    'AE' => [
        '01' => 'AZ',
        '02' => 'AJ',
        '03' => 'DU',
        '04' => 'FU',
        '05' => 'RK',
        '06' => 'SH',
        '07' => 'UQ',
    ],
    'AF' => [
        '01' => 'BDS', // Badakhshan
        '02' => 'BDG', // Badghis
        '03' => 'BGL', // Baghlan
        '05' => 'BAM', // Bamian
        '06' => 'FRA', // Farah
        '07' => 'FYB', // Faryab
        '08' => 'GHA', // Ghazni
        '09' => 'GHO', // Ghowr
        '10' => 'HEL', // Helmand
        '11' => 'HER', // Herat
        '13' => 'KAB', // Kabol
        '14' => 'KAP', // Kapisa
        '17' => 'LOG', // Lowgar
        '18' => 'NAN', // Nangarhar
        '19' => 'NIM', // Nimruz
        '23' => 'KAN', // Kandahar
        '24' => 'KDZ', // Kondoz
        '26' => 'TAK', // Takhar
        '27' => 'WAR', // Vardak
        '28' => 'ZAB', // Zabol
        '29' => 'PKA', // Paktika
        '30' => 'BAL', // Balkh
        '31' => 'JOW', // Jowzjan
        '32' => 'SAM', // Samangan
        '33' => 'SAR', // Sar-e Pol
        '34' => 'KNR', // Konar
        '35' => 'LAG', // Laghman
        '36' => 'PIA', // Paktia
        '37' => 'KHO', // Khowst
        '38' => 'NUR', // Nurestan
        '39' => 'URU', // Oruzgan
        '40' => 'PAR', // Parvan
        '41' => 'DAY', // Daykondi
        '42' => 'PAN', // Panjshir
    ],
    'AG' => [
        '01' => '10',
        '03' => '03',
        '04' => '04',
        '05' => '05',
        '06' => '06',
        '07' => '07',
        '08' => '08',
        '09' => '11',
    ],
    'AL' => [
        '40' => '01',
        '41' => '09',
        '42' => '02',
        '43' => '03',
        '44' => '04',
        '45' => '05',
        '46' => '06',
        '47' => '07',
        '48' => '08',
        '49' => '10',
        '50' => '11',
        '51' => '12',
    ],
    'AM' => [
        '01' => 'AG',
        '02' => 'AR',
        '03' => 'AV',
        '04' => 'GR',
        '05' => 'KT',
        '06' => 'LO',
        '07' => 'SH',
        '08' => 'SU',
        '09' => 'TV',
        '10' => 'VD',
        '11' => 'ER',
    ],
    'AO' => [
        '01' => 'BGU',
        '02' => 'BIE',
        '03' => 'CAB',
        '04' => 'CCU',
        '05' => 'CNO',
        '06' => 'CUS',
        '07' => 'CNN',
        '08' => 'HUA',
        '09' => 'HUI',
        '12' => 'MAL',
        '13' => 'NAM',
        '14' => 'MOX',
        '15' => 'UIG',
        '16' => 'ZAI',
        '17' => 'LNO',
        '18' => 'LSU',
        '19' => 'BGO',
        '20' => 'LUA',
    ],
    'AR' => [
        '01' => 'B',
        '02' => 'K',
        '03' => 'H',
        '04' => 'U',
        '05' => 'X',
        '06' => 'W',
        '07' => 'C',
        '08' => 'E',
        '09' => 'P',
        '10' => 'Y',
        '11' => 'L',
        '12' => 'F',
        '13' => 'M',
        '14' => 'N',
        '15' => 'Q',
        '16' => 'R',
        '17' => 'A',
        '18' => 'J',
        '19' => 'D',
        '20' => 'Z',
        '21' => 'S',
        '22' => 'G',
        '23' => 'V',
        '24' => 'T',
    ],
    'AT' => [
        '01' => '1',
        '02' => '2',
        '03' => '3',
        '04' => '4',
        '05' => '5',
        '06' => '6',
        '07' => '7',
        '08' => '8',
        '09' => '9',
    ],
    'AU' => [
        '01' => 'ACT',
        '02' => 'NSW',
        '03' => 'NT',
        '04' => 'QLD',
        '05' => 'SA',
        '06' => 'TAS',
        '07' => 'VIC',
        '08' => 'WA',
    ],
    'AZ' => [
        '01' => 'ABS', // Abseron
        '02' => 'AGC', // Agcabadi
        '03' => 'AGM', // Agdam
        '04' => 'AGS', // Agdas
        '05' => 'AGA', // Agstafa
        '06' => 'AGU', // Agsu
        '07' => '', // Ali Bayramli
        '08' => 'AST', // Astara
        '09' => 'BA', // Baki
        '10' => 'BAL', // Balakan
        '11' => 'BAR', // Barda
        '12' => 'BEY', // Beylaqan
        '13' => 'BIL', // Bilasuvar
        '14' => 'CAB', // Cabrayil
        '15' => 'CAL', // Calilabad
        '16' => 'DAS', // Daskasan
        '17' => '', // Davaci
        '18' => 'FUZ', // Fuzuli
        '19' => 'GAD', // Gadabay
        '20' => 'GA', // Ganca
        '21' => 'GOR', // Goranboy
        '22' => 'GOY', // Goycay
        '23' => 'HAC', // Haciqabul
        '24' => 'IMI', // Imisli
        '25' => 'ISM', // Ismayilli
        '26' => 'KAL', // Kalbacar
        '27' => 'KUR', // Kurdamir
        '28' => 'LAC', // Lacin
        '29' => 'LAN', // Lankaran
        '30' => 'LA', // Lankaran city
        '31' => 'LER', // Lerik
        '32' => 'MAS', // Masalli
        '33' => 'MI', // Mingacevir
        '34' => 'NA', // Naftalan
        '35' => 'NV', // Naxcivan
        '36' => 'NEF', // Neftcala
        '37' => 'OGU', // Oguz
        '38' => 'QAB', // Qabala
        '39' => 'QAX', // Qax
        '40' => 'QAZ', // Qazax
        '41' => 'QOB', // Qobustan
        '42' => 'QBA', // Quba
        '43' => 'QBI', // Qubadli
        '44' => 'QUS', // Qusar
        '45' => 'SAT', // Saatli
        '46' => 'SAB', // Sabirabad
        '47' => 'SAK', // Saki
        '48' => 'SA', // Saki
        '49' => 'SAL', // Salyan
        '50' => 'SMI', // Samaxi
        '51' => 'SKR', // Samkir
        '52' => 'SMX', // Samux
        '53' => 'SIY', // Siyazan
        '54' => 'SM', // Sumqayit
        '55' => 'SUS', // Susa
        '56' => 'SUS', // Susa  City Şuşa used to have SS, but was deleted in 2011. See https://en.wikipedia.org/wiki/ISO_3166-2:AZ#Changes. Now maps to region Şuşa [SUS]
        '57' => 'TAR', // Tartar
        '58' => 'TOV', // Tovuz
        '59' => 'UCA', // Ucar
        '60' => 'XAC', // Xacmaz
        '61' => 'XA', // Xankandi
        '62' => 'GYG', // Xanlar
        '63' => 'XIZ', // Xizi
        '64' => 'XCI', // Xocali
        '65' => 'XVD', // Xocavand
        '66' => 'YAR', // Yardimli
        '67' => 'YEV', // Yevlax
        '68' => 'YE', // Yevlax
        '69' => 'ZAN', // Zangilan
        '70' => 'ZAQ', // Zaqatala
        '71' => 'ZAR', // Zardab
    ],
    'BA' => [
        '01' => 'BIH',
        '02' => 'SRP',

        // invalid codes  [used by maxmind]
        '03' => 'BRC' //  Brčko distrikt was added in 2010. See https://en.wikipedia.org/wiki/ISO_3166-2:BA#Changes
    ],
    'BB' => [
        '01' => '01',
        '02' => '02',
        '03' => '03',
        '04' => '04',
        '05' => '05',
        '06' => '06',
        '07' => '07',
        '08' => '08',
        '09' => '09',
        '10' => '10',
        '11' => '11',
    ],
    'BD' => [
        '81' => 'C',
        '82' => 'D',
        '83' => 'E',
        '84' => 'B',
        '85' => 'A',
        '86' => 'G',

        // invalid codes  [used by maxmind]
        '87' => 'F' // Rangpur added in 2011. See https://en.wikipedia.org/wiki/ISO_3166-2:BD#Changes
    ],
    'BE' => [
        '01' => 'VAN',
        '03' => 'WHT',
        '04' => 'WLG',
        '05' => 'VLI',
        '06' => 'WLX',
        '07' => 'WNA',
        '08' => 'VOV',
        '09' => 'VWV',
        '10' => 'WBR',
        '11' => 'BRU',
        '12' => 'VBR',

        // Conventional FIPS codes that are not listed on wikidata
        '13' => 'VLG',  // Flanders
        '14' => 'WAL'  // Wallonia
    ],
    'BF' => [
        '15' => 'BAM', // Bam
        '19' => 'BLK', // Boulkiemde
        '20' => 'GAN', // Ganzourgou
        '21' => 'GNA', // Gnagna
        '28' => 'KOT', // Kouritenga
        '33' => 'OUD', // Oudalan
        '34' => 'PAS', // Passore
        '36' => 'SNG', // Sanguie
        '40' => 'SOM', // Soum
        '42' => 'TAP', // Tapoa
        '44' => 'ZOU', // Zoundweogo
        '45' => 'BAL', // Bale
        '46' => 'BAN', // Banwa
        '47' => 'BAZ', // Bazega
        '48' => 'BGR', // Bougouriba
        '49' => 'BLG', // Boulgou
        '50' => 'GOU', // Gourma
        '51' => 'HOU', // Houet
        '52' => 'IOB', // Ioba
        '53' => 'KAD', // Kadiogo
        '54' => 'KEN', // Kenedougou
        '55' => 'COM', // Komoe
        '56' => 'KMD', // Komondjari
        '57' => 'KMP', // Kompienga
        '58' => 'KOS', // Kossi
        '59' => 'KOP', // Koulpelogo
        '60' => 'KOW', // Kourweogo
        '61' => 'LER', // Leraba
        '62' => 'LOR', // Loroum
        '63' => 'MOU', // Mouhoun
        '64' => 'NAM', // Namentenga
        '65' => 'NAO', // Naouri
        '66' => 'NAY', // Nayala
        '67' => 'NOU', // Noumbiel
        '68' => 'OUB', // Oubritenga
        '69' => 'PON', // Poni
        '70' => 'SMT', // Sanmatenga
        '71' => 'SEN', // Seno
        '72' => 'SIS', // Sissili
        '73' => 'SOR', // Sourou
        '74' => 'TUI', // Tuy
        '75' => 'YAG', // Yagha
        '76' => 'YAT', // Yatenga
        '77' => 'ZIR', // Ziro
        '78' => 'ZON', // Zondoma
    ],
    'BG' => [
        '38' => '01',
        '39' => '02',
        '40' => '08',
        '41' => '07',
        '42' => '23',
        '43' => '26',
        '44' => '09',
        '45' => '10',
        '46' => '11',
        '47' => '12',
        '48' => '13',
        '49' => '14',
        '50' => '15',
        '51' => '16',
        '52' => '17',
        '53' => '18',
        '54' => '27',
        '55' => '19',
        '56' => '20',
        '57' => '21',
        '58' => '23',
        '59' => '24',
        '60' => '25',
        '61' => '03',
        '62' => '04',
        '63' => '05',
        '64' => '06',
        '65' => '28',

        // Mikhaylovgrad seems to be a city in the region Montana
        '33' => '12'
    ],
    'BH' => [
        '01' => '15', // Al Hadd => Muharraq Governorate (https://en.wikipedia.org/wiki/Al_Hidd)
        '02' => '13', // Al Manamah => Capital Governorate (https://en.wikipedia.org/wiki/Manama)
        '05' => '', // Jidd Hafs => Capital and Northern Governorate 13/17 (https://en.wikipedia.org/wiki/Jidhafs)
        '06' => '', // Sitrah  => Capital and Southern Governorate 13/14 (https://en.wikipedia.org/wiki/Sitra)
        '08' => '', // Al Mintaqah al Gharbiyah => Northern and Southern Governorate 17/14 (https://en.wikipedia.org/wiki/Western_Region,_Bahrain)
        '09' => '14', // Mintaqat Juzur Hawar => Southern Governorate (https://en.wikipedia.org/wiki/Hawar_Islands)
        '10' => '17', // Al Mintaqah ash Shamaliyah => Northern Governorate (https://en.wikipedia.org/wiki/Northern_Region,_Bahrain)
        '11' => '', // Al Mintaqah al Wusta => Capital and Northern Governorates 13/17 (https://en.wikipedia.org/wiki/Central_Region,_Bahrain)
        '12' => '14', // Madīnat ٰĪsá => seems to be Southern Governorate based on the maps shown on wikipedia (https://en.wikipedia.org/wiki/Isa_Town)
        '13' => '14', // Ar Rifa => Southern Governorates (https://en.wikipedia.org/wiki/Rifa_and_Southern_Region,_Bahrain)
        '14' => '17', // Madinat Hamad => Northern Governorate (https://en.wikipedia.org/wiki/Hamad_Town)
        '15' => '15',
        '16' => '13',
        '17' => '14',
        '18' => '17',
        '19' => '', // seems to be Southern and Northern Governorate 14/17 based on the maps shown on wikipedia (https://en.wikipedia.org/wiki/Isa_Town)
    ],
    'BI' => [
        '02' => '', // Bujumbura was splitted into Bujumbura Mairie (BM) and Bujumbura Rural (BL) in 2010
        '09' => 'BB',
        '10' => 'BR',
        '11' => 'CA',
        '12' => 'CI',
        '13' => 'GI',
        '14' => 'KR',
        '15' => 'KY',
        '16' => 'KI',
        '17' => 'MA',
        '18' => 'MY',
        '19' => 'NG',
        '20' => 'RT',
        '21' => 'RY',
        '22' => 'MU',
        '23' => 'MW',
    ],
    'BJ' => [
        '07' => 'AL',
        '08' => 'AK',
        '09' => 'AQ',
        '10' => 'BO',
        '11' => 'CO',
        '12' => 'KO',
        '13' => 'DO',
        '14' => 'LI',
        '15' => 'MO',
        '16' => 'OU',
        '17' => 'PL',
        '18' => 'ZO',
    ],
    'BM' => [
        // ISO 3166-2 does not define any subdivisions of Bermuda, so simply remove them (https://en.wikipedia.org/wiki/ISO_3166-2:BM)
        '01' => '',
        '02' => '',
        '03' => '',
        '04' => '',
        '05' => '',
        '06' => '',
        '07' => '',
        '08' => '',
        '09' => '',
        '10' => '',
        '11' => '',
    ],
    'BN' => [
        // Seems Maxmind totally screwed up the region codes for Brunei
        // They used the codes for Benin (which has BN as FIPS country code) and replaced those codes available for Brunei

        // valid codes
        '08' => 'BE', // Belait
        '09' => 'BM', // Brunei and Muara
        '10' => 'TE', // Temburong
        '15' => 'TU', // Tutong

        // invalid codes that should not occur
        '07' => '', // Alibori
        '11' => '', // Collines
        '12' => '', // Kouffo
        '13' => '', // Donga
        '14' => '', // Littoral
        '16' => '', // Oueme
        '17' => '', // Plateau
        '18' => '', // Zou
    ],
    'BO' => [
        '01' => 'H',
        '02' => 'C',
        '03' => 'B',
        '04' => 'L',
        '05' => 'O',
        '06' => 'N',
        '07' => 'P',
        '08' => 'S',
        '09' => 'T',
    ],
    'BR' => [
        '01' => 'AC',
        '02' => 'AL',
        '03' => 'AP',
        '04' => 'AM',
        '05' => 'BA',
        '06' => 'CE',
        '07' => 'DF',
        '08' => 'ES',
        '11' => 'MS',
        '13' => 'MA',
        '14' => 'MT',
        '15' => 'MG',
        '16' => 'PA',
        '17' => 'PB',
        '18' => 'PR',
        '20' => 'PI',
        '21' => 'RJ',
        '22' => 'RN',
        '23' => 'RS',
        '24' => 'RO',
        '25' => 'RR',
        '26' => 'SC',
        '27' => 'SP',
        '28' => 'SE',
        '29' => 'GO',
        '30' => 'PE',
        '31' => 'TO',
    ],
    'BS' => [
        '05' => 'BI', // Bimini
        '06' => 'CI', // Cat Island
        '10' => 'EX', // Exuma
        '13' => 'IN', // Inagua
        '15' => 'LI', // Long Island
        '16' => 'MG', // Mayaguana
        '18' => 'RI', // Ragged Island
        '22' => 'HI', // Harbour Island
        '23' => '', // New Providence deleted in 2011 - without replacement (https://en.wikipedia.org/wiki/ISO_3166-2:BS#Changes)
        '24' => '', // Acklins and Crooked Islands  [now two seperate codes AK & CK]
        '25' => 'FP', // Freeport
        '26' => 'CS', // Fresh Creek  [is now roughly Central Andros]
        '27' => 'CE', // Governor's Harbour  [is now roughly Central Eleuthera]
        '28' => 'HT', // Green Turtle Cay - mapped to GT by wikidata, but removed in 2010 - now HT according to geonames (http://www.geonames.org/maps/google_26.758_-77.325.html)
        '29' => 'EG', // High Rock  [is now roughly East Grand Bahama]
        '30' => 'SA', // Kemps Bay  [now in South Andros]
        '31' => '', // Marsh Harbour
        '32' => '', // Nichollstown and Berry Islands
        '33' => 'SE', // Rock Sound  [is now roughly South Eleuthera]
        '34' => '', // Sandy Point
        '35' => '', // San Salvador and Rum Cay  [now two seperate codes SS & RC]
    ],
    'BT' => [
        '05' => '33',
        '06' => '12',
        '07' => '21',
        '08' => '22',
        '09' => '31',
        '10' => '13',
        '11' => '44',
        '12' => '42',
        '13' => '11',
        '14' => '43',
        '15' => '23',
        '16' => '14', // Samtse
        '17' => '45',
        '18' => '34', // Zhemgang
        '19' => '41',
        '20' => '15',
        '21' => '32', // Tongsa
        '22' => '24', // Wangdi Phodrang
    ],
    'BW' => [
        '01' => 'CE',
        '03' => 'GH',
        '04' => 'KG',
        '05' => 'KL',
        '06' => 'KW',
        '08' => 'NE',
        '09' => 'SE',
        '10' => 'SO',
        '11' => 'NW',
    ],
    'BY' => [
        '01' => 'BR',
        '02' => 'HO',
        '03' => 'HR',
        '04' => 'HM',
        '05' => 'MI',
        '06' => 'MA',
        '07' => 'VI',
    ],
    'BZ' => [
        '01' => 'BZ',
        '02' => 'CY',
        '03' => 'CZL',
        '04' => 'OW',
        '05' => 'SC',
        '06' => 'TOL',
    ],
    'CD' => [
        '01' => '', // Bandundu  [split up]
        '02' => 'EQ', // Equateur
        '04' => 'KE', // Kasai-Oriental
        '05' => '', // Katanga  [split up]
        '06' => 'KN', // Kinshasa
        '08' => 'BC', // Bas-Congo
        '09' => '', // Orientale  [split up]
        '10' => 'MA', // Maniema
        '11' => 'NK', // Nord-Kivu
        '12' => 'SK', // Sud-Kivu

        // valid codes  [not used by maxmind]
        '03' => '', // Kasaï-Occidental  [split up]
    ],
    'CF' => [
        '01' => 'BB',
        '02' => 'BK',
        '03' => 'HK',
        '04' => 'HS',
        '05' => 'HM',
        '06' => 'KG',
        '07' => 'LB',
        '08' => 'MB',
        '09' => 'NM',
        '11' => 'UK',
        '12' => 'AC',
        '13' => 'OP',
        '14' => 'VK',
        '15' => 'KB',
        '16' => 'SE',
        '17' => 'MP',
        '18' => 'BGF',
    ],
    'CG' => [
        '01' => '11',
        '04' => '5',
        '05' => '2',
        '06' => '7',
        '07' => '9',
        '08' => '14',
        '10' => '13',
        '11' => '12',
        '12' => 'BZV',
        '13' => '8',
        '14' => '15',
    ],
    'CH' => [
        '01' => 'AG',
        '02' => 'AR',
        '03' => 'BL',
        '04' => 'BS',
        '05' => 'BE',
        '06' => 'FR',
        '07' => 'GE',
        '08' => 'GL',
        '09' => 'GR',
        '10' => 'AI',
        '11' => 'LU',
        '12' => 'NE',
        '13' => 'NW',
        '14' => 'OW',
        '15' => 'SG',
        '16' => 'SH',
        '17' => 'SZ',
        '18' => 'SO',
        '19' => 'TG',
        '20' => 'TI',
        '21' => 'UR',
        '22' => 'VS',
        '23' => 'VD',
        '24' => 'ZG',
        '25' => 'ZH',
        '26' => 'JU',
    ],
    'CI' => [
        '74' => 'LG', // Agneby  [now part of Lagunes]
        '75' => 'WR', // Bafing  [now part of Woroba]
        '76' => 'BS', // Bas-Sassandra
        '77' => 'DN', // Denguele
        '78' => 'MG', // Dix-Huit Montagnes
        '79' => 'GD', // Fromager  [now part of Gôh-Djiboua]
        '80' => 'SM', // Haut-Sassandra
        '81' => 'LC', // Lacs
        '82' => 'LG', // Lagunes
        '83' => 'SM', // Marahoue
        '84' => 'MG', // Moyen-Cavally  [now part of Montagnes]
        '85' => 'CM', // Moyen-Comoe  [now part of Comoé]
        '86' => 'LC', // N'zi-Comoe  [now part of Lacs]
        '87' => 'SV', // Savanes
        '88' => '', // Sud-Bandama  [spit up]
        '89' => 'CM', // Sud-Comoe
        '90' => 'VB', // Vallee du Bandama
        '91' => 'WR', // Worodougou  [now part of Woroba]
        '92' => 'ZZ', // Zanzan
    ],
    'CL' => [
        '01' => 'VS',
        '02' => 'AI',
        '03' => 'AN',
        '04' => 'AR',
        '05' => 'AT',
        '06' => 'BI',
        '07' => 'CO',
        '08' => 'LI',
        '10' => 'MA',
        '11' => 'ML',
        '12' => 'RM',
        '14' => 'LL',
        '15' => 'TA',
        '16' => 'AP',
        '17' => 'LR',

        // mapped based on their names (https://en.wikipedia.org/wiki/ISO_3166-2:CL)
        '09' => 'LL', // Los Lagos
        '13' => 'TA', // Tarapaca
    ],
    'CM' => [
        '04' => 'ES',
        '05' => 'LT',
        '07' => 'NW',
        '08' => 'OU',
        '09' => 'SW',
        '10' => 'AD',
        '11' => 'CE',
        '12' => 'EN',
        '13' => 'NO',
        '14' => 'SU',
    ],
    'CN' => [
        '01' => 'AH',
        '02' => 'ZJ',
        '03' => 'JX',
        '04' => 'JS',
        '05' => 'JL',
        '06' => 'QH',
        '07' => 'FJ',
        '08' => 'HL',
        '09' => 'HA',
        '10' => 'HE',
        '11' => 'HN',
        '12' => 'HB',
        '13' => 'XJ',
        '14' => 'XZ',
        '15' => 'GS',
        '16' => 'GX',
        '18' => 'GZ',
        '19' => 'LN',
        '20' => 'NM',
        '21' => 'NX',
        '22' => 'BJ',
        '23' => 'SH',
        '24' => 'SX',
        '25' => 'SD',
        '26' => 'SN',
        '28' => 'TJ',
        '29' => 'YN',
        '30' => 'GD',
        '31' => 'HI',
        '32' => 'SC',
        '33' => 'CQ',
    ],
    'CO' => [
        '01' => 'AMA',
        '02' => 'ANT',
        '03' => 'ARA',
        '04' => 'ATL',
        '08' => 'CAQ',
        '09' => 'CAU',
        '10' => 'CES',
        '11' => 'CHO',
        '12' => 'COR',
        '14' => 'GUV',
        '15' => 'GUA',
        '16' => 'HUI',
        '17' => 'LAG',
        '19' => 'MET',
        '20' => 'NAR',
        '21' => 'NSA',
        '22' => 'PUT',
        '23' => 'QUI',
        '24' => 'RIS',
        '25' => 'SAP',
        '26' => 'SAN',
        '27' => 'SUC',
        '28' => 'TOL',
        '29' => 'VAC',
        '30' => 'VAU',
        '31' => 'VID',
        '32' => 'CAS',
        '33' => 'CUN',
        '34' => 'DC',
        '35' => 'BOL',
        '36' => 'BOY',
        '37' => 'CAL',
        '38' => 'MAG',
    ],
    'CR' => [
        '01' => 'A',
        '02' => 'C',
        '03' => 'G',
        '04' => 'H',
        '06' => 'L',
        '07' => 'P',
        '08' => 'SJ',
    ],
    'CU' => [
        '01' => '01', // Pinar del Rio
        '02' => '', // Ciudad de la Habana was splitted in 2011 into 15 & 16 (https://en.wikipedia.org/wiki/ISO_3166-2:CU)
        '03' => '04', // Matanzas
        '04' => '99', // Isla de la Juventud
        '05' => '09', // Camaguey
        '07' => '08', // Ciego de Avila
        '08' => '06', // Cienfuegos
        '09' => '12', // Granma
        '10' => '14', // Guantanamo
        '11' => '03', // La Habana
        '12' => '11', // Holguin
        '13' => '10', // Las Tunas
        '14' => '07', // Sancti Spiritus
        '15' => '13', // Santiago de Cuba
        '16' => '05', // Villa Clara
    ],
    'CV' => [
        '01' => 'BV',
        '02' => 'BR',
        '04' => 'MA',
        '05' => 'PA',
        '07' => 'RG',
        '08' => 'SL',
        '10' => '', // Sao Nicolau was splitted in 2005 into Ribeira Brava (BR) & Tarrafal de São Nicolau (TS) (https://en.wikipedia.org/wiki/ISO_3166-2:CV)
        '11' => 'SV',
        '13' => 'MO',
        '14' => 'PR',
        '15' => 'CA',
        '16' => 'CR',
        '17' => 'SD',
        '18' => 'SF',
        '19' => 'SM',
        '20' => 'TA',
    ],
    'CY' => [
        '01' => '04',
        '02' => '06',
        '03' => '03',
        '04' => '01',
        '05' => '02',
        '06' => '05',
    ],
    'CZ' => [
        '52' => '10',
        '78' => '64',
        '79' => '31',
        '80' => '63',
        '81' => '41',
        '82' => '52',
        '83' => '51',
        '84' => '71',
        '85' => '80',
        '86' => '53',
        '87' => '32',
        '88' => '20',
        '89' => '42',
        '90' => '72',
    ],
    'DE' => [
        '01' => 'BW',
        '02' => 'BY',
        '03' => 'HB',
        '04' => 'HH',
        '05' => 'HE',
        '06' => 'NI',
        '07' => 'NW',
        '08' => 'RP',
        '09' => 'SL',
        '10' => 'SH',
        '11' => 'BB',
        '12' => 'MV',
        '13' => 'SN',
        '14' => 'ST',
        '15' => 'TH',
        '16' => 'BE',
    ],
    'DJ' => [
        '01' => 'AS',
        '04' => 'OB',
        '05' => 'TA',
        '06' => 'DI',
        '07' => 'DJ',
        '08' => 'AR',
    ],
    'DK' => [
        '17' => '84',
        '18' => '82',
        '19' => '81',
        '20' => '85',
        '21' => '83',
    ],
    'DM' => [
        '02' => '02',
        '03' => '03',
        '04' => '04',
        '05' => '05',
        '06' => '06',
        '07' => '07',
        '08' => '08',
        '09' => '09',
        '10' => '10',
        '11' => '11',
    ],
    'DO' => [
        '01' => '02',
        '02' => '03',
        '03' => '04',
        '04' => '05',
        '05' => '01', // Distrito Nacional
        '06' => '06',
        '08' => '09',
        '09' => '10',
        '10' => '11',
        '11' => '07',
        '12' => '12',
        '14' => '14',
        '15' => '15',
        '16' => '16',
        '17' => '17', // Peravia
        '18' => '18',
        '19' => '19',
        '20' => '20',
        '21' => '24',
        '23' => '22',
        '24' => '23',
        '25' => '25',
        '26' => '26',
        '27' => '27',
        '28' => '08',
        '29' => '30',
        '30' => '13',
        '31' => '28',
        '32' => '29',
        '33' => '21',
        '34' => '01',
        '35' => '17',
        '36' => '31',
        '37' => '32',
    ],
    'DZ' => [
        '01' => '16',
        '03' => '05',
        '04' => '25',
        '06' => '26',
        '07' => '27',
        '09' => '31',
        '10' => '20',
        '12' => '19',
        '13' => '14',
        '14' => '15',
        '15' => '13',
        '18' => '06',
        '19' => '07',
        '20' => '09',
        '21' => '10',
        '22' => '17',
        '23' => '24',
        '24' => '18',
        '25' => '03',
        '26' => '29',
        '27' => '28',
        '29' => '04',
        '30' => '22',
        '31' => '21',
        '33' => '12',
        '34' => '01',
        '35' => '44',
        '36' => '46',
        '37' => '23',
        '38' => '08',
        '39' => '34',
        '40' => '35',
        '41' => '02',
        '42' => '32',
        '43' => '39',
        '44' => '36',
        '45' => '47',
        '46' => '33',
        '47' => '40',
        '48' => '43',
        '49' => '45',
        '50' => '30',
        '51' => '48',
        '52' => '41',
        '53' => '11',
        '54' => '37',
        '55' => '42',
        '56' => '38',
    ],
    'EC' => [
        '01' => 'W',
        '02' => 'A',
        '03' => 'B',
        '04' => 'F',
        '05' => 'C',
        '06' => 'H',
        '07' => 'X',
        '08' => 'O',
        '09' => 'E',
        '10' => 'G',
        '11' => 'I',
        '12' => 'L',
        '13' => 'R',
        '14' => 'M',
        '15' => 'S',
        '17' => 'Y',
        '18' => 'P',
        '19' => 'T',
        '20' => 'Z',
        '22' => 'U',
        '23' => 'N',
        '24' => 'D',
    ],
    'EE' => [
        '01' => '37',
        '02' => '39',
        '03' => '44',
        '04' => '51',
        '05' => '49',
        '07' => '57',
        '08' => '59',
        '11' => '67',
        '12' => '65',
        '13' => '70',
        '14' => '74',
        '18' => '78',
        '19' => '82',
        '20' => '84',
        '21' => '86',

        // invalid codes [used by maxmind] (mapped based on https://en.wikipedia.org/wiki/Municipalities_of_Estonia#Former_municipalities)
        '06' => '44', // Kohtla-Jarve is part of Ida-Viru
        '09' => '44', // Narva is part of Ida-Viru
        '10' => '67', // Parnu
        '15' => '44', // Sillamae is part of Ida-Viru
        '16' => '37', // Tallinn is part of Harju
        '17' => '78', // Tartu
    ],
    'EG' => [
        '01' => 'DK',
        '02' => 'BA',
        '03' => 'BH',
        '04' => 'FYM',
        '05' => 'GH',
        '06' => 'ALX',
        '07' => 'IS',
        '08' => 'GZ',
        '09' => 'MNF',
        '10' => 'MN',
        '11' => 'C',
        '12' => 'KB',
        '13' => 'WAD',
        '14' => 'SHR',
        '15' => 'SUZ',
        '16' => 'ASN',
        '17' => 'AST',
        '18' => 'BNS',
        '19' => 'PTS',
        '20' => 'DT',
        '21' => 'KFS',
        '22' => 'MT',
        '23' => 'KN',
        '24' => 'SHG',
        '26' => 'JS',
        '27' => 'SIN',

        // invalid codes  [used by maxmind]
        '28' => 'LX', // Al Uqsur
    ],
    'ER' => [
        '01' => 'AN',
        '02' => 'DU',
        '03' => 'DK',
        '04' => 'GB',
        '05' => 'MA',
        '06' => 'SK',
    ],
    'ES' => [
        '07' => 'IB',
        '27' => 'LO',
        '29' => 'MD',
        '31' => 'MC',
        '32' => 'NC',
        '34' => 'AS',
        '39' => 'CB',
        '51' => 'AN',
        '52' => 'AR',
        '53' => 'CN',
        '54' => 'CM',
        '55' => 'CL',
        '56' => 'CT',
        '57' => 'EX',
        '58' => 'GA',
        '59' => 'PV',
        '60' => 'VC',
    ],
    'ET' => [
        '44' => 'AA',
        '45' => 'AF',
        '46' => 'AM',
        '47' => 'BE',
        '48' => 'DD',
        '49' => 'GA',
        '50' => 'HA',
        '51' => 'OR',
        '52' => 'SO',
        '53' => 'TI',
        '54' => 'SN',
    ],
    'FI' => [
        // was rearranged in 2011. codes on wikidata are outdated (https://en.wikipedia.org/wiki/ISO_3166-2:FI)
        '01' => '01', // Aland
        '06' => '10', // Lapland
        '08' => '', // Oulu splitted into subdivisions
        '13' => '', // Southern Finland splitted into subdivisions
        '14' => '', // Eastern Finland splitted into subdivisions
        '15' => '', // Western Finland splitted into subdivisions
    ],
    'FJ' => [
        '01' => 'C',
        '02' => 'E',
        '03' => 'N',
        '04' => 'R',
        '05' => 'W',
    ],
    'FR' => [
        '97' => 'NAQ', // Aquitaine
        '98' => 'ARA', // Auvergne
        '99' => 'NOR', // Basse-Normandie
        'A1' => 'BFC', // Bourgogne
        'A2' => 'BRE', // Bretagne
        'A3' => 'CVL', // Centre
        'A4' => 'GES', // Champagne-Ardenne
        'A5' => 'COR', // Corse
        'A6' => 'BFC', // Franche-Comte
        'A7' => 'NOR', // Haute-Normandie
        'A8' => 'IDF', // Ile-de-France
        'A9' => 'OCC', // Languedoc-Roussillon
        'B1' => 'NAQ', // Limousin
        'B2' => 'GES', // Lorraine
        'B3' => 'OCC', // Midi-Pyrenees
        'B4' => 'HDF', // Nord-Pas-de-Calais
        'B5' => 'PDL', // Pays de la Loire
        'B6' => 'HDF', // Picardie
        'B7' => 'NAQ', // Poitou-Charentes
        'B8' => 'PAC', // Provence-Alpes-Cote d'Azur
        'B9' => 'ARA', // Rhone-Alpes
        'C1' => 'GES', // Alsace
    ],
    'FM' => [
        '01' => 'KSA', // Kosrae
        '02' => 'PNI', // Pohnpei
        '03' => 'TRK', // Chuuk
        '04' => 'YAP', // Yap
    ],
    'GA' => [
        '01' => '1',
        '02' => '2',
        '03' => '3',
        '04' => '4',
        '05' => '5',
        '06' => '6',
        '07' => '7',
        '08' => '8',
        '09' => '9',
    ],
    'GB' => [
        'A1' => 'BDG',
        'A2' => 'BNE',
        'A3' => 'BNS',
        'A4' => 'BAS',
        'A5' => '', // Bedfordshire  [split up]
        'A6' => 'BEX',
        'A7' => 'BIR',
        'A8' => 'BBD',
        'A9' => 'BPL',
        'B1' => 'BOL',
        'B2' => 'BMH',
        'B3' => 'BRC',
        'B4' => 'BRD',
        'B5' => 'BEN',
        'B6' => 'BNH',
        'B7' => 'BST',
        'B8' => 'BRY',
        'B9' => 'BKM',
        'C1' => 'BUR',
        'C2' => 'CLD',
        'C3' => 'CAM',
        'C4' => 'CMD',
        'C5' => '', // Cheshire  [split up]
        'C6' => 'CON',
        'C7' => 'COV',
        'C8' => 'CRY',
        'C9' => 'CMA',
        'D1' => 'DAL',
        'D2' => 'DER',
        'D3' => 'DBY',
        'D4' => 'DEV',
        'D5' => 'DNC',
        'D6' => 'DOR',
        'D7' => 'DUD',
        'D8' => 'DUR',
        'D9' => 'EAL',
        'E1' => 'ERY',
        'E2' => 'ESX',
        'E3' => 'ENF',
        'E4' => 'ESS',
        'E5' => 'GAT',
        'E6' => 'GLS',
        'E7' => 'GRE',
        'E8' => 'HCK',
        'E9' => 'HAL',
        'F1' => 'HMF',
        'F2' => 'HAM',
        'F3' => 'HRY',
        'F4' => 'HRW',
        'F5' => 'HPL',
        'F6' => 'HAV',
        'F7' => 'HEF',
        'F8' => 'HRT',
        'F9' => 'HIL',
        'G1' => 'HNS',
        'G2' => 'IOW',
        'G3' => 'ISL',
        'G4' => 'KEC',
        'G5' => 'KEN',
        'G6' => 'KHL',
        'G7' => 'KTT',
        'G8' => 'KIR',
        'G9' => 'KWL',
        'H1' => 'LBH',
        'H2' => 'LAN',
        'H3' => 'LDS',
        'H4' => 'LCE',
        'H5' => 'LEC',
        'H6' => 'LEW',
        'H7' => 'LIN',
        'H8' => 'LIV',
        'H9' => 'LND',
        'I1' => 'LUT',
        'I2' => 'MAN',
        'I3' => 'MDW',
        'I4' => 'MRT',
        'I5' => 'MDB',
        'I6' => 'MIK',
        'I7' => 'NET',
        'I8' => 'NWM',
        'I9' => 'NFK',
        'J1' => 'NTH',
        'J2' => 'NEL',
        'J3' => 'NLN',
        'J4' => 'NSM',
        'J5' => 'NTY',
        'J6' => 'NBL',
        'J7' => 'NYK',
        'J8' => 'NGM',
        'J9' => 'NTT',
        'K1' => 'OLD',
        'K2' => 'OXF',
        'K3' => 'PTE',
        'K4' => 'PLY',
        'K5' => 'POL',
        'K6' => 'POR',
        'K7' => 'RDG',
        'K8' => 'RDB',
        'K9' => 'RCC',
        'L1' => 'RIC',
        'L2' => 'RCH',
        'L3' => 'ROT',
        'L4' => 'RUT',
        'L5' => 'SLF',
        'L6' => 'SHR',
        'L7' => 'SAW',
        'L8' => 'SFT',
        'L9' => 'SHF',
        'M1' => 'SLG',
        'M2' => 'SOL',
        'M3' => 'SOM',
        'M4' => 'STH',
        'M5' => 'SOS',
        'M6' => 'SGC',
        'M7' => 'STY',
        'M8' => 'SWK',
        'M9' => 'STS',
        'N1' => 'SHN',
        'N2' => 'SKP',
        'N3' => 'STT',
        'N4' => 'STE',
        'N5' => 'SFK',
        'N6' => 'SND',
        'N7' => 'SRY',
        'N8' => 'STN',
        'N9' => 'SWD',
        'O1' => 'TAM',
        'O2' => 'TFW',
        'O3' => 'THR',
        'O4' => 'TOB',
        'O5' => 'TWH',
        'O6' => 'TRF',
        'O7' => 'WKF',
        'O8' => 'WLL',
        'O9' => 'WFT',
        'P1' => 'WND',
        'P2' => 'WRT',
        'P3' => 'WAR',
        'P4' => 'WBK',
        'P5' => 'WSM',
        'P6' => 'WSX',
        'P7' => 'WGN',
        'P8' => 'WIL',
        'P9' => 'WNM',
        'Q1' => 'WRL',
        'Q2' => 'WOK',
        'Q3' => 'WLV',
        'Q4' => 'WOR',
        'Q5' => 'YOR',
        'Q6' => 'ANN',
        'Q7' => 'AND',
        'Q8' => 'ABC', // Armagh  [merged into Armagh, Banbridge and Craigavon]
        'Q9' => 'MEA',
        'R1' => 'CCG', // Ballymoney  [merged into Causeway Coast and Glens]
        'R2' => 'ABC', // Banbridge  [merged into Armagh, Banbridge and Craigavon]
        'R3' => 'BFS',
        'R4' => 'MEA',
        'R5' => 'LBC', // Castlereagh  [merged into Lisburn and Castlereagh]
        'R6' => 'CCG',
        'R7' => 'MUL',
        'R8' => 'ABC', // Craigavon  [merged into Armagh, Banbridge and Craigavon]
        'R9' => 'NMD', // Down  [merged into Newry, Mourne and Down]
        'S1' => 'MUL', // Dungannon and South Tyrone  [merged into Mid-Ulster]
        'S2' => 'FMO', // Fermanagh
        'S3' => 'MEA', // Larne  [merged into Mid and East Antrim]
        'S4' => 'CCG', // Limavady  [merged into Causeway Coast and Glens]
        'S5' => 'LBC', // Lisburn
        'S6' => 'DRS',
        'S7' => 'MUL', // Magherafelt  [merged into Mid-Ulster]
        'S8' => 'CCG',
        'S9' => 'NMD',
        'T1' => 'ANN', // Newtownabbey  [merged into Antrim and Newtownabbey]
        'T2' => 'AND', // North Down  [merged into  North Down and Ards]
        'T3' => 'FMO', // Omagh
        'T4' => 'DRS', // Strabane
        'T5' => 'ABE',
        'T6' => 'ABD',
        'T7' => 'ANS',
        'T8' => 'AGB',
        'T9' => 'SCB',
        'U1' => 'CLK',
        'U2' => 'DGY',
        'U3' => 'DND',
        'U4' => 'EAY',
        'U5' => 'EDU',
        'U6' => 'ELN',
        'U7' => 'ERW',
        'U8' => 'EDH',
        'U9' => 'FAL',
        'V1' => 'FIF',
        'V2' => 'GLG',
        'V3' => 'HLD',
        'V4' => 'IVC',
        'V5' => 'MLN',
        'V6' => 'MRY',
        'V7' => 'NAY',
        'V8' => 'NLK',
        'V9' => 'ORK',
        'W1' => 'PKN',
        'W2' => 'RFW',
        'W3' => 'ZET',
        'W4' => 'SAY',
        'W5' => 'SLK',
        'W6' => 'STG',
        'W7' => 'WDU',
        'W8' => 'ELS',
        'W9' => 'WLN',
        'X1' => 'AGY',
        'X2' => 'BGW',
        'X3' => 'BGE',
        'X4' => 'CAY',
        'X5' => 'CRF',
        'X6' => 'CGN',
        'X7' => 'CMN',
        'X8' => 'CWY',
        'X9' => 'DEN',
        'Y1' => 'FLN',
        'Y2' => 'GWN',
        'Y3' => 'MTY',
        'Y4' => 'MON',
        'Y5' => 'NTL',
        'Y6' => 'NWP',
        'Y7' => 'PEM',
        'Y8' => 'POW',
        'Y9' => 'RCT',
        'Z1' => 'SWA',
        'Z2' => 'TOF',
        'Z3' => 'VGL',
        'Z4' => 'WRX',

        // invalid codes [used by maxmind] (mapped based on names)
        'Z5' => '', // Bedfordshire  [split up]
        'Z6' => 'CBF', // Central Bedfordshire
        'Z7' => 'CHE', // Cheshire East
        'Z8' => 'CHW', // Cheshire West and Chester
        'Z9' => 'IOS', // Isles of Scilly
    ],
    'GD' => [
        '01' => '01',
        '02' => '02',
        '03' => '03',
        '04' => '04',
        '05' => '05',
        '06' => '06',
    ],
    'GE' => [
        // subdivisions rearranged 2002 (https://en.wikipedia.org/wiki/ISO_3166-2:EG)
        // mapping based on the subdivision wikipedia pages
        '01' => 'SZ', // Abashis Raioni is within Samegrelo-Zemo Svaneti
        '02' => 'AB', // Abkhazia
        '03' => 'SJ', // Adigenis Raioni is within Samtskhe-Javakheti
        '04' => 'AJ', // Ajaria
        '05' => 'MM', // Akhalgoris Raioni is within Mtskheta-Mtianeti
        '06' => 'SJ', // Akhalk'alak'is Raioni is within Samtskhe-Javakheti
        '07' => 'SJ', // Akhalts'ikhis Raioni is within Samtskhe-Javakheti
        '08' => 'KA', // Akhmetis Raioni is within Kakheti
        '09' => 'RL', // Ambrolauris Raioni is within Racha-Lechkhumi and Kvemo Svaneti
        '10' => 'SJ', // Aspindzis Raioni is within Samtskhe-Javakheti
        '11' => 'IM', // Baghdat'is Raioni is within Imereti
        '12' => 'KK', // Bolnisis Raioni is within Kvemo Kartli
        '13' => 'SJ', // Borjomis Raioni is within Samtskhe-Javakheti
        '14' => 'IM', // Chiat'ura is within Imereti
        '15' => 'SZ', // Ch'khorotsqus Raioni is within Samegrelo-Zemo Svaneti
        '16' => 'GU', // Ch'okhatauris Raioni is within Guria
        '17' => 'KA', // Dedop'listsqaros Raioni is within Kakheti
        '18' => 'KA', // Dmanisis Raioni is within Kakheti
        '19' => 'MM', // Dushet'is Raioni is within Mtskheta-Mtianeti
        '20' => 'KK', // Gardabanis Raioni is within Kvemo Kartli
        '21' => 'SK', // Gori is within Shida Kartli
        '22' => 'SK', // Goris Raioni is within Shida Kartli
        '23' => 'KA', // Gurjaanis Raioni is within Kakheti
        '24' => 'SK', // Javis Raioni is within Shida Kartli
        '25' => 'SK', // K'arelis Raioni is within Shida Kartli
        '26' => 'SK', // Kaspis Raioni is within Shida Kartli
        '27' => 'IM', // Kharagaulis Raioni is within Imereti
        '28' => 'SK', // Khashuris Raioni is within Shida Kartli
        '29' => 'SZ', // Khobis Raioni is within Samegrelo-Zemo Svaneti
        '30' => 'IM', // Khonis Raioni is within Imereti
        '31' => 'IM', // K'ut'aisi is within Imereti
        '32' => 'KA', // Lagodekhis Raioni is within Kakheti
        '33' => 'GU', // Lanch'khut'is Raioni is within Guria
        '34' => 'RL', // Lentekhis Raioni is within Racha-Lechkhumi and Kvemo Svaneti
        '35' => 'KK', // Marneulis Raioni is within Kvemo Kartli
        '36' => 'SZ', // Martvilis Raioni is within Samegrelo-Zemo Svaneti
        '37' => 'SZ', // Mestiis Raioni is within Samegrelo-Zemo Svaneti
        '38' => 'MM', // Mts'khet'is Raioni is within Mtskheta-Mtianeti
        '39' => 'SJ', // Ninotsmindis Raioni is within Samtskhe-Javakheti
        '40' => 'RL', // Onis Raioni is within Racha-Lechkhumi and Kvemo Svaneti
        '41' => 'GU', // Ozurget'is Raioni is within Guria
        '42' => 'SZ', // P'ot'i is within Samegrelo-Zemo Svaneti
        '43' => 'MM', // Qazbegis Raioni is within Mtskheta-Mtianeti
        '44' => 'KA', // Qvarlis Raioni is within Kakheti
        '45' => 'KK', // Rust'avi is within Kvemo Kartli
        '46' => 'IM', // Sach'kheris Raioni is within Imereti
        '47' => 'KA', // Sagarejos Raioni is within Kakheti
        '48' => 'IM', // Samtrediis Raioni is within Imereti
        '49' => 'SZ', // Senakis Raioni is within Samegrelo-Zemo Svaneti
        '50' => 'KA', // Sighnaghis Raioni is within Kakheti
        '51' => 'TB', // T'bilisi
        '52' => 'KA', // T'elavis Raioni is within Kakheti
        '53' => 'IM', // T'erjolis Raioni is within Imereti
        '54' => 'KK', // T'et'ritsqaros Raioni is within Kvemo Kartli
        '55' => 'MM', // T'ianet'is Raioni is within Mtskheta-Mtianeti
        '56' => 'IM', // Tqibuli is within Imereti
        '57' => 'RL', // Ts'ageris Raioni is within Racha-Lechkhumi and Kvemo Svaneti
        '58' => 'SZ', // Tsalenjikhis Raioni is within Samegrelo-Zemo Svaneti
        '59' => 'KK', // Tsalkis Raioni is within Kvemo Kartli
        '60' => 'IM', // Tsqaltubo is within Imereti
        '61' => 'IM', // Vanis Raioni is within Imereti
        '62' => 'IM', // Zestap'onis Raioni is within Imereti
        '63' => 'SZ', // Zugdidi is within Samegrelo-Zemo Svaneti
        '64' => 'SZ', // Zugdidis Raioni is within Samegrelo-Zemo Svaneti
    ],
    'GH' => [
        '01' => 'AA',
        '02' => 'AH',
        '03' => 'BA',
        '04' => 'CP',
        '05' => 'EP',
        '06' => 'NP',
        '08' => 'TV',
        '09' => 'WP',
        '10' => 'UE',
        '11' => 'UW',
    ],
    'GL' => [
        // ISO introduced their own regions in 2010, they completely differ from FIPS and are not mappable
        '01' => '', // Nordgronland
        '02' => '', // Ostgronland
        '03' => '', // Vestgronland
    ],
    'GM' => [
        '01' => 'B',
        '02' => 'L',
        '03' => 'M',
        '04' => 'U',
        '05' => 'W',
        '07' => 'N',
    ],
    'GN' => [
        '01' => 'BE', // Beyla
        '02' => 'BF', // Boffa
        '03' => 'BK', // Boke
        '04' => 'C', // Conakry
        '05' => 'DB', // Dabola
        '06' => 'DL', // Dalaba
        '07' => 'DI', // Dinguiraye
        '09' => 'FA', // Faranah
        '10' => 'FO', // Forecariah
        '11' => 'FR', // Fria
        '12' => 'GA', // Gaoual
        '13' => 'GU', // Gueckedou
        '15' => 'KE', // Kerouane
        '16' => 'KD', // Kindia
        '17' => 'KS', // Kissidougou
        '18' => 'KN', // Koundara
        '19' => 'KO', // Kouroussa
        '21' => 'MC', // Macenta
        '22' => 'ML', // Mali
        '23' => 'MM', // Mamou
        '25' => 'PI', // Pita
        '27' => 'TE', // Telimele
        '28' => 'TO', // Tougue
        '29' => 'YO', // Yomou
        '30' => 'CO', // Coyah
        '31' => 'DU', // Dubreka
        '32' => 'KA', // Kankan
        '33' => 'KB', // Koubia
        '34' => 'LA', // Labe
        '35' => 'LE', // Lelouma
        '36' => 'LO', // Lola
        '37' => 'MD', // Mandiana
        '38' => 'NZ', // Nzerekore
        '39' => 'SI', // Siguiri
    ],
    'GQ' => [
        '03' => 'AN',
        '04' => 'BN',
        '05' => 'BS',
        '06' => 'CS',
        '07' => 'KN',
        '08' => 'LI',
        '09' => 'WN',
    ],
    'GR' => [
        // rearranged 2016. mapping based on (https://en.wikipedia.org/wiki/ISO_3166-2:GR)
        '01' => 'A', // Evros
        '02' => 'A', // Rodhopi
        '03' => 'A', // Xanthi
        '04' => 'A', // Drama
        '05' => 'B', // Serrai
        '06' => 'B', // Kilkis
        '07' => 'B', // Pella
        '08' => 'C', // Florina
        '09' => 'C', // Kastoria
        '10' => 'C', // Grevena
        '11' => 'C', // Kozani
        '12' => 'B', // Imathia
        '13' => 'B', // Thessaloniki
        '14' => 'A', // Kavala
        '15' => 'B', // Khalkidhiki
        '16' => 'B', // Pieria
        '17' => 'D', // Ioannina
        '18' => 'D', // Thesprotia
        '19' => 'D', // Preveza
        '20' => 'D', // Arta
        '21' => 'E', // Larisa
        '22' => 'E', // Trikala
        '23' => 'E', // Kardhitsa
        '24' => 'E', // Magnisia
        '25' => 'F', // Kerkira
        '26' => 'F', // Levkas
        '27' => 'F', // Kefallinia
        '28' => 'F', // Zakinthos
        '29' => 'H', // Fthiotis
        '30' => 'H', // Evritania
        '31' => 'G', // Aitolia kai Akarnania
        '32' => 'H', // Fokis
        '33' => 'H', // Voiotia
        '34' => 'H', // Evvoia
        '35' => 'I', // Attiki
        '36' => 'J', // Argolis
        '37' => 'J', // Korinthia
        '38' => 'G', // Akhaia
        '39' => 'G', // Ilia
        '40' => 'J', // Messinia
        '41' => 'J', // Arkadhia
        '42' => 'J', // Lakonia
        '43' => 'M', // Khania
        '44' => 'M', // Rethimni
        '45' => 'M', // Iraklion
        '46' => 'M', // Lasithi
        '47' => 'L', // Dhodhekanisos
        '48' => 'K', // Samos
        '49' => 'L', // Kikladhes
        '50' => 'K', // Khios
        '51' => 'K', // Lesvos
    ],
    'GT' => [
        '01' => 'AV',
        '02' => 'BV',
        '03' => 'CM',
        '04' => 'CQ',
        '05' => 'PR',
        '06' => 'ES',
        '07' => 'GU',
        '08' => 'HU',
        '09' => 'IZ',
        '10' => 'JA',
        '11' => 'JU',
        '12' => 'PE',
        '13' => 'QZ',
        '14' => 'QC',
        '15' => 'RE',
        '16' => 'SA',
        '17' => 'SM',
        '18' => 'SR',
        '19' => 'SO',
        '20' => 'SU',
        '21' => 'TO',
        '22' => 'ZA',
    ],
    'GW' => [
        '01' => 'BA',
        '02' => 'QU',
        '04' => 'OI',
        '05' => 'BL',
        '06' => 'CA',
        '07' => 'TO',
        '10' => 'GA',
        '11' => 'BS',
        '12' => 'BM',
    ],
    'GY' => [
        '10' => 'BA',
        '11' => 'CU',
        '12' => 'DE',
        '13' => 'EB',
        '14' => 'ES',
        '15' => 'MA',
        '16' => 'PM',
        '17' => 'PT',
        '18' => 'UD',
        '19' => 'UT',
    ],
    'HN' => [
        '01' => 'AT',
        '02' => 'CH',
        '03' => 'CL',
        '04' => 'CM',
        '05' => 'CP',
        '06' => 'CR',
        '07' => 'EP',
        '08' => 'FM',
        '09' => 'GD',
        '10' => 'IN',
        '11' => 'IB',
        '12' => 'LP',
        '13' => 'LE',
        '14' => 'OC',
        '15' => 'OL',
        '16' => 'SB',
        '17' => 'VA',
        '18' => 'YO',
    ],
    'HR' => [
        '01' => '07',
        '02' => '12',
        '03' => '19',
        '04' => '18',
        '05' => '04',
        '06' => '06',
        '07' => '02',
        '08' => '09',
        '09' => '20',
        '10' => '14',
        '11' => '11',
        '12' => '08',
        '13' => '15',
        '14' => '03',
        '15' => '17',
        '16' => '05',
        '17' => '10',
        '18' => '16',
        '19' => '13',
        '20' => '01',
        '21' => '21',
    ],
    'HT' => [
        '03' => 'NO',
        '06' => 'AR',
        '07' => 'CE',
        '09' => 'ND',
        '10' => 'NE',
        '11' => 'OU',
        '12' => 'SD',
        '13' => 'SE',
        '14' => 'GA',
        '15' => 'NI',
    ],
    'HU' => [
        '01' => 'BK', // Bacs-Kiskun
        '02' => 'BA', // Baranya
        '03' => 'BE', // Bekes
        '04' => 'BZ', // Borsod-Abauj-Zemplen
        '05' => 'BU', // Budapest
        '06' => 'CS', // Csongrad
        '07' => 'DE', // Debrecen
        '08' => 'FE', // Fejer
        '09' => 'GS', // Gyor-Moson-Sopron
        '10' => 'HB', // Hajdu-Bihar
        '11' => 'HE', // Heves
        '12' => 'KE', // Komarom-Esztergom
        '13' => 'MI', // Miskolc
        '14' => 'NO', // Nograd
        '15' => 'PS', // Pecs
        '16' => 'PE', // Pest
        '17' => 'SO', // Somogy
        '18' => 'SZ', // Szabolcs-Szatmar-Bereg
        '19' => 'SD', // Szeged
        '20' => 'JN', // Jasz-Nagykun-Szolnok
        '21' => 'TO', // Tolna
        '22' => 'VA', // Vas
        '23' => 'VE', // Veszprem
        '24' => 'ZA', // Zala
        '25' => 'GY', // Gyor
        '26' => 'BC', // Bekescsaba
        '27' => 'DU', // Dunaujvaros
        '28' => 'EG', // Eger
        '29' => 'HV', // Hodmezovasarhely
        '30' => 'KV', // Kaposvar
        '31' => 'KM', // Kecskemet
        '32' => 'NK', // Nagykanizsa
        '33' => 'NY', // Nyiregyhaza
        '34' => 'SN', // Sopron
        '35' => 'SF', // Szekesfehervar
        '36' => 'SK', // Szolnok
        '37' => 'SH', // Szombathely
        '38' => 'TB', // Tatabanya
        '39' => 'VE', // Veszprem
        '40' => 'ZE', // Zalaegerszeg
        '41' => 'ST', // Salgotarjan
        '42' => 'SS', // Szekszard
        '43' => 'ER', // Erd
    ],
    'ID' => [
        '01' => 'AC',
        '02' => 'BA',
        '03' => 'BE',
        '04' => 'JK',
        '05' => 'JA',
        '07' => 'JT',
        '08' => 'JI',
        '10' => 'YO',
        '11' => 'KB',
        '12' => 'KS',
        '13' => 'KT',
        '14' => 'KI',
        '15' => 'LA',
        '17' => 'NB',
        '18' => 'NT',
        '21' => 'ST',
        '22' => 'SG',
        '24' => 'SB',
        '26' => 'SU',
        '28' => 'MA',
        '29' => 'MU',
        '30' => 'JB',
        '31' => 'SA',
        '32' => 'SS',
        '33' => 'BT',
        '34' => 'GO',
        '35' => 'BB',
        '36' => 'PA',
        '37' => 'RI',
        '38' => 'SN',
        '39' => 'PB',
        '40' => 'KR',
        '41' => 'SR',
    ],
    'IE' => [
        '01' => 'CW',
        '02' => 'CN',
        '03' => 'CE',
        '04' => 'CO',
        '06' => 'DL',
        '07' => 'D',
        '10' => 'G',
        '11' => 'KY',
        '12' => 'KE',
        '13' => 'KK',
        '14' => 'LM',
        '15' => 'LS',
        '16' => 'LK',
        '18' => 'LD',
        '19' => 'LH',
        '20' => 'MO',
        '21' => 'MH',
        '22' => 'MN',
        '23' => 'OY',
        '24' => 'RN',
        '25' => 'SO',
        '26' => 'TA',
        '27' => 'WD',
        '29' => 'WH',
        '30' => 'WX',
        '31' => 'WW',
    ],
    'IL' => [
        '01' => 'D',
        '02' => 'M',
        '03' => 'Z',
        '04' => 'HA',
        '05' => 'TA',
        '06' => 'JM',
    ],
    'IN' => [
        '01' => 'AN',
        '02' => 'AP',
        '03' => 'AS',
        '05' => 'CH',
        '06' => 'DN',
        '07' => 'DL',
        '09' => 'GJ',
        '10' => 'HR',
        '11' => 'HP',
        '12' => 'JK',
        '13' => 'KL',
        '14' => 'LD',
        '16' => 'MH',
        '17' => 'MN',
        '18' => 'ML',
        '19' => 'KA',
        '20' => 'NL',
        '21' => 'OR',
        '22' => 'PY',
        '23' => 'PB',
        '24' => 'RJ',
        '25' => 'TN',
        '26' => 'TR',
        '28' => 'WB',
        '29' => 'SK',
        '30' => 'AR',
        '31' => 'MZ',
        '32' => 'DD',
        '33' => 'GA',
        '34' => 'BR',
        '35' => 'MP',
        '36' => 'UP',
        '37' => 'CT',
        '38' => 'JH',
        '39' => 'UT',
    ],
    'IQ' => [
        '01' => 'AN',
        '02' => 'BA',
        '03' => 'MU',
        '04' => 'QA',
        '05' => 'SU',
        '06' => 'BB',
        '07' => 'BG',
        '08' => 'DA',
        '09' => 'DQ',
        '10' => 'DI',
        '11' => 'AR',
        '12' => 'KA',
        '13' => 'KI',
        '14' => 'MA',
        '15' => 'NI',
        '16' => 'WA',
        '17' => 'NA',
        '18' => 'SD',
    ],
    'IR' => [
        // mapping based on wikidata and on manual name matches
        '01' => '02', // Āz̄arbāyjān-e Gharbī Province
        '03' => '08', // Chahār Maḩāll va Bakhtīār Province
        '04' => '13', // Sīstān va Balūchestān Province
        '05' => '18', // Kohgīlūyeh va Būyer Aḩmad Province
        '07' => '14', // Fārs Province
        '08' => '19', // Gīlān Province
        '09' => '24', // Hamadān Province
        '10' => '05', // Īlām Province
        '11' => '23', // Hormozgān Province
        '13' => '17', // Kermānshāh Province
        '15' => '10', // Khūzestān Province
        '16' => '16', // Kordestān Province
        '22' => '06', // Būshehr Province
        '23' => '20', // Lorestān Province
        '25' => '12', // Semnān Province
        '26' => '07', // Tehrān Province
        '28' => '04', // Eşfahān Province
        '29' => '15', // Kermān Province
        '32' => '03', // Ardabīl Province
        '33' => '01', // Āz̄arbāyjān-e Sharqī Province
        '34' => '22', // Markaz Province
        '35' => '21', // Māzandarān Province
        '36' => '11', // Zanjān Province
        '37' => '27', // Golestān Province
        '38' => '28', // Qazvīn Province
        '39' => '26', // Qom Province
        '40' => '25', // Yazd Province
        '41' => '29', // Khorāsān-e Janūbī Province
        '42' => '30', // Khorāsān-e Razavī Province
        '43' => '31', // Khorāsān-e Razavī Province
        '44' => '32', // Alborz Province

        // invalid codes  [used by maxmind]
        '12' => '15', // Kerman
        '17' => '21', // Mazandaran
        '18' => '12', // Semnan Province
        '19' => '22', // Markazi
        '21' => '11', // Zanjan
        '24' => '22', // Markazi
        '27' => '11', // Zanjan
        '30' => '', // Khorasan  [split up]
        '31' => '25', // Yazd
    ],
    'IS' => [
        // codes contained in maxmind file, but actually no valid FIPS codes anymore
        // mapping roughly based on the maps of Wikipedia
        '03' => '8', // Arnessysla
        '05' => '5', // Austur-Hunavatnssysla
        '06' => '7', // Austur-Skaftafellssysla
        '07' => '3', // Borgarfjardarsysla
        '09' => '6', // Eyjafjardarsysla
        '10' => '2', // Gullbringusysla
        '15' => '1', // Kjosarsysla
        '17' => '3', // Myrasysla
        '20' => '7', // Nordur-Mulasysla
        '21' => '6', // Nordur-Tingeyjarsysla
        '23' => '8', // Rangarvallasysla
        '28' => '5', // Skagafjardarsysla
        '29' => '3', // Snafellsnes- og Hnappadalssysla
        '30' => '4', // Strandasysla
        '31' => '7', // Sudur-Mulasysla
        '32' => '6', // Sudur-Tingeyjarsysla
        '34' => '4', // Vestur-Bardastrandarsysla
        '35' => '5', // Vestur-Hunavatnssysla
        '36' => '4', // Vestur-Isafjardarsysla
        '37' => '8', // Vestur-Skaftafellssysla
        // valid FIPS codes
        '38' => '7', // Austurland
        '39' => '1', // Hofuoborgarsvaoio
        '40' => '6', // Norourland Eystra
        '41' => '5', // Norourland Vestra
        '42' => '8', // Suourland
        '43' => '2', // Suournes
        '44' => '4', // Vestfiroir
        '45' => '3', // Vesturland
    ],
    'IT' => [
        '01' => '65',
        '02' => '77',
        '03' => '78',
        '04' => '72',
        '05' => '45',
        '06' => '36',
        '07' => '62',
        '08' => '42',
        '09' => '25',
        '10' => '57',
        '11' => '67',
        '12' => '21',
        '13' => '75',
        '14' => '88',
        '15' => '82',
        '16' => '52',
        '17' => '32',
        '18' => '55',
        '19' => '23',
        '20' => '34',
    ],
    'JM' => [
        '01' => '13',
        '02' => '09',
        '04' => '12',
        '07' => '04',
        '08' => '02',
        '09' => '06',
        '10' => '14',
        '11' => '11',
        '12' => '08',
        '13' => '05',
        '14' => '03',
        '15' => '07',
        '16' => '10',
        '17' => '01',
    ],
    'JO' => [
        '02' => 'BA',
        '09' => 'KA',
        '12' => 'AT',
        '15' => 'MA',
        '16' => 'AM',
        '17' => 'AZ',
        '18' => 'IR',
        '19' => 'MN',
        '20' => 'AJ',
        '21' => 'AQ',
        '22' => 'JA',
        '23' => 'MD',
    ],
    'JP' => [
        '01' => '23',
        '02' => '05',
        '03' => '02',
        '04' => '12',
        '05' => '38',
        '06' => '18',
        '07' => '40',
        '08' => '07',
        '09' => '21',
        '10' => '10',
        '11' => '34',
        '12' => '01',
        '13' => '28',
        '14' => '08',
        '15' => '17',
        '16' => '03',
        '17' => '37',
        '18' => '46',
        '19' => '14',
        '20' => '39',
        '21' => '43',
        '22' => '26',
        '23' => '24',
        '24' => '04',
        '25' => '45',
        '26' => '20',
        '27' => '42',
        '28' => '29',
        '29' => '15',
        '30' => '44',
        '31' => '33',
        '32' => '27',
        '33' => '41',
        '34' => '11',
        '35' => '25',
        '36' => '32',
        '37' => '22',
        '38' => '09',
        '39' => '36',
        '40' => '13',
        '41' => '31',
        '42' => '16',
        '43' => '30',
        '44' => '06',
        '45' => '35',
        '46' => '19',
        '47' => '47',
    ],
    'KE' => [
        // completely reorganized in 2014
        '01' => '',
        '02' => '',
        '03' => '',
        '05' => '',
        '06' => '',
        '07' => '',
        '08' => '',
        '09' => '',
    ],
    'KG' => [
        '01' => 'GB', // Bishkek
        '02' => 'C', // Chuy
        '03' => 'J', // Jalal-Abad
        '04' => 'N', // Naryn
        '06' => 'T', // Talas
        '07' => 'Y', // Ysyk-Kol
        '08' => 'GO', // Osh
        '09' => 'B', // Batken

        // [invalid code]
        '05' => 'GO', // Osh
    ],
    'KH' => [
        '02' => '3',
        '03' => '4',
        '04' => '5',
        '05' => '6',
        '07' => '8',
        '08' => '9',
        '09' => '10',
        '10' => '11',
        '12' => '15',
        '13' => '13',
        '14' => '14',
        '17' => '19',
        '18' => '20',
        '19' => '21',
        '22' => '12',
        '23' => '16',
        '25' => '1',
        '28' => '18',
        '29' => '2',
        '30' => '24',

        // invalid codes [used by maxmind] (mapped based on the names)
        '01' => '2', // Batdambang
        '06' => '7', // Kampot
        '11' => '12', // Phnum Penh
        '15' => '16', // Ratanakiri Kiri
        '16' => '17', // Siem Reap
    ],
    'KI' => [
        '01' => 'G',
        '02' => 'L',
        '03' => 'P',
    ],
    'KM' => [
        '01' => 'A',
        '02' => 'G',
        '03' => 'M',
    ],
    'KN' => [
        '01' => '01',
        '02' => '02',
        '03' => '03',
        '04' => '04',
        '05' => '05',
        '06' => '06',
        '07' => '07',
        '08' => '08',
        '09' => '09',
        '10' => '10',
        '11' => '11',
        '12' => '12',
        '13' => '13',
        '15' => '15',
    ],
    'KP' => [
        // mapping based on names an wikipedia pages
        '01' => '04', // Chagang-do
        '03' => '08', // Hamgyong-namdo
        '06' => '05', // Hwanghae-namdo
        '07' => '09', // Hwanghae-bukto
        '08' => '06', // Kaesong-si
        '09' => '07', // Kangwon-do
        '11' => '09', // P'yongan-bukto
        '12' => '01', // P'yongyang-si
        '13' => '10', // Yanggang-do
        '14' => '14', // Namp'o-si
        '15' => '02', // P'yongan-namdo
        '17' => '09', // Hamgyong-bukto
        '18' => '13', // Najin Sonbong-si
    ],
    'KR' => [
        '01' => '49',
        '03' => '45',
        '05' => '43',
        '06' => '42',
        '10' => '26',
        '11' => '11',
        '12' => '28',
        '13' => '41',
        '14' => '47',
        '15' => '27',
        '16' => '46',
        '17' => '44',
        '18' => '29',
        '19' => '30',
        '20' => '48',
        '21' => '31',
    ],
    'KW' => [
        '01' => 'AH',
        '02' => 'KU',
        '05' => 'JA',
        '07' => 'FA',
        '08' => 'HA',
        '09' => 'MU',
    ],
    'KY' => [
        // Cayman Islands do not have an ISO regions
        '01' => '',
        '02' => '',
        '03' => '',
        '04' => '',
        '05' => '',
        '06' => '',
        '07' => '',
        '08' => '',
    ],
    'KZ' => [
        '01' => 'ALM',
        '02' => 'ALA',
        '03' => 'AKM',
        '04' => 'AKT',
        '05' => 'AST',
        '06' => 'ATY',
        '07' => 'ZAP',
        '08' => 'BAY',
        '09' => 'MAN',
        '10' => 'YUZ',
        '11' => 'PAV',
        '12' => 'KAR',
        '13' => 'KUS',
        '14' => 'KZY',
        '15' => 'VOS',
        '16' => 'SEV',
        '17' => 'ZHA',
    ],
    'LA' => [
        '01' => 'AT',
        '02' => 'CH',
        '03' => 'HO',
        '07' => 'OU',
        '13' => 'XA',
        '14' => 'XI',
        '17' => 'LP',

        // valid codes [not used by maxmind]
        '18' => 'PH', // Phôngsali Province
        '19' => 'SL', // Salavan Province
        '20' => 'SV', // Savannakhét Province
        '22' => 'BK', // Bokèo Province
        '23' => 'BL', // Bolikhamxai Province
        '24' => 'VI', // Viangchan Municipality
        '25' => 'XS', // Xaisômboun Special Zone
        '26' => 'XE', // Xékong Province
        '27' => 'VI', // Vientiane Province

        // invalid codes [used by maxmind] (mapped based on the names)
        '04' => 'KH', //Khammouan
        '05' => 'LM', //Louang Namtha
        '08' => 'PH', //Phongsali
        '09' => 'SL', //Saravan
        '10' => 'SV', //Savannakhet
        '11' => 'VI', //Vientiane
    ],
    'LB' => [
        '04' => 'BA',
        '05' => 'JL',
        '06' => 'JA',
        '07' => 'NA',
        '08' => 'BI',
        '09' => 'AS',
        '10' => 'AK',
        '11' => 'BH',

        // invalid codes [used by maxmind]
        '01' => 'BI', // Beqaa
        '02' => 'JA', // Al Janub
        '03' => 'AS', // Liban-Nord
    ],
    'LC' => [
        '01' => '01',
        '02' => '', // [split up]
        '03' => '02',
        '04' => '03',
        '05' => '05',
        '06' => '06',
        '07' => '07',
        '08' => '08',
        '09' => '10',
        '10' => '11',
        '11' => '', // [split up]
    ],
    'LI' => [
        '01' => '01',
        '02' => '02',
        '03' => '03',
        '04' => '04',
        '05' => '05',
        '06' => '06',
        '07' => '07',
        '08' => '08',
        '09' => '09',
        '10' => '10',
        '11' => '11',

        // codes screwed up by maxmind
        // Based on the names they seem to be from Liberia, so remove them
        '21' => '', // Gbarpolu
        '22' => '', // River Gee
    ],
    'LK' => [
        // valid FIPS codes  [not used by maxmind]
        '01' => '52', // Amparai District
        '02' => '71', // Anuradhapura District
        '03' => '81', // Badulla District
        '04' => '51', // Batticaloa District
        '06' => '31', // Galle District
        '07' => '33', // Hambantota District
        '09' => '13', // Kalutara District
        '10' => '21', // Kandy District
        '11' => '92', // Kegalla District
        '12' => '61', // Kurunegala District
        '14' => '22', // Matale District
        '15' => '32', // Matara District
        '16' => '82', // Moneragala District
        '17' => '23', // Nuwara Eliya District
        '18' => '72', // Polonnaruwa District
        '19' => '62', // Puttalam District
        '20' => '91', // Ratnapura District
        '21' => '53', // Trincomalee District
        '23' => '11', // Colombo District
        '24' => '12', // Gampaha District
        '25' => '41', // Jaffna District
        '26' => '43', // Mannar District
        '27' => '45', // Mullaittivu District
        '28' => '44', // Vavuniya District

        // invalid codes [use by maxmind]
        '29' => '2', // Central
        '30' => '7', // North Central
        '32' => '6', // North Western
        '33' => '9', // Sabaragamuwa
        '34' => '3', // Southern
        '35' => '8', // Uva
        '36' => '1', // Western
        '37' => '5', // Eastern
        '38' => '4', // Northern
    ],
    'LR' => [
        '01' => 'BG',
        '09' => 'NI',
        '10' => 'SI',
        '11' => 'GB',
        '12' => 'CM',
        '13' => 'MY',
        '14' => 'MO',
        '17' => 'MG',
        '18' => 'RI',
        '19' => 'GG',
        '20' => 'LO',
        '21' => 'GP',
        '22' => 'RG',

        // valid codes  [not used by maxmind]
        '15' => 'BM',
        '16' => 'GK',

        // invalid codes  [used by maxmind]
        '04' => 'CM', // Grand Cape Mount
        '05' => 'LO', // Lofa
        '06' => 'MY', // Maryland
        '07' => 'MO', // Monrovia  [capital city in region Montserrado]
    ],
    'LS' => [
        '10' => 'D',
        '11' => 'B',
        '12' => 'C',
        '13' => 'E',
        '14' => 'A',
        '15' => 'F',
        '16' => 'J',
        '17' => 'H',
        '18' => 'G',
        '19' => 'K',
    ],
    'LT' => [
        '56' => 'AL',
        '57' => 'KU',
        '58' => 'KL',
        '59' => 'MR',
        '60' => 'PN',
        '61' => 'SA',
        '62' => 'TA',
        '63' => 'TE',
        '64' => 'UT',
        '65' => 'VL',
    ],
    'LU' => [
        // completely reorganized in 2015
        '01' => '',
        '02' => '',
        '03' => '',
    ],
    'LV' => [
        // mapping based on the names on wikipedia
        '01' => '002', // Aizkraukles
        '02' => '007', // Aluksnes
        '03' => '015', // Balvu
        '04' => '016', // Bauskas
        '05' => '022', // Cesu
        '06' => 'DGV', // Daugavpils
        '07' => '025', // Daugavpils
        '08' => '026', // Dobeles
        '09' => '033', // Gulbenes
        '10' => '042', // Jekabpils
        '11' => 'JEL', // Jelgava
        '12' => '041', // Jelgavas
        '13' => 'JUR', // Jurmala
        '14' => '047', // Kraslavas
        '15' => '050', // Kuldigas
        '16' => 'LPX', // Liepaja
        '17' => '', // Liepajas [splitted in 2009 and not mappable]
        '18' => '054', // Limbazu
        '19' => '058', // Ludzas
        '20' => '059', // Madonas
        '21' => '067', // Ogres
        '22' => '073', // Preilu
        '23' => 'REZ', // Rezekne
        '24' => '077', // Rezeknes
        '25' => 'RIX', // Riga
        '26' => '', // Rigas  [splitted in 2009 and not mappable]
        '27' => '088', // Saldus
        '28' => '097', // Talsu
        '29' => '099', // Tukuma
        '30' => '101', // Valkas
        '31' => 'VMR', // Valmieras
        '32' => 'VEN', // Ventspils
        '33' => '106', // Ventspils
    ],
    'LY' => [
        '03' => 'JI', // Al Aziziyah  [part of Jafara since 2009]
        '05' => 'JU', // Al Jufrah
        '08' => 'KF', // Al Kufrah
        '13' => 'WS', // Ash Shati'
        '30' => 'MQ', // Murzuq
        '34' => 'SB', // Sabha
        '41' => 'MQ', // Tarhunah  [occupied by Tarhuna wa Msalata and transformed to Murqub in 2009]
        '42' => 'BU', // Tubruq
        '45' => 'MI', // Zlitan  [part of Misrata since 2009]
        '47' => 'WA', // Ajdabiya  [included in Al Wāḩāt since 2007]
        '48' => 'MJ', // Al Fatih  [some parts are in Marj]
        '49' => 'JA', // Al Jabal al Akhdar
        '50' => 'MB', // Al Khums  [seems to be part of Al Marqab]
        '51' => 'NQ', // An Nuqat al Khams
        '52' => 'WD', // Awbari  [part of Wadi al Hayaa]
        '53' => 'ZA', // Az Zawiyah
        '54' => 'BA', // Banghazi
        '55' => 'DR', // Darnah
        '56' => 'NL', // Ghadamis  [part of Nalut]
        '57' => 'JG', // Gharyan  [part of Jabal al Gharbi  since 2007]
        '58' => 'MI', // Misratah
        '59' => '', // Sawfajjin   [split between Sirte and Misrata]
        '60' => 'SR', // Surt
        '61' => 'TB', // Tarabulus
        '62' => '', // Yafran  [split between Jabal al Gharbi and Nalut]
    ],
    'MA' => [
        '45' => '08',
        '46' => '05',
        '47' => '11',
        '48' => '06',
        '49' => '07',
        '50' => '09',
        '51' => '10',
        '52' => '02',
        '53' => '14',
        '54' => '04',
        '55' => '13',
        '56' => '12',
        '57' => '01',
        '58' => '03',
        '59' => '15',
    ],
    'MC' => [
        // there are no fips codes for Monaco
        // those were used by maxind
        '01' => 'CO', // La Condamine
        '02' => 'MO', // Monaco
        '03' => 'MC', // Monte-Carlo
    ],
    'MD' => [
        '51' => 'GA',
        '57' => 'CU', // Chisinau
        '58' => 'SN', // Stinga Nistrului
        '59' => 'AN',
        '60' => 'BA',
        '61' => 'BS',
        '62' => 'BD',
        '63' => 'BR',
        '64' => 'CA',
        '65' => 'CT',
        '66' => 'CL', // Calarasi
        '67' => 'CS',
        '68' => 'CM', // Cimislia
        '69' => 'CR',
        '70' => 'DO',
        '71' => 'DR',
        '72' => 'DU',
        '73' => 'ED',
        '74' => 'FA',
        '75' => 'FL', // Floresti
        '76' => 'GL',
        '77' => 'HI',
        '78' => 'IA',
        '79' => 'LE',
        '80' => 'NI',
        '81' => 'OC',
        '82' => 'OR',
        '83' => 'RE',
        '84' => 'RI',
        '85' => 'SI',
        '86' => 'SD',
        '87' => 'SO',
        '88' => 'SV',
        '89' => 'ST',
        '90' => 'TA', // Taraclia
        '91' => 'TE',
        '92' => 'UN', // Ungheni
    ],
    'MG' => [
        '01' => 'D', // Antsiranana
        '02' => 'F', // Fianarantsoa
        '03' => 'M', // Mahajanga
        '04' => 'A', // Toamasina
        '05' => 'T', // Antananarivo
        '06' => 'U', // Toliara
    ],
    'MK' => [
        '01' => '02', // Aracinovo
        '02' => '55', // Bac  [now part of Novaci]
        '03' => '22', // Belcista  [now Debarca]
        '04' => '03', // Berovo
        '05' => '04', // Bistrica  [city in Bitola]
        '06' => '04', // Bitola
        '07' => '14', // Blatec  [now part of Vinica]
        '08' => '05', // Bogdanci
        '09' => '80', // Bogomila  [city in Caska]
        '10' => '03', // Bogovinje
        '11' => '07', // Bosilovo
        '12' => '08', // Brvenica
        '14' => '04', // Capari [city in Bitola]
        '15' => '80', // Caska
        '16' => '19', // Cegrane  [city in Gostivar]
        '19' => '81', // Cesinovo
        '20' => '82', // Cucer-Sandevo
        '21' => '21', // Debar
        '22' => '23', // Delcevo
        '23' => '72', // Delogozdi  [city in Struga]
        '24' => '25', // Demir Hisar
        '25' => '24', // Demir Kapija
        '26' => '53', // Dobrusevo  [city in Moglia]
        '27' => '19', // Dolna Banjica  [city in Gostivar]
        '28' => '27', // Dolneni
        '30' => '40', // Drugovo  [merged with Kicevo]
        '31' => '76', // Dzepciste  [city in Tetovo]
        '33' => '18', // Gevgelija
        '34' => '19', // Gostivar
        '35' => '20', // Gradsko
        '36' => '34', // Ilinden
        '37' => '80', // Izvor  [attached to Caska]
        '38' => '35', // Jegunovce
        '39' => '03', // Kamenjane  [city in Bogovinje]
        '40' => '37', // Karbinci
        '41' => '85', // Karpos  [now in Skopje]
        '42' => '36', // Kavadarci
        '43' => '40', // Kicevo
        '44' => '85', // Kisela Voda  [now in Skopje]
        '45' => '', // Klecevce  [attached to Klecevce and Staro Nagoricane]
        '46' => '42', // Kocani
        '47' => '41', // Konce
        '48' => '85', // Kondovo  [now in Skopje]
        '49' => '36', // Konopiste  [city in Kavadarci]
        '50' => '58', // Kosel  [city in Ohrid]
        '51' => '43', // Kratovo
        '52' => '44', // Kriva Palanka
        '53' => '45', // Krivogastani
        '54' => '46', // Krusevo
        '55' => '73', // Kuklis  [city in Strumica]
        '56' => '04', // Kukurecani  [city in Bitola]
        '57' => '47', // Kumanovo
        '58' => '72', // Labunista  [city in Struga]
        '59' => '48', // Lipkovo
        '60' => '49', // Lozovo
        '61' => '72', // Lukovo  [city in Struga]
        '62' => '51', // Makedonska Kamenica
        '63' => '52', // Makedonski Brod
        '64' => '50', // Mavrovi Anovi  [city in Mavrovo i Rostuša]
        '65' => '22', // Meseista  [city in Debarca]
        '66' => '18', // Miravci  [city in Gevgelija]
        '67' => '53', // Mogila
        '68' => '73', // Murtino  [splitted between Strumica and Bosilovo; major part in Strumica]
        '69' => '54', // Negotino
        '70' => '54', // Negotino-Polosko
        '71' => '55', // Novaci
        '72' => '56', // Novo Selo
        '73' => '81', // Oblesevo
        '74' => '58', // Ohrid
        '75' => '47', // Orasac  [city in Kumanovo]
        '76' => '48', // Orizari  [city in Lipkovo]
        '77' => '40', // Oslomej  [city in Kičevo]
        '78' => '60', // Pehcevo
        '79' => '59', // Petrovec
        '80' => '61', // Plasnica
        '81' => '64', // Podares  [city in Rodavis]
        '82' => '62', // Prilep
        '83' => '63', // Probistip
        '84' => '64', // Radovis
        '85' => '65', // Rankovce
        '86' => '66', // Resen
        '87' => '67', // Rosoman
        '88' => '50', // Rostusa  [city in Mavrovo i Rostuša]
        '89' => '', // Samokov  [city in Sofia]   ?????????????????????
        '90' => '85', // Saraj  [now in Skopje]
        '91' => '76', // Sipkovica  [city in Tetovo]
        '92' => '70', // Sopiste
        '93' => '25', // Sopotnica  [city in Demir Hisar]
        '94' => '19', // Srbinovo  [city in Gostivar]
        '95' => '55', // Staravina  [city in Novaci]
        '96' => '26', // (Star) Dojran
        '97' => '71', // Staro Nagoricane
        '98' => '83', // Stip
        '99' => '72', // Struga
        'A1' => '73', // Strumica
        'A2' => '73', // Studenicani
        'A3' => '85', // Suto Orizari  [now in Skopje]
        'A4' => '69', // Sveti Nikole
        'A5' => '75', // Tearce
        'A6' => '76', // Tetovo
        'A7' => '62', // Topolcani  [city in Prilep]
        'A8' => '10', // Valandovo
        'A9' => '11', // Vasilevo
        'B1' => '16', // Veles
        'B2' => '72', // Velesta  [city in Struga]
        'B3' => '12', // Vevcani
        'B4' => '14', // Vinica
        'B5' => '62', // Vitoliste  [city in Prilep]
        'B6' => '40', // Vranestica  [now in Kicevo]
        'B7' => '16', // Vrapciste
        'B8' => '35', // Vratnica  [city in Jegunovce]
        'B9' => '19', // Vrutok  [city in Gostivar]
        'C1' => '40', // Zajas  [now in Kicevo]
        'C2' => '32', // Zelenikovo
        'C3' => '30', // Zelino
        'C4' => '27', // Zitose  [city in Dolneni]
        'C5' => '63', // Zletovo  [city in Probistip]
        'C6' => '33', // Zrnovci

        // invalid codes  [used by maxmind]
        '13' => '85', // Cair  [now in Skopje]
        '17' => '78', // Centar
        '18' => '78', // Centar Zupa
        '29' => '85', // Dorce Petrov  [now in Skopje]
        '32' => '85', // Gazi Baba  [now in Skopje]
        'C8' => '85', // Cair  [now in Skopje]
        'C9' => '80', // Caska
        'D2' => '21', // Debar
        'D3' => '25', // Demir Hisar
        'D4' => '19', // Gostivar
        'D5' => '35', // Jegunovce
        'D6' => '36', // Kavadarci
        'D7' => '47', // Kumanovo
        'D8' => '52', // Makedonski Brod
        'E2' => '58', // Ohrid
        'E3' => '62', // Prilep
        'E5' => '26', // Dojran
        'E6' => '72', // Struga
        'E7' => '73', // Strumica
        'E8' => '76', // Tetovo
        'E9' => '10', // Valandovo
        'F1' => '13', // Veles
        'F2' => '85', // Aerodrom  [now in Skopje]
    ],
    'ML' => [
        '01' => 'BKO',
        '03' => '1',
        '04' => '5',
        '05' => '4',
        '06' => '3',
        '07' => '2',
        '08' => '6',
        '09' => '7',
        '10' => '8',
    ],
    'MM' => [
        '01' => '16', // Rakhine State
        '02' => '14', // Chin State
        '03' => '07', // Irrawaddy
        '04' => '11', // Kachin State
        '05' => '13', // Karan State
        '06' => '12', // Kayah State
        '08' => '04', // Mandalay
        '10' => '01', // Sagaing
        '11' => '17', // Shan State
        '12' => '05', // Tenasserim
        '13' => '15', // Mon State
        '17' => '06', // Yangon

        // invalid codes  [used by maxmind]
        '07' => '03', // Magwe
        '09' => '02', // Pegu
        '14' => '06', // Rangoon

        // valid codes  [not used by maxmind]
        '15' => '03', // Magway Division
        '16' => '02', // Bago Division
    ],
    'MN' => [
        '01' => '073', // Arhangay
        '02' => '069', // Bayanhongor
        '03' => '071', // Bayan-Olgiy
        '06' => '061', // Dornod
        '07' => '063', // Dornogovi
        '08' => '059', // Dundgovi
        '09' => '057', // Dzavhan
        '10' => '065', // Govi-Altay
        '11' => '039', // Hentiy
        '12' => '043', // Hovd
        '13' => '041', // Hovsgol
        '14' => '053', // Omnogovi
        '15' => '055', // Ovorhangay
        '16' => '049', // Selenge
        '17' => '051', // Suhbaatar
        '18' => '047', // Tov
        '19' => '046', // Uvs
        '20' => '1', // Ulaanbaatar
        '21' => '067', // Bulgan
        '23' => '037', // Darhan-Uul
        '24' => '064', // Govisumber
        '25' => '035', // Orhon

        // invalid codes  [used by maxmind]
        '05' => '037', // Darhan
        '22' => '035', // Erdenet  [city in Orkhon]
    ],
    'MO' => [
        // No ISO codes assigned for Macau
        '01' => '', // Ilhas
        '02' => '', // Macau
    ],
    'MR' => [
        '01' => '01',
        '02' => '02',
        '03' => '03',
        '04' => '04',
        '05' => '05',
        '06' => '06',
        '07' => '07',
        '08' => '08',
        '09' => '09',
        '10' => '10',
        '11' => '11',
        '12' => '12',
    ],
    'MS' => [
        // No ISO codes assigned for Montserrat
        '01' => '',
        '02' => '',
        '03' => '',
    ],
    'MU' => [
        '12' => 'BL',
        '13' => 'FL',
        '14' => 'GP',
        '15' => 'MO',
        '16' => 'PA',
        '17' => 'PW',
        '18' => 'PL',
        '19' => 'RR',
        '20' => 'SA',
        '21' => 'AG',
        '22' => 'CC',
        '23' => 'RO',
    ],
    'MV' => [
        '01' => '01',
        '05' => '05',
        '30' => '02',
        '31' => '20',
        '32' => '17',
        '33' => '14',
        '34' => '27',
        '35' => '28',
        '36' => '07',
        '37' => '23',
        '38' => '26',
        '39' => '03',
        '40' => 'MLE',
        '41' => '12',
        '42' => '29',
        '43' => '25',
        '44' => '13',
        '45' => '24',
        '46' => '08',
        '47' => '04',
    ],
    'MW' => [
        '02' => 'CK', // Chikwawa
        '03' => 'CR', // Chiradzulu
        '04' => 'CT', // Chitipa
        '05' => 'TH', // Thyolo
        '06' => 'DE', // Dedza
        '07' => 'DO', // Dowa
        '08' => 'KR', // Karonga
        '09' => 'KS', // Kasungu
        '11' => 'LI', // Lilongwe
        '12' => 'MG', // Mangochi
        '13' => 'MC', // Mchinji
        '15' => 'MZ', // Mzimba
        '16' => 'NU', // Ntcheu
        '17' => 'NB', // Nkhata Bay
        '18' => 'NK', // Nkhotakota
        '19' => 'NS', // Nsanje
        '20' => 'NI', // Ntchisi
        '21' => 'RU', // Rumphi
        '22' => 'SA', // Salima
        '23' => 'ZO', // Zomba
        '24' => 'BL', // Blantyre
        '25' => 'MW', // Mwanza
        '26' => 'BA', // Balaka
        '27' => 'LK', // Likoma
        '28' => 'MH', // Machinga
        '29' => 'MU', // Mulanje
        '30' => 'PH', // Phalombe
    ],
    'MX' => [
        '01' => 'AGU',
        '02' => 'BCN',
        '03' => 'BCS',
        '04' => 'CAM',
        '05' => 'CHP',
        '06' => 'CHH',
        '07' => 'COA',
        '08' => 'COL',
        '09' => 'CMX',
        '10' => 'DUR',
        '11' => 'GUA',
        '12' => 'GRO',
        '13' => 'HID',
        '14' => 'JAL',
        '15' => 'MEX',
        '16' => 'MIC',
        '17' => 'MOR',
        '18' => 'NAY',
        '19' => 'NLE',
        '20' => 'OAX',
        '21' => 'PUE',
        '22' => 'QUE',
        '23' => 'ROO',
        '24' => 'SLP',
        '25' => 'SIN',
        '26' => 'SON',
        '27' => 'TAB',
        '28' => 'TAM',
        '29' => 'TLA',
        '30' => 'VER',
        '31' => 'YUC',
        '32' => 'ZAC',
    ],
    'MY' => [
        '01' => '01',
        '02' => '02',
        '03' => '03',
        '04' => '04',
        '05' => '05',
        '06' => '06',
        '07' => '08',
        '08' => '09',
        '09' => '07',
        '11' => '13',
        '12' => '10',
        '13' => '11',
        '14' => '14',
        '15' => '15',
        '16' => '12',
        '17' => '16',
    ],
    'MZ' => [
        '01' => 'P',
        '02' => 'G',
        '03' => 'I',
        '04' => 'L',
        '05' => 'S',
        '06' => 'N',
        '07' => 'A',
        '08' => 'T',
        '09' => 'Q',
        '10' => 'B',
        '11' => 'MPM',
    ],
    'NA' => [
        '21' => 'KH', // Windhoek  [capital city of Khomas]
        '28' => 'CA', // Caprivi (now named Zambezi)
        '29' => 'ER', // Erongo
        '30' => 'HA', // Hardap
        '31' => 'KA', // Karas
        '32' => 'KU', // Kunene
        '33' => 'OW', // Ohangwena
        '34' => '', // Okavango  [now splitted in Kavango East and West]
        '35' => 'OH', // Omaheke
        '36' => 'OS', // Omusati
        '37' => 'ON', // Oshana
        '38' => 'OT', // Oshikoto
        '39' => 'OD', // Otjozondjupa

        // invalid codes  [used by maxmind]
        '01' => 'KA', // Bethanien  [city in Karas]
        '02' => '', // Caprivi Oos  [old region, not mappable]
        '03' => '', // Boesmanland  [old region, not mappable]
        '04' => 'OH', // Gobabis  [capital of Omaheke]
        '05' => 'OD', // Grootfontein  [city in Otjozondjupa]
        '06' => 'KU', // Kaokoland  [now part of Kunene]
        '07' => 'ER', // Karibib  [city in Erongo]
        '08' => 'KA', // Keetmanshoop  [city in Karas]
        '09' => 'KA', // Luderitz  [city in Karas]
        '10' => 'HA', // Maltahohe  [city in Hardap]
        '11' => 'OD', // Okahandja  [city in Otjozondjupa]
        '12' => 'ER', // Omaruru  [city in Erongo]
        '13' => 'OD', // Otjiwarongo  [capital in Otjozondjupa]
        '14' => 'KU', // Outjo  [city in Kunene]
        '15' => '', // Owambo  [old region, not mappable]
        '16' => 'HA', // Rehoboth  [city in Hardap]
        '17' => 'ER', // Swakopmund  [city in Erongo]
        '18' => 'OT', // Tsumeb  [city in Oshikoto]
        '20' => 'KA', // Karasburg  [city in Karas]
        '22' => '', // Damaraland  [old region, not mappable]
        '23' => '', // Hereroland Oos  [old region, not mappable]
        '24' => '', // Hereroland Wes  [old region, not mappable]
        '25' => '', // Kavango  [now splitted in East and West]
        '26' => 'HA', // Mariental  [city in Hardap]
        '27' => '', // Namaland  [old region, not mappable]
    ],
    'NE' => [
        '01' => '1',
        '02' => '2',
        '03' => '3',
        '04' => '4',
        '06' => '5',
        '07' => '7',
        '08' => '8',

        // valid codes  [not used by maxmind]
        '09' => '6',

        // invalid codes  [not used by maxmind]
        '05' => '8',
    ],
    'NG' => [
        '05' => 'LA', // Lagos
        '11' => 'FC', // Federal Capital Territory
        '16' => 'OG', // Ogun
        '21' => 'AK', // Akwa Ibom
        '22' => 'CR', // Cross River
        '23' => 'KD', // Kaduna
        '24' => 'KT', // Katsina
        '25' => 'AN', // Anambra
        '26' => 'BE', // Benue
        '27' => 'BO', // Borno
        '28' => 'IM', // Imo
        '29' => 'KN', // Kano
        '30' => 'KW', // Kwara
        '31' => 'NI', // Niger
        '32' => 'OY', // Oyo
        '35' => 'AD', // Adamawa
        '36' => 'DE', // Delta
        '37' => 'ED', // Edo
        '39' => 'JI', // Jigawa
        '40' => 'KE', // Kebbi
        '41' => 'KO', // Kogi
        '42' => 'OS', // Osun
        '43' => 'TA', // Taraba
        '44' => 'YO', // Yobe
        '45' => 'AB', // Abia
        '46' => 'BA', // Bauchi
        '47' => 'EN', // Enugu
        '48' => 'ON', // Ondo
        '49' => 'PL', // Plateau
        '50' => 'RI', // Rivers
        '51' => 'SO', // Sokoto
        '52' => 'BY', // Bayelsa
        '53' => 'EB', // Ebonyi
        '54' => 'EK', // Ekiti
        '55' => 'GO', // Gombe
        '56' => 'NA', // Nassarawa
        '57' => 'ZA', // Zamfara
    ],
    'NI' => [
        '01' => 'BO',
        '02' => 'CA',
        '03' => 'CI',
        '04' => 'CO',
        '05' => 'ES',
        '06' => 'GR',
        '07' => 'JI',
        '08' => 'LE',
        '09' => 'MD',
        '10' => 'MN',
        '11' => 'MS',
        '12' => 'MT',
        '13' => 'NS',
        '14' => 'SJ',
        '15' => 'RI',
        '17' => 'AN',
        '18' => 'AS',

        // invalid codes  [used by maxmind]
        '16' => '', // Zelaya
    ],
    'NL' => [
        '01' => 'DR',
        '02' => 'FR',
        '03' => 'GE',
        '04' => 'GR',
        '05' => 'LI',
        '06' => 'NB',
        '07' => 'NH',
        '09' => 'UT',
        '10' => 'ZE',
        '11' => 'ZH',
        '15' => 'OV',
        '16' => 'FL',
    ],
    'NO' => [
        '01' => '02',
        '02' => '09',
        '04' => '06',
        '05' => '20',
        '06' => '04',
        '07' => '12',
        '08' => '15',
        '09' => '18',
        '10' => '17',
        '11' => '05',
        '12' => '03',
        '13' => '01',
        '14' => '11',
        '15' => '14',
        '16' => '16',
        '17' => '08',
        '18' => '19',
        '19' => '10',
        '20' => '07',
    ],
    'NP' => [
        '01' => 'BA', // Bagmati
        '02' => 'BH', // Bheri
        '03' => 'DH', // Dhawalagiri
        '04' => 'GA', // Gandaki
        '05' => 'JA', // Janakpur
        '06' => 'KA', // Karnali
        '07' => 'KO', // Kosi
        '08' => 'LU', // Lumbini
        '09' => 'MA', // Mahakali
        '10' => 'ME', // Mechi
        '11' => 'NA', // Narayani
        '12' => 'RA', // Rapti
        '13' => 'SA', // Sagarmatha
        '14' => 'SE', // Seti
    ],
    'NR' => [
        '01' => '01',
        '02' => '02',
        '03' => '03',
        '04' => '04',
        '05' => '05',
        '06' => '06',
        '07' => '07',
        '08' => '08',
        '09' => '09',
        '10' => '10',
        '11' => '11',
        '12' => '12',
        '13' => '13',
        '14' => '14',
    ],
    'NZ' => [
        '10' => 'CIT',
        'E7' => 'AUK',
        'E8' => 'BOP',
        'E9' => 'CAN',
        'F1' => 'GIS',
        'F2' => 'HKB',
        'F3' => 'MWT',
        'F4' => 'MBH',
        'F5' => 'NSN',
        'F6' => 'NTL',
        'F7' => 'OTA',
        'F8' => 'STL',
        'F9' => 'TKI',
        'G1' => 'WKO',
        'G2' => 'WGN',
        'G3' => 'WTC',
    ],
    'OM' => [
        '01' => 'DA', // Ad Dakhiliyah
        '02' => '', // Al Batinah  [splitted in two]
        '03' => 'WU', // Al Wusta
        '04' => '', // Ash Sharqiyah
        '06' => 'MA', // Masqat  [splitted in two]
        '07' => 'MU', // Musandam
        '08' => 'ZU', // Zufar

        // valid codes  [not used by maxmind]
        '09' => 'ZA', // Ad Dhahirah
        '10' => 'BU', // Al Buraimi

        // invalid codes  [used by maxmind]
        '05' => 'ZA', // Az Zahirah
    ],
    'PA' => [
        '01' => '1',
        '02' => '4',
        '03' => '2',
        '04' => '3',
        '05' => '5',
        '06' => '6',
        '07' => '7',
        '08' => '8',
        '09' => 'KY',
        '10' => '9',
    ],
    'PE' => [
        '01' => 'AMA',
        '02' => 'ANC',
        '03' => 'APU',
        '04' => 'ARE',
        '05' => 'AYA',
        '06' => 'CAJ',
        '07' => 'CAL',
        '08' => 'CUS',
        '09' => 'HUV',
        '10' => 'HUC',
        '11' => 'ICA',
        '12' => 'JUN',
        '13' => 'LAL',
        '14' => 'LAM',
        '15' => 'LIM',
        '16' => 'LOR',
        '17' => 'MDD',
        '18' => 'MOQ',
        '19' => 'PAS',
        '20' => 'PIU',
        '21' => 'PUN',
        '22' => 'SAM',
        '23' => 'TAC',
        '24' => 'TUM',
        '25' => 'UCA',
    ],
    'PG' => [
        '01' => 'CPM',
        '02' => 'GPK',
        '03' => 'MBA',
        '04' => 'NPP',
        '05' => 'SHM',
        '06' => 'WPD',
        '07' => 'NSB',
        '08' => 'CPK',
        '09' => 'EHG',
        '10' => 'EBR',
        '11' => 'ESW',
        '12' => 'MPM',
        '13' => 'MRL',
        '14' => 'MPL',
        '15' => 'NIK',
        '16' => 'WHM',
        '17' => 'WBK',
        '18' => 'SAN',
        '19' => 'EPW',
        '20' => 'NCD',
    ],
    'PH' => [
        '01' => 'ABR', // Abra
        '02' => 'AGN', // Agusan del Norte
        '03' => 'AGS', // Agusan del Sur
        '04' => 'AKL', // Aklan
        '05' => 'ALB', // Albay
        '06' => 'ANT', // Antique
        '07' => 'BAN', // Bataan
        '08' => 'BTN', // Batanes
        '09' => 'BTG', // Batangas
        '10' => 'BEN', // Benguet
        '11' => 'BOH', // Bohol
        '12' => 'BUK', // Bukidnon
        '13' => 'BUL', // Bulacan
        '14' => 'CAG', // Cagayan
        '15' => 'CAN', // Camarines Norte
        '16' => 'CAS', // Camarines Sur
        '17' => 'CAM', // Camiguin
        '18' => 'CAP', // Capiz
        '19' => 'CAT', // Catanduanes
        '20' => 'CAV', // Cavite
        '21' => 'CEB', // Cebu
        '22' => 'BAS', // Basilan
        '23' => 'EAS', // Eastern Samar
        '24' => 'DAV', // Davao
        '25' => 'DAS', // Davao del Sur
        '26' => 'DAO', // Davao Oriental
        '27' => 'IFU', // Ifugao
        '28' => 'ILN', // Ilocos Norte
        '29' => 'ILS', // Ilocos Sur
        '30' => 'ILI', // Iloilo
        '31' => 'ISA', // Isabela
        '32' => '', // Kalinga-Apayao  [splitted in two]
        '33' => 'LAG', // Laguna
        '34' => 'LAN', // Lanao del Norte
        '35' => 'LAS', // Lanao del Sur
        '36' => 'LUN', // La Union
        '37' => 'LEY', // Leyte
        '38' => 'MAD', // Marinduque
        '39' => 'MAS', // Masbate
        '40' => 'MDC', // Mindoro Occidental
        '41' => 'MDR', // Mindoro Oriental
        '42' => 'MSC', // Misamis Occidental
        '43' => 'MSR', // Misamis Oriental
        '44' => 'MOU', // Mountain
        '45' => 'NEC', // Negros Occidental
        '46' => 'NER', // Negros Oriental
        '47' => 'NUE', // Nueva Ecija
        '48' => 'NUV', // Nueva Vizcaya
        '49' => 'PLW', // Palawan
        '50' => 'PAM', // Pampanga
        '51' => 'PAN', // Pangasinan
        '53' => 'RIZ', // Rizal
        '54' => 'ROM', // Romblon
        '55' => 'WSA', // Samar
        '56' => 'MAG', // Maguindanao
        '57' => 'NCO', // North Cotabato
        '58' => 'SOR', // Sorsogon
        '59' => 'SLE', // Southern Leyte
        '60' => 'SLU', // Sulu
        '61' => 'SUN', // Surigao del Norte
        '62' => 'SUR', // Surigao del Sur
        '63' => 'TAR', // Tarlac
        '64' => 'ZMB', // Zambales
        '65' => 'ZAN', // Zamboanga del Norte
        '66' => 'ZAS', // Zamboanga del Sur
        '67' => 'NSA', // Northern Samar
        '68' => 'QUI', // Quirino
        '69' => 'SIG', // Siquijor
        '70' => 'SCO', // South Cotabato
        '71' => 'SUK', // Sultan Kudarat
        '72' => 'TAW', // Tawitawi
        'A1' => 'PAM', // Angeles  [city in Pamganga]
        'A2' => 'NEC', // Bacolod  [city in Negros Occidental]
        'A3' => 'NEC', // Bago  [city in Negros Occidental]
        'A4' => 'BEN', // Baguio  [city in Benguet]
        'A5' => 'NER', // Bais  [city in Negros Oriental]
        'A6' => '09', // Basilan City  [city in Zamboanga Peninsula]
        'A7' => 'BTG', // Batangas City  [capital of Batangas]
        'A8' => 'AGN', // Butuan  [city in Agusan del Norte]
        'A9' => 'NUE', // Cabanatuan  [city in Nueva Ecija]
        'B1' => 'NEC', // Cadiz  [city in Negros Occidental]
        'B2' => 'MSR', // Cagayan de Oro  [city in Misamis Oriental]
        'B3' => 'WSA', // Calbayog  [city in Samar]
        'B4' => '00', // Caloocan  [part of National Capital Region]
        'B5' => 'NER', // Canlaon  [city in Negros Oriental]
        'B6' => 'CAV', // Cavite City  [capital of Cavite]
        'B7' => 'CEB', // Cebu City  [capital of Cebu]
        'B8' => 'MAG', // Cotabato  [city in Maguindanao]
        'B9' => 'PAN', // Dagupan  [city in Pangasinan]
        'C1' => 'CEB', // Danao  [city in Cebu]
        'C2' => 'ZAN', // Dapitan  [city in Zamboanga del Norte]
        'C3' => 'DAS', // Davao City  [city in Davao del Sur]
        'C4' => 'ZAN', // Dipolog  [city in Zamboanga del Norte]
        'C5' => 'NER', // Dumaguete  [city in Negros Oriental]
        'C6' => 'SCO', // General Santos  [city in South Cotabato]
        'C7' => 'MSR', // Gingoog  [city in Misamis Oriental]
        'C8' => 'LAN', // Iligan  [city in Lanao del Norte]
        'C9' => 'ILI', // Iloilo City  [capital of Iloilo]
        'D1' => 'CAS', // Iriga  [city in Camarines Sur]
        'D2' => 'NEC', // La Carlota  [city in Negros Occidental]
        'D3' => 'ILN', // Laoag  [city in Ilocos Norte]
        'D4' => 'CEB', // Lapu-Lapu  [city in Cebu]
        'D5' => 'ALB', // Legaspi  [city in Albay]
        'D6' => 'BTG', // Lipa  [city in Batangas]
        'D7' => 'QUE', // Lucena  [city in Quezon]
        'D8' => 'CEB', // Mandaue  [city in Cebu]
        'D9' => '00', // Manila  [part of National Capital Region]
        'E1' => 'LAS', // Marawi  [city in Lanao del Sur]
        'E2' => 'CAS', // Naga  [city in Camarines Sur]
        'E3' => 'ZMB', // Olongapo  [city in Zambales]
        'E4' => 'LEY', // Ormoc  [city in Leyte]
        'E5' => 'MSC', // Oroquieta  [city in Misamis Occidental]
        'E6' => 'MSC', // Ozamis  [city in Misamis Occidental]
        'E7' => 'ZAS', // Pagadian  [city in Zamboanga del Sur]
        'E8' => 'NUE', // Palayan  [city in Nueva Ecija]
        'E9' => '00', // Pasay  [part of National Capital Region]
        'F1' => 'PLW', // Puerto Princesa  [city in Palawan]
        'F2' => '00', // Quezon City  [part of National Capital Region]
        'F3' => 'CAP', // Roxas  [city in Capiz]
        'F4' => 'NEC', // San Carlos  [city in Negros Occidental]
        'F5' => 'PAN', // San Carlos  [city in Pangasinan]
        'F6' => 'NUE', // San Jose  [city in Nueva Ecija]
        'F7' => 'LAG', // San Pablo  [city in Laguna]
        'F8' => 'NEC', // Silay  [city in Negros Occidental]
        'F9' => 'SUN', // Surigao  [city in Surigao del Norte]
        'G1' => 'LEY', // Tacloban  [city in Leyte]
        'G2' => 'CAV', // Tagaytay  [city in Cavite]
        'G3' => 'BOH', // Tagbilaran  [city in Bohol]
        'G4' => 'MSC', // Tangub  [city in Misamis Occidental]
        'G5' => 'CEB', // Toledo  [city in Cebu]
        'G6' => 'CAV', // Trece Martires  [city in Cavite]
        'G7' => 'ZAS', // Zamboanga  [city in Zamboanga del Sur]
        'G8' => 'AUR', // Aurora
        'H2' => 'QUE', // Quezon
        'H3' => 'NEC', // Negros Occidental

        // invalid codes  [used by maxmind]
        'H9' => 'BIL', // Biliran
        'I6' => 'COM', // Compostela Valley
        'I7' => 'DAV', // Davao del Norte
        'J3' => 'GUI', // Guimaras
        'J4' => 'NEC', // Himamaylan  [city in Negros Occidental]
        'J7' => 'KAL', // Kalinga
        'K1' => '00', // Las Pinas  [part of National Capital Region]
        'K5' => '00', // Malabon  [part of National Capital Region]
        'K6' => 'BUK', // Malaybalay  [city in Bukidnon]
        'L4' => '00', // Muntinlupa  [part of National Capital Region]
        'L5' => '00', // Navotas  [part of National Capital Region]
        'L7' => '00', // Paranaque  [part of National Capital Region]
        'L9' => '', // Passi
        'P1' => 'ZMB', // Zambales
        'M5' => 'PAM', // San Jose del Monte  [city in Pampanga]
        'M6' => '', // San Juan  [the are many cities with this name]
        'M8' => '', // Santiago  [the are 3 cities with this name]
        'M9' => 'SAR', // Sarangani
        'N1' => 'NEC', // Sipalay  [city in Negros Occidental]
        'N3' => 'SUN', // Surigao del Norte
        'P2' => 'ZAS', // Zamboanga  [city in Zamboanga del Sur]

    ],
    'PK' => [
        '01' => 'TA',
        '02' => 'BA',
        '03' => 'KP',
        '04' => 'PB',
        '05' => 'SD',
        '06' => 'JK',
        '07' => 'GB',
        '08' => 'IS',
    ],
    'PL' => [
        '72' => 'DS',
        '73' => 'KP',
        '74' => 'LD',
        '75' => 'LU',
        '76' => 'LB',
        '77' => 'MA',
        '78' => 'MZ',
        '79' => 'OP',
        '80' => 'PK',
        '81' => 'PD',
        '82' => 'PM',
        '83' => 'SL',
        '84' => 'SK',
        '85' => 'WN',
        '86' => 'WP',
        '87' => 'ZP',
    ],
    'PS' => [
        // completely new regions
        'GZ' => '', // Gaza
        'WE' => '', // West Bank
    ],
    'PT' => [
        '02' => '01',
        '03' => '02',
        '04' => '03',
        '05' => '04',
        '06' => '05',
        '07' => '06',
        '08' => '07',
        '09' => '08',
        '10' => '30',
        '11' => '09',
        '13' => '10',
        '14' => '11',
        '16' => '12',
        '17' => '13',
        '18' => '14',
        '19' => '15',
        '20' => '16',
        '21' => '17',
        '22' => '18',
        '23' => '20',
    ],
    'PY' => [
        '01' => '10',
        '02' => '13',
        '04' => '5',
        '05' => '6',
        '06' => '11',
        '07' => '1',
        '08' => '3',
        '10' => '4',
        '11' => '7',
        '12' => '8',
        '13' => '12',
        '15' => '9',
        '16' => '15',
        '17' => '2',
        '19' => '14',
        '22' => 'ASU',
        '23' => '16',
        '24' => '19',
    ],
    'QA' => [
        '01' => 'DA', // Ad Dawhah
        '02' => 'KH', // Al Ghuwariyah  [city in Al Khawr]
        '03' => 'SH', // Al Jumaliyah  [city in Ash Shīḩānīyah]
        '04' => 'KH', // Al Khawr
        '06' => 'RA', // Ar Rayyan
        '08' => 'MS', // Madinat ach Shamal
        '09' => 'US', // Umm Salal
        '10' => 'WA', // Al Wakrah
        '11' => '', // Jariyan al Batnah  [split into two]
        '12' => 'WA', // Umm Sa'id  [city in Al Wakrah]

        // invalid codes  [used by maxmind]
        '05' => 'WA', // Al Wakrah Municipality
    ],
    'RO' => [
        '01' => 'AB',
        '02' => 'AR',
        '03' => 'AG',
        '04' => 'BC',
        '05' => 'BH',
        '06' => 'BN',
        '07' => 'BT',
        '08' => 'BR',
        '09' => 'BV',
        '10' => 'B',
        '11' => 'BZ',
        '12' => 'CS',
        '13' => 'CJ',
        '14' => 'CT',
        '15' => 'CV',
        '16' => 'DB',
        '17' => 'DJ',
        '18' => 'GL',
        '19' => 'GJ',
        '20' => 'HR',
        '21' => 'HD',
        '22' => 'IL',
        '23' => 'IS',
        '25' => 'MM',
        '26' => 'MH',
        '27' => 'MS',
        '28' => 'NT',
        '29' => 'OT',
        '30' => 'PH',
        '31' => 'SJ',
        '32' => 'SM',
        '33' => 'SB',
        '34' => 'SV',
        '35' => 'TR',
        '36' => 'TM',
        '37' => 'TL',
        '38' => 'VS',
        '39' => 'VL',
        '40' => 'VN',
        '41' => 'CL',
        '42' => 'GR',
        '43' => 'IF',
    ],
    'RS' => [
        '01' => 'KM', // Kosovo
        '02' => 'VO', // Vojvodina
    ],
    'RU' => [
        '01' => 'AD',
        '02' => 'ZAB', // Aginsky Buryatsky AO  [part of Zabaykal'skiy kray]
        '03' => 'AL',
        '04' => 'ALT',
        '05' => 'AMU',
        '06' => 'ARK',
        '07' => 'AST',
        '08' => 'BA',
        '09' => 'BEL',
        '10' => 'BRY',
        '11' => 'BU',
        '12' => 'CE',
        '13' => 'CHE',
        '14' => 'ZAB', // Chita  [part of Zabaykal'skiy kray]
        '15' => 'CHU',
        '16' => 'CU',
        '17' => 'DA',
        '19' => 'IN',
        '20' => 'IRK',
        '21' => 'IVA',
        '22' => 'KB',
        '23' => 'KGD',
        '24' => 'KL',
        '25' => 'KLU',
        '27' => 'KC',
        '28' => 'KR',
        '29' => 'KEM',
        '30' => 'KHA',
        '31' => 'KK',
        '32' => 'KHM',
        '33' => 'KIR',
        '34' => 'KO',
        '37' => 'KOS',
        '38' => 'KDA',
        '40' => 'KGN',
        '41' => 'KRS',
        '42' => 'LEN',
        '43' => 'LIP',
        '44' => 'MAG',
        '45' => 'ME',
        '46' => 'MO',
        '47' => 'MOS',
        '48' => 'MOW',
        '49' => 'MUR',
        '50' => 'NEN',
        '51' => 'NIZ',
        '52' => 'NGR',
        '53' => 'NVS',
        '54' => 'OMS',
        '55' => 'ORE',
        '56' => 'ORL',
        '57' => 'PNZ',
        '59' => 'PRI',
        '60' => 'PSK',
        '61' => 'ROS',
        '62' => 'RYA',
        '63' => 'SA',
        '64' => 'SAK',
        '65' => 'SAM',
        '66' => 'SPE',
        '67' => 'SAR',
        '68' => 'SE',
        '69' => 'SMO',
        '70' => 'STA',
        '71' => 'SVE',
        '72' => 'TAM',
        '73' => 'TA',
        '74' => 'KYA', // Taymyr  [part of Krasnoyarsk Krai]
        '75' => 'TOM',
        '76' => 'TUL',
        '77' => 'TVE',
        '78' => 'TYU',
        '79' => 'TY',
        '80' => 'UD',
        '81' => 'ULY',
        '83' => 'VLA',
        '84' => 'VGG',
        '85' => 'VLG',
        '86' => 'VOR',
        '87' => 'YAN',
        '88' => 'YAR',
        '89' => 'YEV',
        '90' => 'PER',
        '91' => 'KYA',
        '92' => 'KAM',

        // valid codes  [not used by maxmind]
        '82' => 'IRK', // Ust'-Ordynskiy Buryatskiy [part of  Irkutsk Oblast]

        // invalid codes  [used by maymind]
        '18' => 'KYA', // Evenk  [part of Krasnoyarsk Krai]
        '26' => 'KAM', // Kamchatka
        '36' => 'KAM', // Koryak  [part of Kamchatka Krai]
        '39' => 'KYA', // Krasnoyarsk
        '58' => 'PER', // Perm
        '93' => 'ZAB', // Zabaykal'skiy Kray
    ],
    'RW' => [
        '11' => '02', // Est
        '12' => '01', // Kigali
        '13' => '03', // Nord
        '14' => '04', // Ouest
        '15' => '05', // Sud

        // invalid codes  [used by maxmind]
        '01' => '05', // Butare  [city in Southern]
        '06' => '05', // Gitarama  [city in Southern]
        '07' => '02', // Kibungo  [city in Eastern]
        '09' => '01', // Kigali
    ],
    'SA' => [
        '02' => '11',
        '05' => '03',
        '06' => '04',
        '08' => '05',
        '10' => '01',
        '11' => '14',
        '13' => '06',
        '14' => '02',
        '15' => '08',
        '16' => '10',
        '17' => '09',
        '19' => '07',
        '20' => '12',
    ],
    'SB' => [
        '03' => 'ML',
        '06' => 'GU',
        '07' => 'IS',
        '08' => 'MK',
        '09' => 'TE',
        '10' => 'CE',
        '11' => 'WE',
        '12' => 'CH',
        '13' => 'RB',
    ],
    'SC' => [
        '01' => '01', // Anse aux Pins
        '02' => '02', // Anse Boileau
        '03' => '03', // Anse Etoile
        '05' => '05', // Anse Royale
        '06' => '06', // Baie Lazare
        '07' => '07', // Baie Sainte Anne
        '08' => '08', // Beau Vallon
        '09' => '09', // Bel Air
        '10' => '10', // Bel Ombre
        '11' => '11', // Cascade
        '12' => '12', // Glacis
        '14' => '14', // Grand' Anse
        '17' => '17', // Mont Buxton
        '18' => '18', // Mont Fleuri
        '19' => '19', // Plaisance
        '20' => '20', // Pointe La Rue
        '22' => '22', // Saint Louis
        '23' => '23', // Takamaka

        // valid codes  [not used by maxmind
        '24' => '13',
        '25' => '15',
        '26' => '16',
        '27' => '21',
        '28' => '04',
        '29' => '24',
        '30' => '25',

        // invalid codes  [used by maxmind]
        '04' => '04', // Anse Louis
        '13' => '14', // Grand' Anse
        '15' => '15', // La Digue
        '16' => '16', // La Riviere Anglaise
        '21' => '21', // Port Glaud
    ],
    'SD' => [
        '29' => 'KH', // Al Khartum
        '35' => '', // Upper Nile  [reorganized, not mappable]
        '40' => '', // Al Wahadah State  [reorganized, not mappable]
        '44' => '', // Central Equatoria State  [reorganized, not mappable]
        '49' => 'DS', // Southern Darfur
        '50' => 'KS', // Southern Kordofan
        '52' => 'KA', // Kassala
        '53' => 'NR', // River Nile
        '55' => 'DN', // Northern Darfur

        // valid codes  [not used by maxmind]
        '36' => 'RS',
        '37' => '', //  [reorganized, not mappable]
        '38' => 'GZ',
        '39' => 'GD',
        '41' => 'NW',
        '42' => 'NB',
        '43' => 'NO',
        '45' => '', //  [reorganized, not mappable]
        '46' => '', //  [reorganized, not mappable]
        '47' => 'DW',
        '48' => 'GK',
        '51' => '', //  [reorganized, not mappable]
        '54' => '', //  [reorganized, not mappable]
        '56' => 'KN',
        '57' => '', //  [reorganized, not mappable]
        '58' => 'SI',
        '59' => '', //  [reorganized, not mappable]

        // invalid codes  [used by maxmind]
        '27' => '', // Al Wusta
        '28' => '', // Al Istiwa'iyah
        '30' => 'NO', // Ash Shamaliyah
        '31' => '', // Ash Sharqiyah
        '32' => '', // Bahr al Ghazal
        '33' => 'DW', // Darfur
        '34' => 'GK', // Kurdufan
    ],
    'SE' => [
        '02' => 'K',
        '03' => 'X',
        '05' => 'I',
        '06' => 'N',
        '07' => 'Z',
        '08' => 'F',
        '09' => 'H',
        '10' => 'W',
        '12' => 'G',
        '14' => 'BD',
        '15' => 'T',
        '16' => 'E',
        '18' => 'D',
        '21' => 'C',
        '22' => 'S',
        '23' => 'AC',
        '24' => 'Y',
        '25' => 'U',
        '26' => 'AB',
        '27' => 'M',
        '28' => 'O',
    ],
    'SH' => [
        '01' => 'AC',
        '02' => 'HL',
        '03' => 'TA',
    ],
    'SI' => [
        '01' => '001', // Ajdovscina Commune
        '02' => '002', // Beltinci Commune
        '03' => '003', // Bled Commune
        '04' => '004', // Bohinj Commune
        '05' => '005', // Borovnica Commune
        '06' => '006', // Bovec Commune
        '07' => '007', // Brda Commune
        '08' => '009', // Brezice Commune
        '09' => '008', // Brezovica Commune
        '11' => '011', // Celje Commune
        '12' => '012', // Cerklje na Gorenjskem Commune
        '13' => '013', // Cerknica Commune
        '14' => '014', // Cerkno Commune
        '15' => '015', // Crensovci Commune
        '16' => '016', // Crna na Koroskem Commune
        '17' => '017', // Crnomelj Commune
        '19' => '019', // Divaca Commune
        '20' => '020', // Dobrepolje Commune
        '22' => '022', // Dol pri Ljubljani Commune
        '24' => '024', // Dornava Commune
        '25' => '025', // Dravograd Commune
        '26' => '026', // Duplek Commune
        '27' => '027', // Gorenja vas-Poljane Commune
        '28' => '028', // Gorisnica Commune
        '29' => '029', // Gornja Radgona Commune
        '30' => '030', // Gornji Grad Commune
        '31' => '031', // Gornji Petrovci Commune
        '32' => '032', // Grosuplje Commune
        '34' => '034', // Hrastnik Commune
        '35' => '035', // Hrpelje-Kozina Commune
        '36' => '036', // Idrija Commune
        '37' => '037', // Ig Commune
        '38' => '038', // Ilirska Bistrica Commune
        '39' => '039', // Ivancna Gorica Commune
        '40' => '040', // Izola-Isola Commune
        '42' => '042', // Jursinci Commune
        '44' => '044', // Kanal Commune
        '45' => '045', // Kidricevo Commune
        '46' => '046', // Kobarid Commune
        '47' => '047', // Kobilje Commune
        '49' => '049', // Komen Commune
        '50' => '050', // Koper-Capodistria Urban Commune
        '51' => '051', // Kozje Commune
        '52' => '052', // Kranj Commune
        '53' => '053', // Kranjska Gora Commune
        '54' => '054', // Krsko Commune
        '55' => '055', // Kungota Commune
        '57' => '057', // Lasko Commune
        '61' => '061', // Ljubljana Urban Commune
        '62' => '062', // Ljubno Commune
        '64' => '064', // Logatec Commune
        '66' => '066', // Loski Potok Commune
        '68' => '068', // Lukovica Commune
        '71' => '071', // Medvode Commune
        '72' => '072', // Menges Commune
        '73' => '073', // Metlika Commune
        '74' => '074', // Mezica Commune
        '76' => '076', // Mislinja Commune
        '77' => '077', // Moravce Commune
        '78' => '078', // Moravske Toplice Commune
        '79' => '079', // Mozirje Commune
        '80' => '080', // Murska Sobota Urban Commune
        '81' => '081', // Muta Commune
        '82' => '082', // Naklo Commune
        '83' => '083', // Nazarje Commune
        '84' => '084', // Nova Gorica Urban Commune
        '86' => '086', // Odranci Commune
        '87' => '087', // Ormoz Commune
        '88' => '088', // Osilnica Commune
        '89' => '089', // Pesnica Commune
        '91' => '091', // Pivka Commune
        '92' => '092', // Podcetrtek Commune
        '94' => '094', // Postojna Commune
        '97' => '097', // Puconci Commune
        '98' => '098', // Race-Fram Commune
        '99' => '099', // Radece Commune
        'A1' => '100', // Radenci Commune
        'A2' => '101', // Radlje ob Dravi Commune
        'A3' => '102', // Radovljica Commune
        'A6' => '105', // Rogasovci Commune
        'A7' => '106', // Rogaska Slatina Commune
        'A8' => '107', // Rogatec Commune
        'B1' => '109', // Semic Commune
        'B2' => '117', // Sencur Commune
        'B3' => '118', // Sentilj Commune
        'B4' => '119', // Sentjernej Commune
        'B6' => '110', // Sevnica Commune
        'B7' => '111', // Sezana Commune
        'B8' => '121', // Skocjan Commune
        'B9' => '122', // Skofja Loka Commune
        'C1' => '123', // Skofljica Commune
        'C2' => '112', // Slovenj Gradec Urban Commune
        'C4' => '114', // Slovenske Konjice Commune
        'C5' => '124', // Smarje pri Jelsah Commune
        'C6' => '125', // Smartno ob Paki Commune
        'C7' => '126', // Sostanj Commune
        'C8' => '115', // Starse Commune
        'C9' => '127', // Store Commune
        'D1' => '210', // Sveti Jurij Commune
        'D2' => '128', // Tolmin Commune
        'D3' => '129', // Trbovlje Commune
        'D4' => '130', // Trebnje Commune
        'D5' => '131', // Trzic Commune
        'D6' => '132', // Turnisce Commune
        'D7' => '133', // Velenje Urban Commune
        'D8' => '134', // Velike Lasce Commune
        'E1' => '136', // Vipava Commune
        'E2' => '137', // Vitanje Commune
        'E3' => '138', // Vodice Commune
        'E5' => '140', // Vrhnika Commune
        'E6' => '141', // Vuzenica Commune
        'E7' => '142', // Zagorje ob Savi Commune
        'E9' => '143', // Zavrc Commune
        'F1' => '146', // Zelezniki Commune
        'F2' => '147', // Ziri Commune
        'F3' => '144', // Zrece Commune
        'F4' => '148', // Benedikt Commune
        'F5' => '149', // Bistrica ob Sotli Commune
        'F6' => '150', // Bloke Commune
        'F7' => '151', // Braslovce Commune
        'F8' => '152', // Cankova Commune
        'F9' => '153', // Cerkvenjak Commune
        'G1' => '018', // Destrnik Commune
        'G2' => '154', // Dobje Commune
        'G3' => '155', // Dobrna Commune
        'G4' => '021', // Dobrova-Horjul-Polhov Gradec Commune
        'G5' => '156', // Dobrovnik-Dobronak Commune
        'G6' => '157', // Dolenjske Toplice Commune
        'G7' => '023', // Domzale Commune
        'G8' => '158', // Grad Commune
        'G9' => '159', // Hajdina Commune
        'H1' => '160', // Hoce-Slivnica Commune
        'H2' => '161', // Hodos-Hodos Commune
        'H3' => '162', // Horjul Commune
        'H4' => '041', // Jesenice Commune
        'H5' => '163', // Jezersko Commune
        'H6' => '043', // Kamnik Commune
        'H7' => '048', // Kocevje Commune
        'H8' => '164', // Komenda Commune
        'H9' => '165', // Kostel Commune
        'I1' => '166', // Krizevci Commune
        'I2' => '056', // Kuzma Commune
        'I3' => '058', // Lenart Commune
        'I4' => '059', // Lendava-Lendva Commune
        'I5' => '060', // Litija Commune
        'I6' => '063', // Ljutomer Commune
        'I7' => '065', // Loska Dolina Commune
        'I8' => '167', // Lovrenc na Pohorju Commune
        'I9' => '067', // Luce Commune
        'J1' => '069', // Majsperk Commune
        'J2' => '070', // Maribor Commune
        'J3' => '168', // Markovci Commune
        'J4' => '169', // Miklavz na Dravskem polju Commune
        'J5' => '075', // Miren-Kostanjevica Commune
        'J6' => '170', // Mirna Pec Commune
        'J7' => '085', // Novo mesto Urban Commune
        'J8' => '171', // Oplotnica Commune
        'J9' => '090', // Piran-Pirano Commune
        'K1' => '172', // Podlehnik Commune
        'K2' => '093', // Podvelka Commune
        'K3' => '173', // Polzela Commune
        'K4' => '174', // Prebold Commune
        'K5' => '095', // Preddvor Commune
        'K6' => '175', // Prevalje Commune
        'K7' => '096', // Ptuj Urban Commune
        'K8' => '103', // Ravne na Koroskem Commune
        'K9' => '176', // Razkrizje Commune
        'L1' => '104', // Ribnica Commune
        'L2' => '177', // Ribnica na Pohorju Commune
        'L3' => '108', // Ruse Commune
        'L4' => '033', // Salovci Commune
        'L5' => '178', // Selnica ob Dravi Commune
        'L6' => '183', // Sempeter-Vrtojba Commune
        'L7' => '120', // Sentjur pri Celju Commune
        'L8' => '113', // Slovenska Bistrica Commune
        'L9' => '194', // Smartno pri Litiji Commune
        'M1' => '179', // Sodrazica Commune
        'M2' => '180', // Solcava Commune
        'M3' => '181', // Sveta Ana Commune
        'M4' => '182', // Sveti Andraz v Slovenskih goricah Commune
        'M5' => '184', // Tabor Commune
        'M6' => '010', // Tisina Commune
        'M7' => '185', // Trnovska vas Commune
        'M8' => '186', // Trzin Commune
        'M9' => '187', // Velika Polana Commune
        'N1' => '188', // Verzej Commune
        'N2' => '135', // Videm Commune
        'N3' => '139', // Vojnik Commune
        'N4' => '189', // Vransko Commune
        'N5' => '190', // Zalec Commune
        'N6' => '191', // Zetale Commune
        'N7' => '192', // Zirovnica Commune
        'N8' => '193', // Zuzemberk Commune

        // invalid codes  [used by maxmind]
        'N9' => '195', // Apace Commune
        'O1' => '196', // Cirkulane Commune
        'O2' => '207', // Gorje
        'O3' => '197', // Kostanjevica na Krki
        'O4' => '208', // Log-Dragomer
        'O5' => '198', // Makole
        'O6' => '212', // Mirna
        'O7' => '199', // Mokronog-Trebelno
        'O8' => '200', // Poljcane
        'O9' => '209', // Recica ob Savinji
        'P1' => '201', // Rence-Vogrsko
        'P2' => '211', // Sentrupert
        'P3' => '206', // Smarjesk Toplice
        'P4' => '202', // Sredisce ob Dravi
        'P5' => '203', // Straza
        'P7' => '210', // Sveti Jurij v Slovenskih Goricah
    ],
    'SK' => [
        '01' => 'BC',
        '02' => 'BL',
        '03' => 'KI',
        '04' => 'NI',
        '05' => 'PV',
        '06' => 'TC',
        '07' => 'TA',
        '08' => 'ZI',
    ],
    'SL' => [
        '01' => 'E',
        '02' => 'N',
        '03' => 'S',
        '04' => 'W',
    ],
    'SM' => [
        '01' => '01',
        '02' => '02',
        '03' => '03',
        '04' => '04',
        '05' => '05',
        '06' => '06',
        '07' => '07',
        '08' => '08',
        '09' => '09',
    ],
    'SN' => [
        '01' => 'DK',
        '03' => 'DB',
        '05' => 'TC',
        '07' => 'TH',
        '09' => 'FK',
        '10' => 'KL',
        '11' => 'KD',
        '12' => 'ZG',
        '13' => 'LG',
        '14' => 'SL',
        '15' => 'MT',
    ],
    'SO' => [
        '01' => 'BK',
        '02' => 'BN',
        '03' => 'BR',
        '04' => 'BY',
        '05' => 'GA',
        '06' => 'GE',
        '07' => 'HI',
        '08' => 'JD',
        '09' => 'JH',
        '10' => 'MU',
        '12' => 'SA',
        '13' => 'SD',
        '14' => 'SH',
        '18' => 'NU',
        '19' => 'TO',
        '20' => 'WO',
        '21' => 'AW',
        '22' => 'SO',

        // invalid codes  [used by maxmind]
        '11' => 'NU',
        '16' => 'WO',
    ],
    'SR' => [
        '10' => 'BR',
        '11' => 'CM',
        '12' => 'CR',
        '13' => 'MA',
        '14' => 'NI',
        '15' => 'PR',
        '16' => 'PM',
        '17' => 'SA',
        '18' => 'SI',
        '19' => 'WA',
    ],
    'SS' => [
        // invalid codes  [used by maxmind]
        '01' => 'EC', // Central Equatoria
        '02' => 'EE', // Eastern Equatoria
        '03' => 'JG', // Jonglei
        '04' => 'LK', // Lakes
        '05' => 'BN', // Northern Bahr el Ghazal
        '06' => 'UY', // Unity
        '07' => 'NU', // Upper Nile
        '08' => 'WR', // Warrap
        '09' => 'BW', // Western Bahr el Ghazal
        '10' => 'EW', // Western Equatoria
    ],
    'ST' => [
        '01' => 'P', // Principe
        '02' => 'S', // Sao Tome
    ],
    'SV' => [
        '01' => 'AH',
        '02' => 'CA',
        '03' => 'CH',
        '04' => 'CU',
        '05' => 'LI',
        '06' => 'PA',
        '07' => 'UN',
        '08' => 'MO',
        '09' => 'SM',
        '10' => 'SS',
        '11' => 'SA',
        '12' => 'SV',
        '13' => 'SO',
        '14' => 'US',
    ],
    'SY' => [
        '01' => 'HA', // Al Hasakah
        '02' => 'LA', // Al Ladhiqiyah
        '03' => 'QU', // Al Qunaytirah
        '04' => 'RA', // Ar Raqqah
        '05' => 'SU', // As Suwayda'
        '06' => 'DR', // Dar
        '07' => 'DY', // Dayr az Zawr
        '08' => 'RD', // Rif Dimashq
        '09' => 'HL', // Halab
        '10' => 'HM', // Hamah
        '11' => 'HI', // Hims
        '12' => 'ID', // Idlib
        '13' => 'DI', // Dimashq
        '14' => 'TA', // Tartus
    ],
    'SZ' => [
        '01' => 'HH',
        '02' => 'LU',
        '03' => 'MA',
        '04' => 'SH',

        // screwed up code, that seems to be from Seychelles
        '05' => '', // Praslin
    ],
    'TD' => [
        '01' => 'BA',
        '02' => 'WF',
        '03' => '', // Borkou-Ennedi-Tibesti  [split up]
        '05' => 'GR',
        '06' => 'KA',
        '07' => 'LC',
        '08' => 'LO',
        '09' => 'LR',
        '12' => 'OD',
        '13' => 'SA',
        '14' => 'TA',

        // invalid codes  [used by maxmind]
        '04' => '', // Chari-Baguirmi  [split up]
        '10' => '', // Mayo-Kebbi  [split into east and west]
        '11' => 'MC', // Moyen-Chari

        // valid codes  [not used by maxmind]
        '15' => '', // Chari-Baguirmi  [split up]
        '16' => 'ME',
        '17' => 'MC',
        '18' => 'HL',
        '19' => 'MA',
        '20' => 'MO',
        '21' => 'ND',
    ],
    'TG' => [
        '22' => 'C',
        '23' => 'K',
        '24' => 'M',
        '25' => 'P',
        '26' => 'S',
    ],
    'TH' => [
        '01' => '58', // Mae Hong Son
        '02' => '50', // Chiang Mai
        '03' => '57', // Chiang Rai
        '04' => '55', // Nan
        '05' => '51', // Lamphun
        '06' => '52', // Lampang
        '07' => '54', // Phrae
        '08' => '63', // Tak
        '09' => '64', // Sukhothai
        '10' => '53', // Uttaradit
        '11' => '62', // Kamphaeng Phet
        '12' => '65', // Phitsanulok
        '13' => '66', // Phichit
        '14' => '67', // Phetchabun
        '15' => '61', // Uthai Thani
        '16' => '60', // Nakhon Sawan
        '17' => '43', // Nong Khai
        '18' => '42', // Loei
        '20' => '47', // Sakon Nakhon
        '22' => '40', // Khon Kaen
        '23' => '46', // Kalasin
        '24' => '44', // Maha Sarakham
        '25' => '45', // Roi Et
        '26' => '36', // Chaiyaphum
        '27' => '30', // Nakhon Ratchasima
        '28' => '31', // Buriram
        '29' => '32', // Surin
        '30' => '33', // Sisaket
        '31' => '96', // Narathiwat
        '32' => '18', // Chai Nat
        '33' => '17', // Sing Buri
        '34' => '16', // Lop Buri
        '35' => '15', // Ang Thong
        '36' => '14', // Phra Nakhon Si Ayutthaya
        '37' => '19', // Saraburi
        '38' => '12', // Nonthaburi
        '39' => '13', // Pathum Thani
        '40' => '10', // Krung Thep
        '41' => '56', // Phayao
        '42' => '11', // Samut Prakan
        '43' => '26', // Nakhon Nayok
        '44' => '24', // Chachoengsao
        '46' => '20', // Chon Buri
        '47' => '21', // Rayong
        '48' => '22', // Chanthaburi
        '49' => '23', // Trat
        '50' => '71', // Kanchanaburi
        '51' => '72', // Suphan Buri
        '52' => '70', // Ratchaburi
        '53' => '73', // Nakhon Pathom
        '54' => '75', // Samut Songkhram
        '55' => '74', // Samut Sakhon
        '56' => '76', // Phetchaburi
        '57' => '77', // Prachuap Khiri Khan
        '58' => '86', // Chumphon
        '59' => '85', // Ranong
        '60' => '84', // Surat Thani
        '61' => '82', // Phangnga
        '62' => '83', // Phuket
        '63' => '81', // Krabi
        '64' => '80', // Nakhon Si Thammarat
        '65' => '92', // Trang
        '66' => '93', // Phatthalung
        '67' => '91', // Satun
        '68' => '90', // Songkhla
        '69' => '94', // Pattani
        '70' => '95', // Yala
        '72' => '35', // Yasothon
        '73' => '48', // Nakhon Phanom
        '74' => '25', // Prachin Buri
        '75' => '34', // Ubon Ratchathani
        '76' => '41', // Udon Thani
        '77' => '37', // Amnat Charoen
        '78' => '49', // Mukdahan
        '79' => '39', // Nong Bua Lamphu
        '80' => '27', // Sa Kaeo

        // invalid codes  [used by maxmind]
        '21' => '48', // Nakhon Phanom
        '45' => '25', // Prachin Buri
        '71' => '34', // Ubon Ratchathani
        '81' => '38', // Bueng Kan
    ],
    'TJ' => [
        '01' => 'GB',
        '02' => 'KT',
        '03' => 'SU',

        // invalid codes  [used by maxmind]
        '04' => 'DU',
        '05' => 'RA',
    ],
    'TL' => [
        // invalid codes  [used by maxmind]
        '06' => 'DI', // Dili
    ],
    'TM' => [
        '01' => 'A',
        '02' => 'B',
        '03' => 'D',
        '04' => 'L',
        '05' => 'M',
    ],
    'TN' => [
        '02' => '42',
        '03' => '41',
        '06' => '32',
        '10' => '71',
        '14' => '33',
        '15' => '53',
        '16' => '52',
        '17' => '31',
        '18' => '23',
        '19' => '21',
        '22' => '34',
        '23' => '51',
        '27' => '13',
        '28' => '82',
        '29' => '81',
        '31' => '73',
        '32' => '61',
        '33' => '43',
        '34' => '83',
        '35' => '72',
        '36' => '11',
        '37' => '22',
        '38' => '12',
        '39' => '14',
    ],
    'TO' => [
        '01' => '02',
        '02' => '04',
        '03' => '05',
    ],
    'TR' => [
        '02' => '02', // Adiyaman
        '03' => '03', // Afyonkarahisar
        '04' => '04', // Agri
        '05' => '05', // Amasya
        '07' => '07', // Antalya
        '08' => '08', // Artvin
        '09' => '09', // Aydin
        '10' => '10', // Balikesir
        '11' => '11', // Bilecik
        '12' => '12', // Bingol
        '13' => '13', // Bitlis
        '14' => '14', // Bolu
        '15' => '15', // Burdur
        '16' => '16', // Bursa
        '17' => '17', // Canakkale
        '19' => '19', // Corum
        '20' => '20', // Denizli
        '21' => '21', // Diyarbakir
        '22' => '22', // Edirne
        '23' => '23', // Elazig
        '24' => '24', // Erzincan
        '25' => '25', // Erzurum
        '26' => '26', // Eskisehir
        '28' => '28', // Giresun
        '31' => '31', // Hatay
        '32' => '33', // Mersin
        '33' => '32', // Isparta
        '34' => '34', // Istanbul
        '35' => '35', // Izmir
        '37' => '37', // Kastamonu
        '38' => '38', // Kayseri
        '39' => '39', // Kirklareli
        '40' => '40', // Kirsehir
        '41' => '41', // Kocaeli
        '43' => '43', // Kutahya
        '44' => '44', // Malatya
        '45' => '45', // Manisa
        '46' => '46', // Kahramanmaras
        '48' => '48', // Mugla
        '49' => '49', // Mus
        '50' => '50', // Nevsehir
        '52' => '52', // Ordu
        '53' => '53', // Rize
        '54' => '54', // Sakarya
        '55' => '55', // Samsun
        '57' => '57', // Sinop
        '58' => '58', // Sivas
        '59' => '59', // Tekirdag
        '60' => '60', // Tokat
        '61' => '61', // Trabzon
        '62' => '62', // Tunceli
        '63' => '63', // Sanliurfa
        '64' => '64', // Usak
        '65' => '65', // Van
        '66' => '66', // Yozgat
        '68' => '06', // Ankara
        '69' => '29', // Gumushane
        '70' => '30', // Hakkari
        '71' => '42', // Konya
        '72' => '47', // Mardin
        '73' => '51', // Nigde
        '74' => '56', // Siirt
        '75' => '68', // Aksaray
        '76' => '72', // Batman
        '77' => '69', // Bayburt
        '78' => '70', // Karaman
        '79' => '71', // Kirikkale
        '80' => '73', // Sirnak
        '81' => '01', // Adana
        '82' => '18', // Cankiri
        '83' => '27', // Gaziantep
        '84' => '36', // Kars
        '85' => '67', // Zonguldak
        '86' => '75', // Ardahan
        '87' => '74', // Bartin
        '88' => '76', // Igdir
        '89' => '78', // Karabuk
        '90' => '79', // Kilis
        '91' => '80', // Osmaniye
        '92' => '77', // Yalova
        '93' => '81', // Duzce
    ],
    'TT' => [
        '01' => 'ARI', // Arima
        '02' => '', // Caroni  [split up]
        '03' => 'MRC', // Mayaro
        '04' => '', // Nariva  [split up]
        '05' => 'POS', // Port-of-Spain
        '06' => 'SGE', // Saint Andrew  [now in Sangre Grand]
        '07' => 'SGE', // Saint David  [now in Sangre Grand]
        '08' => '', // Saint George  [split up]
        '09' => '', // Saint Patrick  [split up]
        '10' => 'SFO', // San Fernando
        '11' => 'TOB', // Tobago
        '12' => '', // Victoria  [split up]
    ],
    'TW' => [
        '01' => '',
        '02' => 'KHH',
        '03' => 'TPE',
        '04' => '',
    ],
    'TZ' => [
        '02' => '19',
        '03' => '03',
        '04' => '04',
        '05' => '08',
        '06' => '09',
        '07' => '12',
        '08' => '13',
        '09' => '14',
        '10' => '16',
        '11' => '17',
        '12' => '18',
        '13' => '06',
        '14' => '21',
        '15' => '22',
        '16' => '23',
        '17' => '24',
        '18' => '25',
        '19' => '05',
        '20' => '10',
        '21' => '11',
        '22' => '07',
        '23' => '02',
        '24' => '20',
        '25' => '15',
        '26' => '01',
        '27' => '26',
    ],
    'UA' => [
        '01' => '71',
        '02' => '74',
        '03' => '77',
        '04' => '12',
        '05' => '14',
        '06' => '26',
        '07' => '63',
        '08' => '65',
        '09' => '68',
        '10' => '35',
        '11' => '43',
        '12' => '30',
        '13' => '32',
        '14' => '09',
        '15' => '46',
        '16' => '48',
        '17' => '51',
        '18' => '53',
        '19' => '56',
        '20' => '40',
        '21' => '59',
        '22' => '61',
        '23' => '05',
        '24' => '07',
        '25' => '21',
        '26' => '23',
        '27' => '18',
    ],
    'UG' => [
        '26' => '302', // Apac
        '28' => '401', // Bundibugyo
        '29' => '102', // Bushenyi
        '30' => '304', // Gulu
        '31' => '403', // Hoima
        '33' => '204', // Jinja
        '36' => '101', // Kalangala
        '37' => '102', // Kampala
        '38' => '205', // Kamuli
        '39' => '206', // Kapchorwa
        '40' => '406', // Kasese
        '41' => '407', // Kibale
        '42' => '103', // Kiboga
        '43' => '408', // Kisoro
        '45' => '306', // Kotido
        '46' => '208', // Kumi
        '47' => '307', // Lira
        '50' => '409', // Masindi
        '52' => '410', // Mbarara
        '56' => '107', // Mubende
        '58' => '310', // Nebbi
        '59' => '411', // Ntungamo
        '60' => '210', // Pallisa
        '61' => '110', // Rakai
        '65' => '301', // Adjumani
        '66' => '201', // Bugiri
        '67' => '202', // Busia
        '69' => '207', // Katakwi
        '70' => '104', // Luwero
        '71' => '105', // Masaka
        '72' => '309', // Moyo
        '73' => '109', // Nakasongola
        '74' => '111', // Sembabule
        '76' => '212', // Tororo
        '77' => '303', // Arua
        '78' => '203', // Iganga
        '79' => '405', // Kabarole
        '80' => '213', // Kaberamaido
        '81' => '413', // Kamwenge
        '82' => '414', // Kanungu
        '83' => '112', // Kayunga
        '84' => '305', // Kitgum
        '85' => '415', // Kyenjojo
        '86' => '214', // Mayuge
        '87' => '209', // Mbale
        '88' => '308', // Moroto
        '89' => '106', // Mpigi
        '90' => '108', // Mukono
        '91' => '311', // Nakapiripirit
        '92' => '312', // Pader
        '93' => '412', // Rukungiri
        '94' => '215', // Sironko
        '95' => '211', // Soroti
        '96' => '113', // Wakiso
        '97' => '313', // Yumbe

        // valid codes  [not used by maxmind]
        '34' => '404', // Kabale
    ],
    'UY' => [
        '01' => 'AR',
        '02' => 'CA',
        '03' => 'CL',
        '04' => 'CO',
        '05' => 'DU',
        '06' => 'FS',
        '07' => 'FD',
        '08' => 'LA',
        '09' => 'MA',
        '10' => 'MO',
        '11' => 'PA',
        '12' => 'RN',
        '13' => 'RV',
        '14' => 'RO',
        '15' => 'SA',
        '16' => 'SJ',
        '17' => 'SO',
        '18' => 'TA',
        '19' => 'TT',
    ],
    'UZ' => [
        '01' => 'AN',
        '02' => 'BU',
        '03' => 'FA',
        '05' => 'XO',
        '06' => 'NG',
        '07' => 'NW',
        '08' => 'QA',
        '09' => 'QR',
        '10' => 'SA',
        '12' => 'SU',
        '13' => 'TK',
        '14' => 'TO',
        '15' => 'JI',

        // invalid codes  [used by maxmind]
        '04' => 'JI',
        '11' => 'SI',
    ],
    'VC' => [
        '01' => '01',
        '02' => '02',
        '03' => '03',
        '04' => '04',
        '05' => '05',
        '06' => '06',
    ],
    'VE' => [
        '01' => 'Z',
        '02' => 'B',
        '03' => 'C',
        '04' => 'D',
        '05' => 'E',
        '06' => 'F',
        '07' => 'G',
        '08' => 'H',
        '09' => 'Y',
        '11' => 'I',
        '12' => 'J',
        '13' => 'K',
        '14' => 'L',
        '15' => 'M',
        '16' => 'N',
        '17' => 'O',
        '18' => 'P',
        '19' => 'R',
        '20' => 'S',
        '21' => 'T',
        '22' => 'U',
        '23' => 'V',
        '24' => 'W',
        '25' => 'A',
        '26' => 'X',
    ],
    'VN' => [
        '01' => '44', // An Giang
        '03' => '50', // Ben Tre
        '05' => '04', // Cao Bang
        '09' => '45', // Dong Thap
        '13' => 'HP', // Hai Phong
        '20' => 'SG', // Ho Chi Minh
        '21' => '47', // Kien Giang
        '23' => '35', // Lam Dong
        '24' => '41', // Long An
        '30' => '13', // Quang Ninh
        '32' => '05', // Son La
        '33' => '37', // Tay Ninh
        '34' => '21', // Thanh Hoa
        '35' => '20', // Thai Binh
        '37' => '46', // Tien Giang
        '39' => '09', // Lang Son
        '43' => '39', // Dong Nai
        '44' => 'HN', // Ha Noi
        '45' => '45', // Ba Ria-Vung Tau
        '46' => '31', // Binh Dinh
        '47' => '40', // Binh Thuan
        '49' => '30', // Gia Lai
        '50' => '03', // Ha Giang
        '52' => '23', // Ha Tinh
        '53' => '14', // Hoa Binh
        '54' => '34', // Khanh Hoa
        '55' => '28', // Kon Tum
        '58' => '22', // Nghe An
        '59' => '18', // Ninh Binh
        '60' => '36', // Ninh Thuan
        '61' => '32', // Phu Yen
        '62' => '24', // Quang Binh
        '63' => '29', // Quang Ngai
        '64' => '25', // Quang Tri
        '65' => '52', // Soc Trang
        '66' => '26', // Thua Thien-Hue
        '67' => '51', // Tra Vinh
        '68' => '07', // Tuyen Quang
        '69' => '49', // Vinh Long
        '70' => '06', // Yen Bai
        '71' => '54', // Bac Giang
        '72' => '53', // Bac Kan
        '73' => '55', // Bac Lieu
        '74' => '56', // Bac Ninh
        '75' => '57', // Binh Duong
        '76' => '58', // Binh Phuoc
        '77' => '59', // Ca Mau
        '78' => 'DN', // Da Nang
        '79' => '61', // Hai Duong
        '80' => '63', // Ha Nam
        '81' => '66', // Hung Yen
        '82' => '67', // Nam Dinh
        '83' => '68', // Phu Tho
        '84' => '27', // Quang Nam
        '85' => '69', // Thai Nguyen
        '86' => '70', // Vinh Phuc
        '87' => 'CT', // Can Tho
        '88' => '33', // Dac Lak
        '89' => '01', // Lai Chau
        '90' => '02', // Lao Cai
        '91' => '72', // Dak Nong
        '92' => '71', // Dien Bien
        '93' => '73', // Hau Giang

        // valid codes  [not used by maxmind]
        '51' => 'HN', // Hà Tây  [merged in Ha Noi]
    ],
    'VU' => [
        '07' => 'TOB',
        '13' => 'SAM',
        '15' => 'TAE',
        '16' => 'MAP',
        '17' => 'PAM',
        '18' => 'SEE',

        // invalid codes  [used by maxmind]
        '05' => 'MAP', // Ambrym  [island in Malampa]
        '06' => 'PAM', // Aoba  [island in Penama]
        '08' => 'SEE', // Efate  [island in Shefa]
        '09' => 'SEE', // Epi  [island in Shefa]
        '10' => 'MAP', // Malakula  [island in Malampa]
        '11' => 'MAP', // Paama  [island in Malampa]
        '12' => 'PAM', // Pentecote  [island in Penama]
        '14' => 'SEE', // Shepherd  [island in Shefa]
    ],
    'WS' => [
        '02' => 'AL',
        '03' => 'AT',
        '04' => 'FA',
        '05' => 'GE',
        '06' => 'VF',
        '07' => 'GI',
        '08' => 'PA',
        '09' => 'SA',
        '10' => 'TU',
        '11' => 'VS',

        // valid codes  [not used by maxmind]
        '01' => 'AA',
    ],
    'YE' => [
        '01' => 'AB', // Abyan
        '02' => 'AD', // Adan
        '03' => 'MR', // Al Mahrah
        '04' => 'HD', // Hadramawt
        '05' => 'SH', // Shabwah
        '08' => 'HU', // Al Hudaydah
        '10' => 'MW', // Al Mahwit
        '11' => 'DH', // Dhamar
        '14' => 'MA', // Ma'rib
        '15' => 'SD', // Sa'dah
        '16' => 'SN', // San'a'
        '18' => 'DA', // Ad Dali
        '19' => 'AM', // Amran
        '20' => 'BA', // Al Bayda'
        '21' => 'JA', // Al Jawf
        '22' => 'HJ', // Hajjah
        '23' => 'IB', // Ibb
        '24' => 'LA', // Lahij
        '25' => 'TA', // Taizz

        // invalid codes  [used by maxmind]
        '06' => 'LA', // Lahij
        '07' => 'BA', // Al Bayda'
        '09' => 'JA', // Al Jawf
        '12' => 'HJ', // Hajjah
        '13' => 'IB', // Ibb
        '17' => 'TA', // Taizz
    ],
    'ZA' => [
        '02' => 'NL',
        '03' => 'FS',
        '05' => 'EC',
        '06' => 'GT',
        '07' => 'MP',
        '08' => 'NC',
        '09' => 'LP',
        '10' => 'NW',
        '11' => 'WC',

        // invalid codes  [used by maxmind]
        '01' => 'NW', // North-Western Province
    ],
    'ZM' => [
        '01' => '01',
        '02' => '02',
        '03' => '03',
        '04' => '04',
        '05' => '05',
        '06' => '06',
        '07' => '07',
        '08' => '08',
        '09' => '09',
    ],
    'ZW' => [
        '01' => 'MA',
        '02' => 'MI',
        '03' => 'MC',
        '04' => 'ME',
        '05' => 'MW',
        '06' => 'MN',
        '07' => 'MS',
        '08' => 'MV',
        '09' => 'BU',
        '10' => 'HA',
    ],
];
