/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.json.internal.dom;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.protocols.json.internal.dom.SdkJsonNode;

@SdkInternalApi
public final class SdkObjectNode
implements SdkJsonNode {
    private static final SdkObjectNode EMPTY = SdkObjectNode.builder().build();
    private final Map<String, SdkJsonNode> fields;

    private SdkObjectNode(Builder builder) {
        this.fields = Collections.unmodifiableMap(new HashMap(builder.fields));
    }

    @Override
    public SdkJsonNode get(String fieldName) {
        return this.fields.get(fieldName);
    }

    @Override
    public Map<String, SdkJsonNode> fields() {
        return this.fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SdkObjectNode that = (SdkObjectNode)o;
        return Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hashCode(this.fields);
    }

    public String toString() {
        return this.fields.entrySet().stream().map(e -> String.format("\"%s\": %s", e.getKey(), e.getValue())).collect(Collectors.joining(",\n", "{\n", "\n}"));
    }

    static Builder builder() {
        return new Builder();
    }

    public static SdkObjectNode emptyObject() {
        return EMPTY;
    }

    static final class Builder {
        private final Map<String, SdkJsonNode> fields = new HashMap<String, SdkJsonNode>();

        private Builder() {
        }

        Builder putField(String fieldName, SdkJsonNode value) {
            this.fields.put(fieldName, value);
            return this;
        }

        SdkObjectNode build() {
            return new SdkObjectNode(this);
        }
    }
}

