<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\RemoteBuildExecution;

class GoogleDevtoolsRemoteworkersV1test2CommandOutputs extends \Google\Model
{
  public $exitCode;
  protected $outputsType = GoogleDevtoolsRemoteworkersV1test2Digest::class;
  protected $outputsDataType = '';

  public function setExitCode($exitCode)
  {
    $this->exitCode = $exitCode;
  }
  public function getExitCode()
  {
    return $this->exitCode;
  }
  /**
   * @param GoogleDevtoolsRemoteworkersV1test2Digest
   */
  public function setOutputs(GoogleDevtoolsRemoteworkersV1test2Digest $outputs)
  {
    $this->outputs = $outputs;
  }
  /**
   * @return GoogleDevtoolsRemoteworkersV1test2Digest
   */
  public function getOutputs()
  {
    return $this->outputs;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleDevtoolsRemoteworkersV1test2CommandOutputs::class, 'Google_Service_RemoteBuildExecution_GoogleDevtoolsRemoteworkersV1test2CommandOutputs');
