/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.datatype;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.namespace.QName;

public abstract class Duration {
    public QName getXMLSchemaType() {
        int state = 0;
        state |= this.isSet(DatatypeConstants.YEARS) ? 32 : 0;
        state |= this.isSet(DatatypeConstants.MONTHS) ? 16 : 0;
        state |= this.isSet(DatatypeConstants.DAYS) ? 8 : 0;
        state |= this.isSet(DatatypeConstants.HOURS) ? 4 : 0;
        state |= this.isSet(DatatypeConstants.MINUTES) ? 2 : 0;
        switch (state |= this.isSet(DatatypeConstants.SECONDS)) {
            case 63: {
                return DatatypeConstants.DURATION;
            }
            case 15: {
                return DatatypeConstants.DURATION_DAYTIME;
            }
            case 48: {
                return DatatypeConstants.DURATION_YEARMONTH;
            }
        }
        throw new IllegalStateException();
    }

    public abstract int getSign();

    public int getYears() {
        Number val = this.getField(DatatypeConstants.YEARS);
        int n = 0;
        if (val != null) {
            n = val.intValue();
        }
        return n;
    }

    public int getMonths() {
        Number val = this.getField(DatatypeConstants.MONTHS);
        int n = 0;
        if (val != null) {
            n = val.intValue();
        }
        return n;
    }

    public int getDays() {
        Number val = this.getField(DatatypeConstants.DAYS);
        int n = 0;
        if (val != null) {
            n = val.intValue();
        }
        return n;
    }

    public int getHours() {
        Number val = this.getField(DatatypeConstants.HOURS);
        int n = 0;
        if (val != null) {
            n = val.intValue();
        }
        return n;
    }

    public int getMinutes() {
        Number val = this.getField(DatatypeConstants.MINUTES);
        int n = 0;
        if (val != null) {
            n = val.intValue();
        }
        return n;
    }

    public int getSeconds() {
        Number val = this.getField(DatatypeConstants.SECONDS);
        int n = 0;
        if (val != null) {
            n = val.intValue();
        }
        return n;
    }

    public long getTimeInMillis(Calendar startInstant) {
        Calendar cal = (Calendar)startInstant.clone();
        long t1 = cal.getTimeInMillis();
        this.addTo(cal);
        long t2 = cal.getTimeInMillis();
        return t2 - t1;
    }

    public long getTimeInMillis(Date startInstant) {
        Date date = (Date)startInstant.clone();
        long t1 = date.getTime();
        this.addTo(date);
        long t2 = date.getTime();
        return t2 - t1;
    }

    public abstract Number getField(DatatypeConstants.Field var1);

    public abstract boolean isSet(DatatypeConstants.Field var1);

    public abstract Duration add(Duration var1);

    public abstract void addTo(Calendar var1);

    public void addTo(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(date.getTime());
        this.addTo(calendar);
        date.setTime(calendar.getTimeInMillis());
    }

    public Duration subtract(Duration rhs) {
        throw new UnsupportedOperationException();
    }

    public Duration multiply(int factor) {
        return this.multiply(BigDecimal.valueOf(factor));
    }

    public Duration multiply(BigDecimal factor) {
        throw new UnsupportedOperationException();
    }

    public abstract Duration negate();

    public abstract Duration normalizeWith(Calendar var1);

    public abstract int compare(Duration var1);

    public boolean isLongerThan(Duration duration) {
        throw new UnsupportedOperationException();
    }

    public boolean isShorterThan(Duration duration) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object duration) {
        throw new UnsupportedOperationException();
    }

    public abstract int hashCode();

    public String toString() {
        throw new UnsupportedOperationException();
    }
}

