/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.CoreUtils;
import com.gallery.GalleryRemote.DroppableList;
import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.GalleryRemoteCore;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.StatusUpdate;
import com.gallery.GalleryRemote.StatusUpdateAdapter;
import com.gallery.GalleryRemote.model.Album;
import com.gallery.GalleryRemote.model.Gallery;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.prefs.PropertiesFile;
import com.gallery.GalleryRemote.util.ImageLoaderUtil;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.jdic.screensaver.ScreensaverContext;
import org.jdesktop.jdic.screensaver.ScreensaverSettings;

public class GalleryRemoteScreenSaver
extends GalleryRemote
implements GalleryRemoteCore,
PreferenceNames,
ListDataListener,
ImageLoaderUtil.ImageLoaderUser {
    DefaultComboBoxModel galleries = null;
    Gallery gallery;
    Album album;
    DroppableList jPicturesList;
    StatusUpdateAdapter statusUpdate = new StatusUpdateAdapter();
    ScreensaverContext context;
    Picture currentPicture = null;
    File currentImage = null;
    ImageLoaderUtil loader = new ImageLoaderUtil(3, this);
    Dimension size = null;
    boolean newImage = false;
    ArrayList picturesList = null;
    int delay = 5000;
    boolean hasSettings = true;

    protected void initializeGR() {
        super.initializeGR();
        CoreUtils.initCore();
        Log.startLog(GalleryRemoteScreenSaver._().properties.getIntProperty("logLevel"), GalleryRemoteScreenSaver._().properties.getBooleanProperty("toSysOut"));
        this.startup();
    }

    public void setContext(ScreensaverContext context) {
        this.context = context;
    }

    public void createProperties() {
        super.createProperties();
        File f = new File(System.getProperty("user.home") + File.separator + ".GalleryRemote" + File.separator);
        f.mkdirs();
        File pf = new File(f, "GalleryRemoteScreenSaver.properties");
        if (!pf.exists()) {
            try {
                pf.createNewFile();
            }
            catch (IOException e) {
                Log.logException(1, "GalRem", e);
            }
        }
        this.properties = new PropertiesFile(this.properties, pf.getPath(), "user");
    }

    public Frame getMainFrame() {
        return null;
    }

    public GalleryRemoteCore getCore() {
        return this;
    }

    protected void loadIcons() {
    }

    public void startup() {
        String url;
        ScreensaverSettings settings = this.context.getSettings();
        Log.log(3, "GalRem", "Screensaver settings: " + settings.getProperties().toString());
        Properties p = settings.getProperties();
        this.galleries = new DefaultComboBoxModel();
        this.gallery = new Gallery(GalleryRemote._().getCore().getMainStatusUpdate());
        String curl = settings.getProperty("curl");
        if (curl != null) {
            try {
                p.load(new URL(curl).openStream());
            }
            catch (IOException e) {
                Log.log(0, "GalRem", "Error trying to get configuration file: " + curl);
                Log.logException(0, "GalRem", e);
            }
            Log.log(3, "GalRem", "Fetched settings: " + settings.getProperties().toString());
        }
        if ((url = p.getProperty("url")) != null) {
            this.gallery.setStUrlString(url);
            if (p.getProperty("username") == null || p.getProperty("username").trim().length() == 0) {
                this.gallery.cookieLogin = true;
            } else {
                this.gallery.setUsername(p.getProperty("username"));
                this.gallery.setPassword(p.getProperty("password"));
            }
            this.gallery.setType(0);
            this.properties.setBooleanProperty("slideshowRecursive", p.getProperty("recursive") != null);
            this.properties.setBooleanProperty("slideshowLowRez", p.getProperty("hires") == null);
            this.properties.setBooleanProperty("slideshowNoStretch", p.getProperty("stretch") == null);
            this.delay = Integer.parseInt(p.getProperty("delay")) * 1000;
            String albums = p.getProperty("album");
            String[] albumsA = albums.split(",");
            this.galleries.addElement(this.gallery);
            ImageUtils.deferredTasks();
            this.album = new Album(this.gallery);
            this.album.setName(albumsA[new Random().nextInt(albumsA.length)]);
            this.album.addListDataListener(this);
            this.album.fetchAlbumImages(this.statusUpdate, GalleryRemote._().properties.getBooleanProperty("slideshowRecursive"), 200, true);
        } else {
            this.hasSettings = false;
        }
    }

    public void nextPicture() {
        if (GalleryRemote._() == null) {
            return;
        }
        if (this.picturesList == null || this.picturesList.size() == 0) {
            this.picturesList = new ArrayList(this.album.getPicturesList());
        }
        Picture p = (Picture)this.picturesList.get((int)Math.floor(Math.random() * (double)this.picturesList.size()));
        this.picturesList.remove(p);
        this.loader.preparePicture(p, true, true);
    }

    public void shutdown() {
        if (GalleryRemote._() != null) {
            GalleryRemote.shutdownInstance();
        }
    }

    public void shutdown(boolean shutdownOs) {
        this.shutdown();
    }

    public void flushMemory() {
    }

    public void preloadThumbnails(Iterator pictures) {
    }

    public Image getThumbnail(Picture p) {
        return null;
    }

    public StatusUpdate getMainStatusUpdate() {
        return this.statusUpdate;
    }

    public DefaultComboBoxModel getGalleries() {
        return this.galleries;
    }

    public void thumbnailLoadedNotify() {
    }

    public void setInProgress(boolean inProgress) {
    }

    public void addPictures(File[] files, int index, boolean select) {
        this.album.addPictures(files, index);
    }

    public void addPictures(Picture[] pictures, int index, boolean select) {
        this.album.addPictures(Arrays.asList(pictures), index);
    }

    public Album getCurrentAlbum() {
        return this.album;
    }

    public JList getPicturesList() {
        return this.jPicturesList;
    }

    public void contentsChanged(ListDataEvent e) {
        if (this.album.isHasFetchedImages()) {
            Log.log(3, "GalRem", "Done downloading album info");
            this.nextPicture();
        }
    }

    public void intervalAdded(ListDataEvent e) {
    }

    public void intervalRemoved(ListDataEvent e) {
    }

    public void pictureReady() {
        Log.log(3, "GalRem", "PictureReady, letting screensaver thread update");
        this.newImage = true;
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(GalleryRemoteScreenSaver.this.delay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                GalleryRemoteScreenSaver.this.nextPicture();
            }
        }.start();
    }

    public boolean blockPictureReady(Image image, Picture picture) {
        return false;
    }

    public Dimension getImageSize() {
        if (this.size == null) {
            this.size = this.context.getComponent().getBounds().getSize();
        }
        return this.size;
    }

    public void nullRect() {
    }

    public void pictureStartDownloading(Picture picture) {
    }

    public void pictureStartProcessing(Picture picture) {
    }

    public void pictureLoadError(Picture picture) {
    }
}

