/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.stringparsers;

import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.PropertyStringParser;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateStringParser
extends PropertyStringParser {
    private SimpleDateFormat format = null;

    public static DateStringParser getParser() {
        return new DateStringParser();
    }

    @Override
    public void setUp() throws ParseException {
        String formatString = this.getProperty("format");
        if (formatString == null) {
            this.format = new SimpleDateFormat();
        } else {
            try {
                this.format = new SimpleDateFormat(formatString);
            }
            catch (RuntimeException e) {
                throw new ParseException(e);
            }
        }
    }

    @Override
    public void tearDown() {
        this.format = null;
    }

    @Override
    public Object parse(String arg) throws ParseException {
        Date result = null;
        try {
            result = this.format.parse(arg);
        }
        catch (java.text.ParseException e) {
            throw new ParseException("Unable to convert '" + arg + "' to a Date.", e);
        }
        return result;
    }
}

