# Copyright (c) 2008-2011 Aleksey Cheusov <vle@gmx.net>
# All rights reserved.
#
# See LICENSE file

############################################################
############################################################
# Available target:
# failes if NOT_FOR_PLATFORM, ONLY_FOR_PLATFORM etc. fail
.PHONY: Available

.if "${_CBBH}" == "yes"
Available:
	@true
.else
Available:
	@${_CBBH_MSGS:@m@${ECHO} ${m};@} \
	false
.endif

############################################################
############################################################
# Excluded target:
# fails if the person that runs bulk build (you) manually excluded
# this particular package. There are a number of reasons for this:
# "bad" packages may hangs up eating CPU, stuck somewhere else (ping...)
# or you may want to exclude something just because it is too heavy
# for your machine

.PHONY: Excluded

.if empty(DBB_EXCL_REASON)
Excluded:
	@true
.else
Excluded:
	@echo "Manually excluded by person who runs the bulk build" 1>&2; \
	${DBB_EXCL_REASON:@m@${ECHO} ${m};@} \
	false
.endif

############################################################
############################################################
# Vars target:
# outputs MAKE_FLAGS, MAKE_ENV, CONFIGURE_ENV etc.
.if !defined(DBB_VARS) # override it in distbb.local.mk
DBB_VARS=	${DBB_VARS_ADD}   # user's additions

DBB_VARS+=	TOOLS USE_IMAKE USE_CMAKE USE_LIBTOOL USE_LANGUAGES
DBB_VARS+=	USE_JAVA USE_JAVA2

DBB_VARS+=	CONFIGURE_DIRS CONFIGURE_ENV CONFIGURE_SCRIPT 
DBB_VARS+=	CONFIGURE_ARGS

DBB_VARS+=	MAKE_DIRS MAKE_ENV MAKE_PROGRAM MAKE_FLAGS
DBB_VARS+=	MAKE_FILE CMAKE_ARGS

DBB_VARS+=	BUILD_DIRS BUILD_MAKE_FLAGS BUILD_TARGET

DBB_VARS+=	INSTALL_DIRS INSTALL_MAKE_FLAGS INSTALL_TARGET
DBB_VARS+=	NO_INSTALL NO_INSTALL_MANPAGES

DBB_VARS+=	INSTALLATION_DIRS AUTO_MKDIRS

DBB_VARS+=	SUBST_CLASSES
.for class in ${SUBST_CLASSES}
DBB_VARS+=	SUBST_STAGE.${class}
DBB_VARS+=	SUBST_MESSAGE.${class}
DBB_VARS+=	SUBST_FILES.${class}
DBB_VARS+=	SUBST_SED.${class}
DBB_QVARS.SUBST_SED.${class}=		1
DBB_QVARS.SUBST_MESSAGE.${class}=	1
.endfor
DBB_QVARS.SUBST_CLASSES=		1
DBB_QVARS.USE_LANGUAGES=		1
DBB_QVARS.CONFIGURE_SCRIPT=		1
.endif

.PHONY: Vars

Vars:
.for v in ${DBB_VARS}
.if !empty(${v}:U)
	@echo ${v}:
.if empty(DBB_QVARS.${v})
	@printf '    '; \
	for val in ${${v}:Q}; do printf "%s\n" "$$val"; done | \
	awk '{gsub(/[^\\] +/, "&\n    "); sub(/ +$$/, ""); print}'
.else
	@for val in ${${v}:Q}; do printf "    %s\n" "$$val"; done
.endif
	@echo ''
.endif
.endfor

############################################################
############################################################
# Depends target:
# install all required dependencies, removing {al,ter}:../native/dependencies
.PHONY: Depends
Depends:
	env PKG_ADD_CMD="${PKG_ADD_CMD}" \
	    PKG_DBDIR="${PKG_DBDIR}" \
	    PKG_SUFX=${PKG_SUFX} \
	    aux_reqd_deps_fn=${aux_reqd_deps_fn} \
	    /usr/pkg/libexec/distbb/make-depends "${BH_pkg}${PKGNAME}"

# Remove almost all packages in order to have clean system for build
.PHONY: CleanupPkgdb
CleanupPkgdb:
	${PKG_INFO} -a | awk '!/^libkver-|^pkg_install/ {print $$1}' | \
	xargs ${PKG_DELETE}
