"""
Makernote (proprietary) tag definitions for Sony.

Based on https://www.exiftool.org/TagNames/Sony.html
"""

from exifread.tags import SubIfdTagDict

TAGS: SubIfdTagDict = {
    # depends on model
    # 0x0010: (),
    # 0x0020: (),
    0x0102: (
        "Quality",
        {
            0: "RAW",
            1: "Super Fine",
            2: "Fine",
            3: "Standard",
            4: "Economy",
            5: "Extra Fine",
            6: "RAW + JPEG/HEIF",
            7: "Compressed RAW",
            8: "Compressed RAW + JPEG",
            9: "Light",
        },
    ),
    0x0104: ("FlashExposureComp", None),
    0x0105: (
        "Teleconverter",
        {
            0x0: "None",
            0x4: "Minolta/Sony AF 1.4x APO (D) (0x04)",
            0x5: "Minolta/Sony AF 2x APO (D) (0x05)",
            0x48: "Minolta/Sony AF 2x APO (D)",
            0x50: "Minolta AF 2x APO II",
            0x60: "Minolta AF 2x APO",
            0x88: "Minolta/Sony AF 1.4x APO (D)",
            0x90: "Minolta AF 1.4x APO II",
            0xA0: "Minolta AF 1.4x APO",
        },
    ),
    0x0112: ("WhiteBalanceFineTune", None),
    # depends on model
    # 0x0114: (),
    0x0115: (
        "WhiteBalance",
        {
            0x0: "Auto",
            0x1: "Color Temperature / Color Filter",
            0x10: "Daylight",
            0x20: "Cloudy",
            0x30: "Shade",
            0x40: "Tungsten",
            0x50: "Flash",
            0x60: "Fluorescent",
            0x70: "Custom",
            0x80: "Underwater",
        },
    ),
    # depends on model
    # 0x0116: (),
    0x0E00: ("PrintIM", None),
    0x1000: ("MultiBurstMode", {0: "Off", 1: "On"}),
    0x1001: ("MultiBurstImageWidth", None),
    0x1002: ("MultiBurstImageHeight", None),
    # needs specific processing?
    # 0x1003: ("Panorama", {}),
    0x2001: ("PreviewImage", None),
    0x2002: ("Rating", None),
    0x2004: ("Contrast", None),
    0x2005: ("Saturation", None),
    0x2006: ("Sharpness", None),
    0x2007: ("Brightness", None),
    0x2008: (
        "LongExposureNoiseReduction",
        {
            0x0: "Off",
            0x1: "On (unused)",
            0x10001: "On (dark subtracted)",
            0xFFFF0000: "Off (65535)",
            0xFFFF0001: "On (65535)",
            0xFFFFFFFF: "N/A",
        },
    ),
    0x2009: (
        "HighISONoiseReduction",
        {
            0: "Off",
            1: "Low",
            2: "Normal",
            3: "High",
            256: "Auto",
            65535: "N/A",
        },
    ),
    # Needs specific processing?
    # 0x200A: ("HDR", {}),
    0x200B: (
        "MultiFrameNoiseReduction",
        {
            0: "Off",
            1: "On",
            255: "N/A",
        },
    ),
    0x200E: (
        "PictureEffect",
        {
            0: "Off",
            1: "Toy Camera",
            2: "Pop Color",
            3: "Posterization",
            4: "Posterization B/W",
            5: "Retro Photo",
            6: "Soft High Key",
            7: "Partial Color (red)",
            8: "Partial Color (green)",
            9: "Partial Color (blue)",
            10: "Partial Color (yellow)",
            13: "High Contrast Monochrome",
            16: "Toy Camera (normal)",
            17: "Toy Camera (cool)",
            18: "Toy Camera (warm)",
            19: "Toy Camera (green)",
            20: "Toy Camera (magenta)",
            32: "Soft Focus (low)",
            33: "Soft Focus",
            34: "Soft Focus (high)",
            48: "Miniature (auto)",
            49: "Miniature (top)",
            50: "Miniature (middle horizontal)",
            51: "Miniature (bottom)",
            52: "Miniature (left)",
            53: "Miniature (middle vertical)",
            54: "Miniature (right)",
            64: "HDR Painting (low)",
            65: "HDR Painting",
            66: "HDR Painting (high)",
            80: "Rich-tone Monochrome",
            97: "Water Color",
            98: "Water Color 2",
            112: "Illustration (low)",
            113: "Illustration",
            114: "Illustration (high)",
        },
    ),
    0x200F: (
        "SoftSkinEffect",
        {
            0: "Off",
            1: "Low",
            2: "Mid",
            3: "High",
            4294967295: "N/A",
        },
    ),
    # depends on model
    # 0x2010: (),
    0x2011: (
        "VignettingCorrection",
        {
            0: "Off",
            2: "Auto",
            4294967295: "N/A",
        },
    ),
    0x2012: (
        "LateralChromaticAberration",
        {
            0: "Off",
            2: "Auto",
            4294967295: "N/A",
        },
    ),
    0x2013: (
        "DistortionCorrectionSetting",
        {
            0: "Off",
            2: "Auto",
            4294967295: "N/A",
        },
    ),
    0x2014: ("WBShiftAB_GM", None),
    0x2016: ("AutoPortraitFramed", {0: "No", 1: "Yes"}),
    0x2017: (
        "FlashAction",
        {
            0: "Did not fire",
            1: "Flash Fired",
            2: "External Flash Fired",
            3: "Wireless Controlled Flash Fired",
        },
    ),
    0x201A: ("ElectronicFrontCurtainShutter", {0: "Off", 1: "On"}),
    0x201B: (
        "FocusMode",
        {
            0: "Manual",
            2: "AF-S",
            3: "AF-C",
            4: "AF-A",
            6: "DMF",
            7: "AF-D",
        },
    ),
    0x2021: (
        "FlashExposureComp",
        {
            0: "Off",
            1: "Face tracking",
            2: "Lock On AF",
        },
    ),
    0xB001: (
        "SonyModelID",
        {
            2: "DSC-R1",
            256: "DSLR-A100",
            257: "DSLR-A900",
            258: "DSLR-A700",
            259: "DSLR-A200",
            260: "DSLR-A350",
            261: "DSLR-A300",
            262: "DSLR-A900 (APS-C mode)",
            263: "DSLR-A380/A390",
            264: "DSLR-A330",
            265: "DSLR-A230",
            266: "DSLR-A290",
            269: "DSLR-A850",
            270: "DSLR-A850 (APS-C mode)",
            273: "DSLR-A550",
            274: "DSLR-A500",
            275: "DSLR-A450",
            278: "NEX-5",
            279: "NEX-3",
            280: "SLT-A33",
            281: "SLT-A55 / SLT-A55V",
            282: "DSLR-A560",
            283: "DSLR-A580",
            284: "NEX-C3",
            285: "SLT-A35",
            286: "SLT-A65 / SLT-A65V",
            287: "SLT-A77 / SLT-A77V",
            288: "NEX-5N",
            289: "NEX-7",
            290: "NEX-VG20E",
            291: "SLT-A37",
            292: "SLT-A57",
            293: "NEX-F3",
            294: "SLT-A99 / SLT-A99V",
            295: "NEX-6",
            296: "NEX-5R",
            297: "DSC-RX100",
            298: "DSC-RX1",
            299: "NEX-VG900",
            300: "NEX-VG30E",
            302: "ILCE-3000 / ILCE-3500",
            303: "SLT-A58",
            305: "NEX-3N",
            306: "ILCE-7",
            307: "NEX-5T",
            308: "DSC-RX100M2",
            309: "DSC-RX10",
            310: "DSC-RX1R",
            311: "ILCE-7R",
            312: "ILCE-6000",
            313: "ILCE-5000",
            317: "DSC-RX100M3",
            318: "ILCE-7S",
            319: "ILCA-77M2",
            339: "ILCE-5100",
            340: "ILCE-7M2",
            341: "DSC-RX100M4",
            342: "DSC-RX10M2",
            344: "DSC-RX1RM2",
            346: "ILCE-QX1",
            347: "ILCE-7RM2",
            350: "ILCE-7SM2",
            353: "ILCA-68",
            354: "ILCA-99M2",
            355: "DSC-RX10M3",
            356: "DSC-RX100M5",
            357: "ILCE-6300",
            358: "ILCE-9",
            360: "ILCE-6500",
            362: "ILCE-7RM3",
            363: "ILCE-7M3",
            364: "DSC-RX0",
            365: "DSC-RX10M4",
            366: "DSC-RX100M6",
            367: "DSC-HX99",
            369: "DSC-RX100M5A",
            371: "ILCE-6400",
            372: "DSC-RX0M2",
            373: "DSC-HX95",
            374: "DSC-RX100M7",
            375: "ILCE-7RM4",
            376: "ILCE-9M2",
            378: "ILCE-6600",
            379: "ILCE-6100",
            380: "ZV-1",
            381: "ILCE-7C",
            382: "ZV-E10",
            383: "ILCE-7SM3",
            384: "ILCE-1",
            385: "ILME-FX3",
            386: "ILCE-7RM3A",
            387: "ILCE-7RM4A",
            388: "ILCE-7M4",
            389: "ZV-1F",
            390: "ILCE-7RM5",
            391: "ILME-FX30",
            392: "ILCE-9M3",
            393: "ZV-E1",
            394: "ILCE-6700",
            395: "ZV-1M2",
            396: "ILCE-7CR",
            397: "ILCE-7CM2",
            398: "ILX-LR1",
            399: "ZV-E10M2",
            400: "ILCE-1M2",
        },
    ),
    0xB020: ("CreativeStyle", None),
    0xB021: ("ColorTemperature", None),
    0xB022: ("ColorCompensationFilter", None),
    0xB023: (
        "SceneMode",
        {
            0: "Standard",
            1: "Portrait",
            2: "Text",
            3: "Night Scene",
            4: "Sunset",
            5: "Sports",
            6: "Landscape",
            7: "Night Portrait",
            8: "Macro",
            9: "Super Macro",
            16: "Auto",
            17: "Night View / Portrait",
            18: "Sweep Panorama",
            19: "Handheld Night Shot",
            20: "Anti Motion Blur",
            21: "Cont. Priority AE",
            22: "Auto+",
            23: "3D Sweep Panorama",
            24: "Superior Auto",
            25: "High Sensitivity",
            26: "Fireworks",
            27: "Food",
            28: "Pet",
            33: "HDR",
        },
    ),
    0xB024: (
        "ZoneMatching",
        {
            0: "ISO Setting Used",
            1: "High Key",
            2: "Low Key",
        },
    ),
    0xB025: (
        "DynamicRangeOptimizer",
        {
            0: "Off",
            1: "Standard",
            2: "Advanced Auto",
            3: "Auto",
            8: "Advanced Lv1",
            9: "Advanced Lv2",
            10: "Advanced Lv3",
            11: "Advanced Lv4",
            12: "Advanced Lv5",
            16: "Lv1",
            17: "Lv2",
            18: "Lv3",
            19: "Lv4",
            20: "Lv5",
        },
    ),
    0xB026: (
        "ImageStabilization",
        {
            0: "Off",
            1: "On",
            4294967295: "N/A",
        },
    ),
    # TODO
    # 0xB027: ("LensType", {}),
    0xB029: (
        "ColorMode",
        {
            0: "Standard",
            1: "Vivid",
            2: "Portrait",
            3: "Landscape",
            4: "Sunset",
            5: "Night View / Portrait",
            6: "B & W",
            7: "Adobe RGB",
            12: "Neutral",
            13: "Clear",
            14: "Deep",
            15: "Light",
            16: "Autumn Leaves",
            17: "Sepia",
            18: "FL",
            19: "Vivid 2",
            20: "IN",
            21: "SH",
            100: "Neutral",
            101: "Clear",
            102: "Deep",
            103: "Light",
            104: "Night View",
            105: "Autumn Leaves",
            255: "Off",
            4294967295: "N/A",
        },
    ),
    0xB040: (
        "Macro",
        {
            0: "Off",
            1: "On",
            2: "Close Focus",
            65535: "N/A",
        },
    ),
    0xB041: (
        "ExposureMode",
        {
            0: "Program AE",
            1: "Portrait",
            2: "Beach",
            3: "Sports",
            4: "Snow",
            5: "Landscape",
            6: "Auto",
            7: "Aperture-priority AE",
            8: "Shutter speed priority AE",
            9: "Night Scene / Twilight",
            10: "Hi-Speed Shutter",
            11: "Twilight Portrait",
            12: "Soft Snap/Portrait",
            13: "Fireworks",
            14: "Smile Shutter",
            15: "Manual",
            18: "High Sensitivity",
            19: "Macro",
            20: "Advanced Sports Shooting",
            29: "Underwater",
            33: "Food",
            34: "Sweep Panorama",
            35: "Handheld Night Shot",
            36: "Anti Motion Blur",
            37: "Pet",
            38: "Backlight Correction HDR",
            39: "Superior Auto",
            40: "Background Defocus",
            41: "Soft Skin",
            42: "3D Image",
            65535: "N/A",
        },
    ),
    0xB042: (
        "FocusMode",
        {
            1: "AF-S",
            2: "AF-C",
            4: "Permanent-AF",
            65535: "N/A",
        },
    ),
    # depends on model
    # 0xb043: (),
    0xB044: (
        "AFIlluminator",
        {
            0: "Off",
            1: "On",
            65535: "N/A",
        },
    ),
    0xB047: (
        "JPEGQuality",
        {
            0: "Standard",
            1: "Fine",
            2: "Extra Fine",
            65535: "N/A",
        },
    ),
    0xB048: (
        "FlashLevel",
        {
            -32768: "Low",
            -9: "-9/3",
            -8: "-8/3",
            -7: "-7/3",
            -6: "-6/3",
            -5: "-5/3",
            -4: "-4/3",
            -3: "-3/3",
            -2: "-2/3",
            -1: "-1/3",
            0: "Normal",
            1: "+1/3",
            2: "+2/3",
            3: "+3/3",
            4: "+4/3",
            5: "+5/3",
            6: "+6/3",
            9: "+9/3",
            128: "N/A",
            32767: "High",
        },
    ),
    0xB049: (
        "ReleaseMode",
        {
            0: "Normal",
            2: "Continuous",
            5: " Exposure Bracketing",
            6: "White Balance Bracketing",
            8: "DRO Bracketing",
            65535: "N/A",
        },
    ),
    0xB04A: (
        "SequenceNumber",
        {
            0: "Single",
            65535: "N/A",
        },
    ),
    0xB04B: (
        "Anti-Blur",
        {
            0: "Off",
            1: "On - Continuous",
            2: "On - Shooting",
            65535: "N/A",
        },
    ),
    0xB04E: (
        "FocusMode",
        {
            0: "Manual",
            2: "AF-S",
            3: "AF-C",
            5: "Semi-manual",
            6: "DMF",
        },
    ),
    0xB04F: (
        "DynamicRangeOptimizer",
        {
            0: "Off",
            1: "Standard",
            2: "Plus",
        },
    ),
    0xB050: (
        "HighISONoiseReduction2",
        {
            0: "Normal",
            1: "High",
            2: "Low",
            3: "Off",
            65535: "N/A",
        },
    ),
    0xB052: (
        "IntelligentAuto",
        {
            0: "Off",
            1: "On",
            2: "Advanced",
        },
    ),
    0xB054: (
        "WhiteBalance",
        {
            0: "Auto",
            4: "Custom",
            5: "Daylight",
            6: "Cloudy",
            7: "Cool White Fluorescent",
            8: "Day White Fluorescent",
            9: "Daylight Fluorescent",
            10: "Incandescent2",
            11: "Warm White Fluorescent",
            14: "Incandescent",
            15: "Flash",
            17: "Underwater 1 (Blue Water)",
            18: "Underwater 2 (Green Water)",
            19: "Underwater Auto",
        },
    ),
}
