/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.BitwiseXORComposite;
import gnu.java.awt.ClasspathToolkit;
import gnu.java.awt.peer.gtk.GdkFontPeer;
import gnu.java.awt.peer.gtk.GdkPixbufDecoder;
import gnu.java.awt.peer.gtk.GdkTextLayout;
import gnu.java.awt.peer.gtk.GtkComponentPeer;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import gnu.java.awt.peer.gtk.GtkToolkit;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.CropImageFilter;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.ImagingOpException;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GdkGraphics2D
extends Graphics2D {
    private static BasicStroke draw3DRectStroke;
    private final int native_state;
    Paint paint;
    Stroke stroke;
    Color fg;
    Color bg;
    Shape clip;
    AffineTransform transform;
    private GtkComponentPeer component;
    Font font;
    private RenderingHints hints;
    private BufferedImage bimage;
    private boolean pixelConversionRequired;
    private int[] pixelBuffer;
    Composite comp;
    private Stack stateStack;
    private boolean shiftDrawCalls;

    static native void initStaticState();

    private final native void initStateUnlocked(GtkComponentPeer var1);

    private final native void initState(GtkComponentPeer var1);

    private final native void initState(int var1, int var2);

    private final native void initState(int[] var1, int var2, int var3);

    private final native void copyState(GdkGraphics2D var1);

    public native void dispose();

    private final native void cairoSurfaceSetFilter(int var1);

    private final native void cairoSurfaceSetFilterUnlocked(int var1);

    native void connectSignals(GtkComponentPeer var1);

    public void finalize() {
        this.dispose();
    }

    public Graphics create() {
        return new GdkGraphics2D(this);
    }

    public Graphics create(int x, int y, int width, int height) {
        return new GdkGraphics2D(this, x, y, width, height);
    }

    private final void fail_g2d() {
        System.err.println("Attempted to instantiate GdkGraphics2D but Graphics2D not enabled.  Try again with -Dgnu.java.awt.peer.gtk.Graphics=Graphics2D");
        System.exit(1);
    }

    void initComponentGraphics2D() {
        this.initState(this.component);
        this.setColor(this.component.awtComponent.getForeground());
        this.setBackground(this.component.awtComponent.getBackground());
        this.setPaint(this.getColor());
        this.setTransform(new AffineTransform());
        this.setStroke(new BasicStroke());
        this.setRenderingHints(this.getDefaultHints());
        this.setFont(new Font("SansSerif", 0, 12));
        this.stateStack = new Stack();
    }

    void initComponentGraphics2DUnlocked() {
        this.initStateUnlocked(this.component);
        this.setColorUnlocked(this.component.awtComponent.getForeground());
        this.setBackgroundUnlocked(this.component.awtComponent.getBackground());
        this.setPaintUnlocked(this.getColorUnlocked());
        this.setTransformUnlocked(new AffineTransform());
        this.setStrokeUnlocked(new BasicStroke());
        this.setRenderingHintsUnlocked(this.getDefaultHints());
        this.setFontUnlocked(new Font("SansSerif", 0, 12));
        this.stateStack = new Stack();
    }

    private final native void gdkDrawDrawable(GdkGraphics2D var1, int var2, int var3);

    private final native void drawPixels(int[] var1, int var2, int var3, int var4, double[] var5);

    private final native void setTexturePixelsUnlocked(int[] var1, int var2, int var3, int var4);

    private final native void setTexturePixels(int[] var1, int var2, int var3, int var4);

    private final native void setGradient(double var1, double var3, double var5, double var7, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, boolean var17);

    private final native void setGradientUnlocked(double var1, double var3, double var5, double var7, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, boolean var17);

    private final native void cairoSave();

    private final native void cairoRestore();

    private final native void cairoSetMatrix(double[] var1);

    private final native void cairoSetMatrixUnlocked(double[] var1);

    private final native void cairoSetOperator(int var1);

    private final native void cairoSetRGBAColor(double var1, double var3, double var5, double var7);

    private final native void cairoSetRGBAColorUnlocked(double var1, double var3, double var5, double var7);

    private final native void cairoSetFillRule(int var1);

    private final native void cairoSetLineWidth(double var1);

    private final native void cairoSetLineWidthUnlocked(double var1);

    private final native void cairoSetLineCap(int var1);

    private final native void cairoSetLineCapUnlocked(int var1);

    private final native void cairoSetLineJoin(int var1);

    private final native void cairoSetLineJoinUnlocked(int var1);

    private final native void cairoSetDash(double[] var1, int var2, double var3);

    private final native void cairoSetDashUnlocked(double[] var1, int var2, double var3);

    private final native void cairoSetMiterLimit(double var1);

    private final native void cairoSetMiterLimitUnlocked(double var1);

    private final native void cairoNewPath();

    private final native void cairoMoveTo(double var1, double var3);

    private final native void cairoLineTo(double var1, double var3);

    private final native void cairoCurveTo(double var1, double var3, double var5, double var7, double var9, double var11);

    private final native void cairoRelMoveTo(double var1, double var3);

    private final native void cairoRelLineTo(double var1, double var3);

    private final native void cairoRelCurveTo(double var1, double var3, double var5, double var7, double var9, double var11);

    private final native void cairoRectangle(double var1, double var3, double var5, double var7);

    private final native void cairoClosePath();

    private final native void cairoStroke();

    private final native void cairoFill();

    private final native void cairoClip();

    private final void stateSave() {
        this.stateStack.push(new DrawState(this));
        this.cairoSave();
    }

    private final void stateRestore() {
        ((DrawState)this.stateStack.pop()).restore(this);
        this.cairoRestore();
    }

    private final double shifted(double coord, boolean doShift) {
        if (doShift) {
            return Math.floor(coord) + 0.5;
        }
        return coord;
    }

    private final void walkPath(PathIterator p, boolean doShift) {
        double x = 0.0;
        double y = 0.0;
        double[] coords = new double[6];
        this.cairoSetFillRule(p.getWindingRule());
        while (!p.isDone()) {
            int seg = p.currentSegment(coords);
            switch (seg) {
                case 0: {
                    x = this.shifted(coords[0], doShift);
                    y = this.shifted(coords[1], doShift);
                    this.cairoMoveTo(x, y);
                    break;
                }
                case 1: {
                    x = this.shifted(coords[0], doShift);
                    y = this.shifted(coords[1], doShift);
                    this.cairoLineTo(x, y);
                    break;
                }
                case 2: {
                    double x1 = x + 0.6666666666666666 * (this.shifted(coords[0], doShift) - x);
                    double y1 = y + 0.6666666666666666 * (this.shifted(coords[1], doShift) - y);
                    double x2 = x1 + 0.3333333333333333 * (this.shifted(coords[2], doShift) - x);
                    double y2 = y1 + 0.3333333333333333 * (this.shifted(coords[3], doShift) - y);
                    x = this.shifted(coords[2], doShift);
                    y = this.shifted(coords[3], doShift);
                    this.cairoCurveTo(x1, y1, x2, y2, x, y);
                    break;
                }
                case 3: {
                    x = this.shifted(coords[4], doShift);
                    y = this.shifted(coords[5], doShift);
                    this.cairoCurveTo(this.shifted(coords[0], doShift), this.shifted(coords[1], doShift), this.shifted(coords[2], doShift), this.shifted(coords[3], doShift), x, y);
                    break;
                }
                case 4: {
                    this.cairoClosePath();
                    break;
                }
            }
            p.next();
        }
    }

    private final Map getDefaultHints() {
        HashMap defaultHints = new HashMap();
        defaultHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        defaultHints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        defaultHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        defaultHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        defaultHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        return defaultHints;
    }

    public static int[] findSimpleIntegerArray(ColorModel cm, Raster raster) {
        if (cm == null || raster == null) {
            return null;
        }
        if (!cm.getColorSpace().isCS_sRGB()) {
            return null;
        }
        if (!(cm instanceof DirectColorModel)) {
            return null;
        }
        DirectColorModel dcm = (DirectColorModel)cm;
        if (dcm.getRedMask() != 0xFF0000 || dcm.getGreenMask() != 65280 || dcm.getBlueMask() != 255) {
            return null;
        }
        if (!(raster instanceof WritableRaster)) {
            return null;
        }
        if (raster.getSampleModel().getDataType() != 3) {
            return null;
        }
        if (!(raster.getDataBuffer() instanceof DataBufferInt)) {
            return null;
        }
        DataBufferInt db = (DataBufferInt)raster.getDataBuffer();
        if (db.getNumBanks() != 1) {
            return null;
        }
        return db.getData();
    }

    private final void updateBufferedImage() {
        if (this.bimage != null && this.pixelConversionRequired) {
            int height = this.bimage.getHeight();
            int width = this.bimage.getWidth();
            int index = 0;
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    this.bimage.setRGB(x, y, this.pixelBuffer[index++]);
                    ++x;
                }
                ++y;
            }
        }
    }

    private final boolean drawImage(Image img, AffineTransform xform, Color bgcolor, ImageObserver obs) {
        if (img == null) {
            return false;
        }
        AffineTransform invertedXform = new AffineTransform();
        try {
            invertedXform = xform.createInverse();
            if (img instanceof BufferedImage) {
                BufferedImage b = (BufferedImage)img;
                return this.drawRaster(b.getColorModel(), b.getTile(0, 0), invertedXform, bgcolor);
            }
            return this.drawImage((Image)GdkPixbufDecoder.createBufferedImage(img.getSource()), xform, bgcolor, obs);
        }
        catch (NoninvertibleTransformException e) {
            throw new ImagingOpException("Unable to invert transform " + xform.toString());
        }
    }

    public void draw(Shape s) {
        if (this.stroke != null && !(this.stroke instanceof BasicStroke)) {
            this.fill(this.stroke.createStrokedShape(s));
            return;
        }
        this.cairoNewPath();
        if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            this.cairoRectangle(this.shifted(r.getX(), this.shiftDrawCalls), this.shifted(r.getY(), this.shiftDrawCalls), r.getWidth(), r.getHeight());
        } else {
            this.walkPath(s.getPathIterator(null), this.shiftDrawCalls);
        }
        this.cairoStroke();
        this.updateBufferedImage();
    }

    public void fill(Shape s) {
        this.cairoNewPath();
        if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            this.cairoRectangle(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        } else {
            this.walkPath(s.getPathIterator(null), false);
        }
        this.cairoFill();
        this.updateBufferedImage();
    }

    public void clip(Shape s) {
        Rectangle2D r;
        if (this.clip == null || s == null) {
            this.clip = s;
        } else if (s instanceof Rectangle2D && this.clip instanceof Rectangle2D) {
            r = (Rectangle2D)s;
            Rectangle2D curr = (Rectangle2D)this.clip;
            this.clip = curr.createIntersection(r);
        } else {
            throw new UnsupportedOperationException();
        }
        if (this.clip != null) {
            this.cairoNewPath();
            if (this.clip instanceof Rectangle2D) {
                r = (Rectangle2D)this.clip;
                this.cairoRectangle(r.getX(), r.getY(), r.getWidth(), r.getHeight());
            } else {
                this.walkPath(this.clip.getPathIterator(null), false);
            }
            this.cairoClip();
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    public void setPaint(Paint p) {
        if (this.paint == null) {
            return;
        }
        this.paint = p;
        if (this.paint instanceof Color) {
            this.setColor((Color)this.paint);
        } else if (this.paint instanceof TexturePaint) {
            TexturePaint tp = (TexturePaint)this.paint;
            BufferedImage img = tp.getImage();
            int width = (int)tp.getAnchorRect().getWidth();
            int height = (int)tp.getAnchorRect().getHeight();
            double scaleX = (double)width / (double)img.getWidth();
            double scaleY = (double)width / (double)img.getHeight();
            AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, scaleY, 0.0, 0.0);
            AffineTransformOp op = new AffineTransformOp(at, this.getRenderingHints());
            BufferedImage texture = op.filter(img, null);
            int[] pixels = texture.getRGB(0, 0, width, height, null, 0, width);
            this.setTexturePixels(pixels, width, height, width);
        } else if (this.paint instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)this.paint;
            Point2D p1 = gp.getPoint1();
            Point2D p2 = gp.getPoint2();
            Color c1 = gp.getColor1();
            Color c2 = gp.getColor2();
            this.setGradient(p1.getX(), p1.getY(), p2.getX(), p2.getY(), c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha(), c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha(), gp.isCyclic());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setPaintUnlocked(Paint p) {
        if (this.paint == null) {
            return;
        }
        this.paint = p;
        if (this.paint instanceof Color) {
            this.setColorUnlocked((Color)this.paint);
        } else if (this.paint instanceof TexturePaint) {
            TexturePaint tp = (TexturePaint)this.paint;
            BufferedImage img = tp.getImage();
            int width = (int)tp.getAnchorRect().getWidth();
            int height = (int)tp.getAnchorRect().getHeight();
            double scaleX = (double)width / (double)img.getWidth();
            double scaleY = (double)width / (double)img.getHeight();
            AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, scaleY, 0.0, 0.0);
            AffineTransformOp op = new AffineTransformOp(at, this.getRenderingHints());
            BufferedImage texture = op.filter(img, null);
            int[] pixels = texture.getRGB(0, 0, width, height, null, 0, width);
            this.setTexturePixelsUnlocked(pixels, width, height, width);
        } else if (this.paint instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)this.paint;
            Point2D p1 = gp.getPoint1();
            Point2D p2 = gp.getPoint2();
            Color c1 = gp.getColor1();
            Color c2 = gp.getColor2();
            this.setGradientUnlocked(p1.getX(), p1.getY(), p2.getX(), p2.getY(), c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha(), c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha(), gp.isCyclic());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setTransform(AffineTransform tx) {
        this.transform = tx;
        if (this.transform != null) {
            double[] m = new double[6];
            this.transform.getMatrix(m);
            this.cairoSetMatrix(m);
        }
    }

    public void setTransformUnlocked(AffineTransform tx) {
        this.transform = tx;
        if (this.transform != null) {
            double[] m = new double[6];
            this.transform.getMatrix(m);
            this.cairoSetMatrixUnlocked(m);
        }
    }

    public void transform(AffineTransform tx) {
        if (this.transform == null) {
            this.transform = new AffineTransform(tx);
        } else {
            this.transform.concatenate(tx);
        }
        this.setTransform(this.transform);
        if (this.clip != null) {
            Rectangle2D r = this.clip.getBounds2D();
            double[] coords = new double[]{r.getX(), r.getY(), r.getX() + r.getWidth(), r.getY() + r.getHeight()};
            try {
                tx.createInverse().transform(coords, 0, coords, 0, 2);
                r.setRect(coords[0], coords[1], coords[2] - coords[0], coords[3] - coords[1]);
                this.clip = r;
            }
            catch (NoninvertibleTransformException e) {
                // empty catch block
            }
        }
    }

    public void rotate(double theta) {
        this.transform(AffineTransform.getRotateInstance(theta));
    }

    public void rotate(double theta, double x, double y) {
        this.transform(AffineTransform.getRotateInstance(theta, x, y));
    }

    public void scale(double sx, double sy) {
        this.transform(AffineTransform.getScaleInstance(sx, sy));
    }

    public void translate(double tx, double ty) {
        this.transform(AffineTransform.getTranslateInstance(tx, ty));
    }

    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    public void shear(double shearX, double shearY) {
        this.transform(AffineTransform.getShearInstance(shearX, shearY));
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke st) {
        this.stroke = st;
        if (this.stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this.stroke;
            this.cairoSetLineCap(bs.getEndCap());
            this.cairoSetLineWidth(bs.getLineWidth());
            this.cairoSetLineJoin(bs.getLineJoin());
            this.cairoSetMiterLimit(bs.getMiterLimit());
            float[] dashes = bs.getDashArray();
            if (dashes != null) {
                double[] double_dashes = new double[dashes.length];
                int i = 0;
                while (i < dashes.length) {
                    double_dashes[i] = dashes[i];
                    ++i;
                }
                this.cairoSetDash(double_dashes, double_dashes.length, bs.getDashPhase());
            } else {
                this.cairoSetDash(new double[0], 0, 0.0);
            }
        }
    }

    public void setStrokeUnlocked(Stroke st) {
        this.stroke = st;
        if (this.stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this.stroke;
            this.cairoSetLineCapUnlocked(bs.getEndCap());
            this.cairoSetLineWidthUnlocked(bs.getLineWidth());
            this.cairoSetLineJoinUnlocked(bs.getLineJoin());
            this.cairoSetMiterLimitUnlocked(bs.getMiterLimit());
            float[] dashes = bs.getDashArray();
            if (dashes != null) {
                double[] double_dashes = new double[dashes.length];
                int i = 0;
                while (i < dashes.length) {
                    double_dashes[i] = dashes[i];
                    ++i;
                }
                this.cairoSetDashUnlocked(double_dashes, double_dashes.length, bs.getDashPhase());
            } else {
                this.cairoSetDashUnlocked(new double[0], 0, 0.0);
            }
        }
    }

    public void setPaintMode() {
        this.setComposite(AlphaComposite.SrcOver);
    }

    public void setXORMode(Color c) {
        this.setComposite(new BitwiseXORComposite(c));
    }

    public void setColor(Color c) {
        if (c == null) {
            c = Color.BLACK;
        }
        this.fg = c;
        this.paint = c;
        this.cairoSetRGBAColor((double)this.fg.getRed() / 255.0, (double)this.fg.getGreen() / 255.0, (double)this.fg.getBlue() / 255.0, (double)this.fg.getAlpha() / 255.0);
    }

    public void setColorUnlocked(Color c) {
        if (c == null) {
            c = Color.BLACK;
        }
        this.fg = c;
        this.paint = c;
        this.cairoSetRGBAColorUnlocked((double)this.fg.getRed() / 255.0, (double)this.fg.getGreen() / 255.0, (double)this.fg.getBlue() / 255.0, (double)this.fg.getAlpha() / 255.0);
    }

    public Color getColor() {
        return this.fg;
    }

    public Color getColorUnlocked() {
        return this.getColor();
    }

    public void clipRect(int x, int y, int width, int height) {
        this.clip(new Rectangle(x, y, width, height));
    }

    public Shape getClip() {
        if (this.clip == null) {
            return null;
        }
        return this.clip.getBounds2D();
    }

    public Rectangle getClipBounds() {
        if (this.clip == null) {
            return null;
        }
        return this.clip.getBounds();
    }

    protected Rectangle2D getClipInDevSpace() {
        Rectangle2D uclip = this.clip.getBounds2D();
        if (this.transform == null) {
            return uclip;
        }
        Point2D pos = this.transform.transform(new Point2D.Double(uclip.getX(), uclip.getY()), null);
        Point2D extent = this.transform.deltaTransform(new Point2D.Double(uclip.getWidth(), uclip.getHeight()), null);
        return new Rectangle2D.Double(pos.getX(), pos.getY(), extent.getX(), extent.getY());
    }

    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle2D.Double(x, y, width, height));
    }

    public void setClip(Shape s) {
        this.clip = s;
        if (this.clip == null) {
            if (this.component != null) {
                Dimension d = this.component.awtComponent.getSize();
                this.setClip(0, 0, d.width, d.height);
            }
        } else {
            this.cairoNewPath();
            if (s instanceof Rectangle2D) {
                Rectangle2D r = (Rectangle2D)s;
                this.cairoRectangle(r.getX(), r.getY(), r.getWidth(), r.getHeight());
            } else {
                this.walkPath(s.getPathIterator(null), false);
            }
            this.cairoClip();
        }
    }

    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        Stroke tmp = this.stroke;
        this.setStroke(draw3DRectStroke);
        super.draw3DRect(x, y, width, height, raised);
        this.setStroke(tmp);
        this.updateBufferedImage();
    }

    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        Stroke tmp = this.stroke;
        this.setStroke(draw3DRectStroke);
        super.fill3DRect(x, y, width, height, raised);
        this.setStroke(tmp);
        this.updateBufferedImage();
    }

    public void drawRect(int x, int y, int width, int height) {
        this.draw(new Rectangle(x, y, width, height));
    }

    public void fillRect(int x, int y, int width, int height) {
        this.cairoNewPath();
        this.cairoRectangle(x, y, width, height);
        this.cairoFill();
    }

    public void clearRect(int x, int y, int width, int height) {
        if (this.bg != null) {
            this.cairoSetRGBAColor((double)this.bg.getRed() / 255.0, (double)this.bg.getGreen() / 255.0, (double)this.bg.getBlue() / 255.0, 1.0);
        }
        this.cairoNewPath();
        this.cairoRectangle(x, y, width, height);
        this.cairoFill();
        this.setColor(this.fg);
        this.updateBufferedImage();
    }

    public void setBackground(Color c) {
        this.bg = c;
    }

    public void setBackgroundUnlocked(Color c) {
        this.setBackground(c);
    }

    public Color getBackground() {
        return this.bg;
    }

    private final void doPolygon(int[] xPoints, int[] yPoints, int nPoints, boolean close, boolean fill) {
        if (nPoints < 1) {
            return;
        }
        GeneralPath gp = new GeneralPath(0);
        gp.moveTo(xPoints[0], yPoints[0]);
        int i = 1;
        while (i < nPoints) {
            gp.lineTo(xPoints[i], yPoints[i]);
            ++i;
        }
        if (close) {
            gp.closePath();
        }
        Shape sh = gp;
        if (!fill && this.stroke != null && !(this.stroke instanceof BasicStroke)) {
            sh = this.stroke.createStrokedShape(gp);
            fill = true;
        }
        if (fill) {
            this.fill(sh);
        } else {
            this.draw(sh);
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        int[] xp = new int[2];
        int[] yp = new int[2];
        xp[0] = x1;
        xp[1] = x2;
        yp[0] = y1;
        yp[1] = y2;
        this.doPolygon(xp, yp, 2, false, false);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.doPolygon(xPoints, yPoints, nPoints, true, true);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.doPolygon(xPoints, yPoints, nPoints, true, false);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.doPolygon(xPoints, yPoints, nPoints, false, false);
    }

    private final boolean drawRaster(ColorModel cm, Raster r, AffineTransform imageToUser, Color bgcolor) {
        int i;
        if (r == null) {
            return false;
        }
        SampleModel sm = r.getSampleModel();
        DataBuffer db = r.getDataBuffer();
        if (db == null || sm == null) {
            return false;
        }
        if (cm == null) {
            cm = ColorModel.getRGBdefault();
        }
        double[] i2u = new double[6];
        if (imageToUser != null) {
            imageToUser.getMatrix(i2u);
        } else {
            i2u[0] = 1.0;
            i2u[1] = 0.0;
            i2u[2] = 0.0;
            i2u[3] = 1.0;
            i2u[4] = 0.0;
            i2u[5] = 0.0;
        }
        int[] pixels = GdkGraphics2D.findSimpleIntegerArray(cm, r);
        if (pixels == null) {
            if (sm instanceof MultiPixelPackedSampleModel) {
                pixels = r.getPixels(0, 0, r.getWidth(), r.getHeight(), pixels);
                i = 0;
                while (i < pixels.length) {
                    pixels[i] = cm.getRGB(pixels[i]);
                    ++i;
                }
            } else {
                pixels = new int[r.getWidth() * r.getHeight()];
                i = 0;
                while (i < pixels.length) {
                    pixels[i] = cm.getRGB(db.getElem(i));
                    ++i;
                }
            }
        }
        if (cm.hasAlpha()) {
            if (bgcolor != null && cm.hasAlpha()) {
                i = 0;
                while (i < pixels.length) {
                    if (cm.getAlpha(pixels[i]) == 0) {
                        pixels[i] = bgcolor.getRGB();
                    }
                    ++i;
                }
            }
        } else {
            i = 0;
            while (i < pixels.length) {
                int n = i++;
                pixels[n] = pixels[n] | 0xFF000000;
            }
        }
        this.drawPixels(pixels, r.getWidth(), r.getHeight(), r.getWidth(), i2u);
        this.updateBufferedImage();
        return true;
    }

    public void drawRenderedImage(RenderedImage image, AffineTransform xform) {
        this.drawRaster(image.getColorModel(), image.getData(), xform, this.bg);
    }

    public void drawRenderableImage(RenderableImage image, AffineTransform xform) {
        this.drawRenderedImage(image.createRendering(new RenderContext(xform)), xform);
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.drawImage(img, xform, this.bg, obs);
    }

    public void drawImage(BufferedImage image, BufferedImageOp op, int x, int y) {
        BufferedImage filtered = op.filter(image, null);
        this.drawImage((Image)filtered, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), this.bg, null);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), this.bg, observer);
    }

    public boolean hit(Rectangle rect, Shape text, boolean onStroke) {
        throw new UnsupportedOperationException();
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        throw new UnsupportedOperationException();
    }

    public void setComposite(Composite comp) {
        this.comp = comp;
        if (!(comp instanceof AlphaComposite)) {
            throw new UnsupportedOperationException();
        }
        AlphaComposite a = (AlphaComposite)comp;
        this.cairoSetOperator(a.getRule());
        Color c = this.getColor();
        this.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(a.getAlpha() * (float)c.getAlpha())));
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.hints.put(hintKey, hintValue);
        if (hintKey.equals(RenderingHints.KEY_INTERPOLATION) || hintKey.equals(RenderingHints.KEY_ALPHA_INTERPOLATION)) {
            if (hintValue.equals(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR)) {
                this.cairoSurfaceSetFilter(0);
            } else if (hintValue.equals(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
                this.cairoSurfaceSetFilter(1);
            } else if (hintValue.equals(RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED)) {
                this.cairoSurfaceSetFilter(2);
            } else if (hintValue.equals(RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY)) {
                this.cairoSurfaceSetFilter(3);
            } else if (hintValue.equals(RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT)) {
                this.cairoSurfaceSetFilter(4);
            }
        }
        boolean bl = false;
        if (this.hints.containsValue(RenderingHints.VALUE_STROKE_NORMALIZE) || this.hints.containsValue(RenderingHints.VALUE_STROKE_DEFAULT)) {
            bl = true;
        }
        this.shiftDrawCalls = bl;
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.hints.get(hintKey);
    }

    public void setRenderingHints(Map hints) {
        this.hints = new RenderingHints(this.getDefaultHints());
        this.hints.add(new RenderingHints(hints));
        if (hints.containsKey(RenderingHints.KEY_INTERPOLATION)) {
            if (hints.containsValue(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR)) {
                this.cairoSurfaceSetFilter(0);
            } else if (hints.containsValue(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
                this.cairoSurfaceSetFilter(1);
            }
        }
        if (hints.containsKey(RenderingHints.KEY_ALPHA_INTERPOLATION)) {
            if (hints.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED)) {
                this.cairoSurfaceSetFilter(2);
            } else if (hints.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY)) {
                this.cairoSurfaceSetFilter(3);
            } else if (hints.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT)) {
                this.cairoSurfaceSetFilter(4);
            }
        }
        boolean bl = false;
        if (hints.containsValue(RenderingHints.VALUE_STROKE_NORMALIZE) || hints.containsValue(RenderingHints.VALUE_STROKE_DEFAULT)) {
            bl = true;
        }
        this.shiftDrawCalls = bl;
    }

    public void setRenderingHintsUnlocked(Map hints) {
        this.hints = new RenderingHints(this.getDefaultHints());
        this.hints.add(new RenderingHints(hints));
        if (hints.containsKey(RenderingHints.KEY_INTERPOLATION)) {
            if (hints.containsValue(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR)) {
                this.cairoSurfaceSetFilterUnlocked(0);
            } else if (hints.containsValue(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
                this.cairoSurfaceSetFilterUnlocked(1);
            }
        }
        if (hints.containsKey(RenderingHints.KEY_ALPHA_INTERPOLATION)) {
            if (hints.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED)) {
                this.cairoSurfaceSetFilterUnlocked(2);
            } else if (hints.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY)) {
                this.cairoSurfaceSetFilterUnlocked(3);
            } else if (hints.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT)) {
                this.cairoSurfaceSetFilterUnlocked(4);
            }
        }
        boolean bl = false;
        if (hints.containsValue(RenderingHints.VALUE_STROKE_NORMALIZE) || hints.containsValue(RenderingHints.VALUE_STROKE_DEFAULT)) {
            bl = true;
        }
        this.shiftDrawCalls = bl;
    }

    public void addRenderingHints(Map hints) {
        this.hints.add(new RenderingHints(hints));
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public Composite getComposite() {
        if (this.comp == null) {
            return AlphaComposite.SrcOver;
        }
        return this.comp;
    }

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(this.transform, true, true);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        GdkGraphics2D g = (GdkGraphics2D)this.create(x, y, width, height);
        this.gdkDrawDrawable(g, x + dx, y + dy);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.draw(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0));
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        double scaleX = (double)width / (double)img.getWidth(observer);
        double scaleY = (double)height / (double)img.getHeight(observer);
        return this.drawImage(img, new AffineTransform(scaleX, 0.0, 0.0, scaleY, (double)x, (double)y), bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, this.bg, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        Image subImage;
        if (img == null) {
            return false;
        }
        int sourceWidth = sx2 - sx1;
        int sourceHeight = sy2 - sy1;
        int destWidth = dx2 - dx1;
        int destHeight = dy2 - dy1;
        double scaleX = (double)destWidth / (double)sourceWidth;
        double scaleY = (double)destHeight / (double)sourceHeight;
        if (img instanceof BufferedImage) {
            BufferedImage b = (BufferedImage)img;
            subImage = b.getSubimage(sx1, sy1, sx2, sy2);
        } else {
            CropImageFilter filter = new CropImageFilter(sx1, sx2, sx2, sy2);
            FilteredImageSource src = new FilteredImageSource(img.getSource(), filter);
            subImage = Toolkit.getDefaultToolkit().createImage(src);
        }
        return this.drawImage(subImage, new AffineTransform(scaleX, 0.0, 0.0, scaleY, (double)dx1, (double)dy1), bgcolor, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this.bg, observer);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.drawArc(x, y, width, height, 0, 360);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (arcWidth > width) {
            arcWidth = width;
        }
        if (arcHeight > height) {
            arcHeight = height;
        }
        int xx = x + width - arcWidth;
        int yy = y + height - arcHeight;
        this.drawArc(x, y, arcWidth, arcHeight, 90, 90);
        this.drawArc(xx, y, arcWidth, arcHeight, 0, 90);
        this.drawArc(xx, yy, arcWidth, arcHeight, 270, 90);
        this.drawArc(x, yy, arcWidth, arcHeight, 180, 90);
        int y1 = y + arcHeight / 2;
        int y2 = y + height - arcHeight / 2;
        this.drawLine(x, y1, x, y2);
        this.drawLine(x + width, y1, x + width, y2);
        int x1 = x + arcWidth / 2;
        int x2 = x + width - arcWidth / 2;
        this.drawLine(x1, y, x2, y);
        this.drawLine(x1, y + height, x2, y + height);
    }

    native void cairoDrawGlyphVector(GdkFontPeer var1, float var2, float var3, int var4, int[] var5, float[] var6);

    native void cairoDrawGdkTextLayout(GdkTextLayout var1, float var2, float var3);

    GdkFontPeer getFontPeer() {
        return (GdkFontPeer)this.getFont().getPeer();
    }

    public void drawGdkTextLayout(GdkTextLayout gl, float x, float y) {
        this.cairoDrawGdkTextLayout(gl, x, y);
        this.updateBufferedImage();
    }

    public void drawString(String str, float x, float y) {
        if (str == null || str.length() == 0) {
            return;
        }
        this.drawGlyphVector(this.getFont().createGlyphVector(null, str), x, y);
        this.updateBufferedImage();
    }

    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    public void drawString(AttributedCharacterIterator ci, int x, int y) {
        this.drawString(ci, (float)x, (float)y);
    }

    public void drawGlyphVector(GlyphVector gv, float x, float y) {
        int n = gv.getNumGlyphs();
        int[] codes = gv.getGlyphCodes(0, n, null);
        float[] positions = gv.getGlyphPositions(0, n, null);
        this.setFont(gv.getFont());
        this.cairoDrawGlyphVector(this.getFontPeer(), x, y, n, codes, positions);
        this.updateBufferedImage();
    }

    public void drawString(AttributedCharacterIterator ci, float x, float y) {
        GlyphVector gv = this.getFont().createGlyphVector(this.getFontRenderContext(), ci);
        this.drawGlyphVector(gv, x, y);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fill(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0));
    }

    public void fillOval(int x, int y, int width, int height) {
        this.fillArc(x, y, width, height, 0, 360);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (arcWidth > width) {
            arcWidth = width;
        }
        if (arcHeight > height) {
            arcHeight = height;
        }
        int xx = x + width - arcWidth;
        int yy = y + height - arcHeight;
        this.fillArc(x, y, arcWidth, arcHeight, 90, 90);
        this.fillArc(xx, y, arcWidth, arcHeight, 0, 90);
        this.fillArc(xx, yy, arcWidth, arcHeight, 270, 90);
        this.fillArc(x, yy, arcWidth, arcHeight, 180, 90);
        this.fillRect(x, y + arcHeight / 2, width, height - arcHeight + 1);
        this.fillRect(x + arcWidth / 2, y, width - arcWidth + 1, height);
    }

    public Font getFont() {
        if (this.font == null) {
            return new Font("SansSerif", 0, 12);
        }
        return this.font;
    }

    static native void releasePeerGraphicsResource(GdkFontPeer var0);

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public FontMetrics getFontMetrics(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    public void setFont(Font f) {
        if (f == null) {
            return;
        }
        this.font = f.getPeer() instanceof GdkFontPeer ? f : ((ClasspathToolkit)Toolkit.getDefaultToolkit()).getFont(f.getName(), f.getAttributes());
    }

    public void setFontUnlocked(Font f) {
        this.setFont(f);
    }

    public String toString() {
        return this.getClass().getName() + "[font=" + this.getFont().toString() + ",color=" + this.fg.toString() + ']';
    }

    private final /* synthetic */ void this() {
        this.native_state = GtkGenericPeer.getUniqueInteger();
        this.shiftDrawCalls = false;
    }

    GdkGraphics2D(GdkGraphics2D g) {
        this.this();
        if (!GtkToolkit.useGraphics2D()) {
            this.fail_g2d();
        }
        this.paint = g.paint;
        this.stroke = g.stroke;
        this.setRenderingHints(g.hints);
        this.fg = g.fg.getAlpha() != -1 ? new Color(g.fg.getRed(), g.fg.getGreen(), g.fg.getBlue(), g.fg.getAlpha()) : new Color(g.fg.getRGB());
        this.bg = g.bg.getAlpha() != -1 ? new Color(g.bg.getRed(), g.bg.getGreen(), g.bg.getBlue(), g.bg.getAlpha()) : new Color(g.bg.getRGB());
        this.clip = g.clip == null ? null : new Rectangle(g.getClipBounds());
        this.transform = g.transform == null ? new AffineTransform() : new AffineTransform(g.transform);
        this.font = g.font;
        this.component = g.component;
        this.copyState(g);
        this.setColor(this.fg);
        this.setBackground(this.bg);
        this.setPaint(this.paint);
        this.setStroke(this.stroke);
        this.setTransform(this.transform);
        this.setClip(this.clip);
        this.stateStack = new Stack();
    }

    GdkGraphics2D(GdkGraphics2D g, int x, int y, int widht, int height) {
        this(g);
        this.translate(x, y);
        this.clipRect(0, 0, widht, height);
    }

    GdkGraphics2D(int width, int height) {
        this.this();
        if (!GtkToolkit.useGraphics2D()) {
            this.fail_g2d();
        }
        this.initState(width, height);
        this.setColor(Color.black);
        this.setBackground(new Color(0, 0, 0, 0));
        this.setPaint(this.getColor());
        this.setFont(new Font("SansSerif", 0, 12));
        this.setTransform(new AffineTransform());
        this.setStroke(new BasicStroke());
        this.setRenderingHints(this.getDefaultHints());
        this.stateStack = new Stack();
    }

    GdkGraphics2D(GtkComponentPeer component) {
        this.this();
        if (!GtkToolkit.useGraphics2D()) {
            this.fail_g2d();
        }
        this.component = component;
        if (component.isRealized()) {
            this.initComponentGraphics2D();
        } else {
            this.connectSignals(component);
        }
    }

    GdkGraphics2D(BufferedImage bimage) {
        this.this();
        this.bimage = bimage;
        this.pixelBuffer = GdkGraphics2D.findSimpleIntegerArray(bimage.getColorModel(), bimage.getRaster());
        if (this.pixelBuffer == null) {
            this.pixelBuffer = new int[bimage.getRaster().getWidth() * bimage.getRaster().getHeight()];
            this.pixelConversionRequired = true;
        } else {
            this.pixelConversionRequired = false;
        }
        this.initState(this.pixelBuffer, bimage.getWidth(), bimage.getHeight());
        this.setColor(Color.black);
        this.setBackground(new Color(0, 0, 0, 0));
        this.setPaint(this.getColor());
        this.setFont(new Font("SansSerif", 0, 12));
        this.setTransform(new AffineTransform());
        this.setStroke(new BasicStroke());
        this.setRenderingHints(this.getDefaultHints());
        this.stateStack = new Stack();
        if (this.pixelConversionRequired) {
            this.drawImage((Image)bimage, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), this.bg, null);
        }
    }

    static {
        throw new Error("Graphics2D not implemented. Cairo was not found or disabled at configure time");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class DrawState {
        private Paint paint;
        private Stroke stroke;
        private Color fg;
        private Color bg;
        private Shape clip;
        private AffineTransform transform;
        private Font font;
        private Composite comp;

        public void restore(GdkGraphics2D g) {
            g.paint = this.paint;
            g.stroke = this.stroke;
            g.fg = this.fg;
            g.bg = this.bg;
            g.clip = this.clip;
            g.transform = this.transform;
            g.font = this.font;
            g.comp = this.comp;
        }

        DrawState(GdkGraphics2D g) {
            this.paint = g.paint;
            this.stroke = g.stroke;
            this.fg = g.fg;
            this.bg = g.bg;
            this.clip = g.clip;
            if (g.transform != null) {
                this.transform = (AffineTransform)g.transform.clone();
            }
            this.font = g.font;
            this.comp = g.comp;
        }
    }
}

