/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.provider.GnuDHPublicKey;
import gnu.java.security.provider.GnuDSAPrivateKey;
import gnu.java.security.provider.GnuDSAPublicKey;
import gnu.java.security.provider.GnuRSAPrivateKey;
import gnu.java.security.provider.GnuRSAPublicKey;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.spec.DHParameterSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EncodedKeyFactory
extends KeyFactorySpi {
    private static final OID ID_DSA = new OID("1.2.840.10040.4.1");
    private static final OID ID_RSA = new OID("1.2.840.113549.1.1.1");
    private static final OID ID_DH = new OID("1.2.840.10046.2.1");
    static /* synthetic */ Class class$java$security$spec$DSAParameterSpec;
    static /* synthetic */ Class class$java$security$spec$PKCS8EncodedKeySpec;
    static /* synthetic */ Class class$java$security$spec$X509EncodedKeySpec;

    public PublicKey engineGeneratePublic(KeySpec spec) throws InvalidKeySpecException {
        if (!(spec instanceof X509EncodedKeySpec)) {
            throw new InvalidKeySpecException("only supports X.509 key specs");
        }
        DERReader der = new DERReader(((X509EncodedKeySpec)spec).getEncoded());
        try {
            DERValue spki = der.read();
            if (!spki.isConstructed()) {
                throw new InvalidKeySpecException("malformed encoded key");
            }
            DERValue alg = der.read();
            if (!alg.isConstructed()) {
                throw new InvalidKeySpecException("malformed encoded key");
            }
            DERValue val = der.read();
            if (!(val.getValue() instanceof OID)) {
                throw new InvalidKeySpecException("malformed encoded key");
            }
            OID algId = (OID)val.getValue();
            byte[] algParams = null;
            if (alg.getLength() > val.getEncodedLength()) {
                val = der.read();
                algParams = val.getEncoded();
                if (val.isConstructed()) {
                    der.skip(val.getLength());
                }
            }
            if (!((val = der.read()).getValue() instanceof BitString)) {
                throw new InvalidKeySpecException("malformed encoded key");
            }
            byte[] publicKey = ((BitString)val.getValue()).toByteArray();
            if (algId.equals(ID_DSA)) {
                DERReader dsaPub;
                BigInteger p = null;
                BigInteger g = null;
                BigInteger q = null;
                if (algParams != null) {
                    DERReader dsaParams = new DERReader(algParams);
                    val = dsaParams.read();
                    if (!val.isConstructed()) {
                        throw new InvalidKeySpecException("malformed DSA parameters");
                    }
                    val = dsaParams.read();
                    if (!(val.getValue() instanceof BigInteger)) {
                        throw new InvalidKeySpecException("malformed DSA parameters");
                    }
                    p = (BigInteger)val.getValue();
                    val = dsaParams.read();
                    if (!(val.getValue() instanceof BigInteger)) {
                        throw new InvalidKeySpecException("malformed DSA parameters");
                    }
                    q = (BigInteger)val.getValue();
                    val = dsaParams.read();
                    if (!(val.getValue() instanceof BigInteger)) {
                        throw new InvalidKeySpecException("malformed DSA parameters");
                    }
                    g = (BigInteger)val.getValue();
                }
                if (!((val = (dsaPub = new DERReader(publicKey)).read()).getValue() instanceof BigInteger)) {
                    throw new InvalidKeySpecException("malformed DSA parameters");
                }
                BigInteger Y = (BigInteger)val.getValue();
                return new GnuDSAPublicKey(Y, p, q, g);
            }
            if (algId.equals(ID_RSA)) {
                DERReader rsaParams = new DERReader(publicKey);
                if (!rsaParams.read().isConstructed()) {
                    throw new InvalidKeySpecException("malformed encoded key");
                }
                return new GnuRSAPublicKey(new RSAPublicKeySpec((BigInteger)rsaParams.read().getValue(), (BigInteger)rsaParams.read().getValue()));
            }
            if (algId.equals(ID_DH)) {
                if (algParams == null) {
                    throw new InvalidKeySpecException("missing DH parameters");
                }
                DERReader dhParams = new DERReader(algParams);
                val = dhParams.read();
                if (!val.isConstructed()) {
                    throw new InvalidKeySpecException("malformed DH parameters");
                }
                val = dhParams.read();
                if (!(val.getValue() instanceof BigInteger)) {
                    throw new InvalidKeySpecException("malformed DH parameters");
                }
                BigInteger p = (BigInteger)val.getValue();
                val = dhParams.read();
                if (!(val.getValue() instanceof BigInteger)) {
                    throw new InvalidKeySpecException("malformed DH parameters");
                }
                BigInteger g = (BigInteger)val.getValue();
                val = dhParams.read();
                if (!(val.getValue() instanceof BigInteger)) {
                    throw new InvalidKeySpecException("malformed DH parameters");
                }
                BigInteger q = (BigInteger)val.getValue();
                DERReader dhPub = new DERReader(publicKey);
                val = dhPub.read();
                if (!(val.getValue() instanceof BigInteger)) {
                    throw new InvalidKeySpecException("malformed DH parameters");
                }
                BigInteger Y = (BigInteger)val.getValue();
                return new GnuDHPublicKey(new DHParameterSpec(p, g), Y, q);
            }
            throw new InvalidKeySpecException("unknown algorithm: " + algId);
        }
        catch (IOException ioe) {
            throw new InvalidKeySpecException(ioe.getMessage());
        }
    }

    public PrivateKey engineGeneratePrivate(KeySpec spec) throws InvalidKeySpecException {
        if (!(spec instanceof PKCS8EncodedKeySpec)) {
            throw new InvalidKeySpecException("only supports PKCS8 key specs");
        }
        DERReader der = new DERReader(((PKCS8EncodedKeySpec)spec).getEncoded());
        try {
            DERValue pki = der.read();
            if (!pki.isConstructed()) {
                throw new InvalidKeySpecException("malformed encoded key");
            }
            DERValue val = der.read();
            if (!(val.getValue() instanceof BigInteger)) {
                throw new InvalidKeySpecException("malformed encoded key");
            }
            DERValue alg = der.read();
            if (!alg.isConstructed()) {
                throw new InvalidKeySpecException("malformed encoded key");
            }
            val = der.read();
            if (!(val.getValue() instanceof OID)) {
                throw new InvalidKeySpecException("malformed encoded key");
            }
            OID algId = (OID)val.getValue();
            byte[] algParams = null;
            if (alg.getLength() > val.getEncodedLength()) {
                val = der.read();
                algParams = val.getEncoded();
                if (val.isConstructed()) {
                    der.skip(val.getLength());
                }
            }
            byte[] privateKey = (byte[])der.read().getValue();
            if (algId.equals(ID_DSA)) {
                if (algParams == null) {
                    throw new InvalidKeySpecException("missing DSA parameters");
                }
                AlgorithmParameters params = AlgorithmParameters.getInstance("DSA");
                params.init(algParams);
                Class clazz = class$java$security$spec$DSAParameterSpec;
                if (clazz == null) {
                    clazz = class$java$security$spec$DSAParameterSpec = EncodedKeyFactory.class("[Ljava.security.spec.DSAParameterSpec;", false);
                }
                DSAParameterSpec dsaSpec = (DSAParameterSpec)params.getParameterSpec(clazz);
                DERReader dsaPriv = new DERReader(privateKey);
                return new GnuDSAPrivateKey((BigInteger)dsaPriv.read().getValue(), dsaSpec.getP(), dsaSpec.getQ(), dsaSpec.getG());
            }
            if (algId.equals(ID_RSA)) {
                DERReader rsaParams = new DERReader(privateKey);
                if (!rsaParams.read().isConstructed()) {
                    throw new InvalidKeySpecException("malformed encoded key");
                }
                return new GnuRSAPrivateKey(new RSAPrivateCrtKeySpec((BigInteger)rsaParams.read().getValue(), (BigInteger)rsaParams.read().getValue(), (BigInteger)rsaParams.read().getValue(), (BigInteger)rsaParams.read().getValue(), (BigInteger)rsaParams.read().getValue(), (BigInteger)rsaParams.read().getValue(), (BigInteger)rsaParams.read().getValue(), (BigInteger)rsaParams.read().getValue()));
            }
            throw new InvalidKeySpecException("unknown algorithm: " + algId);
        }
        catch (InvalidParameterSpecException iapse) {
            throw new InvalidKeySpecException(iapse.getMessage());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InvalidKeySpecException(nsae.getMessage());
        }
        catch (IOException ioe) {
            throw new InvalidKeySpecException(ioe.getMessage());
        }
    }

    public KeySpec engineGetKeySpec(Key key, Class speClass) throws InvalidKeySpecException {
        if (key instanceof PrivateKey && key.getFormat().equals("PKCS#8")) {
            Class clazz = class$java$security$spec$PKCS8EncodedKeySpec;
            if (clazz == null) {
                clazz = class$java$security$spec$PKCS8EncodedKeySpec = EncodedKeyFactory.class("[Ljava.security.spec.PKCS8EncodedKeySpec;", false);
            }
            if (speClass.isAssignableFrom(clazz)) {
                return new PKCS8EncodedKeySpec(key.getEncoded());
            }
        }
        if (key instanceof PublicKey && key.getFormat().equals("X.509")) {
            Class clazz = class$java$security$spec$X509EncodedKeySpec;
            if (clazz == null) {
                clazz = class$java$security$spec$X509EncodedKeySpec = EncodedKeyFactory.class("[Ljava.security.spec.X509EncodedKeySpec;", false);
            }
            if (speClass.isAssignableFrom(clazz)) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
        }
        throw new InvalidKeySpecException();
    }

    public Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new InvalidKeyException("translating keys not supported");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

