/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments.processors;

import edu.cornell.med.icb.identifier.DoubleIndexedIdentifier;
import edu.cornell.med.icb.identifier.IndexedIdentifier;
import it.unimi.dsi.lang.MutableString;
import org.campagnelab.goby.reads.RandomAccessSequenceInterface;

public class GenomeAlignmentTargetMapper {
    private final IndexedIdentifier targetIdentifiers;
    private final DoubleIndexedIdentifier reverse;
    private RandomAccessSequenceInterface genome;
    private int[] genomeToAlignment;
    private int[] alignmentToGenome;

    public GenomeAlignmentTargetMapper(IndexedIdentifier targetIdentifiers, RandomAccessSequenceInterface genome) {
        this.genome = genome;
        this.targetIdentifiers = targetIdentifiers;
        this.alignmentToGenome = new int[targetIdentifiers.size()];
        this.reverse = new DoubleIndexedIdentifier(targetIdentifiers);
        for (int alignmentTargetIndex = 0; alignmentTargetIndex < this.reverse.size(); ++alignmentTargetIndex) {
            MutableString id = this.reverse.getId(alignmentTargetIndex);
            this.alignmentToGenome[alignmentTargetIndex] = genome.getReferenceIndex(id.toString());
        }
        this.genomeToAlignment = new int[genome.size()];
        MutableString targetId = new MutableString();
        for (int genomeTargetIndex = 0; genomeTargetIndex < genome.size(); ++genomeTargetIndex) {
            String id = genome.getReferenceName(genomeTargetIndex);
            targetId.setLength(0);
            targetId.append(id);
            this.genomeToAlignment[genomeTargetIndex] = (Integer)targetIdentifiers.getOrDefault((Object)targetId, (Object)-1);
        }
    }

    int toGenome(int alignmentTargetIndex) {
        return this.alignmentToGenome[alignmentTargetIndex];
    }

    int toAlignment(int genomeTargetIndex) {
        return this.genomeToAlignment[genomeTargetIndex];
    }

    public String getAlignmentId(int targetIndex) {
        return this.reverse.getId(targetIndex).toString();
    }
}

