/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.CRAMBAIIndexer;
import htsjdk.samtools.CRAMIndexer;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.build.ContainerFactory;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.structure.CRAMEncodingStrategy;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;
import java.io.OutputStream;

public class CRAMContainerStreamWriter {
    private final OutputStream outputStream;
    private final String outputStreamIdentifier;
    private final SAMFileHeader samFileHeader;
    private final ContainerFactory containerFactory;
    private final CRAMIndexer cramIndexer;
    private long streamOffset = 0L;

    public CRAMContainerStreamWriter(OutputStream recordOutputStream, OutputStream indexOutputStream, CRAMReferenceSource source, SAMFileHeader samFileHeader, String outputIdentifier) {
        this(recordOutputStream, source, samFileHeader, outputIdentifier, indexOutputStream == null ? null : new CRAMBAIIndexer(indexOutputStream, samFileHeader));
    }

    public CRAMContainerStreamWriter(OutputStream outputStream, CRAMReferenceSource source, SAMFileHeader samFileHeader, String outputIdentifier, CRAMIndexer indexer) {
        this(new CRAMEncodingStrategy(), source, samFileHeader, outputStream, indexer, outputIdentifier);
    }

    public CRAMContainerStreamWriter(CRAMEncodingStrategy encodingStrategy, CRAMReferenceSource referenceSource, SAMFileHeader samFileHeader, OutputStream outputStream, CRAMIndexer indexer, String outputIdentifier) {
        this.samFileHeader = samFileHeader;
        this.outputStream = outputStream;
        this.cramIndexer = indexer;
        this.outputStreamIdentifier = outputIdentifier;
        this.containerFactory = new ContainerFactory(samFileHeader, encodingStrategy, referenceSource);
    }

    public void writeAlignment(SAMRecord alignment) {
        Container container = this.containerFactory.getNextContainer(alignment, this.streamOffset);
        if (container != null) {
            this.writeContainer(container);
        }
    }

    public void writeHeader(SAMFileHeader requestedSAMFileHeader) {
        CramHeader cramHeader = new CramHeader(CramVersions.DEFAULT_CRAM_VERSION, this.outputStreamIdentifier);
        this.streamOffset = CramIO.writeCramHeader(cramHeader, this.outputStream);
        this.streamOffset += Container.writeSAMFileHeaderContainer(cramHeader.getCRAMVersion(), requestedSAMFileHeader, this.outputStream);
    }

    public void writeHeader() {
        this.writeHeader(this.samFileHeader);
    }

    public void finish(boolean writeEOFContainer) {
        try {
            Container container = this.containerFactory.getFinalContainer(this.streamOffset);
            if (container != null) {
                this.writeContainer(container);
            }
            if (writeEOFContainer) {
                CramIO.writeCramEOF(CramVersions.DEFAULT_CRAM_VERSION, this.outputStream);
            }
            this.outputStream.flush();
            if (this.cramIndexer != null) {
                this.cramIndexer.finish();
            }
            this.outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    protected void writeContainer(Container container) {
        this.streamOffset += (long)container.write(CramVersions.DEFAULT_CRAM_VERSION, this.outputStream);
        if (this.cramIndexer != null) {
            this.cramIndexer.processContainer(container, ValidationStringency.SILENT);
        }
    }
}

