/* $Header: /usr/cvsroot/libutf/ure.h,v 1.2 2006/05/26 20:20:46 agc Exp $ */

/*
 * Copyright © 1996-2006 Alistair Crooks.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef URE_H_
#define URE_H_

#include <sys/types.h>

/* we need this for the Rune definition */
#include "utf.h"

/* someone was working overtime when they specified how large a range could be */
typedef off_t	ureoff_t;

/* bits used later on... */
enum {
	URE_COMP_BIT= 0x4000,
	URE_EXEC_BIT = 0x8000,
	URE_FLAG_BITS = 0xff
};

/* urecomp() flags */
enum {
	URE_BASIC = (URE_COMP_BIT | 0x00),
	URE_EXTENDED = (URE_COMP_BIT | 0x01),
	URE_COMP_ICASE = (URE_COMP_BIT | 0x02),
	URE_NOSUB = (URE_COMP_BIT | 0x04),
	URE_NEWLINE = (URE_COMP_BIT | 0x08),
	URE_NOSPEC = (URE_COMP_BIT | 0x10),
	URE_PEND = (URE_COMP_BIT | 0x20),
	URE_DUMP = (URE_COMP_BIT | 0x80)
};

/* ureexec flags */
enum {
	URE_NOTBOL = (URE_EXEC_BIT | 0x01),
	URE_NOTEOL = (URE_EXEC_BIT | 0x02),
	URE_STARTEND = (URE_EXEC_BIT | 0x04),
	URE_ICASE = (URE_EXEC_BIT | 0x08),
	URE_TRACE = (URE_EXEC_BIT | 0x10),
	URE_LARGE = (URE_EXEC_BIT | 0x20),
	URE_BACKR = (URE_EXEC_BIT | 0x40)
};

/* URE error numbers - see ureerror */
enum UREErrs {
	URE_SUCCESS,
	URE_NOMATCH,
	URE_ERR_UNMATCHED_BRACKET,
	URE_ERR_INTERNAL_MESS,
	URE_ERR_REPEAT_FOLLOWS_NOTHING,
	URE_ERR_TRAILING_BACKSLASH,
	URE_ERR_INTERNAL_DISASTER,
	URE_ERR_OPERAND_EMPTY,
	URE_ERR_NESTED_REPEAT,
	URE_ERR_TOO_MANY_PARENS,
	URE_ERR_UNMATCHED_PAREN,
	URE_ERR_JUNK_ON_END,
	URE_ERR_NULL_ARG,
	URE_ERR_TOO_BIG,
	URE_ERR_EXECUTION_BUG,
	URE_ERR_MEMORY_CORRUPTION,
	URE_ERR_CORRUPTED_POINTERS,
	URE_ERR_NULL_PARAM,
	URE_ERR_BAD_MAGIC,
	URE_ERR_CORRUPTED_OPCODE,
	URE_ERR_SUBST_NULL_ARG,
	URE_ERR_SUBST_BAD_MAGIC,
	URE_ERR_SUBST_DAMAGED_MATCH,
	URE_ERR_OUT_OF_SPACE,
	URE_ERR_UNKNOWN
};

#define URE_NSUBEXP  0x2000

/* this structure describes a compiled utf-aware regular expression */
typedef struct ure_t {
	int	u_subc;		/* # of sub expressions */
	int	u_flags;	/* compilation flags */
	Rune	u_start;	/* Internal use only. */
	Rune	u_anch;		/* Internal use only. */
	Rune	*u_must;	/* Internal use only. */
	int	u_mlen;		/* Internal use only. */
	Rune	*u_prog;	/* Compiled form of expression. */
} ure_t;

/* a match structure - describes the start and end points */
typedef struct {
	ureoff_t	rm_so;	/* start of match */
	ureoff_t	rm_eo;	/* end of match */
} urematch_t;

int urecomp(ure_t *, char *, int);
int ureexec(ure_t *, char *, int, urematch_t *, int, char *);
int ureerror(int, ure_t *, char *, int);
void urefree(ure_t *);

#endif /* !URE_H_ */
