/*
 * AppleRecords - A DAAP client
 * Copyright (C) 2004  Chris Davies <c.davies@cdavies.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.cdavies.applerecords;

import javax.swing.*;

import org.cdavies.itunes.*;

/**
 * 
 * A control for storing information about iTunes servers available on the 
 * local network, in the form of <code>ItunesConnection</code>s this control
 * is where instances of AppleRecords source all their connections and
 * consequently tracklists and tracks.
 * 
 * 
 * @author       Chris Davies (c.davies@cdavies.org)
 * @version      0.5 21/06/2004
 * @see		org.cdavies.itunes.ItunesConnection
 *
 */

public class AppleRecordsServerControl extends JComboBox {
	
	/**
	 * 
	 * Create a new instance of this control. This method is now entirely 
	 * redundant. It used to contain code, but now it doesn't. Go figure.
	 * 
	 */
	
	public AppleRecordsServerControl() {
		
		super();
		
	}
	
	/**
	 * 
	 * Adds a new connection instance to this instance of the server control
	 * widget. This has (possibly) two effects. Fistly and most obviously, 
	 * the widget will now display this server's name as an option, so the
	 * user may select it.
	 * <p>
	 * Secondly, if this is the only connection that this instance currently
	 * contains, this will trigger an event which the <code>ServerControlActionListener</code>
	 * will handle, populating the track table with this connection's tracklist.
	 *
	 * @param	conn	The <code>ItunesConnection</code> to add to this control
	 * @see ServerControlActionListener
	 *
	 */
	
	public synchronized void addItunesConnection(ItunesConnection conn) {
		
		addItem(conn);
		validate();
		
	}
	
	/**
	 * 
	 * This method is somewhat dodgy, it assumes every connection has
	 * a unique name, which is not necessarily the case. 
	 * <p>
	 * One day soonish, this method will be replaced by something that
	 * actually does what it says on the tin.
	 *
	 * @param	name	The name of the connection to remove from this control
	 *
	 */
	
	public synchronized void removeItunesConnection(String name) {
		
		for (int _i = 0; _i < getItemCount(); _i++) {
			
			ItunesConnection _conn = (ItunesConnection)getItemAt(_i);
			
			if (_conn.toString().equals(name)) {
				
				removeItemAt(_i);
				break;
				
			}
			
		}
		
		validate();
		
	}
	
}
