package org.cdavies.itunes.hash;

import com.twmacinta.util.MD5;

import org.cdavies.itunes.utils.HexString;

public class Itunes45Hash implements ItunesHash {
	
	public static int HASH_SIZE = 32;
	
	private String _staticHash = null;
	private static String _appleCopyright = "Copyright 2003 Apple Computer, Inc.";
	
	public Itunes45Hash() {
		
		calculateStaticHash();
		
	}
	
	private void calculateStaticHash() {
		
		MD5 _md5sum;
		
		StringBuffer _buf = new StringBuffer(8192);
		
		for (int i = 0; i < 256; i++) {
			
			_md5sum = new MD5();
			
			if ((i & 0x40) != 0)
				_md5sum.Update("eqwsdxcqwesdc".getBytes());
			else
				_md5sum.Update("op[;lm,piojkmn".getBytes());

			if ((i & 0x20) != 0)
				_md5sum.Update("876trfvb 34rtgbvc".getBytes());
			else
				_md5sum.Update("=-0ol.,m3ewrdfv".getBytes());

			if ((i & 0x10) != 0)
				_md5sum.Update("87654323e4rgbv ".getBytes());
			else
				_md5sum.Update("1535753690868867974342659792".getBytes());

			if ((i & 0x08) != 0)
				_md5sum.Update("Song Name".getBytes());
			else
				_md5sum.Update("DAAP-CLIENT-ID:".getBytes());

			if ((i & 0x04) != 0)
				_md5sum.Update("111222333444555".getBytes());
			else
				_md5sum.Update("4089961010".getBytes());

			if ((i & 0x02) != 0)
				_md5sum.Update("playlist-item-spec".getBytes());
			else
				_md5sum.Update("revision-number".getBytes());

			if ((i & 0x01) != 0)
				_md5sum.Update("session-id".getBytes());
			else
				_md5sum.Update("content-codes".getBytes());

			if ((i & 0x80) != 0)
				_md5sum.Update("IUYHGFDCXWEDFGHN".getBytes());
			else
				_md5sum.Update("iuytgfdxwerfghjm".getBytes());
		
			_buf.append(HexString.bytesToHexString(_md5sum.Final())); 
			
		}
		
		_staticHash = _buf.toString();
		
	}
	
	
	public String generateHash(String url, int accessIndex, int requestId) {
		
		if (_staticHash == null)
			return null;
		
		MD5 _md5sum = new MD5();
		int _start = HASH_SIZE * accessIndex;
		int _end = _start + HASH_SIZE;
		
		_md5sum.Update(url.getBytes());
		_md5sum.Update(_appleCopyright.getBytes());
		_md5sum.Update(_staticHash.substring(_start, _end).getBytes());
			
		if (requestId != -1)
			_md5sum.Update((new Integer(requestId)).toString().getBytes());
				
		
		return HexString.bytesToHexString(_md5sum.Final());
		
	}
	
}
