# NOTE: Derived from web_diary_dir/lib/TDS/Collection.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package TDS::Collection;

#line 215 "web_diary_dir/lib/TDS/Collection.pm (autosplit into web_diary_dir/lib/auto/TDS/Collection/collect_files.al)"
################################################################


sub collect_files ($;$)
{
    my ($self, $mode) = shift;

    # ե륭å֤
    return @{$self->files} if @{$self->files};

    $mode ||= $TDS::Status->mode;
#    die $mode;
    my @files;
    if ($mode eq 'RECENT'){
	@files = 
	    $self->pickup_recent($TDS::Status->start_time->year, 
				 $TDS::Status->start_time->month,
				 $TDS::Status->start_time->day,
				 $RecentNum);
    } elsif ($mode eq 'N_YEAR'){
	for ($TDS::Status->start_year..
	     $TDS::Status->year){
	    my $year = $_;
	    push(@files,
		 $self->pickup_neighbour($year,
					 $TDS::Status->month,
					 $TDS::Status->day_part));

	}
    } elsif ($mode eq 'PSEUDO_RECENT'){
	@files = $self->pickup_recent($TDS::Status->year,
				      $TDS::Status->month,
				      $TDS::Status->day_part,
				      $RecentNum);
    } else {
	my $day_part = $TDS::Status->day_part;

	if ($day_part eq ''){           # 
	    @files = $self->pickup_files($TDS::Status->year,
					 $TDS::Status->month);
	} elsif ($day_part =~ /[abc]/){ # 
	    my ($min_day, $max_day) =
		($day_part eq 'a') ? (1, 9) :
		    ($day_part eq 'b') ? (10, 19) :
			(20, 31);
	    @files = $self->pickup_files($TDS::Status->year,
					 $TDS::Status->month,
					 $min_day, $max_day);
	} else {                        # 
	    my $num = $NeighbourNum;
	    @files = $self->pickup_neighbour($TDS::Status->year,
					     $TDS::Status->month,
					     $TDS::Status->day_part,
					     $num, $num);
	}
    }
    if (@files){
	my $day = new DateTime::Date;
	$day->Set(@{$files[scalar(@files)-1]}[1,2,3]);
	$self->last_day($day);
#	die $day->Dump;
    }
    return @{$self->files} = @files;
}

# end of TDS::Collection::collect_files
1;
