/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.perspective.persist.xml;

import org.flexdock.docking.state.LayoutNode;
import org.flexdock.docking.state.tree.SplitNode;
import org.flexdock.perspective.persist.xml.AbstractLayoutNodeSerializer;
import org.flexdock.perspective.persist.xml.ISerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SplitNodeSerializer
extends AbstractLayoutNodeSerializer
implements ISerializer {
    public Element serialize(Document document, Object object) {
        SplitNode splitNode = (SplitNode)object;
        Element splitNodeElement = super.serialize(document, object);
        if (splitNode.getSiblingId() != null && !"".equals(splitNode.getSiblingId())) {
            splitNodeElement.setAttribute("siblingId", splitNode.getSiblingId());
        }
        splitNodeElement.setAttribute("orientation", splitNode.getOrientationDesc());
        splitNodeElement.setAttribute("region", splitNode.getRegionDesc());
        splitNodeElement.setAttribute("percentage", String.valueOf(splitNode.getPercentage()));
        if (splitNode.getDockingRegion() != null) {
            splitNodeElement.setAttribute("dockingRegion", splitNode.getDockingRegion().toLowerCase());
        }
        return splitNodeElement;
    }

    protected Element getElement(Document document, Object o) {
        return document.createElement("SplitNode");
    }

    public Object deserialize(Element element) {
        SplitNode splitNode = (SplitNode)super.deserialize(element);
        String siblingId = element.getAttribute("siblingId");
        String orientationString = element.getAttribute("orientation");
        String regionString = element.getAttribute("region");
        String percentage = element.getAttribute("percentage");
        String dockingRegion = element.getAttribute("dockingRegion");
        int orientation = -1;
        if (orientationString.equals("vertical")) {
            orientation = 0;
        } else if (orientationString.equals("horizontal")) {
            orientation = 1;
        }
        int region = -1;
        if (regionString.equals("top")) {
            region = 1;
        } else if (regionString.equals("bottom")) {
            region = 3;
        } else if (regionString.equals("left")) {
            region = 2;
        } else if (regionString.equals("right")) {
            region = 4;
        }
        splitNode.setOrientation(orientation);
        splitNode.setRegion(region);
        splitNode.setPercentage(Float.parseFloat(percentage));
        if (siblingId != null && !"".equals(siblingId)) {
            splitNode.setSiblingId(siblingId);
        }
        if (dockingRegion != null && !dockingRegion.equals("")) {
            splitNode.setDockingRegion(dockingRegion.toUpperCase());
        }
        return splitNode;
    }

    protected LayoutNode createLayoutNode() {
        return new SplitNode(-1, -1, -1.0f, null);
    }
}

