/*
 * Decompiled with CFR 0.152.
 */
package javax.media.pim;

import com.sun.media.util.Registry;
import com.sun.media.util.Resource;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.Format;
import javax.media.Manager;
import javax.media.pim.ClassNameInfo;
import javax.media.pim.ListInfo;
import javax.media.pim.PlugInInfo;
import javax.media.pim.PlugInVector;

public class PlugInManager
extends javax.media.PlugInManager {
    private static Hashtable lists = null;
    private static PlugInVector plugins = null;
    private static Registry r = null;
    private static Format[] emptyFormat = new Format[0];
    private static boolean jdkInit = false;
    private static Method forName3ArgsM;
    private static Method getSystemClassLoaderM;
    private static ClassLoader systemClassLoader;
    private static Method getContextClassLoaderM;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Thread;

    public PlugInManager() {
        PlugInManager.readFromRegistry();
    }

    private static boolean checkIfJDK12() {
        if (jdkInit) {
            return forName3ArgsM != null;
        }
        jdkInit = true;
        try {
            forName3ArgsM = (class$java$lang$Class == null ? (class$java$lang$Class = PlugInManager.class$("java.lang.Class")) : class$java$lang$Class).getMethod("forName", class$java$lang$String == null ? (class$java$lang$String = PlugInManager.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = PlugInManager.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            getSystemClassLoaderM = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = PlugInManager.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getMethod("getSystemClassLoader", null);
            systemClassLoader = (ClassLoader)getSystemClassLoaderM.invoke((Object)(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = PlugInManager.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader), null);
            getContextClassLoaderM = (class$java$lang$Thread == null ? (class$java$lang$Thread = PlugInManager.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
            return true;
        }
        catch (Throwable t) {
            forName3ArgsM = null;
            return false;
        }
    }

    static Class getClassForName(String className) throws ClassNotFoundException {
        block9: {
            try {
                return Class.forName(className);
            }
            catch (Exception e2) {
                if (!PlugInManager.checkIfJDK12()) {
                    throw new ClassNotFoundException(e2.getMessage());
                }
            }
            catch (Error e3) {
                if (PlugInManager.checkIfJDK12()) break block9;
                throw e3;
            }
        }
        try {
            return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class == null ? (class$java$lang$Class = PlugInManager.class$("java.lang.Class")) : class$java$lang$Class), className, new Boolean(true), systemClassLoader);
        }
        catch (Throwable e4) {
            try {
                ClassLoader contextClassLoader = (ClassLoader)getContextClassLoaderM.invoke((Object)Thread.currentThread(), null);
                return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class == null ? (class$java$lang$Class = PlugInManager.class$("java.lang.Class")) : class$java$lang$Class), className, new Boolean(true), contextClassLoader);
            }
            catch (Exception e5) {
                throw new ClassNotFoundException(e5.getMessage());
            }
            catch (Error e6) {
                throw e6;
            }
        }
    }

    public static synchronized Vector getPlugInList(Format input, Format output, int type) {
        ListInfo li = (ListInfo)lists.get(new Integer(type));
        if (li == null) {
            return new Vector(1);
        }
        Vector pluginList = li.classNames;
        Vector<String> result = new Vector<String>(5);
        boolean blw = false;
        Boolean lw = (Boolean)Manager.getHint(3);
        if (lw != null && lw.booleanValue()) {
            blw = true;
        }
        Enumeration eClassNames = pluginList.elements();
        while (eClassNames.hasMoreElements()) {
            ClassNameInfo cni = (ClassNameInfo)eClassNames.nextElement();
            PlugInInfo pii = PlugInManager.vectorFindPlugIn(type, cni.className, cni.hashValue);
            if (pii == null || !PlugInManager.match(pii.inputFormats, input) || !PlugInManager.match(pii.outputFormats, output) || blw && cni.className.indexOf("com.sun.media.renderer.video") == 0 && !cni.className.equals("com.sun.media.renderer.video.LightWeightRenderer")) continue;
            result.addElement(cni.className);
        }
        return result;
    }

    public static synchronized void setPlugInList(Vector pluginList, int type) {
        if (pluginList == null || type < 1) {
            return;
        }
        Vector<ClassNameInfo> validNames = new Vector<ClassNameInfo>(5);
        Enumeration eClassNames = pluginList.elements();
        while (eClassNames.hasMoreElements()) {
            String className = (String)eClassNames.nextElement();
            ClassNameInfo cni = new ClassNameInfo(className);
            if (PlugInManager.vectorFindPlugIn(type, cni.className, cni.hashValue) == null) continue;
            validNames.addElement(cni);
        }
        lists.put(new Integer(type), new ListInfo(type, validNames));
        Resource.purgeDB();
    }

    public static synchronized void commit() throws IOException {
        Registry.removeGroup("PIM");
        Registry.set("PIM.lists", lists.clone());
        Enumeration eListInfo = lists.elements();
        while (eListInfo.hasMoreElements()) {
            ListInfo li = (ListInfo)eListInfo.nextElement();
            if (li == null) {
                System.err.println("li is null????");
                continue;
            }
            int type = li.type;
            Vector classNames = li.classNames;
            Enumeration eClassNames = classNames.elements();
            while (eClassNames.hasMoreElements()) {
                ClassNameInfo cni = (ClassNameInfo)eClassNames.nextElement();
                PlugInInfo pii = PlugInManager.vectorFindPlugIn(type, cni.className, cni.hashValue);
                if (pii == null) {
                    System.err.println("pii is null for " + cni.className);
                    continue;
                }
                Registry.set("PIM." + type + "_" + cni.className + ".in", pii.inputFormats);
                Registry.set("PIM." + type + "_" + cni.className + ".out", pii.outputFormats);
            }
        }
        Registry.commit();
        Resource.destroy();
    }

    public static synchronized boolean addPlugIn(String className, Format[] in, Format[] out, int type) {
        ClassNameInfo cni;
        Vector<ClassNameInfo> v;
        Integer typeInt = new Integer(type);
        ListInfo li = (ListInfo)lists.get(typeInt);
        if (li != null) {
            v = li.classNames;
            Enumeration eClassNames = v.elements();
            while (eClassNames.hasMoreElements()) {
                cni = (ClassNameInfo)eClassNames.nextElement();
                if (!cni.className.equals(className)) continue;
                return false;
            }
        } else {
            v = new Vector<ClassNameInfo>(5);
        }
        try {
            Class piClass = PlugInManager.getClassForName(className);
        }
        catch (Throwable t) {
            return false;
        }
        cni = new ClassNameInfo(className);
        v.addElement(cni);
        lists.put(typeInt, new ListInfo(type, v));
        if (in == null) {
            in = emptyFormat;
        }
        if (out == null) {
            out = emptyFormat;
        }
        PlugInManager.vectorInsertPlugIn(new PlugInInfo(type, className, cni.hashValue, in, out));
        Resource.purgeDB();
        return true;
    }

    public static synchronized boolean removePlugIn(String className, int type) {
        Integer typeInt = new Integer(type);
        ListInfo li = (ListInfo)lists.get(typeInt);
        ClassNameInfo cni = null;
        PlugInInfo pii = null;
        if (li != null) {
            Vector v = li.classNames;
            Enumeration eClassNames = v.elements();
            while (eClassNames.hasMoreElements()) {
                cni = (ClassNameInfo)eClassNames.nextElement();
                if (!cni.className.equals(className)) continue;
                v.removeElement(cni);
                break;
            }
        }
        if (cni != null) {
            pii = PlugInManager.vectorRemovePlugIn(type, className, cni.hashValue);
            Resource.purgeDB();
        }
        return pii != null;
    }

    public static synchronized Format[] getSupportedInputFormats(String className, int type) {
        ClassNameInfo cni = new ClassNameInfo(className);
        PlugInInfo pii = PlugInManager.vectorFindPlugIn(type, className, cni.hashValue);
        if (pii == null) {
            return emptyFormat;
        }
        return pii.inputFormats;
    }

    public static synchronized Format[] getSupportedOutputFormats(String className, int type) {
        ClassNameInfo cni = new ClassNameInfo(className);
        PlugInInfo pii = PlugInManager.vectorFindPlugIn(type, className, cni.hashValue);
        if (pii == null) {
            return emptyFormat;
        }
        return pii.outputFormats;
    }

    private static void vectorInsertPlugIn(PlugInInfo pii) {
        plugins.addElement(pii);
    }

    private static PlugInInfo vectorFindPlugIn(int type, String className, long hashValue) {
        return plugins.lookup(type, className, hashValue);
    }

    private static PlugInInfo vectorRemovePlugIn(int type, String className, long hashValue) {
        PlugInInfo pii = PlugInManager.vectorFindPlugIn(type, className, hashValue);
        if (pii != null) {
            plugins.removeElement(pii);
            return pii;
        }
        return null;
    }

    private static synchronized boolean match(Format[] formats, Format tomatch) {
        if (tomatch == null || formats == null) {
            return true;
        }
        int i2 = 0;
        while (i2 < formats.length) {
            if (formats[i2].matches(tomatch)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private static void readFromRegistry() {
        if (lists != null) {
            return;
        }
        plugins = new PlugInVector(40);
        r = new Registry();
        Object list = Registry.get("PIM.lists");
        if (list == null || !(list instanceof Hashtable)) {
            lists = new Hashtable(8);
            System.out.println("No plugins found");
            return;
        }
        lists = (Hashtable)list;
        Enumeration eListInfo = lists.elements();
        while (eListInfo.hasMoreElements()) {
            ListInfo li = (ListInfo)eListInfo.nextElement();
            int type = li.type;
            Vector classNames = li.classNames;
            Vector<ClassNameInfo> validClassNames = new Vector<ClassNameInfo>(5);
            Enumeration eClassNames = classNames.elements();
            while (eClassNames.hasMoreElements()) {
                ClassNameInfo cni = (ClassNameInfo)eClassNames.nextElement();
                String key = type + "_" + cni.className;
                Object f1 = Registry.get("PIM." + key + ".in");
                Object f2 = Registry.get("PIM." + key + ".out");
                if (f1 == null || !(f1 instanceof Format[]) || f2 == null || !(f2 instanceof Format[])) continue;
                PlugInInfo pii = new PlugInInfo(type, cni.className, cni.hashValue, (Format[])f1, (Format[])f2);
                PlugInManager.vectorInsertPlugIn(pii);
                validClassNames.addElement(cni);
            }
            lists.put(new Integer(type), new ListInfo(type, validClassNames));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PlugInManager.readFromRegistry();
    }
}

