/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtpstatistics;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import net.sf.gogui.game.GameInformation;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.Node;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.Move;
import net.sf.gogui.sgf.SgfReader;
import net.sf.gogui.utils.ErrorMessage;

public class FileCheck {
    private final boolean m_allowSetup;
    private final int m_size;
    private String m_name;

    public FileCheck(ArrayList arrayList, int n, boolean bl) throws ErrorMessage {
        this.m_size = n;
        this.m_allowSetup = bl;
        for (int i = 0; i < arrayList.size(); ++i) {
            this.m_name = (String)arrayList.get(i);
            this.checkFile();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkFile() throws ErrorMessage {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(this.m_name));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.throwError("file not found");
        }
        SgfReader sgfReader = new SgfReader(fileInputStream, this.m_name, null, 0L);
        GameTree gameTree = sgfReader.getGameTree();
        GameInformation gameInformation = gameTree.getGameInformation();
        if (gameInformation.m_boardSize != this.m_size) {
            this.throwError("size is not " + this.m_size);
        }
        Node node = gameTree.getRoot();
        GoColor goColor = GoColor.BLACK;
        for (Node node2 = node; node2 != null; node2 = node2.getChild()) {
            Move move;
            if (node2.getNumberAddWhite() + node2.getNumberAddBlack() > 0) {
                if (!this.m_allowSetup) throw new ErrorMessage("contains setup stones");
                if (node2 != node) throw new ErrorMessage("setup stones in non-root position");
                goColor = GoColor.EMPTY;
            }
            if ((move = node2.getMove()) == null) continue;
            if (goColor == GoColor.EMPTY) {
                goColor = move.getColor();
            }
            if (move.getColor() != goColor) {
                this.throwError("non-alternating moves");
            }
            goColor = goColor.otherColor();
        }
    }

    private void throwError(String string) throws ErrorMessage {
        throw new ErrorMessage(this.m_name + ": " + string);
    }
}

