/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.Move;
import net.sf.gogui.gtp.GtpClient;
import net.sf.gogui.gtp.GtpError;

public class CommandThread
extends Thread {
    private static final int TIMEOUT = 8000;
    private boolean m_commandInProgress;
    private GtpClient m_gtp;
    private GtpError m_exception;
    private Component m_owner;
    private final Object m_mutex = new Object();
    private Runnable m_callback;
    private String m_command;
    private String m_response;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CommandThread(GtpClient gtpClient, Component component) {
        this.m_gtp = gtpClient;
        this.m_owner = component;
    }

    public void close() {
        if (!this.isProgramDead()) {
            this.m_gtp.close();
            TimeoutCallback timeoutCallback = new TimeoutCallback(null);
            this.m_gtp.waitForExit(8000, timeoutCallback);
        }
    }

    public void destroyGtp() {
        this.m_gtp.destroyProcess();
    }

    public void setAutoNumber(boolean bl) {
        this.m_gtp.setAutoNumber(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponse() {
        Object object = this.m_mutex;
        synchronized (object) {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.m_commandInProgress) {
                throw new AssertionError();
            }
            return this.m_response;
        }
    }

    public String getCommandClearBoard(int n) {
        return this.m_gtp.getCommandClearBoard(n);
    }

    public String getCommandGenmove(GoColor goColor) {
        return this.m_gtp.getCommandGenmove(goColor);
    }

    public String getCommandPlay(Move move) {
        return this.m_gtp.getCommandPlay(move);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GtpError getException() {
        Object object = this.m_mutex;
        synchronized (object) {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !this.m_commandInProgress) {
                throw new AssertionError();
            }
            this.m_commandInProgress = false;
            return this.m_exception;
        }
    }

    public String getProgramCommand() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        return this.m_gtp.getProgramCommand();
    }

    public int getProtocolVersion() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        return this.m_gtp.getProtocolVersion();
    }

    public ArrayList getSupportedCommands() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        return this.m_gtp.getSupportedCommands();
    }

    public void sendInterrupt() throws GtpError {
        this.m_gtp.sendInterrupt();
    }

    public boolean isCommandInProgress() {
        return this.m_commandInProgress;
    }

    public boolean isCommandSupported(String string) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.m_commandInProgress) {
            throw new AssertionError();
        }
        return this.m_gtp.isCommandSupported(string);
    }

    public boolean isInterruptSupported() {
        return this.m_gtp.isInterruptSupported();
    }

    public boolean isProgramDead() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        return this.m_gtp.isProgramDead();
    }

    public void queryInterruptSupport() {
        this.m_gtp.queryInterruptSupport();
    }

    public void queryProtocolVersion() throws GtpError {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.m_commandInProgress) {
            throw new AssertionError();
        }
        this.m_gtp.queryProtocolVersion();
    }

    public void querySupportedCommands() throws GtpError {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.m_commandInProgress) {
            throw new AssertionError();
        }
        this.m_gtp.querySupportedCommands();
    }

    public String queryVersion() throws GtpError {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.m_commandInProgress) {
            throw new AssertionError();
        }
        return this.m_gtp.queryVersion();
    }

    public void run() {
        Object object = this.m_mutex;
        synchronized (object) {
            boolean bl = true;
            while (true) {
                try {
                    if (this.m_command == null || !bl) {
                        this.m_mutex.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Interrupted");
                }
                bl = false;
                this.m_response = null;
                this.m_exception = null;
                try {
                    this.m_response = this.m_gtp.send(this.m_command);
                }
                catch (GtpError gtpError) {
                    this.m_exception = gtpError;
                }
                SwingUtilities.invokeLater(this.m_callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String string, Runnable runnable) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.m_commandInProgress) {
            throw new AssertionError();
        }
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_command = string;
            this.m_callback = runnable;
            this.m_commandInProgress = true;
            this.m_mutex.notifyAll();
        }
    }

    public String send(String string) throws GtpError {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.m_commandInProgress) {
            throw new AssertionError();
        }
        TimeoutCallback timeoutCallback = new TimeoutCallback(string);
        return this.m_gtp.send(string, 8000L, timeoutCallback);
    }

    public void sendBoardsize(int n) throws GtpError {
        this.m_gtp.sendBoardsize(n);
    }

    public void sendClearBoard(int n) throws GtpError {
        this.m_gtp.sendClearBoard(n);
    }

    public void sendPlay(Move move) throws GtpError {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.m_commandInProgress) {
            throw new AssertionError();
        }
        TimeoutCallback timeoutCallback = new TimeoutCallback("play");
        this.m_gtp.sendPlay(move, 8000L, timeoutCallback);
    }

    static {
        $assertionsDisabled = !CommandThread.class.desiredAssertionStatus();
    }

    private class TimeoutCallback
    implements GtpClient.TimeoutCallback {
        private final String m_command;

        TimeoutCallback(String string) {
            this.m_command = string;
        }

        public boolean askContinue() {
            String string = this.m_command == null ? "Program did not terminate" : "Program did not respond to command '" + this.m_command + "'";
            string = string + "\nKill program?";
            String string2 = "Error";
            Object[] objectArray = new String[]{"Kill Program", "Wait"};
            int n = JOptionPane.showOptionDialog(CommandThread.this.m_owner, string, string2, 0, 0, null, objectArray, objectArray[1]);
            return n != 0;
        }
    }
}

