.\" $Header: /home/vikas/netmgt/nocol/src/doc/RCS/nocol-overview.8,v 1.8 1994/11/29 20:12:56 vikas Exp $
.\"
.TH NOCOL-OVERVIEW 8 "May 1994"
.SH NAME
nocol-overview \- Unix based network monitoring package.
.SH SYNOPSIS
This is an overview of the NOCOL software. See
.IR nocol-prog (3)
for more information on the design and initiatives behind NOCOL.
.SH DESCRIPTION
.LP
.B NOCOL/NetConsole
.I (Network Operations Center On-Line)
is a collection of network and system monitoring programs that run on Unix
platforms. 
Monitors for the following are available at this time:
.RS
.nf
 - IP ICMP monitor (using IP 'ping' or 'multiping')
 - OSI reachability monitor (using OSI ping)
 - RPC portmapper monitor (using 'rpcping')
 - Ethernet load (bandwidth & pps)
 - TCP port reachability monitor
 - Unix host performance (disks, memory, swap, load, nfs, collisions)
 - SNMP variables monitor (RMON, Cisco router, terminal server)
 - TCP data throughput
 - Nameserver (named)
 - SNMP traps
 - Usage of terminal server modem lines (busy lines)
 - Appletalk route monitor (for cisco routers)
 - Novell service monitor
 - BGP peer status
.fi
.RE
The software is extensible and new monitors can be added easily.

The software consists of a number of monitoring agents that poll various
parameters (from any system or device) and write the output in a common format suitable for post-processing by a number of agents (such as logging,
notification, automated troubleshooting, display, etc.).

All data collected by the monitoring agents follows a fixed (non-readable)
format. Each data entry is termed an
.I event
in NOCOL, and each event has certain flags and a
.I severity
level associated with it. 
The display agent
.IR nocol (1),
displays the output of these monitoring agents depending on the severity
of the event.
This design allows running just one set of monitoring agents and
.I any
number of display agents, and all of the displays process and display
the same consistent set of data.

There are four levels of 
.I severity
associated with an event- CRITICAL, ERROR, WARNING and INFO. The severity
level is controlled independently by the monitoring agents, and the decision
to raise or set an event's severity to any level depends on the logic
imbedded in the monitoring agent. The intent is that an event is gradually
escalated to its maximum allowed severity level and thus prevent false alarms.

As an example, for the 
.BR pingmon (8)
monitor, if a site is unreachable via
.IR ping ,
it would be assigned a severity of WARNING by pingmon, which would then 
escalate to ERROR and then to CRITICAL if the site is still unreachable after 
two more test passes.
In the case of
.BR trapmon (8),
an SNMP trap message of
.I EGP neighbor lost
would be directly assigned a severity level of CRITICAL, while an 
.I Warm Start
trap is assigned a severity of WARNING.
On the other hand,
.BR hostmon (8)
has three thresholds associated with each variable, and the maximum severity
of an event depends on the threshold exceeded.

The display agent (and other data post-processors) use this event
severity to decide whether to display it (or troubleshoot/log it) depending
on the selected severity level.

The software is very flexible and modular, which allows enhancements and 
development with a minimum amount of effort. 
The post-processor modules process all data files present in the DATA
directory sequentially. This 
allows new monitoring programs to simply start generating data in the data
directory and the post-processors will automatically start
displaying/processing the new data.
The monitoring tools can be changed, and the only element that has to
remain common between all the modules is the EVENT data structure.

.SH CURRENT MODULES
The NOCOL package presently consists of the following modules:
.TP
.B netconsole
which simply \fIdisplays\fR the data collected by the monitoring agents. 
It uses the Unix
.I curses
screen management system to support a wide variety of terminal types. The
criterion for displaying an event is:
.RS
.TP 3
1.
Severity level of the \fIevent\fR is higher than the severity level set in
the \fIdisplay\fR.
.TP 3
2.
The display filter (if set) matches some string in the event line.
.RE
.IP
The display can be in regular 80 column mode or in extended 132 column mode.
Critical events are displayed in reverse video (if the terminal type supports
it). Additional features like displaying informational
messages in a part of the window, automatic resizing window sizes, operator
acknowledgement via a bell when a new event goes critical are also available.
.\"----------------
.TP
.B ippingmon
which monitors the reachability of a site via "ICMP" ping packets (ICMP was
preferred over SNMP for many obvious reasons ;-). 
This program can use the default output from the system's 
.I ping
program, but an accompanying program (
.IR multiping )
can ping multiple IP sites at the same time and is preferable for monitoring
a large list of sites.
A site is marked unreachable if the number of lost packets exceeds a fixed
threshold (set to 3 out of 10 packets sent), and the
severity level is increased each time that the site tests as  unreachable.
Use
.I rpcpingmon
to monitor Unix hosts that have an RPC portmapper running instead of using
ippingmon (since testing the RPC portmapper is more useful on Unix hosts).
.\" ***
.TP
.B rpcpingmon
is similar to ippingmon in functionality but checks to see whether the
remote hosts' RPC portmapper is responding (instead of checking for ICMP
reachability).
.\" ***
.TP
.B osipingmon
which is similar to the 
.I ippingmon
module but uses the OSI \fIping\fR program instead. No multiple ping program
for OSI sites has been developed at this time. The only requirement is that
the system's OSI \fIping\fR program output match the typical BSD IP ping
program's output.
.\" ***
.TP
.B etherload
which monitors the network traffic and packets-per-second on ethernets; if
the bandwidth utilization or pps exceeds the set thresholds, it escalates
the severity of the event.
.\" ***
.TP
.B nsmon
which monitors the nameservers (
.IR named )
on the list of specified hosts. It periodically sends an SOA query for the
default domain and if the queried nameservers cannot resolve the query, then
the site is elevated to CRITICAL status.
.\" ***
.TP
.B tpmon
For monitoring the throughput (kbits per second) to a list of hosts. The
program connects to the discard socket on the remote machine (using a STREAM
socket) and sends large packets for a small amount of time to evaluate the
effective end-to-end throughput. It elevates a site to WARNING level if the
throughput drops below a certain threshold (set in the configuration file).
.\" ***
.TP
.B trapmon
Converts all SNMP traps into a format suitable for displaying using NOCOL.
The severity of the various traps is preset (and can be changed during
compilation time).
.\" ***
.TP
.B noclogd
This is the NOCOL logging daemon. It listens on a UDP port for the various
monitors to log events to it. It then writes out the event (in text line
format), to various log files specified in a configuration file. Alternatively,
it can pipe the text line to a program specified in the config file (this
facilitates automatic notification, troubleshooting, etc.).
.\" ***
.TP
.B genmon
This is a generic monitor interface for adding additional monitors. It
reads in text lines (in the 
.IR noclogd (8)
format) and writes them in the NOCOL datafile format. It is meant to
facilitate development of additional monitors. 
(NOTE: See perlnocol also).
.\" ***
.TP
.B eventselect
This program parses all the NOCOL datafiles specified on the command line
and extracts those events that match the criterion specified on the
command line. The events can be selected by sender name, severity, time
or variable name. This process can be run periodically from the 
.IR cron (1)
and be used to do any postprocessing (sending email, page
someone)  if a site is in critical state for a period of time, etc.
.\" ***
.TP
.B perlnocol
There is a collection of utility PERL routines (library) called
.I nocollib.pl
that can be used to develop monitors in the PERL programming language.
Monitors for RMON, cisco router variables, Novell routes, 
appletalk routes,  bootp servers, modem line usage on terminal-servers
have been developed and included.
These might require slight changes for your environment.
.RS
.IP armon
Monitor missing or unregistered Appletalk routes on a Cisco router.
.IP bgpmon
Check the status of a BGP peer on a cisco router.
.IP bpmon
Check the status of a bootp daemon (using bootptest or bootpquery).
.IP hostmon
A distributed host monitoring system for disks, memory, load, swap space,
nfs, etc. Consists of a client program that runs on all the remote machines
and a server program that connects to the clients and gathers+processes the
data from the clients and writes into the NOCOL format.
.IP mailmon
Checks for clogged mail queues using 'sendmail -bp'.
.IP modemmon
Monitors the number of free modem lines on a terminal server and indicates an
error when the number of free lines drops below the defined thresholds.
.IP novellmon
Checks for missing or unregistered Novell \fIservices\fR on a Cisco router.
.IP nrmon
Checks for missing or unregistered Novell \fIroutes\fR.
.IP snmpmon
Uses the CMU-SNMP \fBsnmpwalk\fR program to monitor SNMP statistics such as
RMON mib, traffic load, router packet & error rates, cisco router interface
variables, terminal server busy lines, etc.
.RE
See
.IR perlnocol (8)
for adding new monitors and programming using this PERL interface.
.SH PLATFORM
.LP
Any Unix system with the 
.I curses
screen management library and IP
.I (Internet Protocol)
programming facility. Sockets are needed for the logging facility.
It has been tested on SunOS 4.1.x, Solaris 2.3, Ultrix, OSF, BSDI
and NeXT systems. See the file
.B PORTING
for more up to date information.
Porting to other platforms might require minor adjustments depending
on the vagaries of the different vendors (mostly in the include files).
.SH FUTURE DEVELOPMENTS
.LP
Possible future enhancements are:
.RS
.TP 3
1.
Additions to the
.I snmpmon
program for other SNMP device types.
.TP 3
2.
Graphical reports and extracting statistics from the old logs.
.TP 3
3.
Add protocol and host analysing in
.I etherload
for more detailed information.
.\"--------------------------------------------
.SH AVAILABILITY
.LP
.B NOCOL
is available via anonymous FTP from
.I ftp.navya.com
under
.IR pub/vikas/nocol.tar.Z
or from
.I ftp.jvnc.net
.RI ( pub/vikas/nocol.tar.Z
).
.br
The software is currently being used at a number of Internet sites.
The system running at JvNCet can be viewed by logging into the host
.I nocol.jvnc.net
with username
.I nocol
(an \fIrlogin\fR instead of \fItelnet\fR will handle your X window terminal
types better).
.LP
To be added to the NOCOL mailing list (for future updates and bug fixes),
send a message to
.br
.B nocol-users-request@navya.com
with your email address.
.SH AUTHOR
Vikas Aggarwal (vikas@navya.com) with contributions by many.
.br
The PERL interface was written and contributed by John Wobus at
Syracuse University in 1993.
.LP
All bug reports and comments to Vikas Aggarwal (vikas@navya.com).
.br
See the file \fICOPYRIGHT\fR for full COPYRIGHT details.
.SH SEE ALSO
netconsole(1) nocol-prog(3) perlnocol(3)
etherload(8) eventselect(8) genmon(8) noclogd(8) nocol-overview(8)
nocol-utility(8) nsmon(8) pingmon(8) portmon(8) 
tpmon(8) trapmon(8)

