/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros;

import java.io.File;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.parosproxy.paros.model.FileCopier;

public final class Constant {
    public static final String PROGRAM_NAME = "Paros";
    public static final String PROGRAM_VERSION = "3.2.13";
    public static final long VERSION_TAG = 30020013L;
    public static final String PROGRAM_TITLE = "Paros 3.2.13";
    public static final String SYSTEM_PAROS_USER_LOG = "paros.user.log";
    public static final String FILE_CONFIG_DEFAULT = "xml/config.xml";
    public String FILE_CONFIG = "config.xml";
    public static final String FOLDER_PLUGIN = "plugin";
    public static final String FOLDER_FILTER = "filter";
    public static final String FOLDER_SESSION_DEFAULT = "session";
    public String FOLDER_SESSION = "session";
    public static final String DBNAME_TEMPLATE = "db" + System.getProperty("file.separator") + "parosdb";
    public static final String DBNAME_UNTITLED_DEFAULT = "session" + System.getProperty("file.separator") + "untitled";
    public String DBNAME_UNTITLED = this.FOLDER_SESSION + System.getProperty("file.separator") + "untitled";
    public String ACCEPTED_LICENSE_DEFAULT;
    public String ACCEPTED_LICENSE = this.ACCEPTED_LICENSE_DEFAULT = "AcceptedLicense";
    private static Constant instance = null;
    public static final int MAX_HOST_CONNECTION = 5;
    public static final String USER_AGENT = "Paros/3.2.13";
    private static String staticEyeCatcher = "Paros";
    private static boolean staticSP = false;
    private static Pattern patternWindows = Pattern.compile("window", 2);
    private static Pattern patternLinux = Pattern.compile("linux", 2);
    static /* synthetic */ Class class$org$parosproxy$paros$Constant;

    public static String getEyeCatcher() {
        return staticEyeCatcher;
    }

    public static void setEyeCatcher(String string) {
        staticEyeCatcher = string;
    }

    public static void setSP(boolean bl) {
        staticSP = bl;
    }

    public static boolean isSP() {
        return staticSP;
    }

    public Constant() {
        FileCopier fileCopier = new FileCopier();
        File file = null;
        Log log = null;
        String string = System.getProperty("user.home");
        System.setProperty(SYSTEM_PAROS_USER_LOG, "log");
        if (string != null && !string.equals("")) {
            string = string + System.getProperty("file.separator") + "paros";
            file = new File(string);
            string = string + System.getProperty("file.separator");
            this.FILE_CONFIG = string + this.FILE_CONFIG;
            this.FOLDER_SESSION = string + this.FOLDER_SESSION;
            this.DBNAME_UNTITLED = string + this.DBNAME_UNTITLED;
            this.ACCEPTED_LICENSE = string + this.ACCEPTED_LICENSE;
            try {
                System.setProperty(SYSTEM_PAROS_USER_LOG, string);
                System.setProperty("log4j.configuration", "xml/log4j.properties");
                if (!file.isDirectory()) {
                    file.mkdir();
                    log = LogFactory.getLog(class$org$parosproxy$paros$Constant == null ? (class$org$parosproxy$paros$Constant = Constant.class$("org.parosproxy.paros.Constant")) : class$org$parosproxy$paros$Constant);
                    log.info("Created directory " + string);
                } else {
                    log = LogFactory.getLog(class$org$parosproxy$paros$Constant == null ? (class$org$parosproxy$paros$Constant = Constant.class$("org.parosproxy.paros.Constant")) : class$org$parosproxy$paros$Constant);
                }
                file = new File(this.FILE_CONFIG);
                if (!file.isFile()) {
                    log.info("Copying defaults from xml/config.xml to " + this.FILE_CONFIG);
                    fileCopier.copy(new File(FILE_CONFIG_DEFAULT), file);
                } else {
                    try {
                        XMLConfiguration xMLConfiguration = new XMLConfiguration(this.FILE_CONFIG);
                        xMLConfiguration.setAutoSave(false);
                        xMLConfiguration.load();
                        long l = xMLConfiguration.getLong("version");
                        if (30020013L > l) {
                            fileCopier.copy(new File(FILE_CONFIG_DEFAULT), file);
                        }
                    }
                    catch (ConfigurationException configurationException) {
                        fileCopier.copy(new File(FILE_CONFIG_DEFAULT), file);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        fileCopier.copy(new File(FILE_CONFIG_DEFAULT), file);
                    }
                }
                file = new File(this.FOLDER_SESSION);
                if (!file.isDirectory()) {
                    log.info("Creating directory " + this.FOLDER_SESSION);
                    file.mkdir();
                }
            }
            catch (Exception exception) {
                System.err.println("Unable to initialize home directory! " + exception.getMessage());
                exception.printStackTrace(System.err);
                System.exit(1);
            }
        } else {
            System.setProperty("log4j.configuration", "xml/log4j.properties");
            this.FILE_CONFIG = FILE_CONFIG_DEFAULT;
            this.FOLDER_SESSION = FOLDER_SESSION_DEFAULT;
            this.DBNAME_UNTITLED = DBNAME_UNTITLED_DEFAULT;
            this.ACCEPTED_LICENSE = this.ACCEPTED_LICENSE_DEFAULT;
        }
    }

    public static Constant getInstance() {
        if (instance == null) {
            instance = new Constant();
        }
        return instance;
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        Matcher matcher = patternWindows.matcher(string);
        return matcher.find();
    }

    public static boolean isLinux() {
        String string = System.getProperty("os.name");
        Matcher matcher = patternLinux.matcher(string);
        return matcher.find();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

