<?php

class DomainRootSiteLogic extends SOY2LogicBase{

	const FRONT_CONTROLLER_FILENAME = "index.php";
	const HTACCESS_FILENAME = ".htaccess";

    function create(){
    	$this->createBackUp();
    	$this->createController();
    	$this->createHtaccess();
    }

    function delete(){
    	$this->createBackUp();
    	@unlink(SOYCMS_TARGET_DIRECTORY .self::HTACCESS_FILENAME);
    	@unlink(SOYCMS_TARGET_DIRECTORY .self::FRONT_CONTROLLER_FILENAME);
    }

    function createHtaccess($htaccessFileContent = null){

    	if(is_null($htaccessFileContent)){
    		$htaccessFileContent = $this->getHtaccess();
    	}

		file_put_contents(SOYCMS_TARGET_DIRECTORY.self::HTACCESS_FILENAME, $htaccessFileContent);
    }

    function getHtaccess($site = null){
		if(!$site) $site = $this->getDomainRootSite();

		$tmp = array();
		$tmp[] = "# @generated by SOY CMS at " . date("Y-m-d H:i:s");
		$tmp[] = "RewriteEngine on";

		//元のサイトの静的ファイルを参照してみる
		if($site){
			$tmp[] = "";
			$tmp[] = 'RewriteCond %{REQUEST_FILENAME} !-f';
			$tmp[] = 'RewriteCond %{DOCUMENT_ROOT}/'.$site->getSiteId().'%{REQUEST_URI} -f [OR]';
			$tmp[] = 'RewriteCond %{DOCUMENT_ROOT}'.$site->getSiteId().'%{REQUEST_URI} -f';
			$tmp[] = 'RewriteRule ^(.*)$ /'.$site->getSiteId().'/$1 [L]';
			$tmp[] = "";
		}

		$tmp[] = 'RewriteCond %{REQUEST_FILENAME} !-f';
		$tmp[] = 'RewriteCond %{REQUEST_FILENAME}/index.php !-f';
		$tmp[] = 'RewriteCond %{REQUEST_FILENAME}/index.html !-f';
		$tmp[] = 'RewriteCond %{REQUEST_FILENAME}/index.htm !-f';
		$tmp[] = 'RewriteCond %{REQUEST_URI} !^/server-status';# Apacheのmod_statusへの配慮
		$tmp[] = 'RewriteCond %{REQUEST_URI} !^/server-info';  # Apacheのmod_infoへの配慮
		$tmp[] = 'RewriteCond %{REQUEST_URI} !^/'.self::FRONT_CONTROLLER_FILENAME.'/';

		if(defined("SOYCMS_PHP_CGI_MODE") && SOYCMS_PHP_CGI_MODE == true){
    		$tmp[] = 'RewriteRule ^(.*)$ '.self::FRONT_CONTROLLER_FILENAME.'?pathinfo=$1&%{QUERY_STRING} [L]';
    	}else{
			$tmp[] = 'RewriteRule ^(.*)$ '.self::FRONT_CONTROLLER_FILENAME.'/$1 [L]';
		}

		$tmp[] = "#---SOY CMS end of htaccess file --";
		$tmp[] = "";

		return implode("\n",$tmp);
    }

    function createController($site = null){
		if(!$site) $site = $this->getDomainRootSite();

		if($site){
	    	$controller = array();
			$controller[] = "<?php ";
			$controller[]  = '/* @generated by SOY CMS at ' . date("Y-m-d H:i:s") . '*/';
			$controller[]  = 'include_once("'.$site->getSiteId().'/'.self::FRONT_CONTROLLER_FILENAME.'");';
			$controller[]  = "?>";

			file_put_contents(SOYCMS_TARGET_DIRECTORY.self::FRONT_CONTROLLER_FILENAME, implode("\n",$controller));
		}
    }

    /**
     * バックアップ作成
     */
    function createBackUp(){
    	$indexphp = SOYCMS_TARGET_DIRECTORY.self::FRONT_CONTROLLER_FILENAME;
    	CMSUtil::createBackup($indexphp);

		$htaccess = SOYCMS_TARGET_DIRECTORY.self::HTACCESS_FILENAME;
    	CMSUtil::createBackup($htaccess);
    }

    function checkCreatedController($filepath){
    	$str = file_get_contents($filepath);

    	if(preg_match('/@generated by SOY ?CMS/',$str)){
    		return true;
    	}

    	return false;
    }

    /**
     * ルートサイト取得
     */
    private function getDomainRootSite(){
    	static $dao;
    	if(!$dao) $dao = SOY2DAOFactory::create("admin.SiteDAO");
    	try{
    		return $dao->getDomainRootSite();
    	}catch(Exception $e){
    		return null;
    	}
    }
}
?>