/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasAllMouseHandlers;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class LoggingPopup
extends PopupPanel {
    private final HTML resizeIcon;
    private final ScrollPanelWithMinSize scrollPanel;
    private VerticalPanel logArea;

    public LoggingPopup() {
        super(false, false);
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setBorderWidth(1);
        mainPanel.getElement().getStyle().setBackgroundColor("white");
        HTML titleBar = new HTML("<center><b>Logging</b></center>");
        mainPanel.add(titleBar);
        new WindowMoveHandler(titleBar);
        this.scrollPanel = new ScrollPanelWithMinSize();
        mainPanel.add(this.scrollPanel);
        this.logArea = new VerticalPanel();
        this.scrollPanel.setWidget(this.logArea);
        this.scrollPanel.setPixelSize(300, 200);
        HorizontalPanel bottomBar = new HorizontalPanel();
        mainPanel.add(bottomBar);
        bottomBar.setWidth("100%");
        bottomBar.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
        final Button maxmin = new Button("Minimize");
        bottomBar.add(maxmin);
        maxmin.addClickHandler(new ClickHandler(){

            @Override
            public void onClick(ClickEvent event) {
                if (maxmin.getText().equals("Minimize")) {
                    maxmin.setText("Maximize");
                    LoggingPopup.this.scrollPanel.setVisible(false);
                    LoggingPopup.this.resizeIcon.setVisible(false);
                } else {
                    LoggingPopup.this.scrollPanel.setVisible(true);
                    LoggingPopup.this.resizeIcon.setVisible(true);
                    maxmin.setText("Minimize");
                }
            }
        });
        this.resizeIcon = new HTML("<div style='font-size:200%; line-height:75%'>\u21f2</div>");
        this.resizeIcon.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        bottomBar.add(this.resizeIcon);
        new WindowResizeHandler(this.resizeIcon);
        super.setWidget(mainPanel);
        this.show();
    }

    @Override
    public void add(Widget w) {
        this.logArea.add(w);
        this.scrollPanel.setScrollPosition(this.scrollPanel.getElement().getScrollHeight());
    }

    @Override
    public void setWidget(Widget w) {
        this.logArea.clear();
        this.add(w);
    }

    private class WindowResizeHandler
    extends MouseDragHandler {
        public WindowResizeHandler(Widget dragHandle) {
            super(dragHandle);
        }

        @Override
        public void handleDrag(int absX, int absY) {
            LoggingPopup.this.scrollPanel.incrementPixelSize(absX, absY);
        }
    }

    private class WindowMoveHandler
    extends MouseDragHandler {
        public WindowMoveHandler(Widget dragHandle) {
            super(dragHandle);
        }

        @Override
        public void handleDrag(int absX, int absY) {
            LoggingPopup moveTarget = LoggingPopup.this;
            RootPanel.get().setWidgetPosition(moveTarget, moveTarget.getAbsoluteLeft() + absX, moveTarget.getAbsoluteTop() + absY);
        }
    }

    private static class ScrollPanelWithMinSize
    extends ScrollPanel {
        private int minScrollPanelHeight = 100;
        private int minScrollPanelWidth = 100;
        private int scrollPanelHeight;
        private int scrollPanelWidth;

        private ScrollPanelWithMinSize() {
        }

        public void incrementPixelSize(int width, int height) {
            this.setPixelSize(this.scrollPanelWidth + width, this.scrollPanelHeight + height);
        }

        @Override
        public void setPixelSize(int width, int height) {
            this.scrollPanelWidth = Math.max(width, this.minScrollPanelWidth);
            this.scrollPanelHeight = Math.max(height, this.minScrollPanelHeight);
            super.setPixelSize(this.scrollPanelWidth, this.scrollPanelHeight);
        }
    }

    private abstract class MouseDragHandler
    implements MouseMoveHandler,
    MouseUpHandler,
    MouseDownHandler {
        protected boolean dragging = false;
        protected Widget dragHandle;
        protected int dragStartX;
        protected int dragStartY;

        public MouseDragHandler(Widget dragHandle) {
            this.dragHandle = dragHandle;
            HasAllMouseHandlers hamh = (HasAllMouseHandlers)((Object)dragHandle);
            hamh.addMouseDownHandler(this);
            hamh.addMouseUpHandler(this);
            hamh.addMouseMoveHandler(this);
        }

        public abstract void handleDrag(int var1, int var2);

        @Override
        public void onMouseDown(MouseDownEvent event) {
            this.dragging = true;
            DOM.setCapture(this.dragHandle.getElement());
            this.dragStartX = event.getClientX();
            this.dragStartY = event.getClientY();
            DOM.eventGetCurrentEvent().preventDefault();
        }

        @Override
        public void onMouseMove(MouseMoveEvent event) {
            if (this.dragging) {
                this.handleDrag(event.getClientX() - this.dragStartX, event.getClientY() - this.dragStartY);
                this.dragStartX = event.getClientX();
                this.dragStartY = event.getClientY();
            }
        }

        @Override
        public void onMouseUp(MouseUpEvent event) {
            this.dragging = false;
            DOM.releaseCapture(this.dragHandle.getElement());
        }
    }
}

