/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.Reference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractFileSetTest {
    private Project project;

    @Before
    public void setUp() {
        this.project = new Project();
        this.project.setBasedir(".");
    }

    protected abstract AbstractFileSet getInstance();

    protected final Project getProject() {
        return this.project;
    }

    @Test
    public final void testEmptyElementIfIsReference() {
        AbstractFileSet f = this.getInstance();
        f.setIncludes("**/*.java");
        try {
            f.setRefid(new Reference(this.getProject(), "dummyref"));
            Assert.fail((String)("Can add reference to " + f.getDataTypeName() + " with elements from setIncludes"));
        }
        catch (BuildException be) {
            Assert.assertEquals((Object)"You must not specify more than one attribute when using refid", (Object)be.getMessage());
        }
        f = this.getInstance();
        f.createPatternSet();
        try {
            f.setRefid(new Reference(this.getProject(), "dummyref"));
            Assert.fail((String)("Can add reference to " + f.getDataTypeName() + " with nested patternset element."));
        }
        catch (BuildException be) {
            Assert.assertEquals((Object)"You must not specify nested elements when using refid", (Object)be.getMessage());
        }
        f = this.getInstance();
        f.createInclude();
        try {
            f.setRefid(new Reference(this.getProject(), "dummyref"));
            Assert.fail((String)("Can add reference to " + f.getDataTypeName() + " with nested include element."));
        }
        catch (BuildException be) {
            Assert.assertEquals((Object)"You must not specify more than one attribute when using refid", (Object)be.getMessage());
        }
        f = this.getInstance();
        f.setRefid(new Reference(this.getProject(), "dummyref"));
        try {
            f.setIncludes("**/*.java");
            Assert.fail((String)("Can set includes in " + f.getDataTypeName() + " that is a reference."));
        }
        catch (BuildException be) {
            Assert.assertEquals((Object)"You must not specify more than one attribute when using refid", (Object)be.getMessage());
        }
        try {
            f.setIncludesfile(new File("/a"));
            Assert.fail((String)("Can set includesfile in " + f.getDataTypeName() + " that is a reference."));
        }
        catch (BuildException be) {
            Assert.assertEquals((Object)"You must not specify more than one attribute when using refid", (Object)be.getMessage());
        }
        try {
            f.setExcludes("**/*.java");
            Assert.fail((String)("Can set excludes in " + f.getDataTypeName() + " that is a reference."));
        }
        catch (BuildException be) {
            Assert.assertEquals((Object)"You must not specify more than one attribute when using refid", (Object)be.getMessage());
        }
        try {
            f.setExcludesfile(new File("/a"));
            Assert.fail((String)("Can set excludesfile in " + f.getDataTypeName() + " that is a reference."));
        }
        catch (BuildException be) {
            Assert.assertEquals((Object)"You must not specify more than one attribute when using refid", (Object)be.getMessage());
        }
        try {
            f.setDir(this.project.resolveFile("."));
            Assert.fail((String)("Can set dir in " + f.getDataTypeName() + " that is a reference."));
        }
        catch (BuildException be) {
            Assert.assertEquals((Object)"You must not specify more than one attribute when using refid", (Object)be.getMessage());
        }
        try {
            f.createInclude();
            Assert.fail((String)("Can add nested include in " + f.getDataTypeName() + " that is a reference."));
        }
        catch (BuildException be) {
            Assert.assertEquals((Object)"You must not specify nested elements when using refid", (Object)be.getMessage());
        }
        try {
            f.createExclude();
            Assert.fail((String)("Can add nested exclude in " + f.getDataTypeName() + " that is a reference."));
        }
        catch (BuildException be) {
            Assert.assertEquals((Object)"You must not specify nested elements when using refid", (Object)be.getMessage());
        }
        try {
            f.createIncludesFile();
            Assert.fail((String)("Can add nested includesfile in " + f.getDataTypeName() + " that is a reference."));
        }
        catch (BuildException be) {
            Assert.assertEquals((Object)"You must not specify nested elements when using refid", (Object)be.getMessage());
        }
        try {
            f.createExcludesFile();
            Assert.fail((String)("Can add nested excludesfile in " + f.getDataTypeName() + " that is a reference."));
        }
        catch (BuildException be) {
            Assert.assertEquals((Object)"You must not specify nested elements when using refid", (Object)be.getMessage());
        }
        try {
            f.createPatternSet();
            Assert.fail((String)("Can add nested patternset in " + f.getDataTypeName() + " that is a reference."));
        }
        catch (BuildException be) {
            Assert.assertEquals((Object)"You must not specify nested elements when using refid", (Object)be.getMessage());
        }
    }

    @Test
    public void testCircularReferenceCheck() {
        AbstractFileSet f = this.getInstance();
        this.project.addReference("dummy", (Object)f);
        f.setRefid(new Reference(this.getProject(), "dummy"));
        try {
            f.getDir(this.project);
            Assert.fail((String)("Can make " + f.getDataTypeName() + " a Reference to itself."));
        }
        catch (BuildException be) {
            Assert.assertEquals((Object)"This data type contains a circular reference.", (Object)be.getMessage());
        }
        try {
            f.getDirectoryScanner(this.project);
            Assert.fail((String)("Can make " + f.getDataTypeName() + " a Reference to itself."));
        }
        catch (BuildException be) {
            Assert.assertEquals((Object)"This data type contains a circular reference.", (Object)be.getMessage());
        }
        AbstractFileSet f1 = this.getInstance();
        this.project.addReference("dummy1", (Object)f1);
        f1.setRefid(new Reference(this.getProject(), "dummy2"));
        AbstractFileSet f2 = this.getInstance();
        this.project.addReference("dummy2", (Object)f2);
        f2.setRefid(new Reference(this.getProject(), "dummy3"));
        AbstractFileSet f3 = this.getInstance();
        this.project.addReference("dummy3", (Object)f3);
        f3.setRefid(new Reference(this.getProject(), "dummy1"));
        try {
            f1.getDir(this.project);
            Assert.fail((String)"Can make circular reference.");
        }
        catch (BuildException be) {
            Assert.assertEquals((Object)"This data type contains a circular reference.", (Object)be.getMessage());
        }
        try {
            f1.getDirectoryScanner(this.project);
            Assert.fail((String)"Can make circular reference.");
        }
        catch (BuildException be) {
            Assert.assertEquals((Object)"This data type contains a circular reference.", (Object)be.getMessage());
        }
        f1 = this.getInstance();
        this.project.addReference("dummy1", (Object)f1);
        f1.setRefid(new Reference(this.getProject(), "dummy2"));
        f2 = this.getInstance();
        this.project.addReference("dummy2", (Object)f2);
        f2.setRefid(new Reference(this.getProject(), "dummy3"));
        f3 = this.getInstance();
        this.project.addReference("dummy3", (Object)f3);
        f3.setDir(this.project.resolveFile("."));
        File dir = f1.getDir(this.project);
        Assert.assertEquals((String)"Dir is basedir", (Object)dir, (Object)this.project.getBaseDir());
    }

    @Test
    public void canCallSetFileTwiceWithSameArgument() {
        AbstractFileSet f = this.getInstance();
        f.setFile(new File("/a"));
        f.setFile(new File("/a"));
    }

    @Test
    public void cantCallSetFileTwiceWithDifferentArguments() {
        AbstractFileSet f = this.getInstance();
        f.setFile(new File("/a"));
        try {
            f.setFile(new File("/b"));
            Assert.fail((String)"expected an exception");
        }
        catch (BuildException ex) {
            Assert.assertEquals((Object)"setFile cannot be called twice with different arguments", (Object)ex.getMessage());
        }
    }
}

