/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecodecvssnap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipArchive {
    private static final void usage() {
        System.err.println("zipfile [ptxq] archive [file ...]");
        System.exit(-1);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        long l = 0L;
        int n;
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static void copy(InputStream inputStream, String string, byte[] byArray) throws IOException {
        Object object;
        File file = new File(string);
        String string2 = file.getParent();
        if (string2 != null && !((File)(object = new File(string2))).exists()) {
            System.err.println("mkdirs:" + ((File)object).mkdirs());
        }
        if (string.charAt(string.length() - 1) != '/') {
            object = new BufferedOutputStream(new FileOutputStream(file));
            ZipArchive.copy(inputStream, (OutputStream)object, byArray);
            ((OutputStream)object).close();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 2) {
            ZipArchive.usage();
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        try {
            if (string.equals("t") || string.equals("p") || string.equals("x")) {
                PrintStream printStream = System.out;
                byte[] byArray = new byte[1024];
                if (stringArray.length == 2) {
                    ZipEntry zipEntry;
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));
                    ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        String string3 = zipEntry.getName();
                        if (string.equals("t")) {
                            printStream.print(string3);
                            printStream.print(" size: ");
                            printStream.println(zipEntry.getSize());
                            continue;
                        }
                        if (string.equals("p")) {
                            ZipArchive.copy((InputStream)zipInputStream, printStream, byArray);
                            continue;
                        }
                        ZipArchive.copy((InputStream)zipInputStream, string3, byArray);
                    }
                } else {
                    ZipFile zipFile = new ZipFile(string2);
                    int n = 2;
                    while (n < stringArray.length) {
                        String string4 = stringArray[n];
                        ZipEntry zipEntry = zipFile.getEntry(string4);
                        if (zipEntry == null) {
                            System.err.println("zipfile " + string2 + ':' + stringArray[n] + " - not found");
                            System.exit(-1);
                        } else if (string.equals("t")) {
                            printStream.print(string4);
                            printStream.print(" size: ");
                            printStream.println(zipEntry.getSize());
                        } else if (string.equals("p")) {
                            ZipArchive.copy(zipFile.getInputStream(zipEntry), printStream, byArray);
                        } else {
                            ZipArchive.copy(zipFile.getInputStream(zipEntry), string4, byArray);
                        }
                        ++n;
                    }
                }
            } else if (string.equals("q")) {
                ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string2));
                int n = 2;
                while (n < stringArray.length) {
                    File file = new File(stringArray[n]);
                    if (!file.exists()) {
                        throw new IOException(stringArray[n] + " - not found");
                    }
                    if (!file.canRead()) {
                        throw new IOException(stringArray[n] + " - not readable");
                    }
                    FileInputStream fileInputStream = new FileInputStream(file);
                    int n2 = (int)file.length();
                    byte[] byArray = new byte[n2];
                    if (fileInputStream.read(byArray) != n2) {
                        throw new IOException(stringArray[n] + " - read error");
                    }
                    fileInputStream.close();
                    ZipEntry zipEntry = new ZipEntry(stringArray[n]);
                    zipEntry.setSize(n2);
                    zipEntry.setTime(file.lastModified());
                    zipOutputStream.putNextEntry(zipEntry);
                    zipOutputStream.write(byArray, 0, n2);
                    ++n;
                }
                zipOutputStream.close();
            } else {
                ZipArchive.usage();
            }
        }
        catch (IOException iOException) {
            System.err.println("I/O Exception:  " + iOException);
        }
    }
}

