/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.sig.ISignatureCodec;
import gnu.java.security.sig.dss.DSSSignatureRawCodec;
import gnu.java.security.sig.dss.DSSSignatureX509Codec;
import gnu.java.security.sig.rsa.RSAPKCS1V1_5SignatureRawCodec;
import gnu.java.security.sig.rsa.RSAPKCS1V1_5SignatureX509Codec;
import gnu.java.security.sig.rsa.RSAPSSSignatureRawCodec;
import gnu.java.security.util.FormatUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SignatureCodecFactory {
    private static Set names;

    public static ISignatureCodec getInstance(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        if (string.startsWith("/")) {
            return null;
        }
        if (string.endsWith("/")) {
            return SignatureCodecFactory.getInstance(string.substring(0, string.length() - 1), 1);
        }
        int n = string.indexOf("/");
        if (n == -1) {
            return SignatureCodecFactory.getInstance(string, 1);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return SignatureCodecFactory.getInstance(string2, string3);
    }

    public static ISignatureCodec getInstance(String string, String string2) {
        int n = FormatUtil.getFormatID(string2);
        if (n == 0) {
            return null;
        }
        return SignatureCodecFactory.getInstance(string, n);
    }

    public static ISignatureCodec getInstance(String string, int n) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        switch (n) {
            case 1: {
                return SignatureCodecFactory.getRawCodec(string);
            }
            case 2: {
                return SignatureCodecFactory.getX509Codec(string);
            }
        }
        return null;
    }

    public static final synchronized Set getNames() {
        if (names == null) {
            HashSet hashSet = new HashSet();
            hashSet.add("dss/RAW");
            hashSet.add("dss/X.509");
            Set set = HashFactory.getNames();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = "rsa-pkcs1-v1.5-" + string;
                hashSet.add(string2 + "/RAW");
                hashSet.add(string2 + "/X.509");
                string2 = "rsa-pss-" + string;
                hashSet.add(string2 + "/RAW");
            }
            names = Collections.unmodifiableSet(hashSet);
        }
        return names;
    }

    private static final ISignatureCodec getRawCodec(String string) {
        ISignatureCodec iSignatureCodec = null;
        if (string.equalsIgnoreCase("dsa") || string.equalsIgnoreCase("dss")) {
            iSignatureCodec = new DSSSignatureRawCodec();
        } else if ((string = string.toLowerCase()).startsWith("rsa-pkcs1-v1.5")) {
            iSignatureCodec = new RSAPKCS1V1_5SignatureRawCodec();
        } else if (string.startsWith("rsa-pss")) {
            iSignatureCodec = new RSAPSSSignatureRawCodec();
        }
        return iSignatureCodec;
    }

    private static final ISignatureCodec getX509Codec(String string) {
        ISignatureCodec iSignatureCodec = null;
        if (string.equalsIgnoreCase("dsa") || string.equalsIgnoreCase("dss")) {
            iSignatureCodec = new DSSSignatureX509Codec();
        } else if ((string = string.toLowerCase()).startsWith("rsa-pkcs1-v1.5")) {
            iSignatureCodec = new RSAPKCS1V1_5SignatureX509Codec();
        }
        return iSignatureCodec;
    }

    private SignatureCodecFactory() {
    }
}

