/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;

final class Util {
    static final String HEX = "0123456789abcdef";

    static final byte[] toByteArray(String string) {
        string = string.toLowerCase();
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = (byte)(Character.digit(string.charAt(n++), 16) << 4 | Character.digit(string.charAt(n++), 16));
            ++n2;
        }
        return byArray;
    }

    static final String toHexString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(HEX.charAt(byArray[n3 + n] >>> 4 & 0xF));
            stringBuffer.append(HEX.charAt(byArray[n3 + n] & 0xF));
            ++n3;
        }
        return stringBuffer.toString();
    }

    static final String toHexString(byte[] byArray) {
        return Util.toHexString(byArray, 0, byArray.length);
    }

    static final String toHexString(byte[] byArray, int n, int n2, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(HEX.charAt(byArray[n3 + n] >>> 4 & 0xF));
            stringBuffer.append(HEX.charAt(byArray[n3 + n] & 0xF));
            if (n3 < n2 - 1) {
                stringBuffer.append(c);
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    static final String toHexString(byte[] byArray, char c) {
        return Util.toHexString(byArray, 0, byArray.length, c);
    }

    static final String hexDump(byte[] byArray, int n, int n2, String string) {
        String string2 = Util.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            if (string != null) {
                stringBuffer.append(string);
            }
            stringBuffer.append(Util.formatInt(n3 + n, 16, 8));
            stringBuffer.append("  ");
            String string3 = Util.toHexString(byArray, n3 + n, Math.min(16, n2 - n3), ' ');
            stringBuffer.append(string3);
            int n4 = 56 - (56 - string3.length());
            while (n4 < 56) {
                stringBuffer.append(" ");
                ++n4;
            }
            n4 = 0;
            while (n4 < Math.min(16, n2 - n3)) {
                if ((byArray[n3 + n + n4] & 0xFF) < 32 || (byArray[n3 + n + n4] & 0xFF) > 126) {
                    stringBuffer.append('.');
                } else {
                    stringBuffer.append((char)(byArray[n3 + n + n4] & 0xFF));
                }
                ++n4;
            }
            stringBuffer.append(string2);
            n3 += 16;
        }
        return stringBuffer.toString();
    }

    static final String hexDump(byte[] byArray, int n, int n2) {
        return Util.hexDump(byArray, n, n2, "");
    }

    static final String hexDump(byte[] byArray, String string) {
        return Util.hexDump(byArray, 0, byArray.length, string);
    }

    static final String hexDump(byte[] byArray) {
        return Util.hexDump(byArray, 0, byArray.length);
    }

    static final String formatInt(int n, int n2, int n3) {
        String string = Integer.toString(n, n2);
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < n3 - string.length()) {
            stringBuffer.append("0");
            ++n4;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    static final byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    static final byte[] trim(byte[] byArray, int n) {
        return Util.trim(byArray, 0, n);
    }

    static final byte[] trim(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n > byArray.length) {
            throw new IndexOutOfBoundsException("max=" + byArray.length + " off=" + n + " len=" + n2);
        }
        if (n == 0 && n2 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, Math.min(n2, byArray.length - n));
        return byArray2;
    }

    static final byte[] trim(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0 && !bigInteger.equals(BigInteger.ZERO)) {
            return Util.trim(byArray, 1, byArray.length - 1);
        }
        return byArray;
    }

    static final int unixTime() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    static final Object[] transform(Object[] objectArray, Class clazz, String string, Object[] objectArray2) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        if (objectArray2 == null) {
            objectArray2 = new Object[]{};
        }
        Object[] objectArray3 = (Object[])Array.newInstance(clazz, objectArray.length);
        Class[] classArray = new Class[objectArray2.length];
        int n = 0;
        while (n < objectArray2.length) {
            classArray[n] = objectArray2[n].getClass();
            ++n;
        }
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                objectArray3[n] = null;
            } else {
                Class clazz2 = objectArray[n].getClass();
                Method method = clazz2.getMethod(string, classArray);
                Object object = method.invoke(objectArray[n], objectArray2);
                if (!clazz.isAssignableFrom(object.getClass())) {
                    throw new ClassCastException();
                }
                objectArray3[n] = object;
            }
            ++n;
        }
        return objectArray3;
    }

    static final String getProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public final Object run() {
                return System.getProperty(string);
            }
        });
    }

    static final String getSecurityProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public final Object run() {
                return Security.getProperty(string);
            }
        });
    }

    private Util() {
    }
}

