/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventDispatchThread;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.InvocationEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.EmptyStackException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EventQueue {
    private static final int INITIAL_QUEUE_DEPTH = 8;
    private AWTEvent[] queue;
    private int next_in;
    private int next_out;
    private EventQueue next;
    private EventQueue prev;
    private AWTEvent currentEvent;
    private long lastWhen;
    private EventDispatchThread dispatchThread;
    private boolean shutdown;

    private final synchronized void setShutdown(boolean bl) {
        this.shutdown = bl;
    }

    synchronized boolean isShutdown() {
        if (this.shutdown) {
            return true;
        }
        if (this.peekEvent() == null) {
            Frame[] frameArray = Frame.getFrames();
            int n = 0;
            while (n < frameArray.length) {
                if (frameArray[n].isDisplayable()) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized AWTEvent getNextEvent() throws InterruptedException {
        if (this.next == null) ** GOTO lbl6
        return this.next.getNextEvent();
lbl-1000:
        // 1 sources

        {
            if (this.isShutdown()) {
                throw new InterruptedException();
            }
            this.wait();
lbl6:
            // 2 sources

            ** while (this.next_in == this.next_out)
        }
lbl7:
        // 1 sources

        var1_1 = this.queue[this.next_out];
        if (++this.next_out == this.queue.length) {
            this.next_out = 0;
        }
        return var1_1;
    }

    public synchronized AWTEvent peekEvent() {
        if (this.next != null) {
            return this.next.peekEvent();
        }
        if (this.next_in != this.next_out) {
            return this.queue[this.next_out];
        }
        return null;
    }

    public synchronized AWTEvent peekEvent(int n) {
        if (this.next != null) {
            return this.next.peekEvent(n);
        }
        int n2 = this.next_out;
        while (n2 != this.next_in) {
            AWTEvent aWTEvent = this.queue[n2];
            if (aWTEvent.id != n) continue;
            return aWTEvent;
        }
        return null;
    }

    public synchronized void postEvent(AWTEvent aWTEvent) {
        AWTEvent[] aWTEventArray;
        if (aWTEvent == null) {
            throw new NullPointerException();
        }
        if (this.next != null) {
            this.next.postEvent(aWTEvent);
            return;
        }
        int n = this.next_out;
        while (n != this.next_in) {
            Object object;
            aWTEventArray = this.queue[n];
            if (aWTEventArray.id == aWTEvent.id && (object = aWTEventArray.getSource()) == aWTEvent.getSource() && object instanceof Component) {
                Component component = (Component)object;
                AWTEvent aWTEvent2 = component.coalesceEvents((AWTEvent)aWTEventArray, aWTEvent);
                if (aWTEvent2 == null) break;
                this.queue[n] = aWTEvent2;
                return;
            }
            if (++n != this.queue.length) continue;
            n = 0;
        }
        this.queue[this.next_in] = aWTEvent;
        if (++this.next_in == this.queue.length) {
            this.next_in = 0;
        }
        if (this.next_in == this.next_out) {
            aWTEventArray = this.queue;
            this.queue = new AWTEvent[this.queue.length * 2];
            int n2 = aWTEventArray.length - this.next_out;
            System.arraycopy(aWTEventArray, this.next_out, this.queue, 0, n2);
            if (this.next_out != 0) {
                System.arraycopy(aWTEventArray, 0, this.queue, n2, this.next_out);
            }
            this.next_out = 0;
            this.next_in = aWTEventArray.length;
        }
        if (this.dispatchThread == null || !this.dispatchThread.isAlive()) {
            this.dispatchThread = new EventDispatchThread(this);
            this.dispatchThread.start();
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            throw new Error("Can't call invokeAndWait from event dispatch thread");
        }
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        Thread thread = Thread.currentThread();
        InvocationEvent invocationEvent = new InvocationEvent(eventQueue, runnable, thread, true);
        Thread thread2 = thread;
        synchronized (thread2) {
            eventQueue.postEvent(invocationEvent);
            thread.wait();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : var4_4
            Exception exception = invocationEvent.getException();
            if (exception == null) return;
            throw new InvocationTargetException(exception);
        }
    }

    public static void invokeLater(Runnable runnable) {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        InvocationEvent invocationEvent = new InvocationEvent(eventQueue, runnable, null, false);
        eventQueue.postEvent(invocationEvent);
    }

    public static boolean isDispatchThread() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        while (eventQueue.next != null) {
            eventQueue = eventQueue.next;
        }
        boolean bl = false;
        if (Thread.currentThread() == eventQueue.dispatchThread) {
            bl = true;
        }
        return bl;
    }

    public static AWTEvent getCurrentEvent() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        Thread thread = Thread.currentThread();
        while (thread != eventQueue.dispatchThread) {
            if (eventQueue.next == null) {
                return null;
            }
            eventQueue = eventQueue.next;
        }
        return eventQueue.currentEvent;
    }

    public synchronized void push(EventQueue eventQueue) {
        if (eventQueue == null) {
            throw new NullPointerException();
        }
        if (this.next != null) {
            this.next.push(eventQueue);
            return;
        }
        if (this.dispatchThread == null) {
            this.dispatchThread = new EventDispatchThread(this);
        }
        int n = this.next_out;
        while (n != this.next_in) {
            eventQueue.postEvent(this.queue[n]);
            this.next_out = n++;
            if (n != this.queue.length) continue;
            n = 0;
        }
        this.next = eventQueue;
        eventQueue.prev = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void pop() throws EmptyStackException {
        if (this.prev == null) {
            throw new EmptyStackException();
        }
        EventQueue eventQueue = this.prev;
        synchronized (eventQueue) {
            this.prev.next = this.next;
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            EventQueue eventQueue2 = this;
            synchronized (eventQueue2) {
                int n = this.next_out;
                while (true) {
                    if (n == this.next_in) {
                        this.next_in = 0;
                        this.next_out = 0;
                        this.setShutdown(true);
                        this.dispatchThread = null;
                        this.notifyAll();
                        return;
                    }
                    this.prev.postEvent(this.queue[n]);
                    this.next_out = n++;
                    if (n != this.queue.length) continue;
                    n = 0;
                }
            }
        }
    }

    protected void dispatchEvent(AWTEvent aWTEvent) {
        this.currentEvent = aWTEvent;
        if (aWTEvent instanceof InputEvent) {
            this.lastWhen = ((InputEvent)aWTEvent).getWhen();
        } else if (aWTEvent instanceof ActionEvent) {
            this.lastWhen = ((ActionEvent)aWTEvent).getWhen();
        } else if (aWTEvent instanceof InvocationEvent) {
            this.lastWhen = ((InvocationEvent)aWTEvent).getWhen();
        }
        if (aWTEvent instanceof ActiveEvent) {
            ActiveEvent activeEvent = (ActiveEvent)((Object)aWTEvent);
            activeEvent.dispatch();
        } else {
            Object object = aWTEvent.getSource();
            if (object instanceof Component) {
                Component component = (Component)object;
                component.dispatchEvent(aWTEvent);
            } else if (object instanceof MenuComponent) {
                MenuComponent menuComponent = (MenuComponent)object;
                menuComponent.dispatchEvent(aWTEvent);
            }
        }
    }

    public static long getMostRecentEventTime() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (Thread.currentThread() != eventQueue.dispatchThread) {
            return System.currentTimeMillis();
        }
        return eventQueue.lastWhen;
    }

    private final /* synthetic */ void this() {
        this.queue = new AWTEvent[8];
        this.next_in = 0;
        this.next_out = 0;
        this.lastWhen = System.currentTimeMillis();
        this.dispatchThread = new EventDispatchThread(this);
        this.shutdown = false;
    }

    public EventQueue() {
        this.this();
    }
}

