/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Mnemonic;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.Type;
import org.xbill.DNS.WireParseException;

public class NSECRecord
extends Record {
    private Name next;
    private int[] types;

    Record getObject() {
        return new NSECRecord();
    }

    private final int[] listToArray(List list2) {
        int n = list2.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = (Integer)list2.get(n2);
            ++n2;
        }
        return nArray;
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.next = new Name(dNSInput);
        int n = -1;
        ArrayList arrayList = new ArrayList();
        while (dNSInput.remaining() > 0) {
            if (dNSInput.remaining() < 2) {
                throw new WireParseException("invalid bitmap descriptor");
            }
            int n2 = dNSInput.readU8();
            if (n2 < n) {
                throw new WireParseException("invalid ordering");
            }
            int n3 = dNSInput.readU8();
            if (n3 > dNSInput.remaining()) {
                throw new WireParseException("invalid bitmap");
            }
            int n4 = 0;
            while (n4 < n3) {
                int n5 = dNSInput.readU8();
                if (n5 != 0) {
                    int n6 = 0;
                    while (n6 < 8) {
                        if ((n5 & 1 << 7 - n6) != 0) {
                            int n7 = n2 * 256 + n4 * 8 + n6;
                            arrayList.add(Mnemonic.toInteger(n7));
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
        }
        this.types = this.listToArray(arrayList);
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        Tokenizer.Token token;
        this.next = tokenizer.getName(name);
        ArrayList arrayList = new ArrayList();
        while ((token = tokenizer.get()).isString()) {
            int n = Type.value(token.value);
            if (n < 0) {
                throw tokenizer.exception("Invalid type: " + token.value);
            }
            arrayList.add(Mnemonic.toInteger(n));
        }
        tokenizer.unget();
        this.types = this.listToArray(arrayList);
        Arrays.sort(this.types);
    }

    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.next);
        int n = 0;
        while (n < this.types.length) {
            stringBuffer.append(" ");
            stringBuffer.append(Type.string(this.types[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    public Name getNext() {
        return this.next;
    }

    public int[] getTypes() {
        int[] nArray = new int[this.types.length];
        System.arraycopy(this.types, 0, nArray, 0, this.types.length);
        return nArray;
    }

    public boolean hasType(int n) {
        boolean bl = false;
        if (Arrays.binarySearch(this.types, n) >= 0) {
            bl = true;
        }
        return bl;
    }

    static void mapToWire(DNSOutput dNSOutput, int[] nArray, int n, int n2, int n3) {
        int n4 = nArray[n3 - 1] & 0xFF;
        int n5 = n4 / 8 + 1;
        int[] nArray2 = new int[n5];
        dNSOutput.writeU8(n);
        dNSOutput.writeU8(n5);
        int n6 = n2;
        while (n6 < n3) {
            int n7 = nArray[n6];
            int n8 = (n7 & 0xFF) / 8;
            nArray2[n8] = nArray2[n8] | 1 << 7 - n7 % 8;
            ++n6;
        }
        n6 = 0;
        while (n6 < n5) {
            dNSOutput.writeU8(nArray2[n6]);
            ++n6;
        }
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        this.next.toWire(dNSOutput, null, bl);
        if (this.types.length == 0) {
            return;
        }
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.types.length) {
            int n4 = this.types[n3] >> 8;
            if (n4 != n) {
                if (n2 >= 0) {
                    NSECRecord.mapToWire(dNSOutput, this.types, n, n2, n3);
                }
                n = n4;
                n2 = n3;
            }
            ++n3;
        }
        NSECRecord.mapToWire(dNSOutput, this.types, n, n2, this.types.length);
    }

    NSECRecord() {
    }

    public NSECRecord(Name name, int n, long l, Name name2, int[] nArray) {
        super(name, 47, n, l);
        this.next = NSECRecord.checkName("next", name2);
        int n2 = 0;
        while (n2 < nArray.length) {
            Type.check(nArray[n2]);
            ++n2;
        }
        this.types = new int[nArray.length];
        System.arraycopy(nArray, 0, this.types, 0, nArray.length);
        Arrays.sort(this.types);
    }
}

