/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_PLOT_H__
#define __SG_PLOT_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include <gtk/gtkmarshal.h>
#include <gtkextra/gtkextra.h>

#include "../sg_dataset.h"
#include "sg_widgets_enums.h"
#include "sg_list.h"
#include "sg_layer.h"

#define GTK_TYPE_SG_PLOT                  (sg_plot_get_type ())
#define SG_PLOT(obj)                  (GTK_CHECK_CAST ((obj), GTK_TYPE_SG_PLOT, SGplot))
#define SG_PLOT_CLASS(klass)          (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_SG_PLOT, SGplotClass))
#define GTK_IS_SG_PLOT(obj)               (GTK_CHECK_TYPE ((obj), GTK_TYPE_SG_PLOT))
#define GTK_IS_SG_PLOT_CLASS(klass)       (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_SG_PLOT))


typedef struct _SGplotClass SGplotClass;
typedef struct _SGplot SGplot;

struct _SGplot 
{
  GtkPlotCanvas canvas;

  gchar *name;
  
  GtkOrientation orientation;
  gint page_size;
  gint page_width, page_height;
  SGpageUnit page_units;

  gdouble scale;

  SGtool tool;

  SGlayer *active_layer;
  GtkWidget *layer_control;

  gint nlayers;
  GList *layers;
  SGlist *datasets;
 
  gboolean antialias;

  GObject *clipboard;
};

struct _SGplotClass
{
  GtkPlotCanvasClass parent_class;

  void 	(* add_layer)		(SGplot *plot, SGlayer *layer);
  void 	(* remove_layer)	(SGplot *plot, SGlayer *layer);
  void 	(* activate_layer)	(SGplot *plot, SGlayer *layer);
};

GtkType         sg_plot_get_type                (void);
SGplot          *sg_plot_new                    (gchar *name);
SGplot          *sg_plot_new_with_layer         (SGpluginLayer *layer,
                                                 gchar *name);
gint            sg_plot_rename                  (SGplot *plot,
                                                gchar *name); 
void            sg_plot_refresh_datasets        (SGplot *plot);
void            sg_plot_set_size                (SGplot *plot,
                                                gint page_size,
                                                gint width, gint height,
                                                gint orientation);
SGplot          *sg_plot_get_from_canvas        (GtkWidget *canvas);
void            sg_plot_rescale                 (SGplot *plot, gdouble scale); 
void            sg_plot_clear                   (SGplot *plot); 
void            sg_plot_add_layer               (SGplot *plot, SGlayer *layer,
                                                 gdouble x, gdouble y);
void            sg_plot_move_layer              (SGplot *plot, SGlayer *layer,
                                                 gdouble x, gdouble y);
void            sg_plot_resize_layer            (SGplot *plot, SGlayer *layer,
                                                 gdouble width, gdouble height);
void            sg_plot_remove_layer            (SGplot *plot, SGlayer *layer);
void            sg_plot_set_active_layer        (SGplot *plot, SGlayer *layer);
void            sg_plot_layer_control           (SGplot *plot, const gchar *path);
void            sg_plot_put_pixmap              (SGplot *plot, 
                                                 GdkPixmap *pixmap);
void            sg_plot_antialias               (SGplot *plot, gboolean do_art);
void    	sg_plot_copy          		(SGplot *plot);
void    	sg_plot_paste         		(SGplot *plot, 
						 gdouble x, gdouble y);
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_PLOT_H__ */

