/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HostAuthentication;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpMethodHelper;
import org.parosproxy.paros.network.HttpOutputStream;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.parosproxy.paros.network.HttpStatusCode;
import org.parosproxy.paros.network.SSLConnector;

public class HttpSender {
    private static ProtocolSocketFactory sslFactory = null;
    private static Protocol protocol = null;
    private static HttpMethodHelper helper;
    private static String userAgent;
    private HttpClient client = null;
    private HttpClient clientViaProxy = null;
    private ConnectionParam param = null;
    private MultiThreadedHttpConnectionManager httpConnManager = null;
    private MultiThreadedHttpConnectionManager httpConnManagerProxy = null;
    private boolean followRedirect = false;
    private boolean allowState = false;

    public HttpSender(ConnectionParam connectionParam, boolean bl) {
        this.param = connectionParam;
        this.allowState = bl;
        this.client = this.createHttpClient();
        this.clientViaProxy = this.createHttpClientViaProxy();
        if (this.allowState) {
            this.checkState();
        }
        this.addAuth(this.client);
        this.addAuth(this.clientViaProxy);
    }

    public static SSLConnector getSSLConnector() {
        return (SSLConnector)protocol.getSocketFactory();
    }

    private void checkState() {
        if (this.param.isHttpStateEnabled()) {
            this.client.setState(this.param.getHttpState());
            this.clientViaProxy.setState(this.param.getHttpState());
            this.client.getParams().setCookiePolicy("compatibility");
            this.clientViaProxy.getParams().setCookiePolicy("compatibility");
        } else {
            this.client.getParams().setCookiePolicy("ignoreCookies");
            this.clientViaProxy.getParams().setCookiePolicy("ignoreCookies");
        }
    }

    private HttpClient createHttpClient() {
        this.httpConnManager = new MultiThreadedHttpConnectionManager();
        this.setCommonManagerParams(this.httpConnManager);
        return new HttpClient(this.httpConnManager);
    }

    private HttpClient createHttpClientViaProxy() {
        if (this.param.getProxyChainName().equals("")) {
            return this.createHttpClient();
        }
        this.httpConnManagerProxy = new MultiThreadedHttpConnectionManager();
        this.setCommonManagerParams(this.httpConnManagerProxy);
        HttpClient httpClient = new HttpClient(this.httpConnManagerProxy);
        httpClient.getHostConfiguration().setProxy(this.param.getProxyChainName(), this.param.getProxyChainPort());
        if (!this.param.getProxyChainUserName().equals("")) {
            NTCredentials nTCredentials = new NTCredentials(this.param.getProxyChainUserName(), this.param.getProxyChainPassword(), "", this.param.getProxyChainRealm().equals("") ? "" : this.param.getProxyChainRealm());
            AuthScope authScope = new AuthScope(this.param.getProxyChainName(), this.param.getProxyChainPort(), this.param.getProxyChainRealm().equals("") ? AuthScope.ANY_REALM : this.param.getProxyChainRealm());
            httpClient.getState().setProxyCredentials(authScope, nTCredentials);
        }
        return httpClient;
    }

    public int executeMethod(HttpMethod httpMethod) throws HttpException, IOException {
        String string = httpMethod.getURI().getHost();
        httpMethod.setDoAuthentication(true);
        if (this.param.isUseProxy(string)) {
            return this.clientViaProxy.executeMethod(httpMethod);
        }
        return this.client.executeMethod(httpMethod);
    }

    public void shutdown() {
        if (this.httpConnManager != null) {
            this.httpConnManager.shutdown();
        }
        if (this.httpConnManagerProxy != null) {
            this.httpConnManagerProxy.shutdown();
        }
    }

    private void addAuth(HttpClient httpClient) {
        Vector vector = this.param.getListAuth();
        for (int i = 0; i < vector.size(); ++i) {
            HostAuthentication hostAuthentication = (HostAuthentication)vector.get(i);
            AuthScope authScope = null;
            NTCredentials nTCredentials = null;
            try {
                authScope = new AuthScope(hostAuthentication.getHostName(), hostAuthentication.getPort(), hostAuthentication.getRealm() == null || hostAuthentication.getRealm().equals("") ? AuthScope.ANY_REALM : hostAuthentication.getRealm());
                nTCredentials = new NTCredentials(hostAuthentication.getUserName(), hostAuthentication.getPassword(), InetAddress.getLocalHost().getCanonicalHostName(), hostAuthentication.getHostName());
                httpClient.getState().setCredentials(authScope, nTCredentials);
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                unknownHostException.printStackTrace();
            }
        }
    }

    public void sendAndReceive(HttpMessage httpMessage) throws HttpException, IOException {
        this.sendAndReceive(httpMessage, this.followRedirect);
    }

    public void sendAndReceive(HttpMessage httpMessage, HttpOutputStream httpOutputStream, byte[] byArray) throws HttpException, IOException {
        this.sendAndReceive(httpMessage, this.followRedirect, httpOutputStream, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAndReceive(HttpMessage httpMessage, boolean bl) throws HttpException, IOException {
        httpMessage.setTimeSentMillis(System.currentTimeMillis());
        try {
            if (!bl || !httpMessage.getRequestHeader().getMethod().equalsIgnoreCase("POST") && !httpMessage.getRequestHeader().getMethod().equalsIgnoreCase("PUT")) {
                this.send(httpMessage, bl);
                return;
            }
            this.send(httpMessage, false);
            HttpMessage httpMessage2 = httpMessage.cloneAll();
            for (int i = 0; i < 1 && HttpStatusCode.isRedirection(httpMessage2.getResponseHeader().getStatusCode()) && httpMessage2.getResponseHeader().getStatusCode() != 304; ++i) {
                String string = httpMessage2.getResponseHeader().getHeader("Location");
                URI uRI = httpMessage2.getRequestHeader().getURI();
                URI uRI2 = new URI(uRI, string, false);
                httpMessage2.getRequestHeader().setURI(uRI2);
                httpMessage2.getRequestHeader().setMethod("GET");
                httpMessage2.getRequestHeader().setContentLength(0);
                this.send(httpMessage2, true);
            }
            httpMessage.setResponseHeader(httpMessage2.getResponseHeader());
            httpMessage.setResponseBody(httpMessage2.getResponseBody());
        }
        finally {
            httpMessage.setTimeElapsedMillis((int)(System.currentTimeMillis() - httpMessage.getTimeSentMillis()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(HttpMessage httpMessage, boolean bl) throws HttpException, IOException {
        HttpMethod httpMethod = null;
        HttpResponseHeader httpResponseHeader = null;
        try {
            httpMethod = this.runMethod(httpMessage, bl);
            httpResponseHeader = HttpMethodHelper.getHttpResponseHeader(httpMethod);
            httpResponseHeader.setHeader("Transfer-encoding", null);
            httpMessage.setResponseHeader(httpResponseHeader);
            httpMessage.getResponseBody().setCharset(httpResponseHeader.getCharset());
            httpMessage.getResponseBody().setLength(0);
            httpMessage.getResponseBody().append(httpMethod.getResponseBody());
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
    }

    private HttpMethod runMethod(HttpMessage httpMessage, boolean bl) throws HttpException, IOException {
        int n = -1;
        HttpMethod httpMethod = null;
        this.modifyUserAgent(httpMessage);
        httpMethod = helper.createRequestMethod(httpMessage.getRequestHeader(), httpMessage.getRequestBody());
        httpMethod.setFollowRedirects(bl);
        n = this.executeMethod(httpMethod);
        if (this.allowState && this.param.isHttpStateEnabled()) {
            HttpMethodHelper.updateHttpRequestHeaderSent(httpMessage.getRequestHeader(), httpMethod);
        }
        return httpMethod;
    }

    public void setFollowRedirect(boolean bl) {
        this.followRedirect = bl;
    }

    private void modifyUserAgent(HttpMessage httpMessage) {
        try {
            if (userAgent.equals("") || httpMessage.getRequestHeader().isEmpty()) {
                return;
            }
            String string = httpMessage.getRequestHeader().getHeader("User-Agent");
            if (string == null) {
                string = "";
            }
            if (string.indexOf(userAgent) >= 0) {
                return;
            }
            String string2 = "";
            if (!string.equals("") && !string.endsWith(" ")) {
                string2 = " ";
            }
            string = string + string2 + userAgent;
            httpMessage.getRequestHeader().setHeader("User-Agent", string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getUserAgent() {
        return userAgent;
    }

    public static void setUserAgent(String string) {
        userAgent = string;
    }

    private void setCommonManagerParams(MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager) {
        multiThreadedHttpConnectionManager.getParams().setSoTimeout(40000);
        multiThreadedHttpConnectionManager.getParams().setStaleCheckingEnabled(true);
        multiThreadedHttpConnectionManager.getParams().setDefaultMaxConnectionsPerHost(25);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAndReceive(HttpMessage httpMessage, boolean bl, HttpOutputStream httpOutputStream, byte[] byArray) throws HttpException, IOException {
        httpMessage.setTimeSentMillis(System.currentTimeMillis());
        try {
            if (!bl || !httpMessage.getRequestHeader().getMethod().equalsIgnoreCase("POST") && !httpMessage.getRequestHeader().getMethod().equalsIgnoreCase("PUT")) {
                this.send(httpMessage, bl, httpOutputStream, byArray);
                return;
            }
            this.send(httpMessage, false, httpOutputStream, byArray);
            HttpMessage httpMessage2 = httpMessage.cloneAll();
            for (int i = 0; i < 1 && HttpStatusCode.isRedirection(httpMessage2.getResponseHeader().getStatusCode()) && httpMessage2.getResponseHeader().getStatusCode() != 304; ++i) {
                String string = httpMessage2.getResponseHeader().getHeader("Location");
                URI uRI = httpMessage2.getRequestHeader().getURI();
                URI uRI2 = new URI(uRI, string, false);
                httpMessage2.getRequestHeader().setURI(uRI2);
                httpMessage2.getRequestHeader().setMethod("GET");
                httpMessage2.getRequestHeader().setContentLength(0);
                this.send(httpMessage2, true, httpOutputStream, byArray);
            }
            httpMessage.setResponseHeader(httpMessage2.getResponseHeader());
            httpMessage.setResponseBody(httpMessage2.getResponseBody());
        }
        finally {
            httpMessage.setTimeElapsedMillis((int)(System.currentTimeMillis() - httpMessage.getTimeSentMillis()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(HttpMessage httpMessage, boolean bl, HttpOutputStream httpOutputStream, byte[] byArray) throws HttpException, IOException {
        HttpMethod httpMethod = null;
        HttpResponseHeader httpResponseHeader = null;
        try {
            httpMethod = this.runMethod(httpMessage, bl);
            httpResponseHeader = HttpMethodHelper.getHttpResponseHeader(httpMethod);
            httpResponseHeader.setHeader("Transfer-encoding", null);
            httpMessage.setResponseHeader(httpResponseHeader);
            httpMessage.getResponseBody().setCharset(httpResponseHeader.getCharset());
            httpMessage.getResponseBody().setLength(0);
            httpOutputStream.write(httpMessage.getResponseHeader());
            httpOutputStream.flush();
            if (httpMessage.getResponseHeader().getContentLength() >= 0 && httpMessage.getResponseHeader().getContentLength() < 20480) {
                if (httpMessage.getResponseHeader().getContentLength() > 0) {
                    httpMessage.getResponseBody().setBody(httpMethod.getResponseBody());
                    httpOutputStream.write(httpMessage.getResponseBody());
                    httpOutputStream.flush();
                }
            } else {
                InputStream inputStream = httpMethod.getResponseBodyAsStream();
                int n = 0;
                while (inputStream != null && (n = inputStream.read(byArray)) > 0) {
                    httpOutputStream.write(byArray, 0, n);
                    httpOutputStream.flush();
                    httpMessage.getResponseBody().append(byArray, n);
                }
            }
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
    }

    static {
        try {
            protocol = Protocol.getProtocol("https");
            sslFactory = protocol.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sslFactory == null || !(sslFactory instanceof SSLConnector)) {
            Protocol.registerProtocol("https", new Protocol("https", (ProtocolSocketFactory)new SSLConnector(), 443));
        }
        helper = new HttpMethodHelper();
        userAgent = "";
    }
}

