/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import A from"@typo3/core/document-service.js";import{html as k}from"lit";import"@typo3/backend/element/icon-element.js";import{SeverityEnum as m}from"@typo3/backend/enum/severity.js";import"@typo3/backend/input/clearable.js";import"@typo3/workspaces/renderable/record-table.js";import"@typo3/backend/element/pagination.js";import R from"@typo3/workspaces/workspaces.js";import h from"@typo3/backend/modal.js";import f from"@typo3/backend/storage/persistent.js";import b from"@typo3/backend/utility.js";import T from"@typo3/backend/window-manager.js";import l from"@typo3/core/event/regular-event.js";import{topLevelModuleImport as S}from"@typo3/backend/utility/top-level-module-import.js";import{selector as P}from"@typo3/core/literals.js";import M from"@typo3/workspaces/utility/icon-helper.js";import v from"@typo3/backend/action-button/deferred-action.js";var s;(function(c){c.searchForm="#workspace-settings-form",c.searchTextField='#workspace-settings-form input[name="search-text"]',c.searchSubmitBtn='#workspace-settings-form button[type="submit"]',c.depthSelector='#workspace-settings-form [name="depth"]',c.languageSelector='#workspace-settings-form select[name="languages"]',c.stagesSelector='#workspace-settings-form select[name="stages"]',c.workspaceActions=".workspace-actions",c.chooseStageAction='.workspace-actions [name="stage-action"]',c.chooseSelectionAction='.workspace-actions [name="selection-action"]',c.chooseMassAction='.workspace-actions [name="mass-action"]',c.publishAction='[data-action="publish"]',c.prevStageAction='[data-action="prevstage"]',c.nextStageAction='[data-action="nextstage"]',c.changesAction='[data-action="changes"]',c.previewAction='[data-action="preview"]',c.openAction='[data-action="open"]',c.versionAction='[data-action="version"]',c.removeAction='[data-action="remove"]',c.expandAction='[data-action="expand"]',c.workspaceRecipientsSelectAll=".t3js-workspace-recipients-selectall",c.workspaceRecipientsDeselectAll=".t3js-workspace-recipients-deselectall",c.container="#workspace-panel",c.contentsContainer="#workspace-contents",c.noContentsContainer="#workspace-contents-empty",c.previewLinksButton=".t3js-preview-link",c.pagination="#workspace-pagination"})(s||(s={}));class u extends R{constructor(){super(),this.settings={dir:"ASC",id:TYPO3.settings.Workspaces.id,depth:1,language:"all",limit:30,query:"",sort:"label_Workspace",start:0,filterTxt:""},this.paging={currentPage:1,totalPages:1,totalItems:0},this.markedRecordsForMassAction=[],this.handleCheckboxStateChanged=o=>{const n=o.target,e=n.closest("tr"),t=n.checked,a=e.dataset.table,i=e.dataset.uid,r=e.dataset.t3ver_oid,d=a+":"+i+":"+r;if(t)this.markedRecordsForMassAction.push(d);else{const p=this.markedRecordsForMassAction.indexOf(d);p>-1&&this.markedRecordsForMassAction.splice(p,1)}e.dataset.collectionCurrent?u.changeCollectionChildrenState(e.dataset.collectionCurrent,t):e.dataset.collection&&(u.changeCollectionChildrenState(e.dataset.collection,t),u.changeCollectionParentState(e.dataset.collection,t));const g=document.querySelector(s.chooseMassAction);g.disabled=this.markedRecordsForMassAction.length>0},this.openIntegrityWarningModal=()=>{const o=h.confirm(TYPO3.lang["window.integrity_warning.title"],k`<p>${TYPO3.lang["integrity.hasIssuesDescription"]}<br>${TYPO3.lang["integrity.hasIssuesQuestion"]}</p>`,m.warning);return o.addEventListener("button.clicked",()=>o.hideModal()),o},S("@typo3/workspaces/renderable/send-to-stage-form.js"),S("@typo3/workspaces/renderable/record-information.js"),A.ready().then(()=>{this.registerEvents(),this.notifyWorkspaceSwitchAction(),this.settings.depth=document.querySelector(s.depthSelector)?.value,this.settings.language=document.querySelector(s.languageSelector)?.value,this.settings.stage=document.querySelector(s.stagesSelector)?.value,document.querySelector(s.container)!==null&&this.getWorkspaceInfos()})}static refreshPageTree(){top.document.dispatchEvent(new CustomEvent("typo3:pagetree:refresh"))}static changeCollectionParentState(o,n){const e=document.querySelector('tr[data-collection-current="'+o+'"] input[type=checkbox]');e!==null&&e.checked!==n&&(e.checked=n,e.dataset.manuallyChanged="true",e.dispatchEvent(new CustomEvent("multiRecordSelection:checkbox:state:changed",{bubbles:!0,cancelable:!1})))}static changeCollectionChildrenState(o,n){const e=document.querySelectorAll(P`tr[data-collection="${o}"] input[type=checkbox]`);e.length&&e.forEach(t=>{t.checked!==n&&(t.checked=n,t.dataset.manuallyChanged="true",t.dispatchEvent(new CustomEvent("multiRecordSelection:checkbox:state:changed",{bubbles:!0,cancelable:!1})))})}notifyWorkspaceSwitchAction(){const o=document.querySelector("main[data-workspace-switch-action]");if(o.dataset.workspaceSwitchAction){const n=JSON.parse(o.dataset.workspaceSwitchAction);top.TYPO3.WorkspacesMenu.performWorkspaceSwitch(n.id,n.title),top.document.dispatchEvent(new CustomEvent("typo3:pagetree:refresh")),top.TYPO3.ModuleMenu.App.refreshMenu()}}checkIntegrity(o){return this.sendRemoteRequest(this.generateRemotePayload("checkIntegrity",o))}registerEvents(){new l("click",(n,e)=>{const t=e.closest("tr");this.checkIntegrity({selection:[{liveId:t.dataset.uid,versionId:t.dataset.t3ver_oid,table:t.dataset.table}],type:"selection"}).then(async a=>{(await a.resolve())[0].result.result==="warning"?this.openIntegrityWarningModal().addEventListener("confirm.button.ok",()=>{this.renderPublishModal(t)}):this.renderPublishModal(t)})}).delegateTo(document,s.publishAction),new l("click",(n,e)=>{this.sendToStage(e.closest("tr"),"prev")}).delegateTo(document,s.prevStageAction),new l("click",(n,e)=>{this.sendToStage(e.closest("tr"),"next")}).delegateTo(document,s.nextStageAction),new l("click",this.viewChanges.bind(this)).delegateTo(document,s.changesAction),new l("click",this.openPreview.bind(this)).delegateTo(document,s.previewAction),new l("click",(n,e)=>{const t=e.closest("tr"),a=TYPO3.settings.FormEngine.moduleUrl+"&returnUrl="+encodeURIComponent(document.location.href)+"&id="+TYPO3.settings.Workspaces.id+"&edit["+t.dataset.table+"]["+t.dataset.uid+"]=edit";window.location.href=a}).delegateTo(document,s.openAction),new l("click",(n,e)=>{const t=e.closest("tr"),a=t.dataset.table==="pages"?t.dataset.t3ver_oid:t.dataset.pid;window.location.href=TYPO3.settings.WebLayout.moduleUrl+"&id="+a}).delegateTo(document,s.versionAction),new l("click",this.confirmDeleteRecordFromWorkspace.bind(this)).delegateTo(document,s.removeAction),new l("click",(n,e)=>{let t;e.ariaExpanded==="true"?t="actions-caret-down":t="actions-caret-right",e.replaceChildren(document.createRange().createContextualFragment(M.getIcon(t)))}).delegateTo(document,s.expandAction),new l("click",()=>{window.top.document.querySelectorAll(".t3js-workspace-recipient").forEach(e=>{e.disabled||(e.checked=!0)})}).delegateTo(window.top.document,s.workspaceRecipientsSelectAll),new l("click",()=>{window.top.document.querySelectorAll(".t3js-workspace-recipient").forEach(e=>{e.disabled||(e.checked=!1)})}).delegateTo(window.top.document,s.workspaceRecipientsDeselectAll),new l("submit",n=>{n.preventDefault();const e=document.querySelector(s.searchTextField);this.settings.filterTxt=e.value,this.getWorkspaceInfos()}).delegateTo(document,s.searchForm),new l("input",(n,e)=>{const t=document.querySelector(s.searchSubmitBtn);e.value!==""?t.classList.remove("disabled"):(t.classList.add("disabled"),this.getWorkspaceInfos())}).delegateTo(document,s.searchTextField);const o=document.querySelector(s.searchTextField);o!==null&&o.clearable({onClear:()=>{document.querySelector(s.searchSubmitBtn).classList.add("disabled"),this.settings.filterTxt="",this.getWorkspaceInfos()}}),new l("multiRecordSelection:checkbox:state:changed",this.handleCheckboxStateChanged).bindTo(document),new l("change",(n,e)=>{const t=e.value;f.set("moduleData.workspaces_admin.depth",t),this.settings.depth=t,this.getWorkspaceInfos()}).delegateTo(document,s.depthSelector),new l("click",this.generatePreviewLinks.bind(this)).delegateTo(document,s.previewLinksButton),new l("change",(n,e)=>{f.set("moduleData.workspaces_admin.language",e.value),this.settings.language=e.value,this.sendRemoteRequest(this.generateRemotePayload("getWorkspaceInfos",this.settings)).then(async t=>{const a=await t.resolve();e.previousElementSibling.innerHTML=e.querySelector("option:checked").dataset.icon,this.renderWorkspaceInfos(a[0].result)})}).delegateTo(document,s.languageSelector),new l("change",(n,e)=>{const t=e.value;f.set("moduleData.workspaces_admin.stage",t),this.settings.stage=t,this.getWorkspaceInfos()}).delegateTo(document,s.stagesSelector),new l("change",this.sendToSpecificStageAction.bind(this)).delegateTo(document,s.chooseStageAction),new l("change",this.runSelectionAction.bind(this)).delegateTo(document,s.chooseSelectionAction),new l("change",this.runMassAction.bind(this)).delegateTo(document,s.chooseMassAction),new l("click",n=>{n.preventDefault();const e=n.target.closest("button");let t=!1;switch(e.dataset.action){case"previous":this.paging.currentPage>1&&(this.paging.currentPage--,t=!0);break;case"next":this.paging.currentPage<this.paging.totalPages&&(this.paging.currentPage++,t=!0);break;case"page":this.paging.currentPage=parseInt(e.dataset.page,10),t=!0;break;default:throw'Unknown action "'+e.dataset.action+'"'}t&&(this.settings.start=parseInt(this.settings.limit.toString(),10)*(this.paging.currentPage-1),this.getWorkspaceInfos())}).delegateTo(document,s.pagination)}sendToStage(o,n){let e,t,a;if(n==="next")e=o.dataset.nextStage,t="sendToNextStageWindow",a="sendToNextStageExecute";else if(n==="prev")e=o.dataset.prevStage,t="sendToPrevStageWindow",a="sendToPrevStageExecute";else throw"Invalid direction given.";this.sendRemoteRequest(this.generateRemoteActionsPayload(t,[o.dataset.uid,o.dataset.table,o.dataset.t3ver_oid])).then(async i=>{const r=this.renderSendToStageWindow(await i.resolve());r.addEventListener("button.clicked",d=>{if(d.target.name==="ok"){const p=b.convertFormToObject(r.querySelector("form"));p.affects={table:o.dataset.table,nextStage:e,t3ver_oid:o.dataset.t3ver_oid,uid:o.dataset.uid,elements:[]},this.sendRemoteRequest([this.generateRemoteActionsPayload(a,[p]),this.generateRemotePayload("getWorkspaceInfos",this.settings)]).then(async w=>{const y=await w.resolve();r.hideModal(),this.renderWorkspaceInfos(y[1].result),u.refreshPageTree()})}})})}getWorkspaceInfos(){this.sendRemoteRequest(this.generateRemotePayload("getWorkspaceInfos",this.settings)).then(async o=>{this.renderWorkspaceInfos((await o.resolve())[0].result)})}renderWorkspaceInfos(o){const n=document.querySelector(s.contentsContainer),e=document.querySelector(s.noContentsContainer);this.resetMassActionState(o.data.length),this.buildPagination(o.total),o.total===0?(n.style.display="none",e.style.display="block"):(n.style.display="block",e.style.display="none");const t=document.querySelector("typo3-workspaces-record-table");t.results=o.data}buildPagination(o){const n=document.querySelector(s.pagination);if(o===0){n.replaceChildren();return}if(this.paging.totalItems=o,this.paging.totalPages=Math.ceil(o/parseInt(this.settings.limit.toString(),10)),this.paging.totalPages===1){n.replaceChildren();return}let e=n.querySelector("typo3-backend-pagination");e===null&&(e=document.createElement("typo3-backend-pagination"),n.append(e)),e.paging={...this.paging}}viewChanges(o,n){o.preventDefault();const e=n.closest("tr");this.sendRemoteRequest(this.generateRemotePayload("getRowDetails",{stage:parseInt(e.dataset.stage,10),t3ver_oid:parseInt(e.dataset.t3ver_oid,10),table:e.dataset.table,uid:parseInt(e.dataset.uid,10),filterFields:!0})).then(async t=>{const a=(await t.resolve())[0].result.data[0],i=[],r=document.createElement("typo3-workspaces-record-information");r.record=a,r.TYPO3lang=TYPO3.lang,a.label_PrevStage!==!1&&e.dataset.stage!==e.dataset.prevStage&&i.push({text:a.label_PrevStage.title,active:!0,btnClass:"btn-default",name:"prevstage",trigger:(d,g)=>{g.hideModal(),this.sendToStage(e,"prev")}}),a.label_NextStage!==!1&&i.push({text:a.label_NextStage.title,active:!0,btnClass:"btn-default",name:"nextstage",trigger:(d,g)=>{g.hideModal(),this.sendToStage(e,"next")}}),i.push({text:TYPO3.lang.close,active:!0,btnClass:"btn-info",name:"cancel",trigger:(d,g)=>g.hideModal()}),h.advanced({type:h.types.default,title:TYPO3.lang["window.recordInformation"].replace("{0}",e.querySelector(".t3js-title-workspace").innerText.trim()),content:r,severity:m.info,buttons:i,size:h.sizes.medium})})}openPreview(o,n){const e=n.closest("tr");this.sendRemoteRequest(this.generateRemoteActionsPayload("viewSingleRecord",[e.dataset.table,e.dataset.uid])).then(async t=>{const a=(await t.resolve())[0].result;T.localOpen(a)})}confirmDeleteRecordFromWorkspace(o,n){const e=n.closest("tr"),t=h.confirm(TYPO3.lang["window.discard.title"],TYPO3.lang["window.discard.message"],m.warning,[{text:TYPO3.lang.cancel,active:!0,btnClass:"btn-default",name:"cancel",trigger:()=>{t.hideModal()}},{text:TYPO3.lang.ok,btnClass:"btn-warning",name:"ok"}]);t.addEventListener("button.clicked",a=>{a.target.name==="ok"&&this.sendRemoteRequest([this.generateRemoteActionsPayload("deleteSingleRecord",[e.dataset.table,e.dataset.uid])]).then(()=>{t.hideModal(),this.getWorkspaceInfos(),u.refreshPageTree()})})}runSelectionAction(o,n){const e=n.value,t=e!=="discard";if(e.length===0)return;const a=[];for(let i=0;i<this.markedRecordsForMassAction.length;++i){const r=this.markedRecordsForMassAction[i].split(":");a.push({table:r[0],liveId:r[2],versionId:r[1]})}t?this.checkIntegrity({selection:a,type:"selection"}).then(async i=>{(await i.resolve())[0].result.result==="warning"?this.openIntegrityWarningModal().addEventListener("confirm.button.ok",()=>{this.renderSelectionActionModal(e,a)}):this.renderSelectionActionModal(e,a)}):this.renderSelectionActionModal(e,a)}renderPublishModal(o){const n=h.advanced({title:TYPO3.lang["window.publish.title"],content:TYPO3.lang["window.publish.message"],severity:m.info,staticBackdrop:!0,buttons:[{text:TYPO3.lang.cancel,btnClass:"btn-default",trigger:function(){n.hideModal()}},{text:TYPO3.lang.label_doaction_publish,btnClass:"btn-info",action:new v(async()=>{await this.sendRemoteRequest(this.generateRemoteActionsPayload("publishSingleRecord",[o.dataset.table,o.dataset.t3ver_oid,o.dataset.uid])),this.getWorkspaceInfos(),u.refreshPageTree()})}]})}renderSelectionActionModal(o,n){const e=h.advanced({title:TYPO3.lang["window.selectionAction.title"],content:k`<p>${TYPO3.lang["tooltip."+o+"Selected"]}</p>`,severity:m.warning,staticBackdrop:!0,buttons:[{text:TYPO3.lang.cancel,btnClass:"btn-default",trigger:function(){e.hideModal()}},{text:TYPO3.lang["label_doaction_"+o],btnClass:"btn-warning",action:new v(async()=>{await this.sendRemoteRequest(this.generateRemoteActionsPayload("executeSelectionAction",{action:o,selection:n})),this.markedRecordsForMassAction=[],this.getWorkspaceInfos(),u.refreshPageTree()})}]});e.addEventListener("typo3-modal-hidden",()=>{const t=document.querySelector(s.chooseSelectionAction);t.value=""})}runMassAction(o,n){const e=n.value,t=e!=="discard";e.length!==0&&(t?this.checkIntegrity({language:this.settings.language,type:e}).then(async a=>{(await a.resolve())[0].result.result==="warning"?this.openIntegrityWarningModal().addEventListener("confirm.button.ok",()=>{this.renderMassActionModal(e)}):this.renderMassActionModal(e)}):this.renderMassActionModal(e))}renderMassActionModal(o){let n,e;switch(o){case"publish":n="publishWorkspace",e=TYPO3.lang.label_doaction_publish;break;case"discard":n="flushWorkspace",e=TYPO3.lang.label_doaction_discard;break;default:throw"Invalid mass action "+o+" called."}const t=async i=>{const r=(await i.resolve())[0].result;r.processed<r.total?this.sendRemoteRequest(this.generateRemoteMassActionsPayload(n,r)).then(t):(this.getWorkspaceInfos(),h.dismiss())},a=h.advanced({title:TYPO3.lang["window.massAction.title"],content:k`<p>${TYPO3.lang["tooltip."+o+"All"]}</p><p>${TYPO3.lang["tooltip.affectWholeWorkspace"]}</p>`,severity:m.warning,staticBackdrop:!0,buttons:[{text:TYPO3.lang.cancel,btnClass:"btn-default",trigger:function(){a.hideModal()}},{text:e,btnClass:"btn-warning",action:new v(async()=>{const i=await this.sendRemoteRequest(this.generateRemoteMassActionsPayload(n,{init:!0,total:0,processed:0,language:this.settings.language}));await t(i)})}]});a.addEventListener("typo3-modal-hidden",()=>{const i=document.querySelector(s.chooseMassAction);i.value=""})}sendToSpecificStageAction(o,n){const e=[],t=n.value;for(let a=0;a<this.markedRecordsForMassAction.length;++a){const i=this.markedRecordsForMassAction[a].split(":");e.push({table:i[0],uid:i[1],t3ver_oid:i[2]})}this.sendRemoteRequest(this.generateRemoteActionsPayload("sendToSpecificStageWindow",[t,e])).then(async a=>{const i=this.renderSendToStageWindow(await a.resolve());i.addEventListener("button.clicked",r=>{if(r.target.name==="ok"){const g=b.convertFormToObject(i.querySelector("form"));g.affects={elements:e,nextStage:t},this.sendRemoteRequest([this.generateRemoteActionsPayload("sendToSpecificStageExecute",[g]),this.generateRemotePayload("getWorkspaceInfos",this.settings)]).then(async p=>{const w=await p.resolve();i.hideModal(),this.renderWorkspaceInfos(w[1].result),u.refreshPageTree()})}}),i.addEventListener("typo3-modal-hide",()=>{const r=document.querySelector(s.chooseStageAction);r.value=""})})}generatePreviewLinks(){this.sendRemoteRequest(this.generateRemoteActionsPayload("generateWorkspacePreviewLinksForAllLanguages",[this.settings.id])).then(async o=>{const n=(await o.resolve())[0].result,e=document.createElement("dl");for(const[t,a]of Object.entries(n)){const i=document.createElement("dt");i.textContent=t;const r=document.createElement("a");r.href=a,r.target="_blank",r.textContent=a;const d=document.createElement("dd");d.appendChild(r),e.append(i,d)}h.show(TYPO3.lang.previewLink,e,m.info,[{text:TYPO3.lang.ok,active:!0,btnClass:"btn-info",name:"ok",trigger:(t,a)=>a.hideModal()}],["modal-inner-scroll"])})}resetMassActionState(o){if(this.markedRecordsForMassAction=[],o){document.querySelector(s.workspaceActions).classList.remove("hidden");const e=document.querySelector(s.chooseMassAction);e.disabled=!1}document.dispatchEvent(new CustomEvent("multiRecordSelection:actions:hide"))}}var x=new u;export{x as default};
