/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.relaxng;

import gnu.xml.validation.relaxng.FullSyntaxBuilder;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RELAXNGSchemaFactory
extends SchemaFactory {
    LSResourceResolver resourceResolver;

    public LSResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void setResourceResolver(LSResourceResolver lSResourceResolver) {
        this.resourceResolver = lSResourceResolver;
    }

    public boolean isSchemaLanguageSupported(String string) {
        return "http://relaxng.org/ns/structure/1.0".equals(string);
    }

    public Schema newSchema() throws SAXException {
        throw new UnsupportedOperationException();
    }

    public Schema newSchema(Source[] sourceArray) throws SAXException {
        if (sourceArray == null || sourceArray.length != 1) {
            throw new IllegalArgumentException("must specify one source");
        }
        try {
            Document document = RELAXNGSchemaFactory.getDocument(sourceArray[0]);
            FullSyntaxBuilder fullSyntaxBuilder = new FullSyntaxBuilder();
            return fullSyntaxBuilder.parse(document);
        }
        catch (IOException iOException) {
            SAXException sAXException = new SAXException(iOException.getMessage());
            sAXException.initCause(iOException);
            throw sAXException;
        }
    }

    private static final Document getDocument(Source source) throws SAXException, IOException {
        Object object;
        if (source instanceof DOMSource && (object = ((DOMSource)source).getNode()) != null && object instanceof Document) {
            return (Document)object;
        }
        object = source.getSystemId();
        try {
            Object object2;
            InputSource inputSource = new InputSource((String)object);
            if (source instanceof StreamSource) {
                object2 = (StreamSource)source;
                inputSource.setByteStream(((StreamSource)object2).getInputStream());
                inputSource.setCharacterStream(((StreamSource)object2).getReader());
            }
            if (inputSource.getByteStream() == null && inputSource.getCharacterStream() == null && object != null) {
                inputSource.setByteStream(new URL((String)object).openStream());
            }
            object2 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object2).setNamespaceAware(true);
            ((DocumentBuilderFactory)object2).setCoalescing(true);
            ((DocumentBuilderFactory)object2).setExpandEntityReferences(true);
            ((DocumentBuilderFactory)object2).setIgnoringComments(true);
            ((DocumentBuilderFactory)object2).setIgnoringElementContentWhitespace(true);
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            return documentBuilder.parse(inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            SAXException sAXException = new SAXException(parserConfigurationException.getMessage());
            sAXException.initCause(parserConfigurationException);
            throw sAXException;
        }
    }
}

