/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.base16;

public class NSAPRecord
extends Record {
    private byte[] address;

    Record getObject() {
        return new NSAPRecord();
    }

    private static final byte[] checkAndConvertAddress(String string) {
        if (!string.substring(0, 2).equalsIgnoreCase("0x")) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        int n = 0;
        int n2 = 2;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c != '.') {
                int n3 = Character.digit(c, 16);
                if (n3 == -1) {
                    return null;
                }
                if (bl) {
                    byteArrayOutputStream.write(n += n3);
                    bl = false;
                } else {
                    n = n3 << 4;
                    bl = true;
                }
            }
            ++n2;
        }
        if (bl) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.address = dNSInput.readByteArray();
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        String string = tokenizer.getString();
        this.address = NSAPRecord.checkAndConvertAddress(string);
        if (this.address == null) {
            throw tokenizer.exception("invalid NSAP address " + string);
        }
    }

    public String getAddress() {
        return NSAPRecord.byteArrayToString(this.address, false);
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeByteArray(this.address);
    }

    String rrToString() {
        return "0x" + base16.toString(this.address);
    }

    NSAPRecord() {
    }

    public NSAPRecord(Name name, int n, long l, String string) {
        super(name, 22, n, l);
        this.address = NSAPRecord.checkAndConvertAddress(string);
        if (this.address == null) {
            throw new IllegalArgumentException("invalid NSAP address " + string);
        }
    }
}

